<?php
session_start();

// --- DEBUGGING START ---
// Aktifkan pelaporan kesalahan PHP untuk debugging. Hapus atau set ke 0 di produksi.
error_reporting(E_ALL);
ini_set('display_errors', 1);
// --- DEBUGGING END ---

// Pastikan path ini benar untuk file koneksi database Anda
// Asumsi config.php berada satu tingkat di atas direktori saat ini (misal, ujian.php di root, config.php di root/config.php)
// Jika ujian.php berada di subfolder admin, dan config.php di folder atasnya, maka "../config.php" sudah benar.
require_once 'config.php'; 

// Periksa apakah sesi siswa telah dimulai
if (!isset($_SESSION['student_id'])) {
    // Jika tidak ada sesi siswa, redirect kembali ke halaman login
    header("Location: index.php"); 
    exit();
}

// Ambil data siswa dari sesi
$student_id = htmlspecialchars($_SESSION['student_id']);
$student_name = htmlspecialchars($_SESSION['student_name']);
$student_class = htmlspecialchars($_SESSION['student_class']);
$student_wa = htmlspecialchars($_SESSION['student_wa']);
$current_device_id = session_id(); // ID perangkat saat ini

// Pastikan koneksi database ($conn) telah berhasil dibuat di config.php
if (!$conn) {
    // Ini seharusnya sudah ditangani di config.php, tapi sebagai fallback
    die("Kesalahan Fatal: Koneksi database tidak tersedia. Mohon hubungi administrator.");
}

// --- Logika Deteksi Logout Oleh Admin ---
// Fetch last_logged_in_device_id dari database untuk siswa ini
$stmt = $conn->prepare("SELECT last_logged_in_device_id FROM students WHERE id = ?");
if ($stmt) {
    $stmt->bind_param("s", $_SESSION['student_id']);
    if ($stmt->execute()) { // Pastikan eksekusi berhasil
        $result = $stmt->get_result();
        $student_data_db = $result->fetch_assoc();
        $stmt->close();

        // Jika last_logged_in_device_id di database NULL atau tidak sesuai dengan ID sesi saat ini
        // Asumsi jika last_logged_in_device_id kosong di database, itu berarti siswa sudah logout atau sesi dihapus admin.
        // Jika current_device_id adalah string kosong atau NULL, ini juga bisa berarti sesi belum terbentuk sempurna.
        if (empty($student_data_db['last_logged_in_device_id']) || $student_data_db['last_logged_in_device_id'] !== $current_device_id) {
            // Hancurkan sesi saat ini
            session_unset();
            session_destroy();

            // Redirect ke halaman login dengan pesan
            header("Location: index.php?message=" . urlencode("Anda telah dikeluarkan oleh administrator atau sesi Anda berakhir. Silakan login kembali.") . "&type=error");
            exit();
        }
    } else {
        // Tangani error jika eksekusi prepared statement gagal
        error_log("Error executing prepared statement in ujian.php: " . $stmt->error);
        // Opsional: Redirect atau tampilkan pesan error generik
        session_unset();
        session_destroy();
        header("Location: index.php?message=" . urlencode("Terjadi kesalahan teknis saat memeriksa sesi Anda. Silakan login kembali.") . "&type=error");
        exit();
    }
} else {
    // Tangani error jika prepared statement gagal (misal, tabel/kolom tidak ditemukan)
    error_log("Failed to prepare statement in ujian.php: " . $conn->error);
    // Opsional: Redirect atau tampilkan pesan error generik
    session_unset();
    session_destroy();
    header("Location: index.php?message=" . urlencode("Terjadi kesalahan saat menyiapkan verifikasi sesi. Silakan login kembali.") . "&type=error");
    exit();
}

$conn->close(); // Tutup koneksi database setelah selesai
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Halaman Ujian Siswa</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
        }
        /* Optional: Custom gradient background for more depth */
        .custom-gradient-bg {
            background: linear-gradient(to bottom right, #f3e8ff, #fbcfe8); /* Lighter purple to pink gradient */
        }
        /* Enhancing card shadow */
        .card-shadow {
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        /* Adding subtle hover effect to detail boxes */
        .detail-box {
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }
        .detail-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
    </style>
</head>
<body class="custom-gradient-bg min-h-screen flex items-center justify-center p-4">
    <div class="bg-white p-6 sm:p-8 md:p-10 rounded-3xl card-shadow w-full max-w-lg lg:max-w-xl border border-gray-200 text-center animate-fade-in">
        <h1 class="text-3xl sm:text-4xl font-extrabold text-gray-800 mb-4">Konfirmasi Data Peserta</h1>
        <p class="text-xl text-gray-700 font-semibold mb-2">Pastikan data sudah sesuai, <span class="text-indigo-700 font-extrabold text-2xl sm:text-3xl"><?php echo $student_name; ?></span>!</p>
        <p class="text-base text-red-600 font-medium mb-6">Jika ada data tidak sesuai, silakan hubungi pengawas.</p>

        <div class="text-left text-gray-700 space-y-4 mb-8">
            <!-- Display only Nama and Kelas as requested -->
            <div class="bg-gray-50 p-4 rounded-xl shadow-sm border border-gray-100 detail-box">
                <p class="text-gray-900 text-base sm:text-lg">
                    <strong class="font-bold text-gray-800">Nama:</strong> 
                    <span class="font-semibold text-indigo-600"><?php echo $student_name; ?></span>
                </p>
            </div>
            <div class="bg-gray-50 p-4 rounded-xl shadow-sm border border-gray-100 detail-box">
                <p class="text-gray-900 text-base sm:text-lg">
                    <strong class="font-bold text-gray-800">Kelas:</strong> 
                    <span class="font-semibold text-indigo-600"><?php echo $student_class; ?></span>
                </p>
            </div>
            <!-- Removed ID Siswa, No. WA, and ID Perangkat Sesi -->
        </div>

        <p class="text-gray-600 text-lg sm:text-xl mb-8">Anda sekarang dapat memulai ujian Anda. Semoga berhasil!</p>

        <div class="flex flex-col sm:flex-row justify-center gap-4">
            <a href="cbt.php" class="inline-block bg-green-600 text-white font-semibold py-3 px-6 rounded-lg hover:bg-green-700 focus:outline-none focus:ring-4 focus:ring-green-500 focus:ring-opacity-50 transition duration-300 ease-in-out shadow-md transform hover:scale-105">
                Mulai Ujian
            </a>
            <a href="logout.php" class="inline-block bg-red-600 text-white font-semibold py-3 px-6 rounded-lg hover:bg-red-700 focus:outline-none focus:ring-4 focus:ring-red-500 focus:ring-opacity-50 transition duration-300 ease-in-out shadow-md transform hover:scale-105">
                Logout
            </a>
        </div>
    </div>
</body>
</html>
