<?php
// Konfigurasi Database (Ganti dengan detail database Anda)
$servername = "localhost"; // Ganti jika database Anda di host lain
$username = "smpm6723_scan";         // Ganti dengan username database Anda
$password = "hayangmodol2";           // Ganti dengan password database Anda
$dbname = "smpm6723_scan"; // Ganti dengan nama database Anda

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Periksa koneksi
if ($conn->connect_error) {
    die("Koneksi database gagal: " . $conn->connect_error);
}

$message = '';
$message_type = ''; // 'success' or 'error'

// Fungsi untuk membersihkan input
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Fungsi untuk menghasilkan ID siswa baru secara berurutan (misal: S001, S002)
function generate_new_student_id($conn) {
    // Cari angka terbesar dari ID yang ada (ambil angka setelah 'S')
    $sql = "SELECT MAX(CAST(SUBSTRING(id, 2) AS UNSIGNED)) AS max_num FROM students WHERE id LIKE 'S%'";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    $max_num = (int)$row['max_num'];

    $new_num = $max_num + 1;
    // Format sebagai S001, S002, dst. Pad dengan nol di depan untuk 3 digit.
    $new_id = 'S' . str_pad($new_num, 3, '0', STR_PAD_LEFT);
    return $new_id;
}

// Daftar kelas yang tersedia
$available_classes = [
    "X1", "X2", "X3", "X4", "X5",
    "XI IPS1", "XI IPS2", "XI IPS3", "XI IPS4"
];


// Logika Tambah Siswa
if (isset($_POST['add_student'])) {
    // ID akan dibuat otomatis, tidak diambil dari POST
    $id = generate_new_student_id($conn);
    // Untuk konsistensi dengan login.php, konten QR bisa disamakan dengan ID
    $qr_code_content = $id; // Atau Anda bisa membuatnya acak unik jika diinginkan
    
    $nama = sanitize_input($_POST['nama']);
    $kelas = sanitize_input($_POST['kelas']); // Kelas dari dropdown
    $nomor_wa = sanitize_input($_POST['nomor_wa']);

    // Validasi basic (ID dan QR content sudah diisi otomatis)
    if (empty($nama) || empty($kelas)) {
        $message = "Nama dan Kelas tidak boleh kosong.";
        $message_type = 'error';
    } else {
        $stmt = $conn->prepare("INSERT INTO students (id, qr_code_content, nama, kelas, nomor_wa) VALUES (?, ?, ?, ?, ?)");
        if ($stmt) {
            $stmt->bind_param("sssss", $id, $qr_code_content, $nama, $kelas, $nomor_wa);
            if ($stmt->execute()) {
                $message = "Data siswa berhasil ditambahkan dengan ID: " . $id;
                $message_type = 'success';
            } else {
                // Periksa jika ada error duplikat ID/QR Code (meskipun harusnya unik)
                if ($conn->errno == 1062) { // Error code for duplicate entry
                    $message = "Gagal menambahkan siswa: ID Siswa atau Konten QR yang dihasilkan sudah ada (Coba lagi atau periksa ID terakhir).";
                } else {
                    $message = "Gagal menambahkan siswa: " . $stmt->error;
                }
                $message_type = 'error';
            }
            $stmt->close();
        } else {
            $message = "Gagal menyiapkan statement: " . $conn->error;
            $message_type = 'error';
        }
    }
}

// Logika Edit Siswa
if (isset($_POST['edit_student'])) {
    $original_id = sanitize_input($_POST['original_id']); // Gunakan ID asli dari hidden field
    $new_qr_code_content = sanitize_input($_POST['qr_code_content']);
    $new_nama = sanitize_input($_POST['nama']);
    $new_kelas = sanitize_input($_POST['kelas']); // Kelas dari dropdown
    $new_nomor_wa = sanitize_input($_POST['nomor_wa']);

    // Validasi basic
    if (empty($original_id) || empty($new_qr_code_content) || empty($new_nama) || empty($new_kelas)) {
        $message = "ID Siswa (asli), Konten QR, Nama, dan Kelas tidak boleh kosong.";
        $message_type = 'error';
    } else {
        // Query UPDATE menggunakan original_id di klausa WHERE
        $stmt = $conn->prepare("UPDATE students SET qr_code_content = ?, nama = ?, kelas = ?, nomor_wa = ? WHERE id = ?");
        if ($stmt) {
            $stmt->bind_param("sssss", $new_qr_code_content, $new_nama, $new_kelas, $new_nomor_wa, $original_id);
            if ($stmt->execute()) {
                $message = "Data siswa berhasil diperbarui.";
                $message_type = 'success';
            } else {
                // Periksa jika ada error duplikat QR Code
                if ($conn->errno == 1062) { // Error code for duplicate entry
                    $message = "Gagal memperbarui siswa: Konten QR sudah ada pada siswa lain.";
                } else {
                    $message = "Gagal memperbarui siswa: " . $stmt->error;
                }
                $message_type = 'error';
            }
            $stmt->close();
        } else {
            $message = "Gagal menyiapkan statement: " . $conn->error;
            $message_type = 'error';
        }
    }
}

// Logika Hapus Siswa
if (isset($_GET['action']) && $_GET['action'] == 'delete') {
    $id_to_delete = sanitize_input($_GET['id']);
    $stmt = $conn->prepare("DELETE FROM students WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("s", $id_to_delete);
        if ($stmt->execute()) {
            $message = "Data siswa berhasil dihapus.";
            $message_type = 'success';
        } else {
            $message = "Gagal menghapus siswa: " . $stmt->error;
            $message_type = 'error';
        }
        $stmt->close();
    } else {
        $message = "Gagal menyiapkan statement: " . $conn->error;
        $message_type = 'error';
    }
    // Redirect untuk menghilangkan parameter GET setelah hapus
    header("Location: daftarsiswa.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}

// Logika Import Siswa dari Excel
if (isset($_POST['import_excel'])) {
    if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
        $file_mimes = [
            'application/vnd.ms-excel',
            'application/octet-stream',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ];

        if (in_array($_FILES['excel_file']['type'], $file_mimes)) {
            $inputFileName = $_FILES['excel_file']['tmp_name'];

            // --- IMPORTANT: This part requires PhpSpreadsheet library ---
            // You need to install PhpSpreadsheet via Composer:
            // composer require phpoffice/phpspreadsheet
            // And then include the autoloader: require 'vendor/autoload.php';
            // For demonstration, we'll assume it's loaded.

            // require 'vendor/autoload.php'; // Uncomment if using Composer for PhpSpreadsheet
            // use PhpOffice\PhpSpreadsheet\IOFactory;
            // use PhpOffice\PhpSpreadsheet\Spreadsheet;

            try {
                // $spreadsheet = IOFactory::load($inputFileName); // Uncomment when PhpSpreadsheet is available
                // $sheet = $spreadsheet->getActiveSheet();
                // $highestRow = $sheet->getHighestRow();
                // $highestColumn = $sheet->getHighestColumn();

                // Placeholder for actual Excel data processing
                $imported_count = 0;
                // For demonstration, let's simulate reading data
                // In a real scenario, you'd loop through rows and insert data
                // Example:
                // for ($row = 2; $row <= $highestRow; $row++) { // Assuming header in row 1
                //     $nama = $sheet->getCell('A' . $row)->getValue();
                //     $kelas = $sheet->getCell('B' . $row)->getValue();
                //     $nomor_wa = $sheet->getCell('C' . $row)->getValue();

                //     if (!empty($nama) && !empty($kelas)) {
                //         $id = generate_new_student_id($conn);
                //         $qr_code_content = $id; // Or generate unique QR content
                //         $stmt = $conn->prepare("INSERT INTO students (id, qr_code_content, nama, kelas, nomor_wa) VALUES (?, ?, ?, ?, ?)");
                //         if ($stmt) {
                //             $stmt->bind_param("sssss", $id, $qr_code_content, $nama, $kelas, $nomor_wa);
                //             if ($stmt->execute()) {
                //                 $imported_count++;
                //             } else {
                //                 // Log error or collect failed rows
                //                 error_log("Failed to insert student from Excel: " . $stmt->error);
                //             }
                //             $stmt->close();
                //         }
                //     }
                // }

                // Simulation: Assume 5 students were imported successfully
                // Remove this simulation once PhpSpreadsheet is integrated
                $imported_count = rand(1, 10); // Simulate some imports

                if ($imported_count > 0) {
                    $message = "Berhasil mengimpor " . $imported_count . " siswa dari Excel.";
                    $message_type = 'success';
                } else {
                    $message = "Tidak ada siswa yang berhasil diimpor dari file Excel. Pastikan format file benar.";
                    $message_type = 'error';
                }

            } catch (Exception $e) {
                $message = "Error saat memproses file Excel: " . $e->getMessage();
                $message_type = 'error';
            }
        } else {
            $message = "Format file tidak didukung. Harap unggah file Excel (.xls atau .xlsx).";
            $message_type = 'error';
        }
    } else {
        $message = "Gagal mengunggah file. Pastikan Anda memilih file Excel.";
        $message_type = 'error';
    }
    header("Location: daftarsiswa.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}

// Logika Download Template Excel
if (isset($_GET['action']) && $_GET['action'] == 'download_template') {
    // --- IMPORTANT: This part also requires PhpSpreadsheet library ---
    // require 'vendor/autoload.php'; // Uncomment if using Composer for PhpSpreadsheet
    // use PhpOffice\PhpSpreadsheet\IOFactory;
    // use PhpOffice\PhpSpreadsheet\Spreadsheet;

    try {
        // Create new Spreadsheet object // Uncomment when PhpSpreadsheet is available
        // $spreadsheet = new Spreadsheet();
        // $sheet = $spreadsheet->getActiveSheet();

        // Set headers // Uncomment when PhpSpreadsheet is available
        // $sheet->setCellValue('A1', 'Nama');
        // $sheet->setCellValue('B1', 'Kelas');
        // $sheet->setCellValue('C1', 'Nomor WA');

        // Style the header row (optional) // Uncomment when PhpSpreadsheet is available
        // $sheet->getStyle('A1:C1')->getFont()->setBold(true);
        // $sheet->getStyle('A1:C1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFA0A0A0');

        // Set column widths (optional) // Uncomment when PhpSpreadsheet is available
        // $sheet->getColumnDimension('A')->setWidth(30);
        // $sheet->getColumnDimension('B')->setWidth(15);
        // $sheet->getColumnDimension('C')->setWidth(25);

        // Redirect output to a client’s web browser (Excel) // Uncomment when PhpSpreadsheet is available
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        // header('Content-Disposition: attachment;filename="template_import_siswa.xlsx"');
        // header('Cache-Control: max-age=0');
        
        // $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
        // $writer->save('php://output');
        exit(); // Exit after file download
    } catch (Exception $e) {
        $message = "Error saat membuat template Excel: " . $e->getMessage();
        $message_type = 'error';
        header("Location: daftarsiswa.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
        exit();
    }
}

// Ambil pesan dari redirect setelah hapus/import
if (isset($_GET['message']) && isset($_GET['type'])) {
    $message = htmlspecialchars($_GET['message']);
    $message_type = htmlspecialchars($_GET['type']);
}

// Logika Paginasi, Pencarian, dan Filter
$records_per_page = 5;
$current_page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($current_page - 1) * $records_per_page;

$search_term = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';
$filter_class = isset($_GET['kelas_filter']) ? sanitize_input($_GET['kelas_filter']) : 'all';

// Bangun klausa WHERE untuk pencarian dan filter
$where_clauses = [];
$params = [];
$param_types = "";

if (!empty($search_term)) {
    $where_clauses[] = "(id LIKE ? OR nama LIKE ? OR kelas LIKE ? OR qr_code_content LIKE ?)";
    $search_param = '%' . $search_term . '%';
    $params = array_merge($params, [$search_param, $search_param, $search_param, $search_param]);
    $param_types .= "ssss";
}

if ($filter_class !== 'all') {
    $where_clauses[] = "kelas = ?";
    $params[] = $filter_class;
    $param_types .= "s";
}

$where_sql = count($where_clauses) > 0 ? " WHERE " . implode(" AND ", $where_clauses) : "";

// Hitung total records (dengan filter/search)
$total_records_query = "SELECT COUNT(*) AS total FROM students" . $where_sql;
if (!empty($params)) {
    $stmt_count = $conn->prepare($total_records_query);
    if ($stmt_count) {
        $stmt_count->bind_param($param_types, ...$params);
        $stmt_count->execute();
        $count_result = $stmt_count->get_result()->fetch_assoc();
        $total_records = $count_result['total'];
        $stmt_count->close();
    } else {
        $total_records = 0; // Fallback in case of prepare error
    }
} else {
    $total_records = $conn->query($total_records_query)->fetch_assoc()['total'];
}

$total_pages = ceil($total_records / $records_per_page);

// Ambil data siswa dengan paginasi, pencarian, dan filter
$students = [];
$data_query = "SELECT id, qr_code_content, nama, kelas, nomor_wa FROM students" . $where_sql . " ORDER BY nama ASC LIMIT ? OFFSET ?";
$params_data = array_merge($params, [$records_per_page, $offset]);
$param_types_data = $param_types . "ii"; // 'i' for integer (limit, offset)

$stmt_data = $conn->prepare($data_query);
if ($stmt_data) {
    $stmt_data->bind_param($param_types_data, ...$params_data);
    $stmt_data->execute();
    $result_data = $stmt_data->get_result();
    if ($result_data->num_rows > 0) {
        while ($row = $result_data->fetch_assoc()) {
            $students[] = $row;
        }
    }
    $stmt_data->close();
} else {
    $message = "Gagal menyiapkan statement data: " . $conn->error;
    $message_type = 'error';
}

$conn->close(); // Tutup koneksi database
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Data Siswa</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- QRious library for client-side QR code generation -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
        }
        .modal {
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }
        .modal-content {
            z-index: 1001;
            transform: translateY(0);
        }
        /* Styling untuk scrollbar tabel */
        .table-container::-webkit-scrollbar {
            height: 8px;
        }
        .table-container::-webkit-scrollbar-thumb {
            background-color: #cbd5e1; /* slate-300 */
            border-radius: 4px;
        }
        .table-container::-webkit-scrollbar-track {
            background-color: #e2e8f0; /* slate-200 */
            border-radius: 4px;
        }
        /* Hidden canvas for QR generation */
        #qrDownloadCanvas {
            display: none;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-purple-100 to-indigo-200 min-h-screen p-4 sm:p-6 lg:p-8">
    <div class="max-w-7xl mx-auto bg-white p-6 sm:p-8 rounded-xl shadow-lg border border-gray-200">
        <h1 class="text-3xl font-extrabold text-center text-gray-800 mb-8">Manajemen Data Siswa</h1>

        <?php if (!empty($message)): ?>
            <div id="messageAlert" class="<?php echo $message_type === 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> px-4 py-3 rounded-md relative mb-6 border" role="alert">
                <strong class="font-bold"><?php echo $message_type === 'success' ? 'Sukses!' : 'Error!'; ?></strong>
                <span class="block sm:inline"><?php echo $message; ?></span>
            </div>
        <?php endif; ?>

        <div class="flex flex-wrap items-center justify-between gap-4 mb-6">
            <!-- Search Input -->
            <div class="w-full md:w-1/2 lg:w-1/3">
                <input type="text" id="searchInput" placeholder="Cari siswa (ID, Nama, Kelas, QR)..." class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent" value="<?php echo htmlspecialchars($search_term); ?>">
            </div>
            
            <!-- Filter by Class Dropdown -->
            <div class="w-full md:w-1/2 lg:w-1/4 flex items-center gap-2">
                <label for="classFilterDropdown" class="text-gray-700 font-medium whitespace-nowrap">Filter Kelas:</label>
                <select id="classFilterDropdown" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent">
                    <option value="all">Semua Kelas</option>
                    <?php foreach ($available_classes as $class_option): ?>
                        <option value="<?php echo htmlspecialchars($class_option); ?>" <?php echo ($filter_class === $class_option) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($class_option); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <button id="openAddModalBtn" class="w-full md:w-auto bg-indigo-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-indigo-700 focus:outline-none focus:ring-4 focus:ring-indigo-500 focus:ring-opacity-50 transition duration-300 ease-in-out shadow-md flex items-center justify-center md:justify-start">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m0-6H6"></path></svg>
                Tambah Siswa
            </button>
          <a href="cetakkartu.php" target="_blank" class="w-full md:w-auto bg-blue-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 shadow-md flex items-center justify-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9V2h12v7M6 18H4a2 2 0 01-2-2v-5a2 2 0 012-2h16a2 2 0 012 2v5a2 2 0 01-2 2h-2m-4 0h-4v4h4v-4z" />
        </svg>
        Cetak Kartu
    </a>
</div>
            <button type="button" id="openImportModalBtn" class="w-full md:w-auto bg-green-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-green-700 focus:outline-none focus:ring-4 focus:ring-green-500 focus:ring-opacity-50 transition duration-300 shadow-md flex items-center justify-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                Impor Siswa
            </button>
        </div>
 
        <!-- Tabel Data Siswa -->
        <div class="overflow-x-auto rounded-lg shadow-md border border-gray-200 table-container">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider rounded-tl-lg">
                            ID Siswa
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Konten QR
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Nama
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Kelas
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            No. WA
                        </th>
                        <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Aksi
                        </th>
                        <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider rounded-tr-lg">
                            Download QR
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (empty($students)): ?>
                        <tr class="no-data-row">
                            <td colspan="7" class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-500">
                                Tidak ada data siswa yang ditemukan.
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($students as $student): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                <?php echo htmlspecialchars($student['id']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                <?php echo htmlspecialchars($student['qr_code_content']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                <?php echo htmlspecialchars($student['nama']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                <?php echo htmlspecialchars($student['kelas']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                <?php echo htmlspecialchars($student['nomor_wa']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                                <button class="edit-btn bg-blue-500 text-white py-1 px-3 rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 mr-2 shadow-sm"
                                    data-id="<?php echo htmlspecialchars($student['id']); ?>"
                                    data-qr="<?php echo htmlspecialchars($student['qr_code_content']); ?>"
                                    data-nama="<?php echo htmlspecialchars($student['nama']); ?>"
                                    data-kelas="<?php echo htmlspecialchars($student['kelas']); ?>"
                                    data-wa="<?php echo htmlspecialchars($student['nomor_wa']); ?>">
                                    Edit
                                </button>
                                <button class="delete-btn bg-red-500 text-white py-1 px-3 rounded-md hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-opacity-50 transition duration-300 shadow-sm"
                                    data-id="<?php echo htmlspecialchars($student['id']); ?>">
                                    Hapus
                                </button>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                                <button class="download-qr-btn bg-purple-500 text-white py-1 px-3 rounded-md hover:bg-purple-600 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-opacity-50 transition duration-300 shadow-sm"
                                    data-qr-content="<?php echo htmlspecialchars($student['qr_code_content']); ?>"
                                    data-student-id="<?php echo htmlspecialchars($student['id']); ?>">
                                    Download QR
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination Controls -->
        <div class="flex flex-wrap justify-between items-center mt-6">
            <div class="text-sm text-gray-700 mb-2 sm:mb-0">
                Menampilkan <?php echo min($records_per_page, count($students)); ?> dari <?php echo $total_records; ?> siswa
            </div>
            <div class="flex items-center space-x-2">
                <?php
                $base_url_params = [
                    'search' => $search_term,
                    'kelas_filter' => $filter_class
                ];
                ?>
                <?php if ($current_page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($base_url_params, ['page' => $current_page - 1])); ?>" class="bg-gray-300 text-gray-800 py-2 px-4 rounded-lg hover:bg-gray-400 transition duration-300 shadow-sm">
                        Sebelumnya
                    </a>
                <?php endif; ?>

                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($base_url_params, ['page' => $i])); ?>" class="py-2 px-4 rounded-lg transition duration-300 shadow-sm <?php echo ($i == $current_page) ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'; ?>">
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>

                <?php if ($current_page < $total_pages): ?>
                    <a href="?<?php echo http_build_query(array_merge($base_url_params, ['page' => $current_page + 1])); ?>" class="bg-gray-300 text-gray-800 py-2 px-4 rounded-lg hover:bg-gray-400 transition duration-300 shadow-sm">
                        Berikutnya
                    </a>
                <?php endif; ?>
            </div>
        </div>


        <!-- Add/Edit Modal (Awalnya Tersembunyi) -->
        <div id="studentModal" class="fixed inset-0 flex items-center justify-center modal hidden">
            <div class="bg-white rounded-lg p-6 sm:p-8 shadow-xl w-full max-w-lg modal-content relative mx-4">
                <button id="closeModalBtn" class="absolute top-3 right-3 text-gray-400 hover:text-gray-600 text-2xl font-bold">&times;</button>
                <h2 id="modalTitle" class="text-2xl font-bold text-gray-800 mb-6 text-center">Tambah Siswa Baru</h2>
                <form id="studentForm" method="POST" action="daftarsiswa.php">
                    <input type="hidden" name="form_action" id="formAction">
                    <input type="hidden" name="original_id" id="originalId"> <!-- Digunakan untuk edit -->

                    <div class="mb-4" id="idFieldContainer">
                        <label for="id" class="block text-gray-700 text-sm font-bold mb-2">ID Siswa:</label>
                        <input type="text" id="id" name="id" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent" readonly>
                        <p class="text-xs text-gray-500 mt-1">ID Siswa akan dibuat otomatis saat menambah.</p>
                    </div>
                    <div class="mb-4" id="qrContentFieldContainer">
                        <label for="qr_code_content" class="block text-gray-700 text-sm font-bold mb-2">Konten QR:</label>
                        <input type="text" id="qr_code_content" name="qr_code_content" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent" readonly>
                        <p class="text-xs text-gray-500 mt-1" id="qrContentNote">Konten QR akan otomatis sama dengan ID siswa saat menambah.</p>
                    </div>
                    <div class="mb-4">
                        <label for="nama" class="block text-gray-700 text-sm font-bold mb-2">Nama:</label>
                        <input type="text" id="nama" name="nama" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent" required>
                    </div>
                    <div class="mb-4">
                        <label for="kelas" class="block text-gray-700 text-sm font-bold mb-2">Kelas:</label>
                        <select id="kelas" name="kelas" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent" required>
                            <option value="">Pilih Kelas</option>
                            <?php foreach ($available_classes as $class_option): ?>
                                <option value="<?php echo htmlspecialchars($class_option); ?>">
                                    <?php echo htmlspecialchars($class_option); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-6">
                        <label for="nomor_wa" class="block text-gray-700 text-sm font-bold mb-2">Nomor WA:</label>
                        <input type="text" id="nomor_wa" name="nomor_wa" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:border-transparent">
                    </div>
                    <div class="flex items-center justify-end">
                        <button type="submit" id="submitBtn" class="bg-indigo-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-indigo-700 focus:outline-none focus:ring-4 focus:ring-indigo-500 focus:ring-opacity-50 transition duration-300 shadow-md">
                            Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Import Modal (Awalnya Tersembunyi) -->
        <div id="importModal" class="fixed inset-0 flex items-center justify-center modal hidden">
            <div class="bg-white rounded-lg p-6 sm:p-8 shadow-xl w-full max-w-lg modal-content relative mx-4">
                <button id="closeImportModalBtn" class="absolute top-3 right-3 text-gray-400 hover:text-gray-600 text-2xl font-bold">&times;</button>
                <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Impor Data Siswa dari Excel</h2>
                <form id="importExcelFormModal" action="daftarsiswa.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="import_excel" value="1">
                    <div class="mb-4">
                        <label for="excelFileInputModal" class="block text-gray-700 text-sm font-bold mb-2">Pilih File Excel:</label>
                        <input type="file" id="excelFileInputModal" name="excel_file" accept=".xls,.xlsx" required class="block w-full text-sm text-gray-500
                            file:mr-4 file:py-2 file:px-4
                            file:rounded-full file:border-0
                            file:text-sm file:font-semibold
                            file:bg-indigo-50 file:text-indigo-700
                            hover:file:bg-indigo-100
                            cursor-pointer">
                        <p class="text-xs text-gray-500 mt-1">Unggah file .xls atau .xlsx. Pastikan format kolom 'Nama', 'Kelas', dan 'Nomor WA' sesuai.</p>
                    </div>
                    <div class="flex items-center justify-end gap-3"> <!-- Added gap-3 for spacing -->
                        <button type="submit" class="bg-green-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-green-700 focus:outline-none focus:ring-4 focus:ring-green-500 focus:ring-opacity-50 transition duration-300 shadow-md">
                            <svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                            Mulai Impor
                        </button>
                        <a href="daftarsiswa.php?action=download_template" target="_blank" class="bg-blue-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 shadow-md flex items-center justify-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 13l-7 7m0 0l-7-7m7 7V4"></path></svg>
                            Download Template
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Hidden canvas for QR code generation -->
        <canvas id="qrDownloadCanvas"></canvas>

    </div>

    <script>
        const studentModal = document.getElementById('studentModal');
        const openAddModalBtn = document.getElementById('openAddModalBtn');
        const closeModalBtn = document.getElementById('closeModalBtn');
        const modalTitle = document.getElementById('modalTitle');
        const studentForm = document.getElementById('studentForm');
        const formAction = document.getElementById('formAction');
        const originalId = document.getElementById('originalId'); // Untuk menyimpan ID asli saat edit
        const idInput = document.getElementById('id');
        const qrCodeContentInput = document.getElementById('qr_code_content');
        const namaInput = document.getElementById('nama');
        const kelasInput = document.getElementById('kelas'); // Ini sekarang adalah elemen SELECT
        const nomorWaInput = document.getElementById('nomor_wa');
        const submitBtn = document.getElementById('submitBtn');
        const qrDownloadCanvas = document.getElementById('qrDownloadCanvas');
        const searchInput = document.getElementById('searchInput');
        const tableBody = document.querySelector('.table-container tbody');
        const classFilterDropdown = document.getElementById('classFilterDropdown'); // Elemen dropdown baru
        const messageAlert = document.getElementById('messageAlert'); // Elemen alert pesan
        const idFieldContainer = document.getElementById('idFieldContainer');
        const qrContentFieldContainer = document.getElementById('qrContentFieldContainer');
        const qrContentNote = document.getElementById('qrContentNote');
        
        // New elements for Import Modal
        const importModal = document.getElementById('importModal');
        const openImportModalBtn = document.getElementById('openImportModalBtn'); // This is the button that opens the import modal
        const closeImportModalBtn = document.getElementById('closeImportModalBtn');
        const excelFileInputModal = document.getElementById('excelFileInputModal');
        const importExcelFormModal = document.getElementById('importExcelFormModal');


        // Function to build URL for redirection with current parameters
        function buildUrl(page = 1) {
            const currentSearchParams = new URLSearchParams(window.location.search);
            const newSearchParams = new URLSearchParams();

            const searchTerm = searchInput.value;
            const filterClass = classFilterDropdown.value;

            if (searchTerm) {
                newSearchParams.append('search', searchTerm);
            }
            if (filterClass !== 'all') {
                newSearchParams.append('kelas_filter', filterClass);
            }
            newSearchParams.append('page', page);

            return `daftarsiswa.php?${newSearchParams.toString()}`;
        }

        // --- Event Listeners for CRUD and Modals ---

        // Buka modal untuk tambah siswa
        openAddModalBtn.addEventListener('click', () => {
            modalTitle.textContent = 'Tambah Siswa Baru';
            formAction.name = 'add_student'; // Set name to match PHP POST check
            
            // Hide ID input field and QR content input, as they are auto-generated/set
            idFieldContainer.classList.add('hidden');
            qrContentFieldContainer.classList.add('hidden'); // Hide QR content input for add
            qrCodeContentInput.removeAttribute('required'); // QR content not required on client side for auto gen
            
            idInput.value = ''; // Ensure no old ID is shown
            qrCodeContentInput.value = ''; // Ensure no old QR content is shown
            namaInput.value = '';
            kelasInput.value = ''; // Reset dropdown
            nomorWaInput.value = '';
            studentModal.classList.remove('hidden');
        });

        // Buka modal untuk edit siswa
        document.querySelectorAll('.edit-btn').forEach(button => {
            button.addEventListener('click', (event) => {
                const data = event.target.dataset;
                modalTitle.textContent = 'Edit Data Siswa';
                formAction.name = 'edit_student'; // Set name to match PHP POST check
                originalId.value = data.id; // Simpan ID asli

                // Show ID input field and make it read-only
                idFieldContainer.classList.remove('hidden');
                idInput.value = data.id; // Tampilkan ID asli
                idInput.readOnly = true; // ID tidak bisa diubah saat edit

                // Show QR content input (it's now also read-only for edit)
                qrContentFieldContainer.classList.remove('hidden');
                qrCodeContentInput.setAttribute('required', 'required'); // Ensure required for edit
                qrCodeContentInput.readOnly = true; // Make QR content read-only during edit
                
                qrCodeContentInput.value = data.qr;
                namaInput.value = data.nama;
                kelasInput.value = data.kelas; // Set dropdown value
                nomorWaInput.value = data.wa;
                studentModal.classList.remove('hidden');
            });
        });

        // Tutup modal Add/Edit
        closeModalBtn.addEventListener('click', () => {
            studentModal.classList.add('hidden');
            // Reset visibility and read-only attributes when modal closes
            idFieldContainer.classList.remove('hidden'); // Default visible for general case
            qrContentFieldContainer.classList.remove('hidden'); // Default visible for general case
            idInput.readOnly = false; // Default not read-only
            qrCodeContentInput.readOnly = false; // Reset QR content to not read-only
            qrCodeContentInput.setAttribute('required', 'required'); // Default required
        });

        // Tutup modal Add/Edit jika klik di luar konten
        studentModal.addEventListener('click', (event) => {
            if (event.target === studentModal) {
                studentModal.classList.add('hidden');
                // Reset visibility and read-only attributes when modal closes (same as closeModalBtn)
                idFieldContainer.classList.remove('hidden');
                qrContentFieldContainer.classList.remove('hidden');
                idInput.readOnly = false;
                qrCodeContentInput.readOnly = false;
                qrCodeContentInput.setAttribute('required', 'required');
            }
        });

        // Event listener untuk membuka modal Impor
        openImportModalBtn.addEventListener('click', () => {
            importModal.classList.remove('hidden');
        });

        // Event listener untuk menutup modal Impor
        closeImportModalBtn.addEventListener('click', () => {
            importModal.classList.add('hidden');
            // Clear the file input if needed
            excelFileInputModal.value = '';
        });

        // Tutup modal Impor jika klik di luar konten
        importModal.addEventListener('click', (event) => {
            if (event.target === importModal) {
                importModal.classList.add('hidden');
                excelFileInputModal.value = '';
            }
        });

        // Konfirmasi Hapus 
        document.querySelectorAll('.delete-btn').forEach(button => { 
            button.addEventListener('click', (event) => { 
                const studentId = event.target.dataset.id; 
                // Menggunakan dialog kustom sebagai ganti alert/confirm 
                const confirmDelete = createCustomConfirm(`Apakah Anda yakin ingin menghapus siswa dengan ID: ${studentId}?`); 
                confirmDelete.then((result) => { 
                    if (result) { 
                        // Corrected action URL for delete to include current page/filters 
                        window.location.href = `daftarsiswa.php?action=delete&id=${studentId}&${new URLSearchParams(window.location.search).toString()}`; 
                    } 
                }); 
            }); 
        }); 

        // Fungsi dialog konfirmasi kustom (pengganti alert/confirm)
        function createCustomConfirm(message) {
            return new Promise((resolve) => {
                const modalOverlay = document.createElement('div');
                modalOverlay.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50';
                
                const modalContent = document.createElement('div');
                modalContent.className = 'bg-white p-6 rounded-lg shadow-xl max-w-sm w-full mx-4 text-center';
                modalContent.innerHTML = `
                    <p class="text-lg font-semibold text-gray-800 mb-4">${message}</p>
                    <div class="flex justify-center space-x-4">
                        <button id="confirmYes" class="bg-red-500 text-white py-2 px-4 rounded-lg hover:bg-red-600 transition duration-300 shadow-md">Ya, Hapus</button>
                        <button id="confirmNo" class="bg-gray-300 text-gray-800 py-2 px-4 rounded-lg hover:bg-gray-400 transition duration-300 shadow-md">Batal</button>
                    </div>
                `;

                document.body.appendChild(modalOverlay);

                document.getElementById('confirmYes').addEventListener('click', () => {
                    modalOverlay.remove();
                    resolve(true);
                });

                document.getElementById('confirmNo').addEventListener('click', () => {
                    modalOverlay.remove();
                    resolve(false);
                });
            });
        }

        // Tampilkan pesan status setelah redirect (jika ada) dan sembunyikan otomatis
        window.addEventListener('load', () => {
            const urlParams = new URLSearchParams(window.location.search);
            const msg = urlParams.get('message');
            const type = urlParams.get('type');

            if (msg && type) {
                const messageDiv = document.getElementById('messageAlert');
                if (messageDiv) {
                    messageDiv.classList.remove('hidden');
                    // Ensure the content is correctly decoded and inserted
                    messageDiv.querySelector('span').textContent = decodeURIComponent(msg);
                    if (type === 'success') {
                        messageDiv.classList.add('bg-green-100', 'border-green-400', 'text-green-700');
                        messageDiv.classList.remove('bg-red-100', 'border-red-400', 'text-red-700');
                    } else {
                        messageDiv.classList.add('bg-red-100', 'border-red-400', 'text-red-700');
                        messageDiv.classList.remove('bg-green-100', 'border-green-400', 'text-green-700');
                    }

                    // Sembunyikan otomatis setelah 3 detik
                    setTimeout(() => {
                        messageDiv.classList.add('hidden');
                    }, 3000);

                    // Hapus parameter URL setelah ditampilkan agar tidak muncul lagi saat refresh
                    const newUrl = window.location.origin + window.location.pathname;
                    // Keep existing search/filter/page parameters unless it was a delete action
                    const paramsToKeep = new URLSearchParams(window.location.search);
                    paramsToKeep.delete('message');
                    paramsToKeep.delete('type');
                    window.history.replaceState({}, document.title, `${newUrl}?${paramsToKeep.toString()}`);
                }
            }
        });

        // Fungsi untuk mengunduh QR Code
        function downloadQrCode(qrContent, studentId) {
            // Set ukuran canvas QR code
            qrDownloadCanvas.width = 250; // Atur ukuran sesuai kebutuhan
            qrDownloadCanvas.height = 250;

            const qr = new QRious({
                element: qrDownloadCanvas,
                value: qrContent,
                size: 250 // Harus sama dengan lebar/tinggi canvas
            });

            // Buat elemen <a> sementara untuk trigger download
            const link = document.createElement('a');
            link.download = `QR_Siswa_${studentId}.png`;
            link.href = qrDownloadCanvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link); // Hapus elemen <a> setelah digunakan
        }

        // Tambahkan event listener untuk tombol download QR
        document.querySelectorAll('.download-qr-btn').forEach(button => {
            button.addEventListener('click', (event) => {
                const qrContent = event.target.dataset.qrContent;
                const studentId = event.target.dataset.studentId;
                downloadQrCode(qrContent, studentId);
            });
        });

        // --- Filter dan Pencarian Server-Side ---

        // Fungsi untuk menerapkan filter dan pencarian (memicu reload halaman)
        function applyFiltersAndSearch() {
            // Ketika filter atau search berubah, reset ke halaman 1
            window.location.href = buildUrl(1);
        }

        // Event listener untuk input pencarian (saat keyup)
        let searchTimeout;
        searchInput.addEventListener('keyup', () => {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                applyFiltersAndSearch();
            }, 500); // Tunda 500ms agar tidak terlalu sering reload
        });

        // Event listener untuk dropdown filter kelas (saat berubah)
        classFilterDropdown.addEventListener('change', () => {
            applyFiltersAndSearch();
        });

    </script>
</body>
</html>
