<?php
session_start();

// Aktifkan pelaporan kesalahan PHP untuk debugging. Hapus atau set ke 0 di produksi.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pastikan path ini benar untuk file koneksi database Anda
require_once 'config.php'; 

// Periksa apakah sesi siswa telah dimulai
if (!isset($_SESSION['student_id'])) {
    // Jika tidak ada sesi siswa, redirect kembali ke halaman login
    header("Location: index.php?message=" . urlencode("Sesi Anda telah berakhir. Silakan login kembali.") . "&type=error");
    exit();
}

// Ambil data siswa dari sesi (untuk ditampilkan atau log jika diperlukan)
$student_id = htmlspecialchars($_SESSION['student_id']);
$student_name = htmlspecialchars($_SESSION['student_name']);
$student_class = htmlspecialchars($_SESSION['student_class']);
$current_device_id = session_id(); 

// Pastikan koneksi database ($conn) telah berhasil dibuat di config.php
if (!$conn) {
    die("Kesalahan Fatal: Koneksi database tidak tersedia. Mohon hubungi administrator.");
}

// Ambil nama sekolah untuk judul dari tabel 'setting'
$nama_sekolah_title = 'Nama Sekolah'; // Nilai default
$query_setting = $conn->query("SELECT nama_sekolah FROM setting WHERE id = 1");
if ($query_setting && $query_setting->num_rows > 0) {
    $setting_data_for_title = $query_setting->fetch_assoc();
    $nama_sekolah_title = htmlspecialchars($setting_data_for_title['nama_sekolah']);
}


// Logika Deteksi Logout Oleh Admin (verifikasi ulang setiap kali halaman diakses)
$stmt = $conn->prepare("SELECT last_logged_in_device_id FROM students WHERE id = ?");
if ($stmt) {
    $stmt->bind_param("s", $_SESSION['student_id']);
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $student_data_db = $result->fetch_assoc();
        $stmt->close(); // Tutup statement setelah digunakan

        if (empty($student_data_db['last_logged_in_device_id']) || $student_data_db['last_logged_in_device_id'] !== $current_device_id) {
            session_unset();
            session_destroy();
            $conn->close(); // Tutup koneksi sebelum redirect
            header("Location: index.php?message=" . urlencode("Anda telah dikeluarkan oleh administrator atau sesi Anda berakhir. Silakan login kembali.") . "&type=error");
            exit();
        }
    } else {
        error_log("Error executing prepared statement in cbt.php for logout detection: " . $stmt->error);
        session_unset();
        session_destroy();
        $conn->close(); // Tutup koneksi sebelum redirect
        header("Location: index.php?message=" . urlencode("Terjadi kesalahan saat memeriksa sesi. Silakan login kembali.") . "&type=error");
        exit();
    }
} else {
    error_log("Failed to prepare statement in cbt.php for logout detection: " . $conn->error);
    session_unset();
    session_destroy();
    $conn->close(); // Tutup koneksi sebelum redirect
    header("Location: index.php?message=" . urlencode("Terjadi kesalahan saat menyiapkan verifikasi sesi. Silakan login kembali.") . "&type=error");
    exit();
}
// Koneksi $conn akan ditutup secara otomatis di akhir script jika tidak ada redirect yang terjadi sebelumnya.
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $nama_sekolah_title ?> - Ujian Online</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            overflow: hidden; /* Mencegah scrolling pada halaman utama */
            background-color: #1f2937; /* Latar belakang gelap untuk mode ujian */
            color: #e5e7eb; /* Teks terang */
            display: flex;
            flex-direction: column;
            height: 100vh;
        }
        #exam-iframe {
            width: 100%;
            height: calc(100vh - 64px); /* Tinggi penuh dikurangi header */
            border: none;
            flex-grow: 1;
        }
        /* Overlay Kecurangan */
        .overlay,
        .rules-overlay { 
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.85);
            color: white;
            display: none; /* Default hidden, controlled by JS */
            justify-content: center;
            align-items: center;
            z-index: 2000;
            animation: fadeIn 0.3s ease-out;
            text-align: center;
            padding: 20px;
        }
        .overlay-content,
        .rules-content { 
            background: #1c1c1c;
            padding: 30px;
            border-radius: 12px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.05);
            border: 1px solid #333;
            animation: slideIn 0.5s ease-out; /* For rules content */
        }
        .overlay-content h1,
        .rules-content h1 { 
            font-size: 26px;
            color: #f44336;
            margin-bottom: 15px;
        }
        .rules-content h1 {
            color: #ffcc00; /* Yellow for rules heading */
        }
        .overlay-content p,
        .rules-content p { 
            font-size: 17px;
            color: #ddd;
            margin-bottom: 20px;
        }
        .rule-list {
            list-style: none;
            padding: 0;
            margin: 0 0 1.5rem 0;
            text-align: left;
        }
        .rule-list li {
            font-size: 1.1rem;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        .rules-content button {
            background: #ffcc00;
            color: #000;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: bold;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .rules-content button:hover {
            background: #ffd633;
            transform: scale(1.05);
        }
        /* General button style for overlay if needed outside rules */
        button {
            background: #2196f3;
            border: none;
            padding: 10px 25px;
            font-size: 16px;
            border-radius: 6px;
            color: #fff;
            cursor: pointer;
            transition: 0.3s;
        }
        button:hover {
            background: #1976d2;
        }

        /* Keyframe Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideIn {
            from { transform: translateY(-50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes pulse {
            0% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.02); opacity: 0.9; }
            100% { transform: scale(1); opacity: 1; }
        }
    </style>
</head>
<body>
    <!-- Header untuk informasi siswa dan kontrol ujian -->
    <header class="bg-gray-800 text-white p-4 flex justify-between items-center shadow-md h-16 flex-shrink-0">
        <div class="flex items-center space-x-4">
            <div class="text-lg font-semibold">
                Selamat Datang, <span class="text-yellow-400"><?php echo $student_name; ?></span> (Kelas: <?php echo $student_class; ?>)
            </div>
            <!-- Menampilkan QR Code Content (ID Siswa) dan tombol salin -->
            <div class="flex items-center text-sm font-medium" id="qrIdSection">
                <span class="mr-2 text-gray-300">ID Ujian: <span id="qrCodeContentDisplay" class="text-indigo-400 font-bold"><?php echo $student_id; ?></span></span>
                <button id="copyQrCodeBtn" class="p-1 rounded-full hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300" title="Salin ID Ujian">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v2M8 8H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2m-8 0H8m4 0h2m-4 0a2 2 0 01-2 2h2a2 2 0 012-2z"/>
                    </svg>
                </button>
            </div>
        </div>
        <div class="flex items-center space-x-4">
            <!-- Tombol "Akhiri Ujian" dan "Fullscreen Toggle" dihapus sesuai permintaan -->
        </div>
    </header>

    <!-- Konten Ujian dalam Iframe -->
    <iframe id="exam-iframe" src="https://www.smapasundan7.sch.id/ujian/cbt" allowfullscreen></iframe>

    <!-- Overlay Kecurangan -->
    <div class="overlay" id="cheatingOverlay">
        <div class="overlay-content">
            <h1>Peringatan!</h1>
            <p id="cheatingMessage">Kecurangan terdeteksi. Anda akan dikeluarkan dari ujian.</p>
            <!-- Tombol ini akan otomatis memicu logout setelah pesan -->
        </div>
    </div>

    <!-- Overlay Aturan -->
    <div class="rules-overlay" id="rulesOverlay">
        <div class="rules-content">
            <h1>⚠️ PERHATIAN!</h1>
            <ul class="rule-list">
                <li>1️⃣ <strong>PASTIKAN NAMA DAN KELAS SESUAI</strong></li>
                <li>2️⃣ <strong>PASTIKAN TIDAK MELAKUKAN KECURANGAN KETIKA UJIAN BERLANGSUNG</strong></li>
                <li>3️⃣ <strong>JIKA KEMBALI KE HALAMAN AWAL, SILAHKAN MINTA TOKEN TERBARU KE PENGAWAS</strong></li>
            </ul>
            <button id="agreeRulesBtn">Siap, Saya Mengerti! 👍</button>
        </div>
    </div>

    <!-- Popup untuk pesan singkat (misalnya, "ID Ujian disalin!") -->
    <div id="popupMessage" class="popup-message"></div>

    <script>
        const body = document.body;
        const examIframe = document.getElementById('exam-iframe');
        const cheatingOverlay = document.getElementById('cheatingOverlay');
        const cheatingMessage = document.getElementById('cheatingMessage');
        const rulesOverlay = document.getElementById('rulesOverlay');
        const agreeRulesBtn = document.getElementById('agreeRulesBtn');
        const copyQrCodeBtn = document.getElementById('copyQrCodeBtn');
        const qrCodeContentDisplay = document.getElementById('qrCodeContentDisplay');
        const popupMessage = document.getElementById('popupMessage');
        const qrIdSection = document.getElementById('qrIdSection'); // Ambil elemen div yang menampung ID Ujian dan tombol salin

        let lastActivityTime = Date.now();
        const activityTimeout = 300000; // 5 menit (300,000 ms) inactivity sebelum logout

        /**
         * Menampilkan overlay kecurangan dan mengarahkan ke halaman logout setelah penundaan.
         * @param {string} message Pesan yang akan ditampilkan pada overlay kecurangan.
         */
        function showCheatingOverlayAndLogout(message = "Kecurangan terdeteksi. Anda akan dikeluarkan dari ujian.") {
            cheatingMessage.textContent = message;
            cheatingOverlay.style.display = "flex";
            // Memastikan tidak ada interaksi lebih lanjut dengan halaman di belakang overlay
            document.body.style.pointerEvents = 'none'; 
            document.body.style.userSelect = 'none';

            // Log upaya kecurangan ke server (opsional, memerlukan endpoint PHP AJAX)
            console.error("Cheating detected: " + message);
            /* Contoh:
            fetch('log_cheating.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ student_id: '<?php echo $student_id; ?>', reason: message })
            }).catch(e => console.error("Error logging cheating:", e));
            */

            setTimeout(() => {
                window.location.href = "logout.php?message=" + encodeURIComponent(message) + "&type=error";
            }, 3000); // 3 detik sebelum pengalihan
        }

        // --- Mekanisme Deteksi Kecurangan ---

        // 1. Integrasi API Layar Penuh (Fullscreen)
        function enterFullscreen() {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen().catch(err => {
                    console.error(`Error entering fullscreen: ${err.message} (${err.name})`);
                    showCheatingOverlayAndLogout("Gagal masuk mode layar penuh. Harap izinkan popup browser. Ujian berakhir.");
                });
            }
        }

        // Deteksi jika pengguna keluar dari layar penuh (misalnya, dengan menekan Esc)
        document.addEventListener('fullscreenchange', () => {
            if (!document.fullscreenElement) {
                showCheatingOverlayAndLogout("Anda keluar dari mode layar penuh. Ujian berakhir.");
            }
        });
        
        // Atur agar aturan tampil saat halaman dimuat, lalu masuk layar penuh setelah konfirmasi
        window.addEventListener('load', () => {
            rulesOverlay.style.display = "flex"; // Tampilkan overlay aturan terlebih dahulu
            // Atur timer untuk menyembunyikan tombol salin ID ujian setelah 1 menit
            setTimeout(() => {
                if (qrIdSection) {
                    qrIdSection.style.display = 'none';
                }
            }, 60000); // 1 menit = 60000 ms
        });

        agreeRulesBtn.addEventListener('click', () => {
            rulesOverlay.style.display = "none";
            enterFullscreen(); // Masuk layar penuh setelah aturan diakui

            // Aktifkan semua proteksi kecurangan setelah 2 menit
            setTimeout(() => {
                console.log("Proteksi kecurangan diaktifkan!");
                // Peringatan: Peringatan ini akan aktif setelah 2 menit.
                // Jika user sudah melakukan pelanggaran sebelum 2 menit, tidak akan terdeteksi.
                // Jika ingin deteksi langsung, pindahkan listener di luar setTimeout ini.
                
                // 2. Mencegah Klik Kanan (Menu Konteks)
                document.addEventListener('contextmenu', e => {
                    e.preventDefault();
                    showCheatingOverlayAndLogout("Klik kanan tidak diizinkan selama ujian.");
                });

                // 3. Deteksi Perpindahan Fokus Jendela/Tab/Aplikasi
                document.addEventListener('visibilitychange', handleFocusChange);
                window.addEventListener('blur', handleFocusChange);

                // 4. Deteksi Alat Pengembang
                window.addEventListener('resize', checkDevTools);
                setInterval(checkDevTools, 1000); 

                // 5. Logout karena Tidak Ada Aktivitas
                ['mousemove', 'keydown', 'click', 'scroll', 'touchstart', 'touchmove', 'touchend'].forEach(event => {
                    document.addEventListener(event, resetActivityTimer);
                });
                setInterval(() => {
                    if (Date.now() - lastActivityTime > activityTimeout) {
                        showCheatingOverlayAndLogout("Anda tidak aktif terlalu lama. Ujian berakhir.");
                    }
                }, 60000); 

                // 6. Mencegah Screenshot/PrintScreen (Terbatas)
                document.addEventListener('keyup', (e) => {
                    if (e.key === 'PrintScreen' || (e.altKey && e.key === 'PrintScreen') || (e.ctrlKey && e.key === 'PrintScreen')) {
                        showCheatingOverlayAndLogout("Pengambilan screenshot terdeteksi. Ujian berakhir.");
                    }
                });
                document.addEventListener('keydown', (e) => {
                    if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
                        e.preventDefault();
                        showCheatingOverlayAndLogout("Mencetak atau menyimpan halaman tidak diizinkan. Ujian berakhir.");
                    }
                });

                // 7. Mencegah Copy/Cut/Paste
                document.addEventListener('copy', (e) => {
                    e.preventDefault();
                    showCheatingOverlayAndLogout("Copy tidak diizinkan. Ujian berakhir.");
                });
                document.addEventListener('cut', (e) => {
                    e.preventDefault();
                    showCheatingOverlayAndLogout("Cut tidak diizinkan. Ujian berakhir.");
                });
                document.addEventListener('paste', (e) => {
                    e.preventDefault();
                    showCheatingOverlayAndLogout("Paste tidak diizinkan. Ujian berakhir.");
                });

                // 8. Mencegah Hotkeys (Terbatas)
                document.addEventListener('keydown', (e) => {
                    const forbiddenHotkeys = {
                        "F12": "Alat pengembang",
                        "I": "Alat pengembang", 
                        "J": "Alat pengembang", 
                        "C": "Alat pengembang", 
                        "U": "Melihat sumber halaman", 
                        "S": "Menyimpan halaman", 
                        "L": "Fokus ke address bar" 
                    };
                    if (e.key === 'F12' ||
                        ((e.ctrlKey || e.metaKey) && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C')) ||
                        ((e.ctrlKey || e.metaKey) && (e.key === 'u' || e.key === 's' || e.key === 'l'))) {
                        
                        e.preventDefault();
                        const reason = forbiddenHotkeys[e.key.toUpperCase()] || "Tindakan keyboard tidak diizinkan";
                        showCheatingOverlayAndLogout(`${reason}. Ujian berakhir.`);
                    }
                });

            }, 120000); // 2 menit = 120000 ms
        });
        
        // 3. Deteksi Perpindahan Fokus Jendela/Tab/Aplikasi (Fungsi terpisah)
        function handleFocusChange() {
            if (document.hidden || !document.hasFocus()) { // document.hidden untuk tab, !document.hasFocus() untuk beralih aplikasi
                showCheatingOverlayAndLogout("Anda terdeteksi beralih aplikasi/layar atau tab. Ujian berakhir.");
            }
        }

        // 4. Deteksi Alat Pengembang (Fungsi terpisah)
        let devToolsOpen = false;
        const checkDevTools = () => {
            const threshold = 160; 
            const devtoolsDetected = (window.outerWidth - window.innerWidth > threshold) || (window.outerHeight - window.innerHeight > threshold);

            if (devtoolsDetected && !devToolsOpen) {
                devToolsOpen = true;
                showCheatingOverlayAndLogout("Alat pengembang terdeteksi. Ujian berakhir.");
            } else if (!devtoolsDetected && devToolsOpen) {
                devToolsOpen = false;
            }
        };

        // 5. Logout karena Tidak Ada Aktivitas (Fungsi terpisah)
        function resetActivityTimer() {
            lastActivityTime = Date.now();
        }

        // 9. Fokus pada Iframe setelah dimuat
        examIframe.addEventListener('load', () => {
            if (examIframe.contentWindow) {
                examIframe.contentWindow.focus();
            }
        });

        // --- Fungsionalitas Salin Konten Kode QR ---
        copyQrCodeBtn.addEventListener('click', () => {
            const textToCopy = qrCodeContentDisplay.textContent;
            const tempTextArea = document.createElement('textarea');
            tempTextArea.value = textToCopy;
            document.body.appendChild(tempTextArea);
            tempTextArea.select();
            try {
                document.execCommand('copy'); 
                showPopupMessage("ID Ujian disalin!");
            } catch (err) {
                console.error('Gagal menyalin teks: ', err);
                showPopupMessage("Gagal menyalin ID Ujian.");
            }
            document.body.removeChild(tempTextArea);
        });

        // --- Fungsi untuk menampilkan pesan popup singkat ---
        function showPopupMessage(message, duration = 2000) {
            popupMessage.textContent = message;
            popupMessage.style.display = 'block';
            setTimeout(() => {
                popupMessage.style.display = 'none';
            }, duration);
        }

    </script>
</body>
</html>
