<?php
// Mulai sesi PHP. Ini penting untuk menyimpan status login pengguna.
session_start();

// Inisialisasi variabel pesan kesalahan
$errorMessage = '';

// Sertakan file konfigurasi database
// Asumsi 'config.php' berada di direktori yang sama dengan 'login.php'
require_once '../config.php';

// Direktori untuk menyimpan logo sekolah
$uploadDir = 'uploads/';

// Fungsi untuk mendapatkan pengaturan sekolah saat ini
// Fungsi ini diduplikasi di sini untuk menjaga file mandiri,
// namun idealnya ditempatkan di file utilitas terpisah (misal: helpers.php)
function getSchoolSettings($conn) {
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah FROM pengaturan_sekolah WHERE id = 1 LIMIT 1";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    // Mengembalikan nilai default jika pengaturan tidak ditemukan
    return ['nama_sekolah' => 'Nama Sekolah Default', 'alamat_sekolah' => '', 'logo_sekolah' => ''];
}

// Ambil pengaturan sekolah sebelum memproses form login
$settings = getSchoolSettings($conn);
$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
// Placeholder jika tidak ada logo, menggunakan ukuran yang lebih kecil dan tanpa bingkai
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/80x80/B0E0E6/000000?text=LOGO';

// Periksa apakah data form telah dikirim (metode POST)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil username/email dan password dari form
    // Gunakan htmlspecialchars untuk mencegah serangan XSS
    // Gunakan real_escape_string untuk mencegah serangan SQL Injection
    $username_or_email = $conn->real_escape_string(htmlspecialchars($_POST['username']));
    $password = $conn->real_escape_string(htmlspecialchars($_POST['password']));

    // --- Query SQL untuk memverifikasi pengguna (TANPA HASHING PASSWORD) ---
    // Peringatan: Ini sangat tidak aman untuk lingkungan produksi!
    // Sebaiknya gunakan password_hash() untuk menyimpan password dan password_verify() untuk memverifikasi.
    $sql = "SELECT id, username, email, kata_sandi, nama, role FROM pengguna WHERE (username = '$username_or_email' OR email = '$username_or_email') AND kata_sandi = '$password'";

    $result = $conn->query($sql); // Jalankan kueri

    // Periksa apakah ada baris yang cocok (pengguna ditemukan)
    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();

        if ($user['kata_sandi'] === $password) {
            // Login berhasil!
            // PHP akan menangani sesi dan pengalihan setelah JavaScript loader selesai
            $_SESSION['loggedin'] = TRUE;
            $_SESSION['id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama'] = $user['nama'];
            $_SESSION['role'] = $user['role'];

            // Simpan tujuan pengalihan di sesi untuk digunakan setelah loader
            if ($user['role'] == 'admin') {
                $_SESSION['redirect_to'] = "admin.php";
            } elseif ($user['role'] == 'pengawas') {
                $_SESSION['redirect_to'] = "pengawas.php";
            } else {
                $_SESSION['redirect_to'] = "welcome.php";
            }
            // Jangan langsung redirect di sini, biarkan JS menanganinya
        } else {
            $errorMessage = "Password salah.";
        }
    } else {
        $errorMessage = "Username/Email atau password salah.";
    }
}

// Redirect setelah loader jika ada sesi redirect_to
if (isset($_SESSION['redirect_to'])) {
    $redirect_url = $_SESSION['redirect_to'];
    unset($_SESSION['redirect_to']); // Hapus dari sesi setelah digunakan
    header("location: " . $redirect_url);
    exit;
}

// Tutup koneksi database
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin Profesional</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Inter dari Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out;
            overflow: hidden; /* Sembunyikan scrollbar jika elemen keluar area */
        }
        /* Mode gelap: Latar belakang yang lebih dalam */
        html.dark body {
            background-color: #0b0c10;
            color: #e2e8f0;
        }
        /* Mode terang: Latar belakang yang lebih hidup */
        html:not(.dark) body {
            background-color: #e0e7ff;
            color: #1a202c; /* Warna teks body di mode terang */
        }
        /* Transisi untuk elemen di dalam kartu */
        .glass-effect {
            transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }
        /* Mode gelap untuk teks */
        html.dark .text-day-mode-black {
            color: #e2e8f0; /* Berubah menjadi putih di mode gelap */
        }
        /* Mode terang untuk teks: tetap hitam */
        html:not(.dark) .text-day-mode-black {
            color: #000000; /* Warna hitam pekat di mode siang */
        }

        html.dark input {
            background-color: #4a5568;
            border-color: #4a5568;
            color: #e2e8f0;
            transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, color 0.5s ease-in-out;
        }
        html:not(.dark) input {
            transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, color 0.5s ease-in-out;
        }
        html.dark input::placeholder {
            color: #a0aec0;
        }
        /* Transisi untuk tombol pengalih tema */
        #themeToggle {
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }

        /* Gaya untuk bintang-bintang (mode malam) */
        .star-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none; /* Agar tidak menghalangi interaksi mouse */
            z-index: -1; /* Di belakang konten utama */
            opacity: 0; /* Tersembunyi secara default */
            transition: opacity 0.5s ease-in-out; /* Transisi saat muncul/hilang */
        }
        /* Kontainer bintang hanya terlihat di mode gelap */
        html.dark .star-container {
            opacity: 1;
        }
        .star {
            position: absolute;
            background-color: #ffffff; /* Warna bintang putih */
            border-radius: 50%; /* Bentuk bulat */
            opacity: 0; /* Awalnya tersembunyi untuk animasi */
            animation: twinkle linear infinite; /* Animasi berkedip */
        }
        /* Animasi berkedip */
        @keyframes twinkle {
            0%, 100% { opacity: 0; transform: scale(0.8); }
            50% { opacity: 1; transform: scale(1); }
        }

        /* Gaya untuk awan (mode siang) */
        .cloud-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1; /* Di belakang konten utama */
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }
        html:not(.dark) .cloud-container {
            opacity: 1;
        }
        .cloud {
            position: absolute;
            background: #fff;
            border-radius: 50%;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            filter: blur(2px); /* Sedikit blur untuk efek lembut */
            animation: drift linear infinite;
        }
        /* Animasi awan melayang */
        @keyframes drift {
            from { transform: translateX(-10vw); }
            to { transform: translateX(110vw); }
        }

        /* Gaya untuk burung (mode siang) */
        .bird-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1; /* Di belakang konten utama */
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }
        html:not(.dark) .bird-container {
            opacity: 1;
        }
        .bird {
            position: absolute;
            color: #4a5568; /* Warna burung */
            /* Menggunakan Tailwind untuk ukuran SVG */
            animation-timing-function: linear;
            animation-iteration-count: infinite;
            opacity: 0; /* Mulai tersembunyi */
        }
        /* Animasi burung terbang dari kiri ke kanan */
        @keyframes fly-left-to-right {
            0% { transform: translateX(-10vw); opacity: 0; }
            20% { opacity: 1; }
            80% { opacity: 1; }
            100% { transform: translateX(110vw); opacity: 0; }
        }
        /* Animasi burung terbang dari kanan ke kiri */
        @keyframes fly-right-to-left {
            0% { transform: translateX(110vw) scaleX(-1); opacity: 0; }
            20% { opacity: 1; }
            80% { opacity: 1; }
            100% { transform: translateX(-10vw) scaleX(-1); opacity: 0; }
        }

        /* Efek Kaca Transparan pada Form */
        .glass-effect {
            backdrop-filter: blur(50px); /* Intensitas blur DITINGKATKAN LAGI */
            -webkit-backdrop-filter: blur(50px); /* Untuk kompatibilitas Safari */
            /* Menggunakan rgba untuk transparansi, sangat transparan */
            background-color: rgba(255, 255, 255, 0.03); /* Sangat transparan di mode terang */
            border: 1px solid rgba(255, 255, 255, 0.01); /* Batas lebih halus dan sangat transparan */
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.05); /* Bayangan sedikit lebih lembut */
        }
        html.dark .glass-effect {
            background-color: rgba(45, 55, 72, 0.01); /* Sangat transparan di mode gelap */
            border: 1px solid rgba(255, 255, 255, 0.005); /* Batas lebih halus dan sangat transparan */
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.05); /* Bayangan sedikit lebih lembut */
        }

        /* Gaya khusus untuk tombol switch */
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 40px;
            height: 22px;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 22px; /* Membuat slider bulat */
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 50%; /* Membuat lingkaran di dalam slider */
        }

        input:checked + .slider {
            background-color: #2196F3; /* Warna biru saat aktif */
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(18px);
            -ms-transform: translateX(18px);
            transform: translateX(18px);
        }

        /* Gaya untuk slider di mode gelap */
        html.dark .slider {
            background-color: #4a5568; /* Warna abu-abu gelap saat tidak aktif di mode gelap */
        }
        html.dark input:checked + .slider {
            background-color: #3b82f6; /* Warna biru saat aktif di mode gelap */
        }

        /* Gaya Loader */
        .loader-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7); /* Latar belakang semi-transparan */
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000; /* Di atas semua konten lain */
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease-in-out, visibility 0.3s ease-in-out;
        }
        .loader-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .loader-spinner {
            border: 8px solid #f3f3f3; /* Light grey */
            border-top: 8px solid #3498db; /* Blue */
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen">
    <!-- Kontainer untuk bintang-bintang (mode malam) -->
    <div id="starContainer" class="star-container"></div>

    <!-- Kontainer untuk awan (mode siang) -->
    <div id="cloudContainer" class="cloud-container"></div>

    <!-- Kontainer untuk burung-burung (mode siang) -->
    <div id="birdContainer" class="bird-container"></div>

    <!-- Tombol pengalih tema gelap/terang -->
    <div class="absolute top-4 right-4">
        <button id="themeToggle" class="p-2 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-white shadow-md">
            <!-- Icon SVG untuk tema terang (matahari) -->
            <svg class="w-6 h-6 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h1M3 12h1m15.325-7.757l-.707-.707M4.343 19.657l-.707-.707m12.728 0l-.707.707M6.343 6.343l-.707-.707"></path>
            </svg>
            <!-- Ikon bulan, tersembunyi secara default -->
            <svg class="w-6 h-6 moon-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9 9 0 008.354-5.646z"></path>
            </svg>
        </button>
    </div>

    <!-- Kontainer utama form login -->
    <div class="glass-effect p-8 rounded-lg shadow-xl max-w-xs w-full mx-4 sm:mx-auto">
        <!-- Logo dan Nama Sekolah -->
        <div class="flex flex-col items-center mb-6">
            <img src="<?php echo $logo_sekolah_path; ?>" alt="Logo Sekolah" class="w-20 h-auto object-contain mb-3 mx-auto" onerror="this.onerror=null;this.src='https://placehold.co/80x80/B0E0E6/000000?text=LOGO';">
            <h1 class="text-2xl font-bold text-center text-day-mode-black dark:text-white"><?php echo $nama_sekolah_display; ?></h1>
        </div>

        <?php
        // Tampilkan pesan kesalahan jika ada
        if (!empty($errorMessage)) {
            echo '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">';
            echo '<strong class="font-bold">Error!</strong>';
            echo '<span class="block sm:inline ml-2">' . htmlspecialchars($errorMessage) . '</span>';
            echo '</div>';
        }
        ?>
        <!-- Form action diubah ke login.php (file ini sendiri) -->
        <form id="loginForm" action="index.php" method="POST">
            <!-- Input Username -->
            <div class="mb-4">
                <input
                    type="text"
                    id="username"
                    name="username"
                    class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                    placeholder="Masukkan username atau email Anda"
                    required
                >
            </div>
            <!-- Input Password -->
            <div class="mb-2 relative">
                <input
                    type="password"
                    id="password"
                    name="password"
                    class="shadow appearance-none border rounded-lg w-full py-2 px-3 pr-10 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200"
                    placeholder="Masukkan password Anda"
                    required
                >
            </div>
            <!-- Tombol Switch Tampilkan/Sembunyikan Password -->
            <div class="mb-6 flex items-center justify-start mt-2">
                <label class="toggle-switch">
                    <input type="checkbox" id="showPasswordToggle">
                    <span class="slider"></span>
                </label>
                <label for="showPasswordToggle" class="ml-3 text-day-mode-black dark:text-gray-300 cursor-pointer">
                    Tampilkan Kata Sandi
                </label>
            </div>

            <!-- Tombol Login -->
            <div class="flex items-center justify-between">
                <button
                    type="submit"
                    class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 w-full"
                >
                    Login
                </button>
            </div>
            <!-- Link Lupa Password -->
            <div class="text-center mt-4">
                <a href="#" class="inline-block align-baseline font-bold text-sm text-blue-600 hover:text-blue-800 transition duration-200">Lupa Password?</a>
            </div>
            <!-- Powered by: digipas.id dengan logo dan tahun -->
            <div class="text-center mt-6">
                <!-- Ukuran logo Digipas.id diperkecil dengan class w-10 -->
                <img src="digipas.png" alt="Logo Digipas.id" class="mx-auto mb-2 digipas-logo w-10" >
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    Powered by: digipas.id &copy; <span id="currentYear"></span>
                </p>
            </div>
        </form>
    </div>

    <!-- Loader Overlay -->
    <div id="loaderOverlay" class="loader-overlay hidden">
        <div class="loader-spinner"></div>
    </div>

    <!-- Skrip JavaScript untuk fungsi pengalih tema dan elemen latar belakang -->
    <script>
        const themeToggle = document.getElementById('themeToggle');
        const htmlElement = document.documentElement; // Merujuk ke elemen <html>
        const sunIcon = document.querySelector('.sun-icon');
        const moonIcon = document.querySelector('.moon-icon');
        const digipasLogo = document.querySelector('.digipas-logo'); // Pilih logo digipas

        // Elemen untuk mode malam
        const starContainer = document.getElementById('starContainer');
        const numberOfStars = 100;

        // Elemen untuk mode siang
        const cloudContainer = document.getElementById('cloudContainer');
        const birdContainer = document.getElementById('birdContainer');
        
        // Elemen untuk fitur tampilkan/sembunyikan password
        const passwordInput = document.getElementById('password');
        const showPasswordToggle = document.getElementById('showPasswordToggle');

        // Elemen untuk loader
        const loginForm = document.getElementById('loginForm');
        const loaderOverlay = document.getElementById('loaderOverlay');


        // Fungsi untuk membuat dan menempatkan bintang secara acak
        function createStars() {
            for (let i = 0; i < numberOfStars; i++) {
                const star = document.createElement('span');
                star.classList.add('star');
                const size = Math.random() * 3 + 1; // Ukuran bintang antara 1px dan 4px
                star.style.width = `${size}px`;
                star.style.height = `${size}px`;
                star.style.left = `${Math.random() * 100}%`; // Posisi horizontal acak
                star.style.top = `${Math.random() * 100}%`;  // Posisi vertikal acak
                star.style.animationDuration = `${Math.random() * 2 + 1}s`; // Durasi animasi berkedip acak
                star.style.animationDelay = `${Math.random() * 2}s`; // Penundaan animasi acak
                starContainer.appendChild(star);
            }
        }

        // Fungsi untuk membuat dan menempatkan awan secara acak
        function createClouds() {
            const numClouds = 5; // Jumlah awan
            for (let i = 0; i < numClouds; i++) {
                const cloud = document.createElement('div');
                cloud.classList.add('cloud');
                const size = Math.random() * 100 + 80; // Ukuran awan 80px - 180px
                cloud.style.width = `${size}px`;
                cloud.style.height = `${size * 0.6}px`; // Awan cenderung lebih lebar dari tinggi
                cloud.style.left = `${Math.random() * 100}%`;
                cloud.style.top = `${Math.random() * 40}%`; // Awan di bagian atas layar
                cloud.style.animationDuration = `${Math.random() * 30 + 20}s`; // Durasi drifting 20-50s
                cloud.style.animationDelay = `${Math.random() * 10}s`; // Penundaan acak
                // Mulai sedikit di luar layar kiri untuk animasi masuk
                cloud.style.transform = `translateX(-${Math.random() * 50}vw)`;
                cloudContainer.appendChild(cloud);
            }
        }

        // Fungsi untuk membuat dan menempatkan burung secara acak
        function createBirds() {
            const numBirdFlocks = 4; // Jumlah "flock" burung
            for (let i = 0; i < numBirdFlocks; i++) {
                const bird = document.createElement('div');
                bird.classList.add('bird');
                // Simple V-shaped SVG untuk merepresentasikan sekelompok burung
                bird.innerHTML = `
                    <svg class="w-8 h-8 md:w-10 md:h-10" viewBox="0 0 100 100" fill="none" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M10 50 L30 30 L50 50 L70 30 L90 50"></path>
                    </svg>
                `;
                const startY = Math.random() * 60 + 10; // Posisi Y antara 10% dan 70% layar
                const duration = Math.random() * 15 + 10; // Durasi animasi 10-25s
                const delay = Math.random() * 5; // Penundaan 0-5s

                bird.style.top = `${startY}%`;
                bird.style.animationDuration = `${duration}s`;
                bird.style.animationDelay = `${delay}s`;
                
                // Pilih arah terbang secara acak
                if (Math.random() < 0.5) {
                    bird.style.animationName = 'fly-left-to-right';
                } else {
                    bird.style.animationName = 'fly-right-to-left';
                    bird.querySelector('svg').style.transform = 'scaleX(-1)'; // Balik SVG untuk arah kanan ke kiri
                }

                birdContainer.appendChild(bird);
            }
        }

        // Fungsi untuk menerapkan tema (gelap atau terang)
        function applyTheme(theme) {
            const schoolLogo = document.querySelector('.text-center img[alt="Logo Sekolah"]');
            if (theme === 'dark') {
                htmlElement.classList.add('dark'); // Tambahkan kelas 'dark'
                sunIcon.classList.add('hidden');    // Sembunyikan ikon matahari di tombol
                moonIcon.classList.remove('hidden'); // Tampilkan ikon bulan di tombol
                // Jika logo sekolah ada, terapkan filter untuk mode gelap (membuatnya putih/terbalik)
                if (schoolLogo) {
                    schoolLogo.style.filter = 'brightness(0) invert(1)';
                }
                // Logo Digipas.id tidak diubah filternya agar tetap warna asli di mode gelap
                if (digipasLogo) {
                    digipasLogo.style.filter = 'none'; // Pastikan tidak ada filter yang diterapkan
                }
            } else {
                htmlElement.classList.remove('dark'); // Hapus kelas 'dark'
                sunIcon.classList.remove('hidden');    // Tampilkan ikon matahari di tombol
                moonIcon.classList.add('hidden');      // Sembunyikan ikon bulan di tombol
                // Jika logo sekolah ada, hapus filter untuk mode terang (mengembalikan ke normal)
                if (schoolLogo) {
                    schoolLogo.style.filter = 'none';
                }
                // Hapus filter untuk logo Digipas.id (mengembalikan ke normal)
                if (digipasLogo) {
                    digipasLogo.style.filter = 'none';
                }
            }
        }

        // Panggil fungsi untuk membuat elemen latar belakang saat halaman dimuat
        createStars();
        createClouds();
        createBirds();

        // Periksa preferensi tema yang tersimpan di localStorage saat halaman dimuat
        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            applyTheme(savedTheme); // Terapkan tema yang tersimpan
        } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            // Jika tidak ada preferensi tersimpan, gunakan preferensi sistem operasi
            applyTheme('dark');
        } else {
            applyTheme('light'); // Default ke tema terang jika tidak ada preferensi
        }

        // Tambahkan event listener untuk tombol pengalih tema
        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                // Jika saat ini mode gelap, alih ke terang
                applyTheme('light');
                localStorage.setItem('theme', 'light'); // Simpan preferensi
            } else {
                // Jika saat ini mode terang, alih ke gelap
                localStorage.setItem('theme', 'dark'); // Simpan preferensi
                applyTheme('dark');
            }
        });

        // Tambahkan event listener untuk tombol switch tampilkan/sembunyikan password
        showPasswordToggle.addEventListener('change', () => {
            if (showPasswordToggle.checked) {
                passwordInput.type = 'text'; // Ubah ke teks agar terlihat
            } else {
                passwordInput.type = 'password'; // Ubah kembali ke password
            }
        });

        // Handle form submission to show loader
        loginForm.addEventListener('submit', (e) => {
            // Hanya tampilkan loader jika tidak ada pesan kesalahan yang ditampilkan
            // Ini untuk memastikan loader tidak muncul jika input kosong atau kredensial salah
            const errorMessageDiv = document.querySelector('.bg-red-100');
            if (!errorMessageDiv) { // Jika tidak ada div error, berarti validasi awal sukses
                e.preventDefault(); // Mencegah form submit langsung
                loaderOverlay.classList.add('active'); // Tampilkan loader

                // Simulasikan penundaan sebelum submit form secara programatis
                // Sesuaikan durasi ini sesuai kebutuhan animasi loader Anda
                setTimeout(() => {
                    loginForm.submit(); // Lanjutkan submit form setelah animasi
                }, 1500); // Loader akan tampil selama 1.5 detik
            }
        });

        // Set tahun saat ini
        document.getElementById('currentYear').textContent = new Date().getFullYear();
    </script>
</body>
</html>
