<?php
session_start();
include 'koneksi.php';

// Jika sudah login, langsung lempar ke dashboard siswa
if (isset($_SESSION['role']) && $_SESSION['role'] == 'siswa') {
    header("Location: siswa.php");
    exit;
}

$error = '';

if (isset($_POST['login_siswa'])) {
    $id_siswa = mysqli_real_escape_string($koneksi, $_POST['id_siswa']);
    $password = mysqli_real_escape_string($koneksi, $_POST['password']);

    // Cek ID di database
    $query = mysqli_query($koneksi, "SELECT * FROM students WHERE id = '$id_siswa'");
    
    if (mysqli_num_rows($query) > 0) {
        $data = mysqli_fetch_assoc($query);
        
        // Cek Password
        if ($password == $data['password']) {
            
            // Set Session
            $_SESSION['user_id'] = $data['id'];
            $_SESSION['nama'] = $data['nama'];
            $_SESSION['role'] = 'siswa';
            
            // Update last logged in (Opsional)
            // mysqli_query($koneksi, "UPDATE students SET last_activity = NOW() WHERE id = '$id_siswa'");

            header("Location: siswa.php");
            exit;
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "ID Siswa tidak ditemukan!";
    }
}

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3"; // Default
$logo_sekolah = "assets/img/logo.png"; // Default

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            // Asumsi path upload ada di admin/uploads/ atau sesuaikan dengan struktur folder Anda
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Siswa - <?= $nama_sekolah ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            background: #f0f2f5;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            font-family: 'Segoe UI', sans-serif;
        }
        .login-card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.05);
            overflow: hidden;
            width: 100%;
            max-width: 400px;
            background: white;
        }
        .login-header {
            background: linear-gradient(135deg, #0d6efd, #0a58ca);
            padding: 30px 20px;
            text-align: center;
            color: white;
        }
        .logo-img {
            width: 70px;
            height: 70px;
            object-fit: contain;
            background: white;
            border-radius: 50%;
            padding: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        .form-control {
            border-radius: 10px;
            padding: 12px 15px;
            border: 1px solid #dee2e6;
            background-color: #f8f9fa;
        }
        .form-control:focus {
            background-color: #fff;
            box-shadow: none;
            border-color: #0d6efd;
        }
        .btn-login {
            border-radius: 10px;
            padding: 12px;
            font-weight: bold;
            letter-spacing: 0.5px;
        }
    </style>
</head>
<body>

<div class="container px-3">
    <div class="login-card mx-auto">
        
        <div class="login-header">
            <img src="<?= $logo_sekolah ?>" alt="Logo" class="logo-img" onerror="this.src='https://via.placeholder.com/70?text=Logo'">
            <h5 class="fw-bold mb-0">Portal Siswa</h5>
            <small class="opacity-75"><?= $nama_sekolah ?></small>
        </div>

        <div class="p-4 pt-5">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger d-flex align-items-center mb-4" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    <div style="font-size: 14px;"><?= $error ?></div>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">ID SISWA</label>
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0 text-muted ps-3"><i class="bi bi-person"></i></span>
                        <input type="text" name="id_siswa" class="form-control border-start-0 ps-2" placeholder="Masukkan ID Siswa" required autofocus>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold text-secondary">PASSWORD</label>
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0 text-muted ps-3"><i class="bi bi-lock"></i></span>
                        <input type="password" name="password" id="passwordInput" class="form-control border-start-0 border-end-0 ps-2" placeholder="Masukkan Password" required>
                        <span class="input-group-text bg-white border-start-0" style="cursor: pointer;" onclick="togglePassword()">
                            <i class="bi bi-eye-slash" id="toggleIcon"></i>
                        </span>
                    </div>
                </div>

                <div class="d-grid mb-4">
                    <button type="submit" name="login_siswa" class="btn btn-primary btn-login shadow-sm">
                        MASUK SEKARANG <i class="bi bi-arrow-right ms-2"></i>
                    </button>
                </div>

                <div class="text-center">
                    <a href="login.php" class="text-decoration-none small text-muted">
                        <i class="bi bi-person-workspace me-1"></i> Login sebagai Guru
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <div class="text-center mt-4 text-muted small">
        &copy; <?= date('Y') ?> <?= $nama_sekolah ?>
    </div>
</div>

<script>
    function togglePassword() {
        const passwordInput = document.getElementById('passwordInput');
        const toggleIcon = document.getElementById('toggleIcon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.classList.remove('bi-eye-slash');
            toggleIcon.classList.add('bi-eye');
        } else {
            passwordInput.type = 'password';
            toggleIcon.classList.remove('bi-eye');
            toggleIcon.classList.add('bi-eye-slash');
        }
    }
</script>

</body>
</html>