<?php
session_start();
include 'koneksi.php';

// --- BAGIAN 1: LOGIKA PROSES ABSEN (AJAX HANDLER) ---
if (isset($_POST['action']) && $_POST['action'] == 'proses_absen') {
    header('Content-Type: application/json');
    
    if (!isset($_SESSION['role']) || $_SESSION['role'] != 'siswa') {
        echo json_encode(['status' => 'error', 'message' => 'Sesi tidak valid. Silakan login ulang.']);
        exit;
    }

    $id_siswa = $_SESSION['user_id'];
    $qr_raw = $_POST['qr_content']; 
    
    $qr_data = json_decode($qr_raw, true);
    if (!$qr_data || !isset($qr_data['j']) || !isset($qr_data['t'])) {
        echo json_encode(['status' => 'error', 'message' => 'Format QR Code tidak valid!']);
        exit;
    }

    $id_jadwal = mysqli_real_escape_string($koneksi, $qr_data['j']);
    $token_qr = $qr_data['t'];

    // Validasi Waktu (Interval 5 menit)
    $server_timestamp = floor(time() / 300);
    if (abs($server_timestamp - $token_qr) > 1) {
        echo json_encode(['status' => 'error', 'message' => 'QR Code sudah kadaluarsa. Minta Guru refresh QR!']);
        exit;
    }

    $hari_ini = date('Y-m-d');
    $jam_sekarang = date('H:i:s');
    
    // Cek Double Absen
    $cek_absen = mysqli_query($koneksi, "SELECT id FROM absensi_mapel WHERE id_jadwal='$id_jadwal' AND id_siswa='$id_siswa' AND tanggal='$hari_ini'");
    if (mysqli_num_rows($cek_absen) > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Anda sudah melakukan absen untuk mapel ini!']);
        exit;
    }

    // Simpan Absen
    $q_insert = "INSERT INTO absensi_mapel (id_jadwal, id_siswa, tanggal, jam_absen, status) VALUES ('$id_jadwal', '$id_siswa', '$hari_ini', '$jam_sekarang', 'Hadir')";
    
    if (mysqli_query($koneksi, $q_insert)) {
        echo json_encode(['status' => 'success', 'message' => 'Absensi Berhasil!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal menyimpan data ke database.']);
    }
    exit;
}

// --- BAGIAN 2: HALAMAN UTAMA SISWA ---

// Cek Login Siswa
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'siswa') {
    header("Location: siswa_login.php");
    exit;
}
$id_siswa = $_SESSION['user_id'];

// Ambil Data Siswa
$q_siswa = mysqli_query($koneksi, "SELECT * FROM students WHERE id='$id_siswa'");
$siswa = mysqli_fetch_assoc($q_siswa);

// Ambil Pengaturan Sekolah
$nama_sekolah = "SMK Pasundan 3"; 
$logo_sekolah = "assets/img/logo.png";
$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil Siswa
$foto_profil = 'uploads/siswa/' . ($siswa['foto'] ?? '');
if (empty($siswa['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Siswa"; 
}

// --- LOGIKA JADWAL HARI INI ---
date_default_timezone_set('Asia/Jakarta');
$hari_inggris = date('l');
$map_hari = [
    'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
    'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'
];
$hari_ini_indo = $map_hari[$hari_inggris];
$kelas_siswa = $siswa['kelas'];

// Query Jadwal Join ke Tabel Users (Guru)
$q_jadwal = "SELECT j.*, u.nama_lengkap, u.nomor_hp, u.foto as foto_guru 
             FROM jadwal_mengajar j 
             JOIN users u ON j.id_guru = u.id 
             WHERE j.kelas = '$kelas_siswa' AND j.hari = '$hari_ini_indo' 
             ORDER BY j.jam_mulai ASC";
$res_jadwal = mysqli_query($koneksi, $q_jadwal);

// Ambil Riwayat Absen Hari Ini (Untuk Checklist)
$hari_ini_tgl = date('Y-m-d');
$q_riwayat = mysqli_query($koneksi, "
    SELECT a.jam_absen, a.status, j.mata_pelajaran, j.jam_mulai, j.ruangan 
    FROM absensi_mapel a
    JOIN jadwal_mengajar j ON a.id_jadwal = j.id_jadwal
    WHERE a.id_siswa = '$id_siswa' AND a.tanggal = '$hari_ini_tgl'
    ORDER BY a.jam_absen DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Siswa - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
            cursor: pointer;
        }
        .mobile-nav-fab:active { transform: scale(0.95); }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* --- SCANNER AREA --- */
        #reader {
            width: 100%;
            border-radius: 15px;
            overflow: hidden;
            background: #000;
        }
        #reader video { object-fit: cover; border-radius: 15px; }

        /* --- TIMELINE JADWAL --- */
        .timeline-item { position: relative; padding-left: 20px; border-left: 2px solid #e9ecef; margin-bottom: 15px; padding-bottom: 5px; }
        .timeline-item:last-child { border-left: 2px solid transparent; }
        .timeline-dot { position: absolute; left: -6px; top: 0; width: 10px; height: 10px; border-radius: 50%; background: #198754; }
        
        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Siswa</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($siswa['nama']) ?></strong>
                <small class="text-muted"><?= htmlspecialchars($siswa['kelas']) ?></small>
            </li>
            <li><a class="dropdown-item" href="siswa_profile.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (DESKTOP) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Siswa</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="siswa.php" class="nav-link active"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item">
                    <a href="#" class="nav-link" onclick="startScanner(); return false;"><i class="bi bi-qr-code-scan"></i> Scan Absen</a>
                </li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <!-- SAMBUTAN -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h5 class="fw-bold text-dark mb-0">Halo, <?= explode(' ', $siswa['nama'])[0] ?>! 👋</h5>
                    <small class="text-muted">ID: <?= $siswa['id'] ?> &bull; <?= $siswa['kelas'] ?></small>
                </div>
                <div class="d-none d-md-block">
                     <a href="siswa_profile.php" class="btn btn-outline-secondary btn-sm rounded-pill px-3"><i class="bi bi-gear me-1"></i> Edit Profil</a>
                </div>
            </div>

            <!-- SCANNER SECTION (Hidden by default, shown via JS) -->
            <div id="scanner-wrapper" class="row mb-4" style="display: none;">
                <div class="col-12">
                    <div class="card border-0 shadow-sm rounded-4 bg-dark text-white overflow-hidden">
                        <div class="card-body p-0 text-center position-relative">
                            <div id="reader"></div>
                            <button class="btn btn-light btn-sm position-absolute top-0 end-0 m-3 rounded-pill fw-bold shadow" onclick="stopScanner()">
                                <i class="bi bi-x-lg me-1"></i> Tutup
                            </button>
                            <div class="p-3">
                                <small class="text-white-50"><i class="bi bi-info-circle me-1"></i> Arahkan kamera ke QR Code Guru</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="scan-result" class="alert d-none mb-4 shadow-sm"></div>

            <div class="row g-4">
                
                <!-- KOLOM KIRI: INFO STATS & RIWAYAT ABSEN -->
                <div class="col-lg-4 order-lg-2">
                    <!-- POIN -->
                    <div class="card border-0 shadow-sm rounded-4 bg-primary text-white mb-3">
                        <div class="card-body p-3 d-flex justify-content-between align-items-center">
                            <div>
                                <small class="opacity-75">Sisa Poin</small>
                                <h3 class="fw-bold mb-0"><?= $siswa['sisa_poin'] ?? 100 ?></h3>
                            </div>
                            <div class="text-end opacity-75">
                                <i class="bi bi-star-fill fs-1"></i>
                            </div>
                        </div>
                    </div>

                    <!-- RIWAYAT ABSENSI -->
                    <div class="card border-0 shadow-sm rounded-4">
                        <div class="card-header bg-white border-0 pt-3 pb-0">
                            <h6 class="fw-bold text-dark"><i class="bi bi-clock-history text-success me-2"></i>Absen Hari Ini</h6>
                        </div>
                        <div class="card-body">
                            <?php if(mysqli_num_rows($q_riwayat) > 0): ?>
                                <div class="list-group list-group-flush">
                                    <?php while($row = mysqli_fetch_assoc($q_riwayat)): ?>
                                        <div class="list-group-item border-0 d-flex justify-content-between align-items-center px-0 py-2 border-bottom">
                                            <div>
                                                <h6 class="fw-bold mb-0 text-dark small"><?= $row['mata_pelajaran'] ?></h6>
                                                <small class="text-muted" style="font-size: 10px;"><?= $row['ruangan'] ?></small>
                                            </div>
                                            <span class="badge bg-success bg-opacity-10 text-success rounded-pill" style="font-size: 10px;">
                                                <?= substr($row['jam_absen'], 0, 5) ?>
                                            </span>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <p class="small text-muted text-center py-3 mb-0">Belum ada data.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- KOLOM KANAN: JADWAL PELAJARAN (UTAMA) -->
                <div class="col-lg-8 order-lg-1">
                    <div class="card border-0 shadow-sm rounded-4 h-100">
                        <div class="card-header bg-white border-0 pt-3 pb-0 d-flex justify-content-between align-items-center">
                            <h6 class="fw-bold text-dark"><i class="bi bi-calendar-day text-primary me-2"></i>Jadwal Pelajaran (<?= $hari_ini_indo ?>)</h6>
                        </div>
                        <div class="card-body">
                            <?php if(mysqli_num_rows($res_jadwal) > 0): ?>
                                <?php while($j = mysqli_fetch_assoc($res_jadwal)): 
                                    $foto_guru = !empty($j['foto_guru']) ? 'uploads/'.$j['foto_guru'] : 'https://via.placeholder.com/40?text=Guru';
                                    
                                    // Format WA (08xx -> 628xx)
                                    $hp_guru = $j['nomor_hp'];
                                    if(substr($hp_guru, 0, 1) == '0') {
                                        $hp_guru = '62' . substr($hp_guru, 1);
                                    }
                                ?>
                                <div class="d-flex mb-3 p-3 bg-light rounded-3 border">
                                    <!-- Waktu -->
                                    <div class="text-center me-3 pe-3 border-end d-flex flex-column justify-content-center" style="min-width: 80px;">
                                        <span class="fw-bold text-dark fs-5"><?= substr($j['jam_mulai'], 0, 5) ?></span>
                                        <small class="text-muted"><?= substr($j['jam_selesai'], 0, 5) ?></small>
                                    </div>
                                    
                                    <!-- Info Mapel -->
                                    <div class="flex-grow-1">
                                        <h6 class="fw-bold text-primary mb-1"><?= $j['mata_pelajaran'] ?></h6>
                                        <div class="small text-secondary mb-2">
                                            <i class="bi bi-geo-alt-fill me-1"></i> Ruang <?= $j['ruangan'] ?>
                                        </div>
                                        
                                        <!-- Info Guru -->
                                        <div class="d-flex justify-content-between align-items-center mt-2 pt-2 border-top">
                                            <div class="d-flex align-items-center">
                                                <img src="<?= $foto_guru ?>" class="rounded-circle me-2" style="width: 25px; height: 25px; object-fit: cover;">
                                                <small class="fw-semibold text-dark"><?= $j['nama_lengkap'] ?></small>
                                            </div>
                                            
                                            <?php if(!empty($j['nomor_hp'])): ?>
                                            <a href="https://wa.me/<?= $hp_guru ?>?text=Assalamualaikum Bapak/Ibu <?= $j['nama_lengkap'] ?>, saya <?= $siswa['nama'] ?> dari kelas <?= $siswa['kelas'] ?>..." target="_blank" class="btn btn-sm btn-success rounded-pill py-0 px-2" style="font-size: 11px;">
                                                <i class="bi bi-whatsapp me-1"></i> Chat
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bi bi-calendar-x fs-1 text-muted opacity-25 d-block mb-3"></i>
                                    <h6 class="text-muted">Tidak ada jadwal pelajaran hari ini.</h6>
                                    <small class="text-secondary">Silakan cek jadwal di hari lain atau hubungi wali kelas.</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="siswa.php" class="mobile-nav-item active">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="siswa_profile.php" class="mobile-nav-item">
        <i class="bi bi-person-badge"></i>
        <span>Profil</span>
    </a>
    
    <!-- FAB BUTTON ABSEN (TRIGGER CAMERA) -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="#" class="mobile-nav-fab" onclick="startScanner(); return false;">
            <i class="bi bi-qr-code-scan text-white"></i>
        </a>
        <div class="mobile-nav-text-fab">Scan</div>
    </div>

    <a href="#" class="mobile-nav-item">
        <i class="bi bi-file-text"></i>
        <span>Tugas</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<!-- Load Library Scanner -->
<script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>

<script>
    let html5QrcodeScanner = null;

    function startScanner() {
        const scannerWrapper = document.getElementById('scanner-wrapper');
        scannerWrapper.style.display = 'block';
        document.getElementById('scan-result').classList.add('d-none');
        scannerWrapper.scrollIntoView({ behavior: 'smooth', block: 'center' });

        if (html5QrcodeScanner === null) {
            html5QrcodeScanner = new Html5Qrcode("reader");
            const config = { fps: 10, qrbox: { width: 250, height: 250 } };
            
            html5QrcodeScanner.start({ facingMode: "environment" }, config, onScanSuccess, onScanFailure)
            .catch(err => {
                console.error("Error starting scanner", err);
                alert("Gagal membuka kamera. Pastikan izin kamera aktif.");
            });
        }
    }

    function stopScanner() {
        if (html5QrcodeScanner) {
            html5QrcodeScanner.stop().then(() => {
                document.getElementById('scanner-wrapper').style.display = 'none';
                html5QrcodeScanner.clear();
                html5QrcodeScanner = null;
            }).catch((err) => {
                console.log("Failed to stop scanner", err);
            });
        } else {
            document.getElementById('scanner-wrapper').style.display = 'none';
        }
    }

    function onScanSuccess(decodedText, decodedResult) {
        stopScanner();
        const resDiv = document.getElementById('scan-result');
        resDiv.className = 'alert alert-info mb-4 shadow-sm';
        resDiv.innerHTML = '<div class="d-flex align-items-center"><div class="spinner-border spinner-border-sm me-2"></div> Memproses Absensi...</div>';
        resDiv.classList.remove('d-none');

        const formData = new FormData();
        formData.append('action', 'proses_absen');
        formData.append('qr_content', decodedText);

        fetch('siswa.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                resDiv.className = 'alert alert-success mb-4 shadow-sm border-0 text-white bg-success';
                resDiv.innerHTML = '<div class="d-flex align-items-center"><i class="bi bi-check-circle-fill fs-4 me-2"></i> <div><strong>Berhasil!</strong><br>' + data.message + '</div></div>';
                setTimeout(() => { location.reload(); }, 2000);
            } else {
                resDiv.className = 'alert alert-danger mb-4 shadow-sm border-0 text-white bg-danger';
                resDiv.innerHTML = '<div class="d-flex align-items-center"><i class="bi bi-exclamation-triangle-fill fs-4 me-2"></i> <div><strong>Gagal!</strong><br>' + data.message + '</div></div>';
            }
        })
        .catch(error => {
            resDiv.className = 'alert alert-danger mb-4 shadow-sm';
            resDiv.innerHTML = 'Terjadi kesalahan koneksi.';
        });
    }

    function onScanFailure(error) {
        // No action needed
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>