<?php
session_start();
// Pastikan file koneksi sudah benar path-nya
include 'koneksi.php';

// Atur Timezone ke WIB (Wajib agar sinkron dengan jam lokal)
date_default_timezone_set('Asia/Jakarta');

if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

// Ambil ID dari session (sesuaikan dengan nama session login Anda, misal: id_user atau id_guru)
// Asumsi di sini session-nya menyimpan 'id' atau 'user_id'
$id_guru = $_SESSION['id'] ?? $_SESSION['user_id'] ?? 0; 

if ($id_guru == 0) {
    echo "<script>alert('Sesi tidak valid, silakan login ulang.'); window.location='login.php';</script>";
    exit;
}

$token_diterima = $_GET['token'] ?? '';
$tanggal_hari_ini = date('Y-m-d');
$waktu_sekarang = date('H:i:s');

// --- 1. VALIDASI TOKEN QR ---
// Kita buat fungsi helper agar format tanggal konsisten dengan Generator QR (Admin)
// Format harus SAMA PERSIS dengan file pembuat QR (Y-n-j vs Y-m-d sangat berpengaruh)
function generateToken($timeObject) {
    // Logika pembulatan ke bawah kelipatan 2 menit
    $minute = (int)$timeObject->format('i');
    $roundedMinute = $minute - ($minute % 2);
    
    // Set waktu objek ke menit yang sudah dibulatkan agar detiknya 00
    // Clone agar tidak merubah objek asli
    $t = clone $timeObject;
    $t->setTime($t->format('H'), $roundedMinute, 0);

    // Format string kunci. 
    // PERHATIAN: Pastikan format tanggal ('Y-n-j') sama dengan di file generate QR.
    // Jika di Admin pakai date('Y-m-d'), ubah di sini jadi 'Y-m-d'.
    $keyString = "SECRET_KEY_SEKOLAH_" . $t->format('Y-n-j') . "_" . $t->format('H:i');
    
    // Debugging (Uncomment baris bawah ini jika ingin melihat apa yang dihasilkan server)
    // echo "Server generated: " . $keyString . "<br>";
    
    return base64_encode($keyString);
}

$now = new DateTime(); // Waktu sekarang (sudah Asia/Jakarta)
$token_sekarang = generateToken($now);

// Toleransi waktu: Cek periode 2 menit sebelumnya (menangani perpindahan menit/jam/hari)
$prev = clone $now;
$prev->modify('-2 minutes');
$token_sebelumnya = generateToken($prev);

// Cek apakah token cocok dengan SALAH SATU dari token valid (sekarang atau sebelumnya)
if ($token_diterima !== $token_sekarang && $token_diterima !== $token_sebelumnya) {
    // Opsi Debugging: Tampilkan token jika gagal (Hapus di production)
    // echo "Token Diterima: " . htmlspecialchars($token_diterima) . "<br>";
    // echo "Token Valid 1: " . $token_sekarang . "<br>";
    // echo "Token Valid 2: " . $token_sebelumnya . "<br>";
    // exit;
    
    echo "<script>alert('QR Code Kadaluarsa atau Tidak Valid! Pastikan jam HP dan Server sinkron.'); window.location='home.php';</script>";
    exit;
}

// --- 2. CEK APAKAH SUDAH ABSEN HARI INI ---
// Pastikan nama tabel dan kolom sesuai database Anda
$cek = mysqli_query($koneksi, "SELECT * FROM absensi_guru WHERE id_guru='$id_guru' AND tanggal='$tanggal_hari_ini'");
if (mysqli_num_rows($cek) > 0) {
    echo "<script>alert('Anda sudah melakukan absensi hari ini!'); window.location='home.php';</script>";
    exit;
}

// --- 3. SIMPAN ABSENSI ---
$simpan = mysqli_query($koneksi, "INSERT INTO absensi_guru (id_guru, tanggal, waktu_absen) VALUES ('$id_guru', '$tanggal_hari_ini', '$waktu_sekarang')");

if ($simpan) {
    // --- 4. KIRIM NOTIFIKASI WHATSAPP ---
    $q_user = mysqli_query($koneksi, "SELECT nama_lengkap, nomor_hp FROM users WHERE id='$id_guru'");
    $d_user = mysqli_fetch_assoc($q_user);
    
    if ($d_user) {
        $nomor_hp = $d_user['nomor_hp'];
        $nama_guru = $d_user['nama_lengkap'];

        if (!empty($nomor_hp)) {
            $api_token = "mEu2VduS3iokmYIgaMm0mRc2DvZg6SjozrLecV52EZaMVvCZwRNl51E"; // Sesuaikan token Anda
            $secret_key = "LgoSCsVm"; // Sesuaikan secret key Anda
            $domain_api = "https://jogja.wablas.com";
            
            $pesan = "Halo *$nama_guru*,\n\nTerima kasih, presensi kehadiran Anda pada:\nTanggal: *$tanggal_hari_ini*\nPukul: *$waktu_sekarang* WIB\n\nTelah BERHASIL dicatat oleh sistem.\nSelamat bertugas!";

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, "$domain_api/api/send-message");
            curl_setopt($curl, CURLOPT_HEADER, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query(array(
                'phone' => $nomor_hp,
                'message' => $pesan,
                'secret' => $secret_key, 
            )));
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                "Authorization: $api_token"
            ));
            
            $response = curl_exec($curl);
            curl_close($curl);
        }
    }

    echo "<script>alert('Absensi Berhasil & Notifikasi WA Terkirim! Selamat bekerja.'); window.location='home.php';</script>";
} else {
    echo "<script>alert('Gagal menyimpan absensi: " . mysqli_error($koneksi) . "'); window.location='home.php';</script>";
}
?>