<?php
session_start();
// Menggunakan koneksi.php agar konsisten dengan file lain
include 'koneksi.php';

// Cek login admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$statusMessage = '';
$messageType = '';

// Folder upload
$uploadDir = 'uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// --- LOGIKA UPDATE PENGATURAN ---
if (isset($_POST['update_settings'])) {
    $nama_sekolah = mysqli_real_escape_string($koneksi, $_POST['nama_sekolah']);
    $alamat_sekolah = mysqli_real_escape_string($koneksi, $_POST['alamat_sekolah']);
    $nama_kepsek = mysqli_real_escape_string($koneksi, $_POST['nama_kepala_sekolah']);
    $nuptk_kepsek = mysqli_real_escape_string($koneksi, $_POST['nuptk_kepala_sekolah']);
    
    // Ambil data lama untuk handling gambar
    $q_old = mysqli_query($koneksi, "SELECT logo_sekolah, ttd_kepala_sekolah FROM pengaturan_sekolah WHERE id = 1");
    $old_settings = mysqli_fetch_assoc($q_old);
    
    $logo_name = $old_settings['logo_sekolah'] ?? '';
    $ttd_name = $old_settings['ttd_kepala_sekolah'] ?? '';

    // Handle Upload Logo Sekolah
    if (isset($_FILES['logo_sekolah']) && $_FILES['logo_sekolah']['error'] == 0) {
        $ext = pathinfo($_FILES['logo_sekolah']['name'], PATHINFO_EXTENSION);
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        if (in_array(strtolower($ext), $allowed)) {
            $logo_name = 'logo_' . time() . '.' . $ext;
            move_uploaded_file($_FILES['logo_sekolah']['tmp_name'], $uploadDir . $logo_name);
        } else {
            $statusMessage = "Format logo tidak valid (hanya jpg, png, gif).";
            $messageType = 'danger';
        }
    }

    // Handle Upload TTD Kepala Sekolah
    if (isset($_FILES['ttd_kepala_sekolah']) && $_FILES['ttd_kepala_sekolah']['error'] == 0) {
        $ext = pathinfo($_FILES['ttd_kepala_sekolah']['name'], PATHINFO_EXTENSION);
        $allowed = ['png', 'jpg', 'jpeg']; 
        if (in_array(strtolower($ext), $allowed)) {
            $ttd_name = 'ttd_' . time() . '.' . $ext;
            move_uploaded_file($_FILES['ttd_kepala_sekolah']['tmp_name'], $uploadDir . $ttd_name);
        } else {
            $statusMessage = "Format TTD tidak valid (hanya png, jpg, jpeg).";
            $messageType = 'danger';
        }
    }

    // Query Update / Insert (Menggunakan ON DUPLICATE KEY UPDATE)
    $sql = "INSERT INTO pengaturan_sekolah (id, nama_sekolah, alamat_sekolah, logo_sekolah, nama_kepala_sekolah, nuptk_kepala_sekolah, ttd_kepala_sekolah) 
            VALUES (1, '$nama_sekolah', '$alamat_sekolah', '$logo_name', '$nama_kepsek', '$nuptk_kepsek', '$ttd_name')
            ON DUPLICATE KEY UPDATE 
            nama_sekolah = VALUES(nama_sekolah), 
            alamat_sekolah = VALUES(alamat_sekolah), 
            logo_sekolah = VALUES(logo_sekolah),
            nama_kepala_sekolah = VALUES(nama_kepala_sekolah),
            nuptk_kepala_sekolah = VALUES(nuptk_kepala_sekolah),
            ttd_kepala_sekolah = VALUES(ttd_kepala_sekolah)";

    if (mysqli_query($koneksi, $sql)) {
        $statusMessage = "Pengaturan berhasil diperbarui!";
        $messageType = 'success';
    } else {
        $statusMessage = "Gagal memperbarui: " . mysqli_error($koneksi);
        $messageType = 'danger';
    }
}

// --- AMBIL DATA SAAT INI ---
$q_set = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah WHERE id = 1 LIMIT 1");
$settings = mysqli_fetch_assoc($q_set);

if (!$settings) {
    $settings = [
        'nama_sekolah' => '', 'alamat_sekolah' => '', 'logo_sekolah' => '', 
        'nama_kepala_sekolah' => '', 'nuptk_kepala_sekolah' => '', 'ttd_kepala_sekolah' => ''
    ];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan Sekolah - Admin Panel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; }
        .nav-link { color: #555; }
        .preview-img { max-height: 80px; width: auto; border: 1px solid #ddd; padding: 5px; border-radius: 5px; margin-top: 10px; }
        .form-section-title { color: #198754; font-weight: bold; border-bottom: 2px solid #e8f5e9; padding-bottom: 10px; margin-bottom: 20px; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block pt-3">
            <h5 class="text-success fw-bold px-3 mb-4">ADMIN PANEL</h5>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>jenis pelanggaran & reward</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan Pelanggaran</a></li>
                  <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link active"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            <h4 class="fw-bold mb-4">Pengaturan Sekolah & Kop Surat</h4>

            <?php if ($statusMessage): ?>
                <div class="alert alert-<?= $messageType ?> alert-dismissible fade show shadow-sm" role="alert">
                    <?= $statusMessage ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <form action="" method="POST" enctype="multipart/form-data">
                
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-body p-4">
                        <!-- Bagian Identitas Sekolah -->
                        <h6 class="form-section-title"><i class="bi bi-building me-2"></i>Identitas Sekolah</h6>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Nama Sekolah</label>
                                <input type="text" name="nama_sekolah" value="<?= htmlspecialchars($settings['nama_sekolah']) ?>" class="form-control" required placeholder="Contoh: SMK Negeri 1 Jakarta">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Logo Sekolah (JPG/PNG)</label>
                                <input type="file" name="logo_sekolah" accept="image/*" class="form-control">
                                <?php if(!empty($settings['logo_sekolah'])): ?>
                                    <img src="uploads/<?= htmlspecialchars($settings['logo_sekolah']) ?>" class="preview-img bg-light">
                                    <div class="small text-muted mt-1">Logo saat ini</div>
                                <?php endif; ?>
                            </div>
                            <div class="col-12">
                                <label class="form-label fw-bold small">Alamat Lengkap</label>
                                <textarea name="alamat_sekolah" rows="2" class="form-control" placeholder="Alamat lengkap untuk Kop Surat..."><?= htmlspecialchars($settings['alamat_sekolah']) ?></textarea>
                            </div>
                        </div>

                        <!-- Bagian Kepala Sekolah -->
                        <h6 class="form-section-title mt-4"><i class="bi bi-person-badge me-2"></i>Data Kepala Sekolah</h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Nama Kepala Sekolah (Lengkap Gelar)</label>
                                <input type="text" name="nama_kepala_sekolah" value="<?= htmlspecialchars($settings['nama_kepala_sekolah']) ?>" class="form-control" placeholder="Contoh: Dr. H. Budi, M.Pd">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">NUPTK / NIP</label>
                                <input type="text" name="nuptk_kepala_sekolah" value="<?= htmlspecialchars($settings['nuptk_kepala_sekolah']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Upload Tanda Tangan (Scan Transparan)</label>
                                <input type="file" name="ttd_kepala_sekolah" accept="image/*" class="form-control">
                                <?php if(!empty($settings['ttd_kepala_sekolah'])): ?>
                                    <img src="uploads/<?= htmlspecialchars($settings['ttd_kepala_sekolah']) ?>" class="preview-img">
                                    <div class="small text-muted mt-1">TTD saat ini</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-white text-end py-3 border-0">
                        <button type="submit" name="update_settings" class="btn btn-success px-4 fw-bold shadow-sm">
                            <i class="bi bi-save me-2"></i> Simpan Pengaturan
                        </button>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>