<?php
session_start();
include 'koneksi.php';

// 1. Cek akses guru
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$pesan = ""; 
$tipe_pesan = "";

// --- [BARU] FITUR AJAX: UNTUK MENGAMBIL RIWAYAT SISWA (DETAIL) ---
if (isset($_GET['ajax_history'])) {
    $siswa_id = mysqli_real_escape_string($koneksi, $_GET['ajax_history']);
    
    // Ambil data siswa
    $q_s = mysqli_query($koneksi, "SELECT nama, kelas, sisa_poin FROM students WHERE id = '$siswa_id'");
    $d_s = mysqli_fetch_assoc($q_s);
    
    // Ambil riwayat pelanggaran siswa ini
    $query_detail = "
        SELECT r.tanggal, j.nama_pelanggaran, j.poin_pengurang, u.nama_lengkap as nama_guru
        FROM riwayat_pelanggaran r
        JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id
        JOIN users u ON r.guru_id = u.id
        WHERE r.student_id = '$siswa_id'
        ORDER BY r.tanggal DESC
    ";
    $res_detail = mysqli_query($koneksi, $query_detail);

    // Output HTML untuk Modal
    echo '<div class="alert alert-info mb-3">';
    echo '<strong>' . $d_s['nama'] . ' (' . $d_s['kelas'] . ')</strong><br>';
    echo 'Sisa Poin Saat Ini: <span class="badge bg-primary">' . $d_s['sisa_poin'] . '</span>';
    echo '</div>';

    echo '<div class="table-responsive">';
    echo '<table class="table table-sm table-bordered table-striped">';
    echo '<thead class="table-light"><tr><th>Tanggal</th><th>Pelanggaran</th><th>Poin</th><th>Guru</th></tr></thead>';
    echo '<tbody>';
    
    if (mysqli_num_rows($res_detail) > 0) {
        while ($row = mysqli_fetch_assoc($res_detail)) {
            echo '<tr>';
            echo '<td class="small">' . date('d/m/Y H:i', strtotime($row['tanggal'])) . '</td>';
            echo '<td>' . $row['nama_pelanggaran'] . '</td>';
            echo '<td class="text-danger fw-bold">-' . $row['poin_pengurang'] . '</td>';
            echo '<td class="small text-muted">' . $row['nama_guru'] . '</td>';
            echo '</tr>';
        }
    } else {
        echo '<tr><td colspan="4" class="text-center text-muted">Belum ada catatan pelanggaran.</td></tr>';
    }
    
    echo '</tbody></table></div>';
    exit; // Stop script agar tidak me-load seluruh halaman
}
// -----------------------------------------------------------------

// --- AMBIL DATA USER (GURU) ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);

// --- AMBIL DATA PENGATURAN SEKOLAH (Opsional) ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// --- LOGIKA FILTER KELAS ---
$q_kelas_list = mysqli_query($koneksi, "SELECT DISTINCT kelas FROM students ORDER BY kelas ASC");
$selected_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';

// --- PROSES INPUT PELANGGARAN ---
if (isset($_POST['simpan_pelanggaran'])) {
    $student_id = $_POST['student_id'];
    $jenis_id   = $_POST['jenis_pelanggaran_id'];
    
    $q_jenis = mysqli_query($koneksi, "SELECT poin_pengurang FROM jenis_pelanggaran WHERE id = '$jenis_id'");
    $d_jenis = mysqli_fetch_assoc($q_jenis);
    $poin_kurang = $d_jenis['poin_pengurang'];

    $update_siswa = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin - $poin_kurang WHERE id = '$student_id'");
    
    if ($update_siswa) {
        $tgl = date('Y-m-d H:i:s');
        $insert = mysqli_query($koneksi, "INSERT INTO riwayat_pelanggaran (student_id, guru_id, jenis_pelanggaran_id, tanggal) VALUES ('$student_id', '$id_guru', '$jenis_id', '$tgl')");

        if ($insert) {
            $pesan = "Pelanggaran berhasil dicatat! Poin siswa berkurang $poin_kurang.";
            $tipe_pesan = "success";
        } else {
            $pesan = "Gagal mencatat riwayat.";
            $tipe_pesan = "danger";
        }
    } else {
        $pesan = "Gagal mengupdate poin siswa.";
        $tipe_pesan = "danger";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Pelanggaran - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER & NAV --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV (ANDROID STYLE) --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown" aria-expanded="false">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (Updated Menu Structure) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <!-- Menu ini Aktif -->
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link active"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            <h4 class="fw-bold mb-4">Input Pelanggaran Siswa</h4>

            <?php if ($pesan != ""): ?>
                <div class="alert alert-<?= $tipe_pesan ?> alert-dismissible fade show shadow-sm border-0" role="alert">
                    <i class="bi bi-info-circle-fill me-2"></i> <?= $pesan ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <!-- FORM INPUT -->
                <div class="col-lg-6 mb-4">
                    <div class="card border-0 shadow-sm rounded-4">
                        <div class="card-header bg-white border-0 pt-4 pb-0">
                            <h6 class="fw-bold text-dark"><i class="bi bi-pencil-square text-success me-2"></i>Form Pelanggaran</h6>
                        </div>
                        <div class="card-body p-4">
                            
                            <!-- FILTER KELAS -->
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">Filter Kelas</label>
                                <select class="form-select bg-light" onchange="window.location.href='?kelas='+this.value">
                                    <option value="">-- Semua Kelas --</option>
                                    <?php while($k = mysqli_fetch_assoc($q_kelas_list)): ?>
                                        <option value="<?= $k['kelas'] ?>" <?= ($selected_kelas == $k['kelas']) ? 'selected' : '' ?>>
                                            <?= $k['kelas'] ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <form action="" method="POST">
                                <!-- PILIH SISWA -->
                                <div class="mb-3">
                                    <label class="form-label fw-bold small text-muted">Cari Nama Siswa</label>
                                    <select id="select-siswa" name="student_id" class="form-select" required>
                                        <option value="">-- Cari Siswa --</option>
                                        <?php
                                        // Modifikasi Query Berdasarkan Filter Kelas
                                        $sql_siswa = "SELECT id, nama, kelas, sisa_poin FROM students";
                                        if ($selected_kelas != '') {
                                            $kelas_safe = mysqli_real_escape_string($koneksi, $selected_kelas);
                                            $sql_siswa .= " WHERE kelas = '$kelas_safe'";
                                        }
                                        $sql_siswa .= " ORDER BY nama ASC";
                                        
                                        $q_siswa = mysqli_query($koneksi, $sql_siswa);
                                        while ($s = mysqli_fetch_assoc($q_siswa)) {
                                            echo "<option value='" . $s['id'] . "'>" . $s['nama'] . " (" . $s['kelas'] . ") - Poin: " . $s['sisa_poin'] . "</option>";
                                        }
                                        ?>
                                    </select>
                                    
                                    <!-- TOMBOL DETAIL SISWA -->
                                    <button type="button" id="btn-lihat-detail" class="btn btn-sm btn-outline-info mt-2 w-100" disabled>
                                        <i class="bi bi-eye"></i> Lihat Riwayat Siswa Ini
                                    </button>
                                </div>

                                <!-- PILIH PELANGGARAN -->
                                <div class="mb-4">
                                    <label class="form-label fw-bold small text-muted">Jenis Pelanggaran</label>
                                    
                                    <!-- SEARCH PELANGGARAN -->
                                    <div class="input-group mb-2">
                                        <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
                                        <input type="text" id="search-pelanggaran" class="form-control" placeholder="Cari pelanggaran (ketik disini)...">
                                    </div>

                                    <div id="list-pelanggaran" class="d-grid gap-2" style="max-height: 300px; overflow-y: auto;">
                                        <?php
                                        $q_jenis = mysqli_query($koneksi, "SELECT * FROM jenis_pelanggaran ORDER BY poin_pengurang ASC");
                                        while ($j = mysqli_fetch_assoc($q_jenis)) :
                                        ?>
                                            <label class="pelanggaran-item btn btn-outline-light text-dark text-start d-flex justify-content-between align-items-center border">
                                                <span>
                                                    <input type="radio" name="jenis_pelanggaran_id" value="<?= $j['id'] ?>" class="form-check-input me-2" required>
                                                    <span class="pelanggaran-text"><?= $j['nama_pelanggaran'] ?></span>
                                                </span>
                                                <span class="badge bg-danger rounded-pill">-<?= $j['poin_pengurang'] ?></span>
                                            </label>
                                        <?php endwhile; ?>
                                    </div>
                                </div>

                                <button type="submit" name="simpan_pelanggaran" class="btn btn-success w-100 py-2 fw-bold shadow-sm">
                                    <i class="bi bi-save me-2"></i> Simpan Laporan
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- RIWAYAT GLOBAL -->
                <div class="col-lg-6">
                    <div class="card border-0 shadow-sm rounded-4">
                        <div class="card-header bg-white border-0 pt-4 pb-0">
                            <h6 class="fw-bold text-dark"><i class="bi bi-clock-history text-primary me-2"></i>Input Terakhir Anda</h6>
                        </div>
                        <div class="card-body p-0 pt-3">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle mb-0">
                                    <thead class="bg-light text-secondary small">
                                        <tr>
                                            <th class="ps-4">Waktu</th>
                                            <th>Siswa</th>
                                            <th>Pelanggaran</th>
                                        </tr>
                                    </thead>
                                    <tbody class="border-top-0">
                                        <?php
                                        $query_history = "
                                            SELECT r.tanggal, s.nama as nama_siswa, s.kelas, j.nama_pelanggaran, j.poin_pengurang
                                            FROM riwayat_pelanggaran r
                                            JOIN students s ON r.student_id = s.id
                                            JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id
                                            WHERE r.guru_id = '$id_guru' 
                                            ORDER BY r.tanggal DESC LIMIT 5
                                        ";
                                        $res_history = mysqli_query($koneksi, $query_history);
                                        
                                        if ($res_history && mysqli_num_rows($res_history) > 0) {
                                            while ($h = mysqli_fetch_assoc($res_history)) {
                                                echo "<tr>";
                                                echo "<td class='ps-4 small text-muted'>" . date('d/m H:i', strtotime($h['tanggal'])) . "</td>";
                                                echo "<td><span class='fw-bold'>" . $h['nama_siswa'] . "</span><br><small class='text-muted'>" . $h['kelas'] . "</small></td>";
                                                echo "<td>" . $h['nama_pelanggaran'] . " <span class='badge bg-danger text-white ms-1'>-" . $h['poin_pengurang'] . "</span></td>";
                                                echo "</tr>";
                                            }
                                        } else {
                                            echo "<tr><td colspan='3' class='text-center py-4 text-muted small'>Belum ada input.</td></tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL DETAIL RIWAYAT SISWA -->
<div class="modal fade" id="modalDetailSiswa" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="bi bi-clock-history"></i> Riwayat Pelanggaran</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="modal-content-body">
                <div class="text-center py-3">
                    <div class="spinner-border text-primary" role="status"></div>
                    <p class="mt-2 small text-muted">Memuat data...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <!-- Active state di Pelanggaran -->
    <a href="pelanggaran.php" class="mobile-nav-item active">
        <i class="bi bi-exclamation-triangle-fill"></i>
        <span>Poin</span>
    </a>
    
    <!-- FAB BUTTON ABSEN -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>

    <a href="profile.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        // Init Select2
        $('#select-siswa').select2({
            theme: 'bootstrap-5',
            placeholder: "Ketik nama siswa...",
            allowClear: true,
            width: '100%'
        });

        // --- PERBAIKAN SCRIPT PENCARIAN JENIS PELANGGARAN ---
        // ID input search disesuaikan dengan HTML (#search-pelanggaran)
        $('#search-pelanggaran').on('keyup', function() {
            var value = $(this).val().toLowerCase();
            
            // Mencari di dalam container #list-pelanggaran pada elemen .pelanggaran-item
            $('#list-pelanggaran .pelanggaran-item').each(function() {
                var text = $(this).text().toLowerCase();
                
                // Jika cocok, tampilkan (hapus d-none, tambah d-flex untuk layout)
                if (text.indexOf(value) > -1) {
                    $(this).removeClass('d-none').addClass('d-flex');
                } else {
                    // Jika tidak cocok, sembunyikan (tambah d-none, hapus d-flex)
                    $(this).addClass('d-none').removeClass('d-flex');
                }
            });
        });

        // LOGIKA TOMBOL DETAIL SISWA
        $('#select-siswa').on('change', function() {
            var siswaId = $(this).val();
            if (siswaId) {
                $('#btn-lihat-detail').removeAttr('disabled').removeClass('btn-outline-info').addClass('btn-info text-white');
            } else {
                $('#btn-lihat-detail').attr('disabled', 'disabled').removeClass('btn-info text-white').addClass('btn-outline-info');
            }
        });

        // Klik tombol -> Buka Modal -> Ajax Load Data
        $('#btn-lihat-detail').click(function() {
            var siswaId = $('#select-siswa').val();
            if(!siswaId) return;

            // Tampilkan Modal
            var myModal = new bootstrap.Modal(document.getElementById('modalDetailSiswa'));
            myModal.show();

            // Reset isi modal ke loading
            $('#modal-content-body').html('<div class="text-center py-3"><div class="spinner-border text-primary"></div><p class="mt-2 small text-muted">Memuat data...</p></div>');

            // Panggil data via AJAX
            $.ajax({
                url: 'pelanggaran.php', 
                type: 'GET',
                data: { ajax_history: siswaId },
                success: function(response) {
                    $('#modal-content-body').html(response);
                },
                error: function() {
                    $('#modal-content-body').html('<div class="alert alert-danger">Gagal mengambil data.</div>');
                }
            });
        });
    });
</script>
</body>
</html>