<?php
session_start();
include 'koneksi.php';

// --- LOGIKA SETTING SEKOLAH (Agar Logo & Nama Dinamis) ---
$nama_sekolah = "SMK Pasundan 3"; // Default
$logo_sekolah = "assets/img/logo.png"; // Default

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}
// ---------------------------------------------------------

if (isset($_POST['login'])) {
    $username = mysqli_real_escape_string($koneksi, $_POST['username']);
    $password = $_POST['password'];

    // Ambil data user berdasarkan username
    $query = mysqli_query($koneksi, "SELECT * FROM users WHERE username='$username'");
    $data = mysqli_fetch_assoc($query);

    if ($data) {
        // Cek password langsung (Tanpa Hash sesuai request awal)
        if ($password == $data['password']) {
            
            // Set Session
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $data['role'];
            $_SESSION['user_id'] = $data['id'];
            $_SESSION['nama'] = $data['nama_lengkap'];
            $_SESSION['mata_pelajaran'] = $data['mata_pelajaran']; 

            // Redirect sesuai role
            if ($data['role'] == 'admin') {
                header("Location: dashboard.php");
            } else {
                // Arahkan ke home.php (Dashboard Guru yang sudah dibuat sebelumnya)
                header("Location: home.php");
            }
            exit;
        } else {
            $error = "Password yang Anda masukkan salah.";
        }
    } else {
        $error = "Username tidak terdaftar.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        body {
            background-color: #f5f7fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-card {
            width: 100%;
            max-width: 400px;
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.05);
            overflow: hidden;
            background: white;
        }

        .login-header {
            background: linear-gradient(135deg, #198754, #20c997);
            padding: 40px 30px;
            text-align: center;
            color: white;
            position: relative;
        }

        .login-header::after {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 0;
            right: 0;
            height: 40px;
            background: white;
            border-top-left-radius: 25px;
            border-top-right-radius: 25px;
        }

        .logo-container {
            width: 90px;
            height: 90px;
            background: white;
            border-radius: 50%;
            padding: 10px;
            margin: 0 auto 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .login-body {
            padding: 30px;
            padding-top: 10px;
        }

        .form-floating > .form-control:focus, .form-floating > .form-control:not(:placeholder-shown) {
            padding-top: 1.625rem;
            padding-bottom: .625rem;
        }

        .btn-login {
            background: #198754;
            border: none;
            padding: 12px;
            font-weight: 600;
            letter-spacing: 0.5px;
            border-radius: 10px;
            transition: all 0.3s;
        }

        .btn-login:hover {
            background: #146c43;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(25, 135, 84, 0.3);
        }
    </style>
</head>
<body>

    <div class="login-card">
        <!-- Header dengan Logo -->
        <div class="login-header">
            <div class="logo-container">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="logo-img" onerror="this.src='https://via.placeholder.com/100?text=Logo'">
            </div>
            <h5 class="fw-bold mb-0">Sistem Informasi Sekolah</h5>
            <small class="opacity-75"><?= $nama_sekolah ?></small>
        </div>

        <div class="login-body">
            <h4 class="text-center fw-bold text-dark mb-4">LOGIN DIGIPAS</h4>

            <?php if(isset($error)): ?>
                <div class="alert alert-danger py-2 text-center small shadow-sm border-0" role="alert">
                    <i class="bi bi-exclamation-circle-fill me-1"></i> <?= $error ?>
                </div>
            <?php endif; ?>
            
            <form method="POST">
                <!-- Username -->
                <div class="form-floating mb-3">
                    <input type="text" class="form-control bg-light border-0" id="username" name="username" placeholder="Username" required>
                    <label for="username" class="text-muted"><i class="bi bi-person me-2"></i>Username</label>
                </div>

                <!-- Password -->
                <div class="form-floating mb-4">
                    <input type="password" class="form-control bg-light border-0" id="password" name="password" placeholder="Password" required>
                    <label for="password" class="text-muted"><i class="bi bi-lock me-2"></i>Password</label>
                </div>

                <!-- Tombol Login -->
                <div class="d-grid">
                    <button type="submit" name="login" class="btn btn-primary btn-login text-white">
                        MASUK <i class="bi bi-box-arrow-in-right ms-2"></i>
                    </button>
                </div>
            </form>

            <div class="text-center mt-4">
                <small class="text-muted">&copy; <?= date('Y') ?> <?= $nama_sekolah ?></small>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>