<?php
session_start();
include 'koneksi.php';

// 1. Cek akses guru
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];

// --- AMBIL DATA USER (GURU) TERBARU ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);
$mapel_guru = $guru['mata_pelajaran'];

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
$sekolah = mysqli_fetch_assoc($q_sekolah);

$nama_sekolah = isset($sekolah['nama_sekolah']) ? $sekolah['nama_sekolah'] : "E-Learning Sekolah";
$logo_sekolah = isset($sekolah['logo_sekolah']) ? 'admin/uploads/' . $sekolah['logo_sekolah'] : 'assets/img/logo.png';

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}
// -------------------------------------

// --- PROSES EXPORT WORD ---
if (isset($_POST['export_word'])) {
    header("Content-Type: application/vnd.ms-word");
    header("Content-Disposition: attachment; filename=Bank_Soal_".$mapel_guru.".doc");
    header("Pragma: no-cache");
    header("Expires: 0");

    echo '
    <html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <style>
            table { border-collapse: collapse; width: 100%; font-family: Arial, sans-serif; font-size: 12px; }
            th { background-color: #cccccc; font-weight: bold; text-align: center; padding: 8px; border: 1px solid black; }
            td { padding: 5px; border: 1px solid black; vertical-align: top; }
        </style>
    </head>
    <body>
    <h3 style="text-align: center; font-family: Arial;">Bank Soal Mata Pelajaran: '.$mapel_guru.'</h3>
    <table>
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="15%">Jenis</th>
                <th width="65%">Isi</th>
                <th width="15%">Jawaban</th>
            </tr>
        </thead>
        <tbody>';

    $q_export = mysqli_query($koneksi, "SELECT * FROM soal WHERE guru_id='$id_guru' ORDER BY id ASC");
    $no = 1;
    while ($row = mysqli_fetch_assoc($q_export)) {
        $pertanyaan_bersih = str_replace(chr(194).chr(160), ' ', $row['pertanyaan']);
        
        echo '
        <tr>
            <td style="text-align: center;">' . $no . '</td>
            <td>SOAL</td>
            <td>' . nl2br(htmlspecialchars($pertanyaan_bersih)) . '</td>
            <td style="background-color: #ffff00;"></td>
        </tr>';

        $opsi_arr = ['a', 'b', 'c', 'd', 'e'];
        foreach ($opsi_arr as $o) {
            $is_correct = (strtoupper($o) == $row['kunci_jawaban']) ? '1' : '0';
            $opsi_bersih = str_replace(chr(194).chr(160), ' ', $row['opsi_' . $o]);

            echo '
            <tr>
                <td></td>
                <td>JAWABAN</td>
                <td>' . htmlspecialchars($opsi_bersih) . '</td>
                <td style="text-align: center;">' . $is_correct . '</td>
            </tr>';
        }
        $no++;
    }

    echo '</tbody></table></body></html>';
    exit; 
}
// ---------------------------

$msg = "";
$err = "";

// 2. PROSES SIMPAN SOAL BARU
if (isset($_POST['simpan_soal'])) {
    $pertanyaan = mysqli_real_escape_string($koneksi, $_POST['pertanyaan']);
    $opsi_a = mysqli_real_escape_string($koneksi, $_POST['opsi_a']);
    $opsi_b = mysqli_real_escape_string($koneksi, $_POST['opsi_b']);
    $opsi_c = mysqli_real_escape_string($koneksi, $_POST['opsi_c']);
    $opsi_d = mysqli_real_escape_string($koneksi, $_POST['opsi_d']);
    $opsi_e = mysqli_real_escape_string($koneksi, $_POST['opsi_e']);
    $kunci = $_POST['kunci'];

    $sql = "INSERT INTO soal (guru_id, mata_pelajaran, pertanyaan, opsi_a, opsi_b, opsi_c, opsi_d, opsi_e, kunci_jawaban) 
            VALUES ('$id_guru', '$mapel_guru', '$pertanyaan', '$opsi_a', '$opsi_b', '$opsi_c', '$opsi_d', '$opsi_e', '$kunci')";
    
    if (mysqli_query($koneksi, $sql)) {
        $msg = "Soal berhasil ditambahkan!";
    } else {
        $err = "Gagal menyimpan soal: " . mysqli_error($koneksi);
    }
}

// 3. PROSES UPDATE SOAL (EDIT)
if (isset($_POST['update_soal'])) {
    $id_soal = $_POST['id_soal'];
    $pertanyaan = mysqli_real_escape_string($koneksi, $_POST['pertanyaan']);
    $opsi_a = mysqli_real_escape_string($koneksi, $_POST['opsi_a']);
    $opsi_b = mysqli_real_escape_string($koneksi, $_POST['opsi_b']);
    $opsi_c = mysqli_real_escape_string($koneksi, $_POST['opsi_c']);
    $opsi_d = mysqli_real_escape_string($koneksi, $_POST['opsi_d']);
    $opsi_e = mysqli_real_escape_string($koneksi, $_POST['opsi_e']);
    $kunci = $_POST['kunci'];

    $sql = "UPDATE soal SET 
            pertanyaan='$pertanyaan', 
            opsi_a='$opsi_a', 
            opsi_b='$opsi_b', 
            opsi_c='$opsi_c', 
            opsi_d='$opsi_d', 
            opsi_e='$opsi_e', 
            kunci_jawaban='$kunci' 
            WHERE id='$id_soal' AND guru_id='$id_guru'";
    
    if (mysqli_query($koneksi, $sql)) {
        $msg = "Soal berhasil diperbarui!";
    } else {
        $err = "Gagal memperbarui soal: " . mysqli_error($koneksi);
    }
}

// 4. PROSES IMPORT SOAL
if (isset($_POST['import_copy_paste'])) {
    $raw_text = $_POST['raw_text'];
    $lines = preg_split('/\r\n|\r|\n/', $raw_text);
    $soal_list = [];
    $index = -1;
    $mode = '';
    $last_opsi_key = '';

    foreach ($lines as $line) {
        $line = trim($line); 
        if (empty($line)) continue; 

        if (preg_match('/^\d+[\.\)]\s*(.*)/', $line, $matches)) {
            $index++;
            $isi_pertanyaan = $matches[1];
            $isi_pertanyaan = preg_replace('/^[\s\xC2\xA0]+/', '', $isi_pertanyaan);

            $soal_list[$index] = [
                'pertanyaan' => $isi_pertanyaan,
                'a' => '-', 'b' => '-', 'c' => '-', 'd' => '-', 'e' => '-', 
                'kunci' => 'A' 
            ];
            $mode = 'pertanyaan';
        }
        elseif (preg_match('/^(\*)?\s*([A-E])[\.\)]\s*(.*)/i', $line, $matches)) {
            if ($index >= 0) {
                $star_prefix = $matches[1];
                $opsi_key = strtolower($matches[2]);
                $isi_jawaban = $matches[3];

                $is_key = ($star_prefix == '*') || (strpos($isi_jawaban, '*') !== false);
                $isi_jawaban_bersih = str_replace('*', '', $isi_jawaban);
                $isi_jawaban_bersih = preg_replace('/^[\s\xC2\xA0]+/', '', $isi_jawaban_bersih);

                $soal_list[$index][$opsi_key] = trim($isi_jawaban_bersih);
                
                if ($is_key) {
                    $soal_list[$index]['kunci'] = strtoupper($opsi_key);
                }

                $mode = 'opsi';
                $last_opsi_key = $opsi_key;
            }
        }
        else {
            if ($index >= 0) {
                if ($mode == 'pertanyaan') {
                    $line_clean = preg_replace('/^[\s\xC2\xA0]+/', '', $line);
                    $soal_list[$index]['pertanyaan'] .= " " . $line_clean;
                } elseif ($mode == 'opsi') {
                    if (strpos($line, '*') !== false) {
                        $soal_list[$index]['kunci'] = strtoupper($last_opsi_key);
                        $line = str_replace('*', '', $line);
                    }
                    $line_clean = preg_replace('/^[\s\xC2\xA0]+/', '', $line);
                    $soal_list[$index][$last_opsi_key] .= " " . $line_clean;
                }
            }
        }
    }

    $count_success = 0;
    foreach ($soal_list as $s) {
        $p = mysqli_real_escape_string($koneksi, $s['pertanyaan']);
        $a = mysqli_real_escape_string($koneksi, $s['a']);
        $b = mysqli_real_escape_string($koneksi, $s['b']);
        $c = mysqli_real_escape_string($koneksi, $s['c']);
        $d = mysqli_real_escape_string($koneksi, $s['d']);
        $e = mysqli_real_escape_string($koneksi, $s['e']);
        $k = $s['kunci'];

        $sql_import = "INSERT INTO soal (guru_id, mata_pelajaran, pertanyaan, opsi_a, opsi_b, opsi_c, opsi_d, opsi_e, kunci_jawaban) 
                        VALUES ('$id_guru', '$mapel_guru', '$p', '$a', '$b', '$c', '$d', '$e', '$k')";
        if (mysqli_query($koneksi, $sql_import)) {
            $count_success++;
        }
    }

    if ($count_success > 0) {
        $msg = "Berhasil mengimport $count_success soal! Kunci jawaban otomatis terdeteksi dari teks tebal/bintang.";
    } else {
        $err = "Gagal mengimport soal. Pastikan setiap soal diawali angka (1.) dan opsi diawali huruf (A.).";
    }
}

// 5. PROSES HAPUS SOAL (SATUAN)
if (isset($_GET['hapus'])) {
    $id_hapus = $_GET['hapus'];
    mysqli_query($koneksi, "DELETE FROM soal WHERE id='$id_hapus' AND guru_id='$id_guru'");
    header("Location: soal2.php");
    exit;
}

// 6. PROSES HAPUS TERPILIH (MASSAL)
if (isset($_POST['hapus_terpilih'])) {
    if (!empty($_POST['ids'])) {
        $ids = $_POST['ids']; // Array ID
        $ids_string = implode(",", array_map('intval', $ids));
        
        $q_del_massal = mysqli_query($koneksi, "DELETE FROM soal WHERE id IN ($ids_string) AND guru_id='$id_guru'");
        if ($q_del_massal) {
            $msg = count($ids) . " soal terpilih berhasil dihapus!";
        } else {
            $err = "Gagal menghapus soal terpilih: " . mysqli_error($koneksi);
        }
    } else {
        $err = "Tidak ada soal yang dipilih untuk dihapus.";
    }
}

// 7. PROSES HAPUS SEMUA
if (isset($_POST['hapus_semua'])) {
    $q_del_all = mysqli_query($koneksi, "DELETE FROM soal WHERE guru_id='$id_guru'");
    if ($q_del_all) {
        $msg = "Semua soal berhasil dihapus bersih!";
    } else {
        $err = "Gagal menghapus semua soal: " . mysqli_error($koneksi);
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Soal - <?= $nama_sekolah ?></title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER & NAV --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV (ANDROID STYLE) --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* Style khusus untuk Rich Text Paste Area */
        #pasteArea {
            min-height: 250px;
            max-height: 400px;
            overflow-y: auto;
            border: 1px solid #ced4da;
            padding: 10px;
            border-radius: 5px;
            background: #fff;
            white-space: pre-wrap; 
        }
        #pasteArea:focus {
            outline: none;
            border-color: #86b7fe;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown" aria-expanded="false">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <!-- Menu ini Aktif -->
                <li class="nav-item"><a href="soal2.php" class="nav-link active"><i class="bi bi-file-earmark-text-fill"></i> Bank Soal</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold mb-0">Bank Soal: <?= $mapel_guru ?></h4>
            </div>

            <?php if(!empty($msg)) echo "<div class='alert alert-success alert-dismissible fade show shadow-sm border-0'>$msg <button type='button' class='btn-close' data-bs-dismiss='alert'></button></div>"; ?>
            <?php if(!empty($err)) echo "<div class='alert alert-danger alert-dismissible fade show shadow-sm border-0'>$err <button type='button' class='btn-close' data-bs-dismiss='alert'></button></div>"; ?>

            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-white border-bottom py-3 rounded-top-4">
                    <div class="row g-2 align-items-center">
                        <div class="col-md-8 d-flex gap-2 flex-wrap">
                            <!-- TOMBOL TAMBAH MANUAL (MODAL) -->
                            <button type="button" class="btn btn-success rounded-pill shadow-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
                                <i class="bi bi-plus-lg me-1"></i> Tambah
                            </button>
                            <!-- TOMBOL IMPORT (MODAL) -->
                            <button type="button" class="btn btn-outline-success rounded-pill shadow-sm" data-bs-toggle="modal" data-bs-target="#modalImport">
                                <i class="bi bi-clipboard-plus me-1"></i> Import
                            </button>

                            <!-- TOMBOL HAPUS MASSAL & HAPUS SEMUA -->
                            <div class="vr mx-2 d-none d-md-block"></div>
                            <button type="submit" form="formSoal" name="hapus_terpilih" class="btn btn-danger rounded-pill shadow-sm" onclick="return confirm('Yakin ingin menghapus soal yang dicentang?')">
                                <i class="bi bi-check2-square me-1"></i> Hapus
                            </button>
                            <button type="submit" form="formSoal" name="hapus_semua" class="btn btn-outline-danger rounded-pill shadow-sm" onclick="return confirm('PERINGATAN KERAS!\n\nSemua soal Anda akan dihapus permanen.\nApakah Anda benar-benar yakin?')">
                                <i class="bi bi-trash-fill me-1"></i> Reset
                            </button>
                        </div>
                        <div class="col-md-4 text-md-end mt-2 mt-md-0">
                            <!-- FORM EXPORT -->
                            <form method="POST" target="_blank" class="d-inline">
                                <button type="submit" name="export_word" class="btn btn-primary rounded-pill shadow-sm">
                                    <i class="bi bi-file-earmark-word me-1"></i> Export
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <form id="formSoal" method="POST">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%" class="text-center">
                                            <input type="checkbox" id="checkAll" class="form-check-input">
                                        </th>
                                        <th width="5%" class="text-center">No</th>
                                        <th>Pertanyaan (Cuplikan)</th>
                                        <th width="10%" class="text-center">Kunci</th>
                                        <th width="20%" class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    $tampil = mysqli_query($koneksi, "SELECT * FROM soal WHERE guru_id='$id_guru' ORDER BY id DESC");
                                    while ($data = mysqli_fetch_array($tampil)) :
                                        $pertanyaan_pendek = substr($data['pertanyaan'], 0, 100) . (strlen($data['pertanyaan']) > 100 ? '...' : '');
                                    ?>
                                    <tr>
                                        <td class="text-center">
                                            <input type="checkbox" name="ids[]" value="<?= $data['id'] ?>" class="form-check-input checkItem">
                                        </td>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td class="p-3">
                                            <div class="fw-bold text-dark"><?= nl2br(htmlspecialchars($pertanyaan_pendek)) ?></div>
                                            <small class="text-muted">A: <?= htmlspecialchars(substr($data['opsi_a'], 0, 30)) ?>...</small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success rounded-pill px-3"><?= $data['kunci_jawaban'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-sm btn-info text-white btn-detail" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#modalDetail"
                                                    data-pertanyaan="<?= htmlspecialchars($data['pertanyaan']) ?>"
                                                    data-a="<?= htmlspecialchars($data['opsi_a']) ?>"
                                                    data-b="<?= htmlspecialchars($data['opsi_b']) ?>"
                                                    data-c="<?= htmlspecialchars($data['opsi_c']) ?>"
                                                    data-d="<?= htmlspecialchars($data['opsi_d']) ?>"
                                                    data-e="<?= htmlspecialchars($data['opsi_e']) ?>"
                                                    data-kunci="<?= $data['kunci_jawaban'] ?>"
                                                    title="Lihat Detail">
                                                    <i class="bi bi-eye"></i>
                                                </button>
                                                <button type="button" class="btn btn-sm btn-warning text-white btn-edit" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#modalEdit"
                                                    data-id="<?= $data['id'] ?>"
                                                    data-pertanyaan="<?= htmlspecialchars($data['pertanyaan']) ?>"
                                                    data-a="<?= htmlspecialchars($data['opsi_a']) ?>"
                                                    data-b="<?= htmlspecialchars($data['opsi_b']) ?>"
                                                    data-c="<?= htmlspecialchars($data['opsi_c']) ?>"
                                                    data-d="<?= htmlspecialchars($data['opsi_d']) ?>"
                                                    data-e="<?= htmlspecialchars($data['opsi_e']) ?>"
                                                    data-kunci="<?= $data['kunci_jawaban'] ?>"
                                                    title="Edit Soal">
                                                    <i class="bi bi-pencil"></i>
                                                </button>
                                                <a href="soal2.php?hapus=<?= $data['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus soal ini?')" title="Hapus">
                                                    <i class="bi bi-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </form>
                    
                    <?php if(mysqli_num_rows($tampil) == 0): ?>
                        <div class="text-center py-5 text-muted">
                            <i class="bi bi-clipboard-x display-4 d-block mb-3 opacity-50"></i>
                            Belum ada soal. Silakan klik tombol <strong>Tambah</strong>.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- 1. MODAL TAMBAH SOAL (MANUAL) -->
<div class="modal fade" id="modalTambah" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title fw-bold"><i class="bi bi-plus-circle me-2"></i>Tambah Soal Baru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Pertanyaan</label>
                        <textarea name="pertanyaan" class="form-control" rows="3" required placeholder="Tulis soal..."></textarea>
                    </div>
                    <label class="form-label fw-bold">Pilihan Jawaban</label>
                    <div class="row g-2 mb-3">
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">A</span>
                            <input type="text" name="opsi_a" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">B</span>
                            <input type="text" name="opsi_b" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">C</span>
                            <input type="text" name="opsi_c" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">D</span>
                            <input type="text" name="opsi_d" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">E</span>
                            <input type="text" name="opsi_e" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Kunci Jawaban</label>
                        <select name="kunci" class="form-select" required>
                            <option value="">-- Pilih Kunci --</option>
                            <option value="A">A</option>
                            <option value="B">B</option>
                            <option value="C">C</option>
                            <option value="D">D</option>
                            <option value="E">E</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="simpan_soal" class="btn btn-success">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- 2. MODAL IMPORT SOAL (COPY PASTE - UPDATED) -->
<div class="modal fade" id="modalImport" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">Import Soal (Copy Paste)</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="formImport" onsubmit="processPasteContent()">
                <div class="modal-body">
                    <div class="alert alert-info small">
                        <strong>Cara Penggunaan:</strong><br>
                        1. Copy soal dari Word/Web.<br>
                        2. <strong>Pastikan jawaban yang benar ditebalkan (Bold)</strong> pada huruf atau isinya.<br>
                        3. Paste ke dalam kotak di bawah ini. Sistem akan otomatis mendeteksi kunci jawaban.
                    </div>
                    
                    <div id="pasteArea" contenteditable="true" placeholder="Paste soal disini..."></div>
                    <textarea name="raw_text" id="hiddenRawText" style="display:none;"></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="import_copy_paste" class="btn btn-primary">Proses Import</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- 3. MODAL EDIT SOAL -->
<div class="modal fade" id="modalEdit" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title fw-bold"><i class="bi bi-pencil-square me-2"></i>Edit Soal</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_soal" id="edit_id">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Pertanyaan</label>
                        <textarea name="pertanyaan" id="edit_pertanyaan" class="form-control" rows="3" required></textarea>
                    </div>
                    <label class="form-label fw-bold">Pilihan Jawaban</label>
                    <div class="row g-2 mb-3">
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">A</span>
                            <input type="text" name="opsi_a" id="edit_a" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">B</span>
                            <input type="text" name="opsi_b" id="edit_b" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">C</span>
                            <input type="text" name="opsi_c" id="edit_c" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">D</span>
                            <input type="text" name="opsi_d" id="edit_d" class="form-control" required>
                        </div>
                        <div class="col-md-6 input-group input-group-sm">
                            <span class="input-group-text bg-light fw-bold">E</span>
                            <input type="text" name="opsi_e" id="edit_e" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Kunci Jawaban</label>
                        <select name="kunci" id="edit_kunci" class="form-select" required>
                            <option value="A">A</option>
                            <option value="B">B</option>
                            <option value="C">C</option>
                            <option value="D">D</option>
                            <option value="E">E</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="update_soal" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- 4. MODAL DETAIL SOAL -->
<div class="modal fade" id="modalDetail" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title fw-bold"><i class="bi bi-eye me-2"></i>Detail Soal</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="fw-bold small text-muted">Pertanyaan:</label>
                    <p id="detail_pertanyaan" class="fw-bold"></p>
                </div>
                <hr>
                <div class="mb-2"><span class="badge bg-light text-dark border me-2">A</span> <span id="detail_a"></span></div>
                <div class="mb-2"><span class="badge bg-light text-dark border me-2">B</span> <span id="detail_b"></span></div>
                <div class="mb-2"><span class="badge bg-light text-dark border me-2">C</span> <span id="detail_c"></span></div>
                <div class="mb-2"><span class="badge bg-light text-dark border me-2">D</span> <span id="detail_d"></span></div>
                <div class="mb-2"><span class="badge bg-light text-dark border me-2">E</span> <span id="detail_e"></span></div>
                <hr>
                <div class="alert alert-success py-2 mb-0">
                    <strong>Kunci Jawaban: </strong> <span id="detail_kunci" class="fw-bold fs-5"></span>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <!-- FAB BUTTON ABSEN -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <a href="profil.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // 1. Script Check All
    document.getElementById('checkAll').addEventListener('click', function() {
        let checkboxes = document.querySelectorAll('.checkItem');
        for (let checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    });

    // 2. Script Populate Modal Edit & Detail
    const modalEdit = document.getElementById('modalEdit');
    modalEdit.addEventListener('show.bs.modal', event => {
        const button = event.relatedTarget;
        modalEdit.querySelector('#edit_id').value = button.getAttribute('data-id');
        modalEdit.querySelector('#edit_pertanyaan').value = button.getAttribute('data-pertanyaan');
        modalEdit.querySelector('#edit_a').value = button.getAttribute('data-a');
        modalEdit.querySelector('#edit_b').value = button.getAttribute('data-b');
        modalEdit.querySelector('#edit_c').value = button.getAttribute('data-c');
        modalEdit.querySelector('#edit_d').value = button.getAttribute('data-d');
        modalEdit.querySelector('#edit_e').value = button.getAttribute('data-e');
        modalEdit.querySelector('#edit_kunci').value = button.getAttribute('data-kunci');
    });

    const modalDetail = document.getElementById('modalDetail');
    modalDetail.addEventListener('show.bs.modal', event => {
        const button = event.relatedTarget;
        modalDetail.querySelector('#detail_pertanyaan').innerText = button.getAttribute('data-pertanyaan');
        modalDetail.querySelector('#detail_a').innerText = button.getAttribute('data-a');
        modalDetail.querySelector('#detail_b').innerText = button.getAttribute('data-b');
        modalDetail.querySelector('#detail_c').innerText = button.getAttribute('data-c');
        modalDetail.querySelector('#detail_d').innerText = button.getAttribute('data-d');
        modalDetail.querySelector('#detail_e').innerText = button.getAttribute('data-e');
        modalDetail.querySelector('#detail_kunci').innerText = button.getAttribute('data-kunci');
    });

    // 3. Script Proses Copy Paste (PENTING UNTUK DETEKSI BOLD)
    function processPasteContent() {
        var pasteDiv = document.getElementById("pasteArea");
        
        // Manipulasi DOM sementara untuk menandai teks bold dengan bintang (*)
        // Kita cari tag <b>, <strong>, atau style font-weight: bold
        var bolds = pasteDiv.querySelectorAll("b, strong");
        bolds.forEach(function(node) {
            node.prepend("*"); // Tambah bintang di depan teks tebal
        });

        // Ambil text content (sudah ada bintangnya sekarang)
        var rawText = pasteDiv.innerText;
        document.getElementById("hiddenRawText").value = rawText;
        return true;
    }
</script>

</body>
</html>