<?php
session_start();
date_default_timezone_set('Asia/Jakarta');
include 'koneksi.php';

// 1. Cek akses guru
if (!isset($_SESSION['role'])) { // Sesuaikan dengan login check di home.php
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$current_page = basename($_SERVER['PHP_SELF']);

// --- LOGIKA RESET SESI SINGLE (POST) ---
if (isset($_POST['reset_session'])) {
    $id_siswa_reset = intval($_POST['id_siswa']);
    
    // Reset sesi dan set last_activity ke masa lalu agar offline
    $reset_query = mysqli_query($koneksi, "UPDATE students SET last_logged_in_device_id = NULL, last_activity = DATE_SUB(NOW(), INTERVAL 10 MINUTE) WHERE id = '$id_siswa_reset'");
    
    if ($reset_query) {
        $_SESSION['notif'] = "Sesi login siswa berhasil direset & status diubah ke Offline.";
        $_SESSION['notif_type'] = "success";
    } else {
        $_SESSION['notif'] = "Gagal mereset sesi.";
        $_SESSION['notif_type'] = "danger";
    }
    header("Location: " . $current_page);
    exit;
}

// --- LOGIKA RESET SESI MASAL / BULK (POST) ---
if (isset($_POST['bulk_reset']) && isset($_POST['ids'])) {
    $ids = $_POST['ids']; 
    if (is_array($ids) && count($ids) > 0) {
        $clean_ids = array_map('intval', $ids);
        $ids_string = implode(',', $clean_ids); 

        $reset_query = mysqli_query($koneksi, "UPDATE students SET last_logged_in_device_id = NULL, last_activity = DATE_SUB(NOW(), INTERVAL 10 MINUTE) WHERE id IN ($ids_string)");
        
        if ($reset_query) {
            $_SESSION['notif'] = count($ids) . " sesi siswa berhasil direset & di-offline-kan.";
            $_SESSION['notif_type'] = "success";
        } else {
            $_SESSION['notif'] = "Gagal melakukan reset masal.";
            $_SESSION['notif_type'] = "danger";
        }
    }
    header("Location: " . $current_page);
    exit;
}

// --- AJAX HANDLER UNTUK PENCARIAN & FILTER REAL-TIME ---
if (isset($_GET['action']) && $_GET['action'] == 'fetch_siswa') {
    header('Content-Type: application/json');

    $keyword = isset($_GET['keyword']) ? mysqli_real_escape_string($koneksi, $_GET['keyword']) : '';
    $kelas = isset($_GET['kelas']) ? mysqli_real_escape_string($koneksi, $_GET['kelas']) : '';
    $ruangan = isset($_GET['ruangan']) ? mysqli_real_escape_string($koneksi, $_GET['ruangan']) : '';
    $status = isset($_GET['status']) ? $_GET['status'] : '';

    $query_str = "SELECT * FROM students WHERE (nama LIKE '%$keyword%' OR nomor_wa LIKE '%$keyword%')";

    if (!empty($kelas)) {
        $query_str .= " AND kelas = '$kelas'";
    }
    if (!empty($ruangan)) {
        $query_str .= " AND ruangan = '$ruangan'";
    }
    
    // Filter Online (Aktif dalam 5 menit terakhir)
    if ($status == 'online') {
        $query_str .= " AND last_activity > (NOW() - INTERVAL 5 MINUTE)";
    }

    $query_str .= " ORDER BY kelas ASC, nama ASC";
    $result = mysqli_query($koneksi, $query_str);
    
    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $last_activity = strtotime($row['last_activity']);
        $is_online = (time() - $last_activity) < 300; 

        // Placeholder Foto
        $foto_path = 'uploads/siswa/' . $row['foto']; 
        if (empty($row['foto']) || !file_exists($foto_path)) {
            $foto_path = "https://ui-avatars.com/api/?name=" . urlencode($row['nama']) . "&background=random&color=fff";
        }

        $row['nama'] = htmlspecialchars($row['nama']);
        $row['has_session'] = !empty($row['last_logged_in_device_id']);
        $row['is_online'] = $is_online;
        $row['foto_url'] = $foto_path;
        $data[] = $row;
    }
    
    echo json_encode($data);
    exit;
}

// --- DATA UTAMA HALAMAN ---
$query_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($query_guru);

// Setup Foto Profil Guru
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// Statistik
$total_soal = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT COUNT(*) as total FROM soal WHERE guru_id='$id_guru'"))['total'];
$total_siswa = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT COUNT(*) as total FROM students"))['total'];
$online_siswa = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT COUNT(*) as total FROM students WHERE last_activity > (NOW() - INTERVAL 5 MINUTE)"))['total'];

// List Dropdown
$list_kelas = mysqli_query($koneksi, "SELECT DISTINCT kelas FROM students ORDER BY kelas ASC");
$list_ruangan = mysqli_query($koneksi, "SELECT DISTINCT ruangan FROM students ORDER BY ruangan ASC");

// Data Sekolah
$q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
$sekolah = mysqli_fetch_assoc($q_sekolah);
$nama_sekolah = isset($sekolah['nama_sekolah']) ? $sekolah['nama_sekolah'] : "CBT E-Learning";
$logo_sekolah = "assets/img/logo.png"; 
if (isset($sekolah['logo_sekolah']) && !empty($sekolah['logo_sekolah'])) {
    $logo_sekolah = 'admin/uploads/' . $sekolah['logo_sekolah'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monitoring Siswa - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL (Sama dengan home.php) --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR (DESKTOP) --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- STATS & TABLE SPECIFIC --- */
        .stat-card { border: none; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.03); transition: transform 0.2s; background: white; }
        .stat-card:hover { transform: translateY(-5px); }
        
        .table-container { background: white; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.03); overflow: hidden; min-height: 400px;}
        .table thead th { background-color: #f8fafc; font-weight: 600; text-transform: uppercase; font-size: 0.8rem; color: #64748b; padding: 15px; border-bottom: 2px solid #e2e8f0; }
        .table tbody td { padding: 12px 15px; vertical-align: middle; border-bottom: 1px solid #f1f5f9; }
        .table-hover tbody tr:hover { background-color: #f8fafc; }
        
        .avatar-small { width: 36px; height: 36px; border-radius: 50%; object-fit: cover; margin-right: 12px; }
        .status-badge { padding: 5px 10px; border-radius: 20px; font-size: 0.75rem; font-weight: 600; display: inline-flex; align-items: center; gap: 5px; }

        /* --- MOBILE BOTTOM NAV (ANDROID STYLE) --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (Konsisten dengan home.php) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <!-- Menu ini Aktif -->
                <li class="nav-item"><a href="guru_reset.php" class="nav-link active"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <?php if (isset($_SESSION['notif'])): ?>
                <div class="alert alert-<?= $_SESSION['notif_type'] ?> alert-dismissible fade show shadow-sm border-0" role="alert">
                    <i class="bi bi-info-circle-fill me-2"></i> <?= $_SESSION['notif'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['notif']); unset($_SESSION['notif_type']); ?>
            <?php endif; ?>

            <!-- STATISTIK RINGKAS -->
            <div class="row mb-4 g-3">
                <div class="col-6 col-md-4">
                    <div class="card stat-card p-3 h-100">
                        <div class="d-flex align-items-center">
                            <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3 text-primary"><i class="bi bi-journal-text fs-4"></i></div>
                            <div>
                                <h6 class="text-muted mb-0 small">Total Soal</h6>
                                <h4 class="fw-bold mb-0"><?= $total_soal ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6 col-md-4">
                    <div class="card stat-card p-3 h-100">
                        <div class="d-flex align-items-center">
                            <div class="rounded-circle bg-secondary bg-opacity-10 p-3 me-3 text-secondary"><i class="bi bi-people-fill fs-4"></i></div>
                            <div>
                                <h6 class="text-muted mb-0 small">Total Siswa</h6>
                                <h4 class="fw-bold mb-0"><?= $total_siswa ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="card stat-card p-3 h-100">
                        <div class="d-flex align-items-center">
                            <div class="rounded-circle bg-success bg-opacity-10 p-3 me-3 text-success"><i class="bi bi-wifi fs-4"></i></div>
                            <div>
                                <h6 class="text-muted mb-0 small">Siswa Online</h6>
                                <h4 class="fw-bold mb-0 text-success"><?= $online_siswa ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- TABEL MONITORING -->
            <div class="card border-0 shadow-sm rounded-4 bg-white">
                <div class="card-header bg-white border-0 pt-4 px-4 pb-0 d-flex justify-content-between align-items-center flex-wrap gap-2">
                    <h5 class="fw-bold mb-0">Monitoring & Reset Sesi</h5>
                    
                    <button id="btn-bulk-reset" onclick="confirmBulkReset()" class="btn btn-danger btn-sm rounded-pill px-3 shadow-sm" style="display: none;">
                        <i class="bi bi-trash-fill me-1"></i> Reset Terpilih (<span id="count-selected">0</span>)
                    </button>
                </div>

                <div class="card-body px-4">
                    <div class="row g-2 mb-3">
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0"><i class="bi bi-search text-muted"></i></span>
                                <input type="text" id="keyword" class="form-control bg-light border-start-0" placeholder="Cari nama siswa...">
                            </div>
                        </div>
                        <div class="col-4 col-md-2">
                            <select id="filter-kelas" class="form-select bg-light">
                                <option value="">Semua Kelas</option>
                                <?php while($k = mysqli_fetch_assoc($list_kelas)): ?>
                                    <option value="<?= $k['kelas'] ?>"><?= $k['kelas'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-4 col-md-2">
                            <select id="filter-ruangan" class="form-select bg-light">
                                <option value="">Semua Ruang</option>
                                <?php while($r = mysqli_fetch_assoc($list_ruangan)): ?>
                                    <option value="<?= $r['ruangan'] ?>"><?= $r['ruangan'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-4 col-md-2">
                            <select id="filter-status" class="form-select bg-light">
                                <option value="">Semua Status</option>
                                <option value="online">Online Saja</option>
                            </select>
                        </div>
                        <div class="col-md-2 d-grid">
                            <button onclick="loadSiswa()" class="btn btn-primary"><i class="bi bi-arrow-clockwise"></i> Refresh</button>
                        </div>
                    </div>

                    <div class="table-responsive table-container">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th style="width: 40px;" class="text-center">
                                        <input type="checkbox" id="check-all" class="form-check-input" onclick="toggleSelectAll(this)">
                                    </th>
                                    <th>Nama Siswa</th>
                                    <th class="d-none d-md-table-cell">Detail</th>
                                    <th class="d-none d-md-table-cell">Status Login</th>
                                    <th class="text-end">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="siswa-container">
                                <tr><td colspan="5" class="text-center py-5 text-muted">Memuat data...</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <a href="profil.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Variabel PHP ke JS agar URL dinamis
const CURRENT_FILE = '<?= $current_page ?>';

function formatTime(dateString) {
    if (!dateString) return '-';
    // Mengubah format waktu SQL ke format lokal
    const date = new Date(dateString.replace(/-/g, "/")); 
    return date.toLocaleTimeString('id-ID', { hour: '2-digit', minute: '2-digit' });
}

function loadSiswa() {
    const keyword = document.getElementById('keyword').value;
    const kelas = document.getElementById('filter-kelas').value;
    const ruangan = document.getElementById('filter-ruangan').value;
    const status = document.getElementById('filter-status').value;

    const url = `${CURRENT_FILE}?action=fetch_siswa&keyword=${keyword}&kelas=${kelas}&ruangan=${ruangan}&status=${status}`;

    fetch(url)
        .then(response => {
            if (!response.ok) throw new Error("Gagal mengambil data");
            return response.json();
        })
        .then(data => {
            const container = document.getElementById('siswa-container');
            let newHtml = ''; 

            if (data.length === 0) {
                newHtml = '<tr><td colspan="5" class="text-center text-muted py-5"><i class="bi bi-search display-6 d-block mb-2"></i>Tidak ada data siswa ditemukan.</td></tr>';
            } else {
                data.forEach(siswa => {
                    const hasSession = siswa.has_session;
                    
                    let statusColorClass = siswa.is_online ? 'text-success' : 'text-secondary';
                    let statusBgClass = siswa.is_online ? 'bg-success bg-opacity-10' : 'bg-secondary bg-opacity-10';
                    let statusIcon = siswa.is_online ? '<span class="spinner-grow spinner-grow-sm me-1" role="status" style="width:8px;height:8px;"></span>' : '<i class="bi bi-moon-stars me-1"></i>';
                    let statusText = siswa.is_online ? 'Online' : 'Offline';

                    let statusBadgeDesktop = `<span class="status-badge ${statusBgClass} ${statusColorClass}">${statusIcon} ${statusText}</span>`;
                    let statusBadgeMobile = `<span class="badge ${statusBgClass} ${statusColorClass} border border-0 fw-normal" style="font-size: 10px;">${statusIcon} ${statusText}</span>`;

                    // Tombol Reset Individu
                    const btnReset = hasSession 
                        ? `<button onclick="confirmReset(${siswa.id}, '${siswa.nama}')" class="btn btn-sm btn-outline-danger btn-reset-mobile shadow-sm" title="Reset Sesi">
                             <i class="bi bi-power"></i> <span class="btn-reset-label ms-1">Reset</span>
                           </button>` 
                        : `<span class="text-muted small fst-italic d-none d-md-inline">No Session</span><span class="d-md-none text-muted" style="font-size:10px;">-</span>`;

                    // Logic Checkbox
                    const currentChecked = document.querySelector(`.siswa-checkbox[value="${siswa.id}"]:checked`);
                    const isChecked = currentChecked ? 'checked' : '';
                    const checkbox = `<input type="checkbox" class="form-check-input siswa-checkbox" value="${siswa.id}" ${isChecked} onchange="updateBulkBtn()">`;

                    newHtml += `
                        <tr>
                            <td class="col-checkbox">${checkbox}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="${siswa.foto_url}" class="avatar-small shadow-sm">
                                    <div>
                                        <div class="user-name fw-bold text-dark">${siswa.nama}</div>
                                        
                                        <div class="user-details d-md-none">
                                            <span class="badge bg-light text-dark border">${siswa.kelas}</span>
                                            <span class="badge bg-light text-secondary border">${siswa.ruangan}</span>
                                            ${statusBadgeMobile}
                                        </div>

                                        <small class="text-muted d-none d-md-block">${siswa.kelas} - ${siswa.ruangan}</small>
                                    </div>
                                </div>
                            </td>
                            
                            <td class="d-none d-md-table-cell">
                                <span class="badge bg-light text-dark border me-1">${siswa.kelas}</span>
                                <span class="badge bg-light text-secondary border">${siswa.ruangan}</span>
                            </td>
                            <td class="d-none d-md-table-cell">
                                <div class="d-flex flex-column">
                                    <div class="mb-1">${statusBadgeDesktop}</div>
                                    <small class="text-muted" style="font-size:11px;">Aktif: ${formatTime(siswa.last_activity)}</small>
                                </div>
                            </td>
                            
                            <td class="text-end">
                                ${btnReset}
                            </td>
                        </tr>
                    `;
                });
            }

            container.innerHTML = newHtml;
            updateBulkBtn();
        })
        .catch(error => {
            console.error('Error fetching data:', error);
        });
}

// --- LOGIKA BULK ACTION ---
function toggleSelectAll(source) {
    const checkboxes = document.querySelectorAll('.siswa-checkbox');
    checkboxes.forEach(cb => {
        cb.checked = source.checked;
    });
    updateBulkBtn();
}

function updateBulkBtn() {
    const checkedBoxes = document.querySelectorAll('.siswa-checkbox:checked');
    const btn = document.getElementById('btn-bulk-reset');
    const countSpan = document.getElementById('count-selected');
    
    if(countSpan) countSpan.innerText = checkedBoxes.length;

    if (btn) {
        if (checkedBoxes.length > 0) {
            btn.style.display = 'inline-block';
        } else {
            btn.style.display = 'none';
             const checkAll = document.getElementById('check-all');
             if(checkAll && checkedBoxes.length === 0) checkAll.checked = false;
        }
    }
}

function confirmBulkReset() {
    const checkedBoxes = document.querySelectorAll('.siswa-checkbox:checked');
    if (checkedBoxes.length === 0) return;

    let ids = [];
    checkedBoxes.forEach(cb => ids.push(cb.value));

    Swal.fire({
        title: 'Reset ' + ids.length + ' Siswa?',
        text: `Anda akan mengeluarkan ${ids.length} siswa terpilih dari sesi ujian mereka.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, Reset Semua!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = CURRENT_FILE; 

            const inputAction = document.createElement('input');
            inputAction.type = 'hidden';
            inputAction.name = 'bulk_reset';
            inputAction.value = '1';
            form.appendChild(inputAction);

            ids.forEach(id => {
                const inputId = document.createElement('input');
                inputId.type = 'hidden';
                inputId.name = 'ids[]';
                inputId.value = id;
                form.appendChild(inputId);
            });

            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Event Listeners Filter
document.getElementById('keyword').addEventListener('keyup', loadSiswa);
document.getElementById('filter-kelas').addEventListener('change', loadSiswa);
document.getElementById('filter-ruangan').addEventListener('change', loadSiswa);
document.getElementById('filter-status').addEventListener('change', loadSiswa);

// Init & Auto Refresh
document.addEventListener('DOMContentLoaded', () => {
    loadSiswa(); 
    setInterval(loadSiswa, 5000); 
});

// SweetAlert Individual Reset
function confirmReset(id, nama) {
    Swal.fire({
        title: 'Reset Sesi?',
        text: `Reset sesi login untuk ${nama}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Reset'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = CURRENT_FILE; 
            
            const inputId = document.createElement('input');
            inputId.type = 'hidden';
            inputId.name = 'id_siswa';
            inputId.value = id;
            
            const inputAction = document.createElement('input');
            inputAction.type = 'hidden';
            inputAction.name = 'reset_session';
            inputAction.value = '1';
            
            form.appendChild(inputId);
            form.appendChild(inputAction);
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>

</body>
</html>