<?php
session_start();
include 'koneksi.php';

// 1. Cek Login
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$id_jadwal = isset($_GET['id_jadwal']) ? $_GET['id_jadwal'] : 0;
$hari_ini_tgl = date('Y-m-d');

// --- 2. AMBIL DATA USER (GURU) & PENGATURAN (Untuk Tampilan Sidebar/Header) ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
if (!$q_guru || mysqli_num_rows($q_guru) == 0) {
    $guru = ['nama_lengkap' => 'Guru Pengajar', 'foto' => ''];
} else {
    $guru = mysqli_fetch_assoc($q_guru);
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// Pengaturan Sekolah
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 
$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
    }
}

// --- 3. VALIDASI JADWAL UTAMA ---
$q_jadwal = mysqli_query($koneksi, "SELECT * FROM jadwal_mengajar WHERE id_jadwal='$id_jadwal' AND id_guru='$id_guru'");
if (mysqli_num_rows($q_jadwal) == 0) {
    echo "<script>alert('Jadwal tidak valid!'); window.location='home.php';</script>";
    exit;
}
$jadwal = mysqli_fetch_assoc($q_jadwal);
$kelas_target = $jadwal['kelas'];
$ruangan_target = $jadwal['ruangan'];

// --- 4. PROSES LOGIKA (Jurnal & Absen) ---

// Simpan Jurnal
if (isset($_POST['simpan_jurnal'])) {
    $materi = mysqli_real_escape_string($koneksi, $_POST['materi']);
    $tugas = mysqli_real_escape_string($koneksi, $_POST['tugas']);
    
    $cek_jurnal = mysqli_query($koneksi, "SELECT id FROM jurnal_mengajar WHERE id_jadwal='$id_jadwal' AND tanggal='$hari_ini_tgl'");
    
    if (mysqli_num_rows($cek_jurnal) > 0) {
        $q_update = "UPDATE jurnal_mengajar SET materi='$materi', tugas='$tugas' WHERE id_jadwal='$id_jadwal' AND tanggal='$hari_ini_tgl'";
        mysqli_query($koneksi, $q_update);
    } else {
        $q_insert = "INSERT INTO jurnal_mengajar (id_jadwal, id_guru, tanggal, materi, tugas) VALUES ('$id_jadwal', '$id_guru', '$hari_ini_tgl', '$materi', '$tugas')";
        mysqli_query($koneksi, $q_insert);
    }
    echo "<script>alert('Jurnal berhasil disimpan!');</script>";
}

// Simpan Absen Manual
if (isset($_POST['simpan_absen_manual'])) {
    $status_siswa = $_POST['status']; 
    foreach ($status_siswa as $id_siswa => $status) {
        $jam_sekarang = date('H:i:s');
        $cek_absen = mysqli_query($koneksi, "SELECT id FROM absensi_mapel WHERE id_jadwal='$id_jadwal' AND id_siswa='$id_siswa' AND tanggal='$hari_ini_tgl'");
        
        if (mysqli_num_rows($cek_absen) > 0) {
            mysqli_query($koneksi, "UPDATE absensi_mapel SET status='$status' WHERE id_jadwal='$id_jadwal' AND id_siswa='$id_siswa' AND tanggal='$hari_ini_tgl'");
        } else {
            if ($status != '') {
                mysqli_query($koneksi, "INSERT INTO absensi_mapel (id_jadwal, id_siswa, tanggal, jam_absen, status) VALUES ('$id_jadwal', '$id_siswa', '$hari_ini_tgl', '$jam_sekarang', '$status')");
            }
        }
    }
    echo "<script>alert('Absensi manual berhasil disimpan!');</script>";
}

// Ambil Data Jurnal Hari Ini
$q_jurnal_today = mysqli_query($koneksi, "SELECT * FROM jurnal_mengajar WHERE id_jadwal='$id_jadwal' AND tanggal='$hari_ini_tgl'");
$jurnal_today = mysqli_fetch_assoc($q_jurnal_today);
$val_materi = $jurnal_today['materi'] ?? '';
$val_tugas = $jurnal_today['tugas'] ?? '';

// Ambil Data Siswa
$q_siswa = mysqli_query($koneksi, "SELECT s.id, s.nama, s.foto, a.status 
                                   FROM students s 
                                   LEFT JOIN absensi_mapel a ON s.id = a.id_siswa AND a.id_jadwal='$id_jadwal' AND a.tanggal='$hari_ini_tgl'
                                   WHERE s.kelas='$kelas_target' AND s.ruangan='$ruangan_target' 
                                   ORDER BY s.nama ASC");

// Ambil Histori
$q_history = mysqli_query($koneksi, "SELECT * FROM jurnal_mengajar WHERE id_jadwal='$id_jadwal' AND tanggal < '$hari_ini_tgl' ORDER BY tanggal DESC LIMIT 5");

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mengajar - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    
    <style>
        /* --- CSS GLOBAL DARI DESIGN BARU --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* SIDEBAR (DESKTOP) */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* MOBILE HEADER */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* MOBILE BOTTOM NAV */
        .mobile-bottom-nav {
            display: none; position: fixed; bottom: 0; left: 0; right: 0;
            background: white; box-shadow: 0 -5px 20px rgba(0,0,0,0.05); z-index: 1000;
            height: 70px; justify-content: space-between; align-items: center;
            padding: 0 15px; border-top-left-radius: 20px; border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* --- STYLE KHUSUS HALAMAN MENGAJAR --- */
        .card-shadow { box-shadow: 0 4px 15px rgba(0,0,0,0.05); border: none; border-radius: 12px; transition: transform 0.2s; }
        .avatar-small { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; }
        #qrcode img { margin: auto; }
        
        .nav-pills .nav-link.active { background-color: #198754 !important; }
        .nav-pills .nav-link { color: #198754; font-weight: 600; border: 1px solid #f0f0f0; margin-right: 5px; }
        .nav-pills .nav-link:hover { background-color: #f8f9fa; }

        .header-course-card {
            background: linear-gradient(135deg, #198754, #20c997);
            color: white; border-radius: 15px; padding: 20px; position: relative; overflow: hidden;
        }
        .header-course-card::after {
            content: ""; position: absolute; right: -20px; bottom: -20px;
            width: 100px; height: 100px; background: rgba(255,255,255,0.1);
            border-radius: 50%;
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding: 15px; }
            .header-course-card { padding: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER (Sama seperti Dashboard) -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <a href="home.php" class="text-secondary me-3"><i class="bi bi-arrow-left fs-4"></i></a>
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 35px; width: 35px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;">Panel Guru</h6>
            <small class="text-muted" style="font-size: 11px;">Mengajar</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
            </li>
            <li><a class="dropdown-item" href="profile.php">Profil</a></li>
            <li><a class="dropdown-item text-danger" href="logout.php">Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (Sama seperti Dashboard) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="#" class="nav-link active"><i class="bi bi-pencil-square"></i> Mengajar</a></li>
                <li class="nav-item"><a href="segerahadir.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <!-- HEADER INFO MAPEL -->
            <div class="header-course-card mb-4 shadow-sm">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <a href="home.php" class="text-white text-decoration-none d-none d-md-inline-block mb-2"><i class="bi bi-arrow-left me-1"></i> Kembali ke Dashboard</a>
                        <h4 class="fw-bold mb-0"><?= $jadwal['mata_pelajaran'] ?></h4>
                        <div class="mt-2 opacity-75">
                            <i class="bi bi-house-door me-1"></i> <?= $jadwal['kelas'] ?> &nbsp;|&nbsp; 
                            <i class="bi bi-geo-alt me-1"></i> <?= $jadwal['ruangan'] ?>
                        </div>
                    </div>
                    <div class="text-end d-none d-md-block">
                        <div class="bg-white text-success px-3 py-2 rounded-pill fw-bold shadow-sm">
                            <i class="bi bi-calendar-event me-2"></i><?= date('d M Y') ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- TABS NAVIGATION -->
            <div class="card card-shadow mb-3">
                <div class="card-body p-2">
                    <ul class="nav nav-pills nav-fill" id="pills-tab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active rounded-pill" id="pills-absen-tab" data-bs-toggle="pill" data-bs-target="#pills-absen" type="button" role="tab"><i class="bi bi-qr-code-scan me-2"></i>Absensi</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link rounded-pill" id="pills-jurnal-tab" data-bs-toggle="pill" data-bs-target="#pills-jurnal" type="button" role="tab"><i class="bi bi-journal-text me-2"></i>Jurnal</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link rounded-pill" id="pills-history-tab" data-bs-toggle="pill" data-bs-target="#pills-history" type="button" role="tab"><i class="bi bi-clock-history me-2"></i>Riwayat</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link rounded-pill" id="pills-laporan-tab" data-bs-toggle="pill" data-bs-target="#pills-laporan" type="button" role="tab"><i class="bi bi-file-earmark-excel me-2"></i>Laporan</button>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- TAB CONTENT -->
            <div class="tab-content" id="pills-tabContent">
                
                <!-- TAB 1: ABSENSI -->
                <div class="tab-pane fade show active" id="pills-absen" role="tabpanel">
                    <div class="row">
                        <!-- KOLOM KIRI: QR CODE & TOGGLE -->
                        <div class="col-md-4 mb-3">
                            <div class="card card-shadow h-100">
                                <div class="card-header bg-white fw-bold text-success border-bottom-0 pt-3">
                                    <i class="bi bi-upc-scan me-2"></i>Metode Absen
                                </div>
                                <div class="card-body text-center">
                                    <div class="btn-group w-100 mb-3" role="group">
                                        <input type="radio" class="btn-check" name="mode_absen" id="mode_qr" autocomplete="off" checked onclick="toggleMode('qr')">
                                        <label class="btn btn-outline-success" for="mode_qr">QR Code</label>

                                        <input type="radio" class="btn-check" name="mode_absen" id="mode_manual" autocomplete="off" onclick="toggleMode('manual')">
                                        <label class="btn btn-outline-success" for="mode_manual">Manual</label>
                                    </div>

                                    <!-- QR DISPLAY -->
                                    <div id="area-qr">
                                        <div id="qrcode" class="border p-2 bg-white rounded mb-2"></div>
                                        <small class="text-danger fw-bold blink">QR Berubah tiap 5 Menit</small>
                                        <div id="timer-text" class="text-muted small mt-1">Refresh: 5:00</div>
                                    </div>

                                    <!-- MANUAL DISPLAY -->
                                    <div id="area-manual" style="display: none;">
                                        <div class="alert alert-info small text-start border-0 bg-light-info">
                                            <i class="bi bi-info-circle me-1"></i> Ceklis kehadiran siswa pada tabel, lalu klik Simpan.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- KOLOM KANAN: LIST SISWA -->
                        <div class="col-md-8 mb-3">
                            <div class="card card-shadow h-100">
                                <div class="card-header bg-white d-flex justify-content-between align-items-center border-bottom-0 pt-3">
                                    <span class="fw-bold text-dark">Daftar Siswa</span>
                                    <span class="badge bg-success rounded-pill" id="counter-hadir">Loading...</span>
                                </div>
                                
                                <div class="card-body p-0">
                                    <form method="POST">
                                        <div style="max-height: 500px; overflow-y: auto;">
                                            <table class="table table-hover mb-0 align-middle">
                                                <thead class="table-light sticky-top">
                                                    <tr>
                                                        <th class="px-3">Siswa</th>
                                                        <th class="text-center" width="130">Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    $total_hadir = 0; $total_siswa = 0;
                                                    if (mysqli_num_rows($q_siswa) > 0):
                                                        while ($s = mysqli_fetch_assoc($q_siswa)): 
                                                            $total_siswa++;
                                                            $st = $s['status']; 
                                                            if($st == 'Hadir') $total_hadir++;
                                                            $foto = !empty($s['foto']) ? 'uploads/siswa/'.$s['foto'] : 'https://via.placeholder.com/40';
                                                    ?>
                                                    <tr>
                                                        <td class="px-3">
                                                            <div class="d-flex align-items-center">
                                                                <img src="<?= $foto ?>" class="avatar-small me-3 border">
                                                                <div>
                                                                    <div class="fw-bold text-dark" style="font-size: 14px;"><?= $s['nama'] ?></div>
                                                                    <small class="text-muted" style="font-size: 11px;">ID: <?= $s['id'] ?></small>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <!-- MODE QR -->
                                                            <div class="view-qr-status">
                                                                <?php if ($st == 'Hadir'): ?> <span class="badge bg-success">Hadir</span>
                                                                <?php elseif ($st == 'Sakit'): ?> <span class="badge bg-warning text-dark">Sakit</span>
                                                                <?php elseif ($st == 'Izin'): ?> <span class="badge bg-info text-dark">Izin</span>
                                                                <?php elseif ($st == 'Alpha'): ?> <span class="badge bg-danger">Alpha</span>
                                                                <?php else: ?> <span class="badge bg-secondary opacity-50">Belum</span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <!-- MODE MANUAL -->
                                                            <div class="view-manual-input" style="display: none;">
                                                                <select name="status[<?= $s['id'] ?>]" class="form-select form-select-sm" style="font-size: 12px;">
                                                                    <option value="" <?= $st == '' ? 'selected' : '' ?>>-</option>
                                                                    <option value="Hadir" <?= $st == 'Hadir' ? 'selected' : '' ?>>Hadir</option>
                                                                    <option value="Sakit" <?= $st == 'Sakit' ? 'selected' : '' ?>>Sakit</option>
                                                                    <option value="Izin" <?= $st == 'Izin' ? 'selected' : '' ?>>Izin</option>
                                                                    <option value="Alpha" <?= $st == 'Alpha' ? 'selected' : '' ?>>Alpha</option>
                                                                </select>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endwhile; ?>
                                                    <?php else: ?>
                                                        <tr><td colspan="2" class="text-center py-4 text-muted">Belum ada data siswa.</td></tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="view-manual-input p-3 border-top bg-light" style="display: none;">
                                            <button type="submit" name="simpan_absen_manual" class="btn btn-primary w-100 fw-bold rounded-pill">
                                                <i class="bi bi-save me-2"></i> Simpan Absensi
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB 2: JURNAL -->
                <div class="tab-pane fade" id="pills-jurnal" role="tabpanel">
                    <div class="row justify-content-center">
                        <div class="col-md-9">
                            <div class="card card-shadow">
                                <div class="card-header bg-white fw-bold text-success border-bottom-0 pt-3">
                                    <i class="bi bi-pencil-square me-2"></i>Jurnal Harian
                                </div>
                                <div class="card-body">
                                    <form method="POST">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-uppercase text-secondary">Materi</label>
                                            <textarea name="materi" class="form-control" rows="4" placeholder="Contoh: Bab 3 - Algoritma..." required><?= htmlspecialchars($val_materi) ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-uppercase text-secondary">Tugas / PR</label>
                                            <textarea name="tugas" class="form-control" rows="3" placeholder="Contoh: LKS Halaman 40..." required><?= htmlspecialchars($val_tugas) ?></textarea>
                                        </div>
                                        <div class="d-grid">
                                            <button type="submit" name="simpan_jurnal" class="btn btn-success fw-bold rounded-pill">
                                                <i class="bi bi-check-circle me-2"></i>Simpan Jurnal
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB 3: RIWAYAT -->
                <div class="tab-pane fade" id="pills-history" role="tabpanel">
                    <div class="card card-shadow">
                        <div class="card-header bg-white fw-bold text-success border-bottom-0 pt-3">
                            <i class="bi bi-clock-history me-2"></i>Riwayat Pertemuan
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Tanggal</th>
                                            <th>Materi</th>
                                            <th>Tugas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(mysqli_num_rows($q_history) > 0): ?>
                                            <?php while($hist = mysqli_fetch_assoc($q_history)): ?>
                                            <tr>
                                                <td class="small" style="white-space: nowrap;">
                                                    <i class="bi bi-calendar-event me-1 text-muted"></i>
                                                    <?= date('d M Y', strtotime($hist['tanggal'])) ?>
                                                </td>
                                                <td><?= nl2br(htmlspecialchars($hist['materi'])) ?></td>
                                                <td>
                                                    <?php if(!empty($hist['tugas'])): ?>
                                                        <span class="badge bg-warning text-dark">Ada Tugas</span><br>
                                                        <small class="text-muted"><?= nl2br(htmlspecialchars($hist['tugas'])) ?></small>
                                                    <?php else: ?>
                                                        <span class="badge bg-light text-secondary border">Tidak ada</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="3" class="text-center py-5 text-muted">Belum ada riwayat.</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAB 4: LAPORAN -->
                <div class="tab-pane fade" id="pills-laporan" role="tabpanel">
                    <div class="row g-4">
                        <!-- Export Pertemuan -->
                        <div class="col-md-6">
                            <div class="card card-shadow h-100">
                                <div class="card-body">
                                    <h5 class="card-title text-success fs-6 fw-bold"><i class="bi bi-file-earmark-check me-2"></i>Hari Ini</h5>
                                    <p class="card-text text-muted small">Unduh data absensi pertemuan ini.</p>
                                    <a href="export_excel.php?type=pertemuan&id_jadwal=<?= $id_jadwal ?>&tanggal=<?= $hari_ini_tgl ?>" target="_blank" class="btn btn-outline-success w-100 btn-sm rounded-pill">
                                        <i class="bi bi-download me-2"></i>Download
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- Export Harian -->
                        <div class="col-md-6">
                            <div class="card card-shadow h-100">
                                <div class="card-body">
                                    <h5 class="card-title text-primary fs-6 fw-bold"><i class="bi bi-calendar-day me-2"></i>Harian</h5>
                                    <p class="card-text text-muted small">Unduh semua kelas pada tanggal tertentu.</p>
                                    <form action="export_excel.php" method="GET" target="_blank" class="input-group">
                                        <input type="hidden" name="type" value="harian">
                                        <input type="hidden" name="id_jadwal" value="<?= $id_jadwal ?>">
                                        <input type="date" name="tanggal" class="form-control form-control-sm" value="<?= date('Y-m-d') ?>" required>
                                        <button class="btn btn-primary btn-sm" type="submit">Export</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- Export Mingguan -->
                        <div class="col-md-6">
                            <div class="card card-shadow h-100">
                                <div class="card-body">
                                    <h5 class="card-title text-warning text-dark fs-6 fw-bold"><i class="bi bi-calendar-range me-2"></i>Periode</h5>
                                    <p class="card-text text-muted small">Rentang tanggal (Start - End).</p>
                                    <form action="export_excel.php" method="GET" target="_blank">
                                        <input type="hidden" name="type" value="mingguan">
                                        <input type="hidden" name="id_jadwal" value="<?= $id_jadwal ?>">
                                        <div class="row g-2">
                                            <div class="col-6"><input type="date" name="start" class="form-control form-control-sm" required></div>
                                            <div class="col-6"><input type="date" name="end" class="form-control form-control-sm" required></div>
                                            <div class="col-12 mt-2"><button class="btn btn-warning w-100 btn-sm text-dark rounded-pill" type="submit">Export</button></div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- Export Bulanan -->
                        <div class="col-md-6">
                            <div class="card card-shadow h-100">
                                <div class="card-body">
                                    <h5 class="card-title text-danger fs-6 fw-bold"><i class="bi bi-calendar-month me-2"></i>Bulanan</h5>
                                    <p class="card-text text-muted small">Rekap kehadiran siswa per bulan.</p>
                                    <form action="export_excel.php" method="GET" target="_blank">
                                        <input type="hidden" name="type" value="bulanan">
                                        <input type="hidden" name="id_jadwal" value="<?= $id_jadwal ?>">
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <select name="bulan" class="form-select form-select-sm" required>
                                                    <?php 
                                                    $months = ["01"=>"Jan", "02"=>"Feb", "03"=>"Mar", "04"=>"Apr", "05"=>"Mei", "06"=>"Jun", "07"=>"Jul", "08"=>"Agu", "09"=>"Sep", "10"=>"Okt", "11"=>"Nov", "12"=>"Des"];
                                                    foreach($months as $k => $v) {
                                                        $sel = ($k == date('m')) ? 'selected' : '';
                                                        echo "<option value='$k' $sel>$v</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-6">
                                                <select name="tahun" class="form-select form-select-sm" required>
                                                    <?php 
                                                    $cur = date('Y');
                                                    for($y=$cur; $y>=$cur-2; $y--) echo "<option value='$y'>$y</option>";
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-12 mt-2"><button class="btn btn-danger w-100 btn-sm rounded-pill" type="submit">Export</button></div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV (Sama seperti Dashboard) -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="segerahadir.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <a href="profile.php" class="mobile-nav-item">
        <i class="bi bi-person"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // --- 1. LOGIKA COUNT HADIR ---
    document.getElementById('counter-hadir').innerText = "<?= $total_hadir ?> / <?= $total_siswa ?> Hadir";

    // --- 2. LOGIKA TOGGLE MANUAL VS QR ---
    function toggleMode(mode) {
        const areaQr = document.getElementById('area-qr');
        const areaManual = document.getElementById('area-manual');
        const viewQrStatus = document.querySelectorAll('.view-qr-status');
        const viewManualInput = document.querySelectorAll('.view-manual-input');

        if (mode === 'qr') {
            areaQr.style.display = 'block';
            areaManual.style.display = 'none';
            viewQrStatus.forEach(el => el.style.display = 'block');
            viewManualInput.forEach(el => el.style.display = 'none');
            startQrTimer(); 
        } else {
            areaQr.style.display = 'none';
            areaManual.style.display = 'block';
            viewQrStatus.forEach(el => el.style.display = 'none');
            viewManualInput.forEach(el => el.style.display = 'block');
        }
    }

    // --- 3. LOGIKA QR CODE ---
    const idJadwal = "<?= $id_jadwal ?>";
    const qrContainer = document.getElementById("qrcode");
    let qrCodeObj = null;
    let timerInterval = null;

    function generateQR() {
        const timestamp = Math.floor(Date.now() / 1000);
        const timeSlot = Math.floor(timestamp / 300); 
        const qrContent = JSON.stringify({ j: idJadwal, t: timeSlot });

        qrContainer.innerHTML = "";
        qrCodeObj = new QRCode(qrContainer, {
            text: qrContent,
            width: 200, height: 200,
            colorDark : "#000000", colorLight : "#ffffff",
            correctLevel : QRCode.CorrectLevel.H
        });
    }

    function startQrTimer() {
        if(timerInterval) clearInterval(timerInterval);
        generateQR(); 
        let timeLeft = 300; 
        timerInterval = setInterval(() => {
            if(timeLeft <= 0) {
                timeLeft = 300;
                generateQR();
            }
            let m = Math.floor(timeLeft / 60);
            let s = timeLeft % 60;
            document.getElementById("timer-text").innerText = `Refresh: ${m}:${s < 10 ? '0'+s : s}`;
            timeLeft--;
        }, 1000);
    }

    startQrTimer();
</script>
</body>
</html>