<?php
session_start();
include 'koneksi.php';

// Cek Login
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$type = isset($_GET['type']) ? $_GET['type'] : 'pertemuan'; // pertemuan, harian, mingguan, bulanan
$id_jadwal = isset($_GET['id_jadwal']) ? $_GET['id_jadwal'] : 0;

// Nama file output default
$filename = "Laporan_Absensi_" . date('Ymd_His') . ".xls";

// Header agar dibaca sebagai Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Pragma: no-cache");
header("Expires: 0");

// --- LOGIKA QUERY BERDASARKAN TIPE ---
$where_clause = "";
$title_laporan = "";

switch ($type) {
    case 'pertemuan':
        // Export berdasarkan pertemuan spesifik (Hari ini di jam ini)
        $tgl = date('Y-m-d');
        if(isset($_GET['tanggal']) && !empty($_GET['tanggal'])) $tgl = $_GET['tanggal'];
        
        $where_clause = "WHERE a.id_jadwal = '$id_jadwal' AND a.tanggal = '$tgl'";
        $title_laporan = "Laporan Absensi Per Pertemuan (Tanggal: $tgl)";
        break;

    case 'harian':
        // Export semua kelas yang diajar guru tersebut pada tanggal tertentu
        $tgl = date('Y-m-d');
        if(isset($_GET['tanggal']) && !empty($_GET['tanggal'])) $tgl = $_GET['tanggal'];

        // Kita join ke jadwal untuk memastikan jadwal milik guru ini
        $where_clause = "WHERE j.id_guru = '$id_guru' AND a.tanggal = '$tgl'";
        $title_laporan = "Laporan Absensi Harian (Tanggal: $tgl)";
        break;

    case 'mingguan':
        // Export rentang tanggal (Start - End)
        $start = $_GET['start'];
        $end = $_GET['end'];
        
        // Opsi: Filter spesifik jadwal atau semua jadwal guru
        $filter_jadwal = ($id_jadwal != 0) ? "AND a.id_jadwal = '$id_jadwal'" : "AND j.id_guru = '$id_guru'";

        $where_clause = "WHERE a.tanggal BETWEEN '$start' AND '$end' $filter_jadwal";
        $title_laporan = "Laporan Absensi Mingguan ($start s.d $end)";
        break;

    case 'bulanan':
        // Export per Bulan & Tahun
        $bulan = $_GET['bulan']; // format 01, 02, etc
        $tahun = $_GET['tahun']; // format 2023
        
        $filter_jadwal = ($id_jadwal != 0) ? "AND a.id_jadwal = '$id_jadwal'" : "AND j.id_guru = '$id_guru'";

        $where_clause = "WHERE MONTH(a.tanggal) = '$bulan' AND YEAR(a.tanggal) = '$tahun' $filter_jadwal";
        $title_laporan = "Laporan Absensi Bulan $bulan Tahun $tahun";
        break;
}

// QUERY UTAMA
// Menggabungkan tabel absensi, siswa, dan jadwal
$query = "SELECT 
            s.nama AS nama_siswa, 
            s.kelas, 
            j.mata_pelajaran,
            a.tanggal, 
            a.jam_absen, 
            a.status 
          FROM absensi_mapel a
          JOIN students s ON a.id_siswa = s.id
          JOIN jadwal_mengajar j ON a.id_jadwal = j.id_jadwal
          $where_clause
          ORDER BY a.tanggal DESC, j.mata_pelajaran ASC, s.nama ASC";

$result = mysqli_query($koneksi, $query);

?>

<!-- TAMPILAN TABEL EXCEL -->
<!DOCTYPE html>
<html>
<head>
    <style>
        table { border-collapse: collapse; width: 100%; }
        table, th, td { border: 1px solid black; }
        th { background-color: #4CAF50; color: white; text-align: center; }
        td { padding: 5px; }
    </style>
</head>
<body>
    <center>
        <h3>DATA ABSENSI SISWA</h3>
        <h4><?= $title_laporan ?></h4>
    </center>
    <br>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Tanggal</th>
                <th>Jam Absen</th>
                <th>Nama Siswa</th>
                <th>Kelas</th>
                <th>Mata Pelajaran</th>
                <th>Status Kehadiran</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            if(mysqli_num_rows($result) > 0):
                $no = 1;
                while($row = mysqli_fetch_assoc($result)):
                    // Warna status biar mudah dibaca di Excel
                    $bg_color = "";
                    if($row['status'] == 'Alpha') $bg_color = "#ffcccc"; // Merah muda
                    if($row['status'] == 'Sakit') $bg_color = "#fff4cc"; // Kuning muda
                    if($row['status'] == 'Izin') $bg_color = "#ccf2ff"; // Biru muda
            ?>
            <tr>
                <td align="center"><?= $no++ ?></td>
                <td align="center"><?= $row['tanggal'] ?></td>
                <td align="center"><?= $row['jam_absen'] ?></td>
                <td><?= $row['nama_siswa'] ?></td>
                <td align="center"><?= $row['kelas'] ?></td>
                <td><?= $row['mata_pelajaran'] ?></td>
                <td align="center" style="background-color: <?= $bg_color ?>; font-weight:bold;">
                    <?= $row['status'] ?>
                </td>
            </tr>
            <?php 
                endwhile;
            else:
            ?>
            <tr>
                <td colspan="7" align="center">Data tidak ditemukan pada periode ini.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>