<?php
session_start();
include 'koneksi.php'; // Pastikan file ini ada

// Cek akses admin
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

// --- [BARU] AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; // Default jika db kosong

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- 1. LOGIKA DOWNLOAD TEMPLATE CSV ---
if (isset($_GET['aksi']) && $_GET['aksi'] == 'download_template') {
    if (ob_get_level()) ob_end_clean();
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="template_jadwal.csv"');
    $output = fopen('php://output', 'w');
    // Header Kolom
    fputcsv($output, array('ID Guru', 'Kelas', 'Ruangan', 'Mata Pelajaran', 'Hari', 'Jam Mulai', 'Jam Selesai'));
    // Contoh Data
    fputcsv($output, array('1', 'X', 'Lab Komputer', 'Pemrograman Web', 'Senin', '07:00', '09:00'));
    fclose($output);
    exit;
}

// --- 2. LOGIKA HAPUS DATA ---
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $sql = "DELETE FROM jadwal_mengajar WHERE id='$id'";
    if (mysqli_query($koneksi, $sql)) {
        $_SESSION['notif'] = "Data berhasil dihapus!";
        $_SESSION['type'] = "success";
    } else {
        $_SESSION['notif'] = "Gagal menghapus data!";
        $_SESSION['type'] = "error";
    }
    header("Location: admin_jadwa.php");
    exit;
}

// --- 3. LOGIKA IMPORT CSV ---
if (isset($_POST['import'])) {
    $filename = $_FILES["file"]["tmp_name"];
    if ($_FILES["file"]["size"] > 0) {
        $file = fopen($filename, "r");
        fgetcsv($file); // Skip header baris pertama
        while (($data = fgetcsv($file, 10000, ",")) !== FALSE) {
            // Asumsi urutan CSV: ID Guru, Kelas, Ruangan, Mapel, Hari, Jam Mulai, Jam Selesai
            $id_guru = $data[0];
            $kelas = $data[1];
            $ruangan = $data[2];
            $mapel = $data[3];
            $hari = $data[4];
            $jam_mulai = $data[5];
            $jam_selesai = $data[6];

            $sql = "INSERT INTO jadwal_mengajar (id_guru, kelas, ruangan, mata_pelajaran, hari, jam_mulai, jam_selesai) 
                    VALUES ('$id_guru', '$kelas', '$ruangan', '$mapel', '$hari', '$jam_mulai', '$jam_selesai')";
            mysqli_query($koneksi, $sql);
        }
        fclose($file);
        $_SESSION['notif'] = "Data berhasil diimport!";
        $_SESSION['type'] = "success";
        header("Location: admin_jadwa.php");
        exit;
    }
}

// --- 4. LOGIKA SIMPAN & UPDATE ---
if (isset($_POST['simpan']) || isset($_POST['update'])) {
    $id_guru = $_POST['id_guru'];
    $mapel = $_POST['mapel'];
    $hari = $_POST['hari'];
    $jam_mulai = $_POST['jam_mulai'];
    $jam_selesai = $_POST['jam_selesai'];

    // Memecah value Kelas|Ruangan
    $data_kelas = explode('|', $_POST['kelas_ruangan']);
    $kelas_pilih = $data_kelas[0];
    $ruangan_pilih = $data_kelas[1];

    if (isset($_POST['simpan'])) {
        $sql = "INSERT INTO jadwal_mengajar (id_guru, kelas, ruangan, hari, jam_mulai, jam_selesai, mata_pelajaran)
                VALUES ('$id_guru', '$kelas_pilih', '$ruangan_pilih', '$hari', '$jam_mulai', '$jam_selesai', '$mapel')";
        $msg = "Jadwal berhasil ditambahkan!";
    } else {
        $id_jadwal = $_POST['id_jadwal'];
        $sql = "UPDATE jadwal_mengajar SET 
                id_guru='$id_guru', kelas='$kelas_pilih', ruangan='$ruangan_pilih', 
                hari='$hari', jam_mulai='$jam_mulai', jam_selesai='$jam_selesai', mata_pelajaran='$mapel' 
                WHERE id='$id_jadwal'";
        $msg = "Jadwal berhasil diupdate!";
    }

    if (mysqli_query($koneksi, $sql)) {
        $_SESSION['notif'] = $msg;
        $_SESSION['type'] = "success";
    } else {
        $_SESSION['notif'] = "Terjadi kesalahan database.";
        $_SESSION['type'] = "error";
    }
    header("Location: admin_jadwa.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Jadwal - Admin Panel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        
        /* Sidebar Styles (Sama dengan Dashboard) */
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        
        /* Card Styles */
        .card { border: none; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        .card-header { background: #fff; border-bottom: 1px solid #eee; border-radius: 12px 12px 0 0 !important; padding: 1.5rem; }
        
        /* Table & Buttons */
        .btn-success-custom { background-color: #198754; border: none; }
        .btn-success-custom:hover { background-color: #157347; }
        .table thead th { background-color: #198754; color: white; border: none; }
        .action-btn { width: 32px; height: 32px; display: inline-flex; align-items: center; justify-content: center; border-radius: 50%; }

        /* [BARU] Style untuk Logo di Sidebar */
        .sidebar-header {
            text-align: center;
            padding: 20px 10px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            
            <!-- [BARU] BAGIAN LOGO & NAMA SEKOLAH -->
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>

            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link active"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            
            <!-- [BARU] HEADER RESPONSIVE -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="fas fa-calendar-alt me-2"></i> Manajemen Jadwal Guru</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
                
                <!-- Import Buttons moved here for better layout -->
                <div class="d-none d-md-block">
                    <a href="?aksi=download_template" class="btn btn-outline-success me-2 btn-sm">
                        <i class="fas fa-file-csv me-1"></i> Download Template
                    </a>
                    <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalImport">
                        <i class="fas fa-file-import me-1"></i> Import Excel/CSV
                    </button>
                </div>
            </div>

            <!-- Mobile Only Buttons -->
            <div class="d-md-none mb-3">
                 <a href="?aksi=download_template" class="btn btn-outline-success btn-sm w-100 mb-2">
                    <i class="fas fa-file-csv me-1"></i> Template
                </a>
                <button type="button" class="btn btn-success btn-sm w-100" data-bs-toggle="modal" data-bs-target="#modalImport">
                    <i class="fas fa-file-import me-1"></i> Import
                </button>
            </div>

            <div class="row">
                <!-- FORM INPUT (KIRI / ATAS) -->
                <div class="col-lg-4 mb-4">
                    <div class="card h-100">
                        <div class="card-header">
                            <h5 class="m-0 fw-bold text-success"><i class="fas fa-plus-circle me-1"></i> Form Jadwal</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="mb-3">
                                    <label class="form-label text-muted small fw-bold">NAMA GURU</label>
                                    <select name="id_guru" class="form-select" required>
                                        <option value="">-- Pilih Guru --</option>
                                        <?php
                                        $guru = mysqli_query($koneksi, "SELECT * FROM users WHERE role='guru'");
                                        while($g = mysqli_fetch_assoc($guru)) {
                                            echo "<option value='{$g['id']}'>{$g['nama_lengkap']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label text-muted small fw-bold">KELAS & RUANGAN</label>
                                    <select name="kelas_ruangan" class="form-select" required>
                                        <option value="">-- Pilih Kelas --</option>
                                        <?php
                                        $q_kelas = mysqli_query($koneksi, "SELECT DISTINCT kelas, ruangan FROM students ORDER BY kelas ASC");
                                        while($k = mysqli_fetch_assoc($q_kelas)) {
                                            echo "<option value='{$k['kelas']}|{$k['ruangan']}'>Kelas {$k['kelas']} - {$k['ruangan']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label text-muted small fw-bold">MATA PELAJARAN</label>
                                    <input type="text" name="mapel" class="form-control" placeholder="Contoh: Matematika" required>
                                </div>

                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label class="form-label text-muted small fw-bold">HARI</label>
                                        <select name="hari" class="form-select">
                                            <option>Senin</option><option>Selasa</option><option>Rabu</option><option>Kamis</option><option>Jumat</option><option>Sabtu</option>
                                        </select>
                                    </div>
                                    <div class="col-6 mb-3">
                                        <label class="form-label text-muted small fw-bold">MULAI</label>
                                        <input type="time" name="jam_mulai" class="form-control" required>
                                    </div>
                                    <div class="col-6 mb-3">
                                        <label class="form-label text-muted small fw-bold">SELESAI</label>
                                        <input type="time" name="jam_selesai" class="form-control" required>
                                    </div>
                                </div>
                                
                                <div class="d-grid">
                                    <button type="submit" name="simpan" class="btn btn-success btn-lg"><i class="fas fa-save me-2"></i>Simpan Jadwal</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- TABEL DATA (KANAN / BAWAH) -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header bg-white d-flex justify-content-between align-items-center">
                            <h5 class="m-0 fw-bold text-success"><i class="fas fa-list me-1"></i> Data Jadwal</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="tabelJadwal" class="table table-hover align-middle">
                                    <thead>
                                        <tr>
                                            <th>Guru</th>
                                            <th>Mapel</th>
                                            <th>Kelas</th>
                                            <th>Hari/Jam</th>
                                            <th class="text-center">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Join tabel untuk mengambil nama guru
                                        $query = "SELECT j.*, u.nama_lengkap 
                                                  FROM jadwal_mengajar j 
                                                  JOIN users u ON j.id_guru = u.id 
                                                  ORDER BY j.hari DESC, j.jam_mulai ASC";
                                        $result = mysqli_query($koneksi, $query);
                                        while($row = mysqli_fetch_assoc($result)):
                                        ?>
                                        <tr>
                                            <td class="fw-bold text-secondary"><?= $row['nama_lengkap'] ?></td>
                                            <td><?= $row['mata_pelajaran'] ?></td>
                                            <td>
                                                <span class="badge bg-info text-dark"><?= $row['kelas'] ?></span>
                                                <small class="d-block text-muted"><?= $row['ruangan'] ?></small>
                                            </td>
                                            <td>
                                                <div class="fw-bold"><?= $row['hari'] ?></div>
                                                <small class="text-muted"><?= date('H:i', strtotime($row['jam_mulai'])) ?> - <?= date('H:i', strtotime($row['jam_selesai'])) ?></small>
                                            </td>
                                            <td class="text-center">
                                                <button class="btn btn-sm btn-warning action-btn text-white btn-edit" 
                                                    data-id="<?= $row['id'] ?>"
                                                    data-guru="<?= $row['id_guru'] ?>"
                                                    data-kelas="<?= $row['kelas'] ?>|<?= $row['ruangan'] ?>"
                                                    data-mapel="<?= $row['mata_pelajaran'] ?>"
                                                    data-hari="<?= $row['hari'] ?>"
                                                    data-mulai="<?= $row['jam_mulai'] ?>"
                                                    data-selesai="<?= $row['jam_selesai'] ?>">
                                                    <i class="fas fa-pencil-alt"></i>
                                                </button>
                                                <a href="#" onclick="confirmDelete(<?= $row['id'] ?>)" class="btn btn-sm btn-danger action-btn">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL IMPORT -->
<div class="modal fade" id="modalImport" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Data dari CSV</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="alert alert-info small">
                        Pastikan format CSV sesuai dengan template yang diunduh.
                    </div>
                    <label>Pilih File CSV</label>
                    <input type="file" name="file" class="form-control" accept=".csv" required>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="import" class="btn btn-success">Import Sekarang</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- MODAL EDIT (Dinamis menggunakan JS) -->
<div class="modal fade" id="modalEdit" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Jadwal</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_jadwal" id="edit_id">
                    
                    <div class="mb-3">
                        <label>Nama Guru</label>
                        <select name="id_guru" id="edit_guru" class="form-select" required>
                             <?php
                             // Ulangi query guru
                             $guru = mysqli_query($koneksi, "SELECT * FROM users WHERE role='guru'");
                             while($g = mysqli_fetch_assoc($guru)) {
                                 echo "<option value='{$g['id']}'>{$g['nama_lengkap']}</option>";
                             }
                             ?>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label>Kelas & Ruangan</label>
                        <select name="kelas_ruangan" id="edit_kelas" class="form-select" required>
                             <?php
                             $q_kelas = mysqli_query($koneksi, "SELECT DISTINCT kelas, ruangan FROM students ORDER BY kelas ASC");
                             while($k = mysqli_fetch_assoc($q_kelas)) {
                                 echo "<option value='{$k['kelas']}|{$k['ruangan']}'>Kelas {$k['kelas']} - {$k['ruangan']}</option>";
                             }
                             ?>
                        </select>
                    </div>

                    <div class="mb-3"><label>Mapel</label><input type="text" name="mapel" id="edit_mapel" class="form-control" required></div>
                    <div class="mb-3"><label>Hari</label>
                        <select name="hari" id="edit_hari" class="form-select">
                            <option>Senin</option><option>Selasa</option><option>Rabu</option><option>Kamis</option><option>Jumat</option><option>Sabtu</option>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col"><label>Mulai</label><input type="time" name="jam_mulai" id="edit_mulai" class="form-control" required></div>
                        <div class="col"><label>Selesai</label><input type="time" name="jam_selesai" id="edit_selesai" class="form-control" required></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="update" class="btn btn-success">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- SCRIPTS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        // 1. Inisialisasi DataTables
        $('#tabelJadwal').DataTable({
            language: {
                search: "Cari Data:",
                lengthMenu: "Tampilkan _MENU_ data",
                info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
                paginate: { first: "Awal", last: "Akhir", next: "Lanjut", previous: "Kembali" }
            }
        });

        // 2. Handle Tombol Edit
        $('.btn-edit').click(function() {
            var id = $(this).data('id');
            var guru = $(this).data('guru');
            var kelas = $(this).data('kelas');
            var mapel = $(this).data('mapel');
            var hari = $(this).data('hari');
            var mulai = $(this).data('mulai');
            var selesai = $(this).data('selesai');

            $('#edit_id').val(id);
            $('#edit_guru').val(guru);
            $('#edit_kelas').val(kelas);
            $('#edit_mapel').val(mapel);
            $('#edit_hari').val(hari);
            $('#edit_mulai').val(mulai);
            $('#edit_selesai').val(selesai);

            var myModal = new bootstrap.Modal(document.getElementById('modalEdit'));
            myModal.show();
        });

        // 3. Notifikasi PHP ke SweetAlert
        <?php if(isset($_SESSION['notif'])): ?>
            Swal.fire({
                icon: '<?= $_SESSION['type'] ?>',
                title: '<?= ($_SESSION['type'] == "success") ? "Berhasil!" : "Gagal!" ?>',
                text: '<?= $_SESSION['notif'] ?>',
                timer: 3000,
                showConfirmButton: false
            });
            <?php unset($_SESSION['notif']); unset($_SESSION['type']); ?>
        <?php endif; ?>
    });

    // 4. Konfirmasi Hapus SweetAlert
    function confirmDelete(id) {
        Swal.fire({
            title: 'Yakin ingin menghapus?',
            text: "Data jadwal ini akan hilang permanen!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Ya, Hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '?hapus=' + id;
            }
        })
    }
</script>

</body>
</html>