<?php
session_start();

require_once '../config.php';

// Cek sesi login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== TRUE) {
    header("location: index.php");
    exit;
}

// Cek role admin
if ($_SESSION['role'] !== 'admin') {
    header("location: index.php");
    exit;
}

$nama_pengguna = htmlspecialchars($_SESSION['nama']);
$username_pengguna = htmlspecialchars($_SESSION['username']);
$role_pengguna = htmlspecialchars($_SESSION['role']);

$uploadDir = 'uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Fungsi mengambil data
function getSchoolSettings($conn) {
    // UPDATE: Mengambil semua kolom yang baru
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah, nama_kepala_sekolah, ttd_kepala_sekolah, nuptk_kepala_sekolah FROM pengaturan_sekolah WHERE id = 1 LIMIT 1";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    // Default values jika database kosong
    return [
        'nama_sekolah' => 'Nama Sekolah Default', 
        'alamat_sekolah' => '', 
        'logo_sekolah' => '',
        'nama_kepala_sekolah' => '',
        'ttd_kepala_sekolah' => '',
        'nuptk_kepala_sekolah' => ''
    ];
}

// Load data awal
$settings = getSchoolSettings($conn);

$statusMessage = '';
$messageType = '';

// Proses Form Submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 1. Ambil Input Text
    $nama_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['nama_sekolah']));
    $alamat_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['alamat_sekolah']));
    
    // Input Baru: Kepala Sekolah
    $nama_kepala_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['nama_kepala_sekolah']));
    $nuptk_kepala_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['nuptk_kepala_sekolah']));

    // 2. LOGIKA UPLOAD LOGO SEKOLAH
    $current_logo = $conn->real_escape_string(htmlspecialchars($_POST['current_logo']));
    $logo_file_name = $current_logo; // Default pakai yang lama

    if (isset($_FILES['logo_sekolah']) && $_FILES['logo_sekolah']['error'] == UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['logo_sekolah']['tmp_name'];
        $fileName = $_FILES['logo_sekolah']['name'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));
        $newFileName = md5(time() . 'logo' . $fileName) . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        $allowedfileExtensions = array('jpg', 'gif', 'png', 'jpeg');
        if (in_array($fileExtension, $allowedfileExtensions)) {
            // Hapus file lama jika ada dan berbeda
            if (!empty($current_logo) && file_exists($uploadDir . $current_logo)) {
                unlink($uploadDir . $current_logo);
            }
            if (move_uploaded_file($fileTmpPath, $destPath)) {
                $logo_file_name = $newFileName;
            } else {
                $statusMessage = "Gagal mengunggah logo.";
                $messageType = "error";
            }
        } else {
            $statusMessage = "Format logo tidak valid (hanya JPG, PNG, GIF).";
            $messageType = "error";
        }
    } else if (isset($_POST['remove_logo']) && $_POST['remove_logo'] === 'true') {
        if (!empty($current_logo) && file_exists($uploadDir . $current_logo)) {
            unlink($uploadDir . $current_logo);
        }
        $logo_file_name = NULL;
    }

    // 3. LOGIKA UPLOAD TANDA TANGAN (TTD) KEPALA SEKOLAH
    $current_ttd = $conn->real_escape_string(htmlspecialchars($_POST['current_ttd']));
    $ttd_file_name = $current_ttd; // Default pakai yang lama

    if (isset($_FILES['ttd_kepala_sekolah']) && $_FILES['ttd_kepala_sekolah']['error'] == UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['ttd_kepala_sekolah']['tmp_name'];
        $fileName = $_FILES['ttd_kepala_sekolah']['name'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));
        // Penamaan file unik untuk TTD
        $newFileName = md5(time() . 'ttd' . $fileName) . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        $allowedfileExtensions = array('jpg', 'gif', 'png', 'jpeg');
        if (in_array($fileExtension, $allowedfileExtensions)) {
            // Hapus file lama
            if (!empty($current_ttd) && file_exists($uploadDir . $current_ttd)) {
                unlink($uploadDir . $current_ttd);
            }
            if (move_uploaded_file($fileTmpPath, $destPath)) {
                $ttd_file_name = $newFileName;
            } else {
                $statusMessage = "Gagal mengunggah tanda tangan.";
                $messageType = "error";
            }
        } else {
            $statusMessage = "Format tanda tangan tidak valid (hanya JPG, PNG, GIF).";
            $messageType = "error";
        }
    } else if (isset($_POST['remove_ttd']) && $_POST['remove_ttd'] === 'true') {
        if (!empty($current_ttd) && file_exists($uploadDir . $current_ttd)) {
            unlink($uploadDir . $current_ttd);
        }
        $ttd_file_name = NULL;
    }

    // 4. UPDATE DATABASE
    // Hanya proses update database jika tidak ada error upload sebelumnya (atau jika warning upload diabaikan)
    if (empty($statusMessage) || $messageType === 'success') {
        $sql_check = "SELECT id FROM pengaturan_sekolah WHERE id = 1";
        $result_check = $conn->query($sql_check);

        // Siapkan value SQL (handle NULL)
        $sql_logo = $logo_file_name ? "'$logo_file_name'" : "NULL";
        $sql_ttd = $ttd_file_name ? "'$ttd_file_name'" : "NULL";

        if ($result_check->num_rows > 0) {
            // Update
            $sql = "UPDATE pengaturan_sekolah SET 
                    nama_sekolah = '$nama_sekolah', 
                    alamat_sekolah = '$alamat_sekolah', 
                    logo_sekolah = $sql_logo,
                    nama_kepala_sekolah = '$nama_kepala_sekolah',
                    nuptk_kepala_sekolah = '$nuptk_kepala_sekolah',
                    ttd_kepala_sekolah = $sql_ttd,
                    last_updated = NOW() 
                    WHERE id = 1";
        } else {
            // Insert (Jika tabel kosong sama sekali)
            $sql = "INSERT INTO pengaturan_sekolah 
                    (id, nama_sekolah, alamat_sekolah, logo_sekolah, nama_kepala_sekolah, nuptk_kepala_sekolah, ttd_kepala_sekolah, last_updated) 
                    VALUES 
                    (1, '$nama_sekolah', '$alamat_sekolah', $sql_logo, '$nama_kepala_sekolah', '$nuptk_kepala_sekolah', $sql_ttd, NOW())";
        }

        if ($conn->query($sql) === TRUE) {
            $statusMessage = "Pengaturan berhasil diperbarui.";
            $messageType = "success";
        } else {
            $statusMessage = "Terjadi kesalahan database: " . $conn->error;
            $messageType = "error";
        }
    }
}

// Refresh data setelah submit untuk ditampilkan di form
$settings = getSchoolSettings($conn);
$conn->close();

// Setup Variabel Display
$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/60x60/B0E0E6/000000?text=LOGO';
$ttd_sekolah_path = !empty($settings['ttd_kepala_sekolah']) ? $uploadDir . htmlspecialchars($settings['ttd_kepala_sekolah']) : null;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan Sekolah - Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out; overflow-x: hidden; }
        html.dark body { background-color: #0b0c10; color: #e2e8f0; }
        html:not(.dark) body { background-color: #e0e7ff; color: #1a202c; }
        .glass-effect { transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, box-shadow 0.5s ease-in-out; }
        html.dark .text-day-mode-black { color: #e2e8f0; }
        html:not(.dark) .text-day-mode-black { color: #000000; }
        
        /* Sidebar Styles (Sama seperti sebelumnya) */
        html.dark .sidebar { background-color: #1a202c; border-right-color: #2d3748; }
        html:not(.dark) .sidebar { background-color: #ffffff; border-right-color: #e2e8f0; }
        html.dark .sidebar a { color: #a0aec0; }
        html.dark .sidebar a:hover { background-color: #2d3748; color: #ffffff; }
        html:not(.dark) .sidebar a { color: #4a5568; }
        html:not(.dark) .sidebar a:hover { background-color: #edf2f7; color: #2d3748; }
        
        .sidebar { width: 256px; transition: width 0.3s ease-in-out; flex-shrink: 0; }
        .sidebar.minimized { width: 64px; }
        .sidebar.minimized .sidebar-text, .sidebar.minimized .school-name, .sidebar.minimized .sidebar-dropdown-icon { display: none; }
        .sidebar.minimized .sidebar-icon { margin-right: 0 !important; width: 24px; height: 24px; }
        .sidebar.minimized .sidebar-menu-item { justify-content: center; padding-left: 0; padding-right: 0; }
        .sidebar.minimized .school-logo { margin-right: 0 !important; width: 40px; height: 40px; }
        
        /* Tooltip Logic */
        .sidebar.minimized [data-tooltip]:hover:after {
            content: attr(data-tooltip); position: absolute; left: 70px; top: 50%; transform: translateY(-50%);
            background-color: #333; color: #fff; padding: 5px 10px; border-radius: 4px; white-space: nowrap; z-index: 999;
        }
        .sidebar.minimized [data-tooltip]:after { opacity: 0; pointer-events: none; }
    </style>
</head>
<body class="flex min-h-screen">

    <!-- ASIDE / SIDEBAR -->
    <aside id="sidebar" class="sidebar w-64 p-5 border-r shadow-lg flex flex-col justify-between transition-colors duration-500 relative">
        <div>
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center sidebar-header">
                    <img src="<?php echo $logo_sekolah_path; ?>" alt="Logo Sekolah" class="school-logo w-12 h-12 object-contain mr-3 rounded-md" onerror="this.onerror=null;this.src='https://placehold.co/60x60/B0E0E6/000000?text=LOGO';">
                    <span class="text-xl font-bold text-blue-600 dark:text-blue-400 school-name"><?php echo $nama_sekolah_display; ?></span>
                </div>
                <button id="sidebarToggle" class="p-2 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-toggle-button">
                    <svg class="w-6 h-6 sidebar-toggle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                </button>
            </div>
            <nav>
                <ul class="space-y-1">
                    <li><a href="admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Dashboard"><svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg><span class="sidebar-text">Dashboard</span></a></li>
                    <li class="relative">
                        <a href="#" id="manajemenPenggunaDropdownToggle" class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Manajemen Pengguna">
                            <div class="flex items-center"><svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h-5v-9H4L12 3l8 8h-8v9z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c-2.209 0-4-1.791-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4zM12 13a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg><span class="sidebar-text">Manajemen Pengguna</span></div>
                            <svg id="dropdownArrow" class="w-4 h-4 sidebar-dropdown-icon transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </a>
                        <ul id="manajemenPenggunaSubmenu" class="pl-8 mt-1 space-y-1 hidden">
                            <li><a href="daftarsiswa.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Lihat Semua"><span class="sidebar-text">Lihat Semua</span></a></li>
                            <li><a href="#" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Tambah Pengguna"><span class="sidebar-text">Tambah Pengguna</span></a></li>
                        </ul>
                    </li>
                    <li><a href="#" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Laporan"><svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.523 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5s3.332.477 4.5 1.253v13C19.832 18.523 18.246 18 16.5 18s-3.332.477-4.5 1.253"></path></svg><span class="sidebar-text">Laporan</span></a></li>
                    <li><a href="setting.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan"><svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.525.322 1.018.673 1.505 1.01z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg><span class="sidebar-text">Pengaturan</span></a></li>
                </ul>
            </nav>
        </div>
        <div class="mt-8">
            <a href="logout.php" class="flex items-center py-2 px-3 rounded-lg bg-red-500 hover:bg-red-600 text-white transition-colors duration-200 sidebar-menu-item" data-tooltip="Logout">
                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                <span class="sidebar-text">Logout</span>
            </a>
        </div>
    </aside>

    <main id="mainContent" class="flex-1 p-10 transition-all duration-300">
        <!-- Theme Toggle -->
        <div class="absolute top-4 right-4 z-10">
            <button id="themeToggle" class="p-2 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-white shadow-md">
                <svg class="w-6 h-6 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h1M3 12h1m15.325-7.757l-.707-.707M4.343 19.657l-.707-.707m12.728 0l-.707.707M6.343 6.343l-.707-.707"></path></svg>
                <svg class="w-6 h-6 moon-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9 9 0 008.354-5.646z"></path></svg>
            </button>
        </div>

        <h1 class="text-4xl font-extrabold mb-8 text-day-mode-black dark:text-white">Pengaturan Sekolah</h1>

        <div class="glass-effect p-8 rounded-lg shadow-xl mb-8">
            <?php if (!empty($statusMessage)): ?>
                <div class="mb-4 p-3 rounded-lg text-sm <?php echo $messageType === 'success' ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'; ?>">
                    <?php echo $statusMessage; ?>
                </div>
            <?php endif; ?>

            <form action="setting.php" method="POST" enctype="multipart/form-data">
                
                <!-- BAGIAN 1: IDENTITAS SEKOLAH -->
                <h2 class="text-xl font-bold text-gray-700 dark:text-gray-200 mb-4 border-b border-gray-300 dark:border-gray-600 pb-2">Identitas Sekolah</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="nama_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Nama Sekolah:</label>
                        <input type="text" id="nama_sekolah" name="nama_sekolah" value="<?php echo htmlspecialchars($settings['nama_sekolah']); ?>" class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    </div>

                    <div>
                        <label for="logo_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Logo Sekolah:</label>
                        <input type="file" id="logo_sekolah" name="logo_sekolah" accept="image/*" class="block w-full text-sm text-day-mode-black dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                        <input type="hidden" name="current_logo" value="<?php echo htmlspecialchars($settings['logo_sekolah']); ?>">
                        
                        <?php if (!empty($settings['logo_sekolah'])): ?>
                            <div class="mt-2 flex items-center space-x-4">
                                <img src="<?php echo $uploadDir . htmlspecialchars($settings['logo_sekolah']); ?>" class="w-16 h-16 object-contain rounded-lg border">
                                <label class="inline-flex items-center text-sm text-red-600 cursor-pointer">
                                    <input type="checkbox" name="remove_logo" value="true" class="form-checkbox h-4 w-4 text-red-600"> <span class="ml-2">Hapus</span>
                                </label>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mb-6">
                    <label for="alamat_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Alamat Lengkap:</label>
                    <textarea id="alamat_sekolah" name="alamat_sekolah" rows="3" class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($settings['alamat_sekolah']); ?></textarea>
                </div>

                <!-- BAGIAN 2: KEPALA SEKOLAH (BARU) -->
                <h2 class="text-xl font-bold text-gray-700 dark:text-gray-200 mb-4 mt-8 border-b border-gray-300 dark:border-gray-600 pb-2">Informasi Kepala Sekolah</h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="nama_kepala_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Nama Kepala Sekolah:</label>
                        <input type="text" id="nama_kepala_sekolah" name="nama_kepala_sekolah" value="<?php echo htmlspecialchars($settings['nama_kepala_sekolah']); ?>" placeholder="Contoh: Dr. Budi Santoso, M.Pd" class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label for="nuptk_kepala_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">NUPTK / NIP:</label>
                        <input type="text" id="nuptk_kepala_sekolah" name="nuptk_kepala_sekolah" value="<?php echo htmlspecialchars($settings['nuptk_kepala_sekolah']); ?>" placeholder="Masukkan NUPTK atau NIP" class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>

                <div class="mb-6">
                    <label for="ttd_kepala_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Scan Tanda Tangan (TTD):</label>
                    <input type="file" id="ttd_kepala_sekolah" name="ttd_kepala_sekolah" accept="image/*" class="block w-full text-sm text-day-mode-black dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    <input type="hidden" name="current_ttd" value="<?php echo htmlspecialchars($settings['ttd_kepala_sekolah']); ?>">
                    <p class="text-xs text-gray-500 mt-1">*Disarankan format PNG transparan.</p>

                    <?php if (!empty($settings['ttd_kepala_sekolah'])): ?>
                        <div class="mt-2 flex items-center space-x-4 bg-gray-100 dark:bg-gray-800 p-2 rounded w-fit">
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Preview TTD Saat Ini:</p>
                                <img src="<?php echo $uploadDir . htmlspecialchars($settings['ttd_kepala_sekolah']); ?>" class="h-16 w-auto object-contain">
                            </div>
                            <label class="inline-flex items-center text-sm text-red-600 cursor-pointer ml-4">
                                <input type="checkbox" name="remove_ttd" value="true" class="form-checkbox h-4 w-4 text-red-600"> <span class="ml-2">Hapus</span>
                            </label>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Submit Button -->
                <div class="flex items-center justify-end mt-8">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 w-full md:w-auto">
                        Simpan Perubahan
                    </button>
                </div>

            </form>
        </div>

        <div class="text-center mt-10">
            <img src="digipas.png" alt="Logo Digipas.id" class="mx-auto mb-2 w-16 h-auto" onerror="this.onerror=null;this.src='https://placehold.co/64x16/AAAAAA/FFFFFF?text=Logo+Error';">
            <p class="text-sm text-gray-600 dark:text-gray-400">Powered by: digipas.id &copy; <span id="currentYear"></span></p>
        </div>
    </main>

    <script>
        // Script Theme & Sidebar (Tetap sama seperti file asli)
        const themeToggle = document.getElementById('themeToggle');
        const htmlElement = document.documentElement;
        const sunIcon = document.querySelector('.sun-icon');
        const moonIcon = document.querySelector('.moon-icon');
        
        function applyTheme(theme) {
            if (theme === 'dark') {
                htmlElement.classList.add('dark');
                sunIcon.classList.add('hidden');
                moonIcon.classList.remove('hidden');
            } else {
                htmlElement.classList.remove('dark');
                sunIcon.classList.remove('hidden');
                moonIcon.classList.add('hidden');
            }
        }

        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) applyTheme(savedTheme);
        else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) applyTheme('dark');
        else applyTheme('light');

        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                applyTheme('light'); localStorage.setItem('theme', 'light');
            } else {
                localStorage.setItem('theme', 'dark'); applyTheme('dark');
            }
        });

        document.getElementById('currentYear').textContent = new Date().getFullYear();

        const manajemenPenggunaDropdownToggle = document.getElementById('manajemenPenggunaDropdownToggle');
        const manajemenPenggunaSubmenu = document.getElementById('manajemenPenggunaSubmenu');
        const dropdownArrow = document.getElementById('dropdownArrow');

        if (manajemenPenggunaDropdownToggle && manajemenPenggunaSubmenu && dropdownArrow) {
            manajemenPenggunaDropdownToggle.addEventListener('click', (e) => {
                e.preventDefault();
                manajemenPenggunaSubmenu.classList.toggle('hidden');
                dropdownArrow.classList.toggle('rotate-180');
            });
        }

        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        const sidebarToggleIcon = document.querySelector('.sidebar-toggle-icon');
        
        function initializeSidebar() {
            const isMinimized = localStorage.getItem('sidebarMinimized') === 'true';
            if (isMinimized) {
                sidebar.classList.add('minimized');
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7');
            } else {
                sidebar.classList.remove('minimized');
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16');
            }
            sidebarToggle.addEventListener('click', toggleSidebar);
        }

        function toggleSidebar() {
            const isCurrentlyMinimized = sidebar.classList.contains('minimized');
            if (isCurrentlyMinimized) {
                sidebar.classList.remove('minimized');
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16');
                localStorage.setItem('sidebarMinimized', 'false');
            } else {
                sidebar.classList.add('minimized');
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7');
                localStorage.setItem('sidebarMinimized', 'true');
            }
        }
        document.addEventListener('DOMContentLoaded', initializeSidebar);
    </script>
</body>
</html>