<?php
// --- LOGIC PHP (TIDAK BERUBAH SECARA FUNGSIONAL, HANYA MERAPIKAN KODE) ---
session_start();
$errorMessage = '';
require_once '../config.php'; // Pastikan path ini benar

$uploadDir = 'uploads/';

function getSchoolSettings($conn) {
    // Menggunakan prepared statement untuk keamanan ekstra meskipun parameternya statis
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah FROM pengaturan_sekolah WHERE id = 1 LIMIT 1";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return ['nama_sekolah' => 'Sistem Informasi Sekolah', 'alamat_sekolah' => '', 'logo_sekolah' => ''];
}

$settings = getSchoolSettings($conn);
$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username_or_email = $conn->real_escape_string(htmlspecialchars($_POST['username']));
    $password = $conn->real_escape_string(htmlspecialchars($_POST['password']));

    // Query (DISARANKAN: Segera migrasi ke password_hash untuk keamanan!)
    $sql = "SELECT id, username, email, kata_sandi, nama, role FROM pengguna WHERE (username = '$username_or_email' OR email = '$username_or_email') AND kata_sandi = '$password'";
    $result = $conn->query($sql);

    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        if ($user['kata_sandi'] === $password) {
            $_SESSION['loggedin'] = TRUE;
            $_SESSION['id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama'] = $user['nama'];
            $_SESSION['role'] = $user['role'];

            if ($user['role'] == 'admin') {
                $_SESSION['redirect_to'] = "admin.php";
            } elseif ($user['role'] == 'pengawas') {
                $_SESSION['redirect_to'] = "pengawas.php";
            } else {
                $_SESSION['redirect_to'] = "welcome.php";
            }
        } else {
            $errorMessage = "Password yang Anda masukkan salah.";
        }
    } else {
        $errorMessage = "Akun tidak ditemukan atau password salah.";
    }
}

if (isset($_SESSION['redirect_to'])) {
    $redirect_url = $_SESSION['redirect_to'];
    unset($_SESSION['redirect_to']);
    header("location: " . $redirect_url);
    exit;
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="id" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo $nama_sekolah_display; ?></title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts: Plus Jakarta Sans (Sangat profesional & modern) -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Konfigurasi Tailwind untuk Font & Warna Custom -->
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['"Plus Jakarta Sans"', 'sans-serif'],
                    },
                    colors: {
                        brand: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            900: '#1e3a8a',
                        }
                    }
                }
            }
        }
    </script>

    <style>
        /* Pattern Background Halus */
        .bg-pattern {
            background-color: #f8fafc;
            background-image: radial-gradient(#e2e8f0 1px, transparent 1px);
            background-size: 24px 24px;
        }
        .dark .bg-pattern {
            background-color: #0f172a;
            background-image: radial-gradient(#1e293b 1px, transparent 1px);
        }
        
        /* Animasi Transisi Halus */
        .fade-in-up {
            animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1);
        }
        
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Loading Spinner pada Button */
        .btn-loading {
            position: relative;
            color: transparent !important;
            pointer-events: none;
        }
        .btn-loading::after {
            content: "";
            position: absolute;
            width: 1.25em;
            height: 1.25em;
            top: 50%;
            left: 50%;
            margin-top: -0.625em;
            margin-left: -0.625em;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-right-color: transparent;
            animation: spin 0.75s linear infinite;
        }
        @keyframes spin { to { transform: rotate(360deg); } }
    </style>
</head>
<body class="h-full bg-pattern text-slate-800 dark:text-slate-200 transition-colors duration-300">

    <!-- Theme Toggle (Pojok Kanan Atas - Minimalis) -->
    <div class="fixed top-6 right-6 z-50">
        <button id="themeToggle" class="p-2.5 rounded-full bg-white/80 dark:bg-slate-800/80 shadow-lg border border-slate-200 dark:border-slate-700 backdrop-blur-sm hover:scale-105 transition-all text-slate-600 dark:text-slate-300">
            <!-- Sun Icon -->
            <svg class="w-5 h-5 sun-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h1M3 12h1m15.325-7.757l-.707-.707M4.343 19.657l-.707-.707m12.728 0l-.707.707M6.343 6.343l-.707-.707"></path>
            </svg>
            <!-- Moon Icon -->
            <svg class="w-5 h-5 moon-icon hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9 9 0 008.354-5.646z"></path>
            </svg>
        </button>
    </div>

    <!-- Main Container -->
    <div class="flex min-h-full flex-col justify-center py-12 sm:px-6 lg:px-8">
        
        <!-- Header / Logo Area -->
        <div class="sm:mx-auto sm:w-full sm:max-w-md text-center fade-in-up">
            <?php if (!empty($logo_sekolah_path)): ?>
                <img class="mx-auto h-20 w-auto object-contain drop-shadow-sm" 
                     src="<?php echo $logo_sekolah_path; ?>" 
                     alt="Logo Sekolah"
                     onerror="this.style.display='none'">
            <?php else: ?>
                <!-- Fallback Logo Icon Professional -->
                <div class="mx-auto h-16 w-16 bg-brand-600 rounded-xl flex items-center justify-center shadow-lg shadow-brand-500/30 text-white mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-9 h-9">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.499 5.216 50.59 50.59 0 00-2.658.812m-15.482 0a50.57 50.57 0 012.658 3.434 49.568 49.568 0 0110.492 0 50.57 50.57 0 012.658-3.434M12 6.113A33.19 33.19 0 0114.746 9.5c0 1.944.337 3.819.95 5.613A33.19 33.19 0 0112 17.75z" />
                    </svg>
                </div>
            <?php endif; ?>
            
            <h2 class="mt-4 text-2xl font-bold leading-9 tracking-tight text-slate-900 dark:text-white">
                <?php echo $nama_sekolah_display; ?>
            </h2>
            <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">
                Silakan masuk untuk mengakses panel kontrol
            </p>
        </div>

        <!-- Login Card -->
        <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-[420px] fade-in-up" style="animation-delay: 0.1s;">
            <div class="bg-white dark:bg-slate-800 py-10 px-6 shadow-[0_8px_30px_rgb(0,0,0,0.04)] sm:rounded-2xl sm:px-10 border border-slate-100 dark:border-slate-700">
                
                <!-- Error Alert Professional -->
                <?php if (!empty($errorMessage)): ?>
                    <div class="mb-6 rounded-lg bg-red-50 dark:bg-red-900/20 p-4 border border-red-200 dark:border-red-800/30 flex items-start gap-3">
                        <svg class="h-5 w-5 text-red-500 mt-0.5" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
                        </svg>
                        <div class="text-sm font-medium text-red-800 dark:text-red-200">
                            <?php echo htmlspecialchars($errorMessage); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <form class="space-y-6" action="" method="POST" id="loginForm">
                    <!-- Username Input -->
                    <div>
                        <label for="username" class="block text-sm font-semibold leading-6 text-slate-900 dark:text-white">Username / Email</label>
                        <div class="relative mt-2 rounded-md shadow-sm">
                            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                <svg class="h-5 w-5 text-slate-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path d="M3 4a2 2 0 00-2 2v1.161l8.441 4.221a1.25 1.25 0 001.118 0L19 7.162V6a2 2 0 00-2-2H3z" />
                                    <path d="M19 8.839l-7.77 3.885a2.75 2.75 0 01-2.46 0L1 8.839V14a2 2 0 002 2h14a2 2 0 002-2V8.839z" />
                                </svg>
                            </div>
                            <input id="username" name="username" type="text" autocomplete="username" required 
                                class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-brand-600 sm:text-sm sm:leading-6 dark:bg-slate-900/50 dark:ring-slate-600 dark:text-white dark:placeholder-slate-500 transition-shadow"
                                placeholder="nama@sekolah.sch.id">
                        </div>
                    </div>

                    <!-- Password Input -->
                    <div>
                        <div class="flex items-center justify-between">
                            <label for="password" class="block text-sm font-semibold leading-6 text-slate-900 dark:text-white">Password</label>
                            <div class="text-sm">
                                <a href="#" class="font-medium text-brand-600 hover:text-brand-500 dark:text-brand-400 transition-colors">Lupa password?</a>
                            </div>
                        </div>
                        <div class="relative mt-2 rounded-md shadow-sm">
                            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                <svg class="h-5 w-5 text-slate-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 1a4.5 4.5 0 00-4.5 4.5V9H5a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-.5V5.5A4.5 4.5 0 0010 1zm3 8V5.5a3 3 0 10-6 0V9h6z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <input id="password" name="password" type="password" autocomplete="current-password" required 
                                class="block w-full rounded-lg border-0 py-2.5 pl-10 pr-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-brand-600 sm:text-sm sm:leading-6 dark:bg-slate-900/50 dark:ring-slate-600 dark:text-white dark:placeholder-slate-500 transition-shadow"
                                placeholder="••••••••">
                            
                            <!-- Toggle Eye Icon -->
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer group" id="togglePassword">
                                <svg class="h-5 w-5 text-slate-400 group-hover:text-slate-600 dark:group-hover:text-slate-300 transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor" id="eyeIcon">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                                <svg class="h-5 w-5 text-slate-400 hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor" id="eyeIconSlash">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.059 10.059 0 013.999-5.42m-7.1 12.5l16.14-16.14M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div>
                        <button type="submit" id="submitBtn" class="flex w-full justify-center rounded-lg bg-brand-600 px-3 py-2.5 text-sm font-semibold leading-6 text-white shadow-sm hover:bg-brand-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-brand-600 transition-all duration-200 transform active:scale-[0.98]">
                            Masuk Aplikasi
                        </button>
                    </div>
                </form>

                <!-- Footer / Credits -->
                <div class="mt-8">
                    <div class="relative">
                        <div class="absolute inset-0 flex items-center">
                            <div class="w-full border-t border-slate-200 dark:border-slate-700"></div>
                        </div>
                        <div class="relative flex justify-center text-sm">
                            <span class="bg-white dark:bg-slate-800 px-2 text-slate-500">Secure System</span>
                        </div>
                    </div>

                    <div class="mt-6 text-center">
                        <div class="flex items-center justify-center gap-2 grayscale opacity-70 hover:grayscale-0 hover:opacity-100 transition-all duration-300">
                            <img src="digipas.png" alt="Digipas" class="h-6 w-auto" onerror="this.style.display='none'">
                            <p class="text-xs text-slate-500 dark:text-slate-400">
                                Powered by <span class="font-semibold text-slate-700 dark:text-slate-300">digipas.id</span> &copy; <span id="currentYear"></span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // --- LOGIC THEME ---
        const themeToggle = document.getElementById('themeToggle');
        const htmlElement = document.documentElement;
        const sunIcon = document.querySelector('.sun-icon');
        const moonIcon = document.querySelector('.moon-icon');

        function applyTheme(theme) {
            if (theme === 'dark') {
                htmlElement.classList.add('dark');
                sunIcon.classList.add('hidden');
                moonIcon.classList.remove('hidden');
            } else {
                htmlElement.classList.remove('dark');
                sunIcon.classList.remove('hidden');
                moonIcon.classList.add('hidden');
            }
        }

        // Cek LocalStorage atau Preferensi Sistem
        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            applyTheme(savedTheme);
        } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            applyTheme('dark');
        } else {
            applyTheme('light');
        }

        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                applyTheme('light');
                localStorage.setItem('theme', 'light');
            } else {
                applyTheme('dark');
                localStorage.setItem('theme', 'dark');
            }
        });

        // --- LOGIC PASSWORD TOGGLE ---
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');
        const eyeIcon = document.getElementById('eyeIcon');
        const eyeIconSlash = document.getElementById('eyeIconSlash');

        togglePassword.addEventListener('click', () => {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            if (type === 'text') {
                eyeIcon.classList.add('hidden');
                eyeIconSlash.classList.remove('hidden');
            } else {
                eyeIcon.classList.remove('hidden');
                eyeIconSlash.classList.add('hidden');
            }
        });

        // --- LOGIC LOADER PADA BUTTON ---
        const loginForm = document.getElementById('loginForm');
        const submitBtn = document.getElementById('submitBtn');

        loginForm.addEventListener('submit', (e) => {
            // Kita tidak pakai overlay full screen lagi, tapi spinner di tombol
            // agar UX lebih modern
            const isError = document.querySelector('.bg-red-50');
            
            // Jika validasi HTML5 lolos
            if (loginForm.checkValidity()) {
                submitBtn.classList.add('btn-loading'); // Tambah class loading
                submitBtn.disabled = true; // Matikan tombol agar tidak double submit
                
                // Jika ingin melihat efek loading (karena PHP submit sangat cepat), 
                // kode di bawah hanya simulasi. Hapus e.preventDefault() untuk production.
                // e.preventDefault(); 
                // setTimeout(() => loginForm.submit(), 1000);
            }
        });

        document.getElementById('currentYear').textContent = new Date().getFullYear();
    </script>
</body>
</html>