<?php
session_start();

// --- KONFIGURASI KONEKSI DATABASE ---
require_once '../config.php'; 

// Verifikasi sesi login (Opsional)
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== TRUE || $_SESSION['role'] !== 'admin') {
    // header("location: index.php");
    // exit;
}

// --- 1. Fungsi Ambil Pengaturan Sekolah ---
function getSchoolSettings($conn) {
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah, nama_kepala_sekolah, ttd_kepala_sekolah FROM pengaturan_sekolah LIMIT 1";       
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return [
        'nama_sekolah' => 'NAMA SEKOLAH BELUM DIATUR', 
        'alamat_sekolah' => '', 
        'logo_sekolah' => '',
        'nama_kepala_sekolah' => '',
        'ttd_kepala_sekolah' => ''
    ];
}

$settings = getSchoolSettings($conn);
$nama_sekolah = htmlspecialchars($settings['nama_sekolah'] ?? 'Nama Sekolah');
$alamat_sekolah = htmlspecialchars($settings['alamat_sekolah'] ?? '');
$logo_path = !empty($settings['logo_sekolah']) ? 'uploads/' . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/100x100/transparent/000000?text=LOGO';
$nama_ks = htmlspecialchars($settings['nama_kepala_sekolah'] ?? 'Kepala Sekolah');
if(empty($nama_ks)) $nama_ks = "Kepala Sekolah";
$ttd_path = !empty($settings['ttd_kepala_sekolah']) ? 'uploads/' . htmlspecialchars($settings['ttd_kepala_sekolah']) : '';

// --- 2. Pengaturan Tampilan & LOGIC FIX ---
// Pastikan nilai default ditangani dengan baik
$show_photo = isset($_GET['show_photo']) ? (int)$_GET['show_photo'] : 1;
$show_ttd   = isset($_GET['show_ttd']) ? (int)$_GET['show_ttd'] : 1;

// --- 3. Ambil ID Siswa (Logic Diperbaiki) ---
$student_ids = [];

// Prioritas 1: Ambil dari POST (saat form submit)
if (isset($_POST['ids']) && is_array($_POST['ids'])) {
    $student_ids = $_POST['ids'];
} 
// Prioritas 2: Ambil dari GET (saat klik link toggle)
elseif (isset($_GET['id'])) {
    // Decode URL terlebih dahulu untuk keamanan karakter koma
    $raw_id = urldecode($_GET['id']);
    if (strpos($raw_id, ',') !== false) {
        $student_ids = explode(',', $raw_id);
    } else {
        $student_ids = [$raw_id];
    }
}

// Sanitasi ID
$student_ids = array_map(function($id) use ($conn) {
    return $conn->real_escape_string(trim($id));
}, $student_ids);
$student_ids = array_filter($student_ids);

// Buat string ID untuk URL (gunakan urlencode agar aman di link)
$ids_param = urlencode(implode(',', $student_ids));

// Ambil Data Siswa
$students_data = [];
if (!empty($student_ids)) {
    $ids_string = "'" . implode("','", $student_ids) . "'";
    $sql = "SELECT id, nama, kelas, ruangan, foto FROM students WHERE id IN ($ids_string) ORDER BY kelas ASC, nama ASC";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $students_data[] = $row;
        }
    }
}

// Helper URL Builder (FIX FINAL: ID wajib ikut)
function buildUrl($params = [], $ids_string = '') {
    $query_data = $_GET; // Ambil parameter yang ada
    
    // Timpa atau tambahkan parameter baru
    foreach ($params as $key => $value) {
        $query_data[$key] = $value;
    }
    
    // Pastikan ID masuk (menggunakan string yang sudah di-encode/implode sebelumnya)
    // Kita decode dulu karena http_build_query akan meng-encode ulang
    if (!empty($ids_string)) {
        $query_data['id'] = urldecode($ids_string);
    }
    
    return "?" . http_build_query($query_data);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Kartu Ujian - <?php echo $nama_sekolah; ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Oswald:wght@500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary: #1e3a8a;
            --accent: #ca8a04;
            --bg-pattern: #f8fafc;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #e2e8f0; 
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        /* --- Kartu ISO 7810 ID-1 Standard --- */
        .id-card-wrapper {
            position: relative;
            width: 86mm; 
            height: 54mm;
            margin: 0 auto;
            page-break-inside: avoid;
        }

        /* --- GARIS POTONG & GRID --- */
        .cut-guide {
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            border: 1px dashed #94a3b8; 
            z-index: 50; 
            pointer-events: none;
            box-sizing: border-box;
        }

        .id-card {
            position: relative;
            width: 100%;
            height: 100%;
            background-color: white;
            border-radius: 8px; /* Tampilan layar rounded */
            overflow: hidden;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            z-index: 10;
        }

        /* --- Security Pattern Background --- */
        .security-bg {
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background-image: 
                radial-gradient(#e2e8f0 1px, transparent 1px),
                radial-gradient(#e2e8f0 1px, transparent 1px);
            background-size: 10px 10px;
            background-position: 0 0, 5px 5px;
            opacity: 0.5;
            z-index: 0;
        }

        /* --- Header --- */
        .card-header {
            background: linear-gradient(135deg, #1e3a8a 0%, #172554 100%);
            color: white;
            padding: 8px 12px;
            display: flex;
            align-items: center;
            gap: 10px;
            position: relative;
            z-index: 2;
            border-bottom: 3px solid var(--accent);
        }

        /* --- Body --- */
        .card-body {
            flex: 1;
            padding: 10px 12px 2px 12px;
            display: flex;
            gap: 10px;
            align-items: flex-start;
            position: relative;
            z-index: 2;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 2px; 
        }
        .data-table td {
            padding: 1px 0;
            vertical-align: top;
        }
        .label-col { width: 55px; font-size: 8px; color: #64748b; font-weight: 600; text-transform: uppercase; padding-top: 2px; }
        .sep-col { width: 8px; font-size: 8px; color: #94a3b8; text-align: center; padding-top: 2px; }
        .val-col { font-size: 10px; color: #0f172a; font-weight: 700; line-height: 1.2; }
        .val-nama { font-size: 11px; color: #1e3a8a; text-transform: uppercase; letter-spacing: -0.01em; }

        .card-footer {
            background: #f1f5f9;
            padding: 3px 12px;
            font-size: 7px;
            color: #64748b;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #e2e8f0;
            position: relative;
            z-index: 2;
        }

        /* --- SETTING PRINT (SOLUSI 10 KARTU - 2x5 RAPAT) --- */
        @media print {
            @page {
                size: A4;
                /* UPDATED: Margin dibuat 0mm agar muat 100%. 
                   Printer biasanya punya margin fisik sendiri (non-printable area),
                   tapi setting ini memaksa browser tidak menambah margin software.
                */
                margin: 0mm; 
            }
            body { 
                background: white; 
                /* Tambahkan sedikit padding pada body untuk kompensasi margin 0 */
                padding: 10mm;
            }
            .no-print { display: none !important; }
            
            /* Grid Utama (Garis Potong Luar - Solid Hitam Tegas) */
            .print-grid {
                display: grid;
                grid-template-columns: repeat(2, 1fr); /* 2 Kolom */
                gap: 0; /* Rapat total */
                width: 100%;
                justify-content: center;
                
                /* FIX: Reset padding bawaan layar agar tidak memakan tempat vertikal */
                padding: 0 !important; 
                margin: 0 !important;

                /* Bingkai Luar Grid */
                border-top: 1px solid #000;
                border-left: 1px solid #000;
            }

            /* Wrapper Per Kartu (Sel Grid) */
            .id-card-wrapper {
                width: 86mm !important; 
                height: 54mm !important; 
                margin: 0 !important;
                
                /* Bingkai Kanan & Bawah untuk membentuk Grid Penuh */
                border-right: 1px solid #000;
                border-bottom: 1px solid #000;
                
                /* Padding 0 agar benar-benar rapat ke garis potong */
                padding: 0 !important; 
                
                display: flex;
                justify-content: center;
                align-items: center;
                break-inside: avoid;
                
                /* Pastikan garis potong terlihat di atas */
                position: relative;
                z-index: 10;
            }

            /* Hapus garis putus-putus internal agar tidak membingungkan */
            .cut-guide {
                display: none !important;
            }

            /* Kartu Asli */
            .id-card {
                width: 100%; 
                height: 100%;
                box-shadow: none;
                border-radius: 0px !important; 
                border: none !important;
            }
        }

        /* Screen Only Layout */
        .print-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
            padding: 40px 20px;
        }
    </style>
</head>
<body>

    <!-- TOOLBAR (Tidak dicetak) -->
    <div class="no-print bg-white border-b border-gray-200 shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 py-3 flex flex-wrap justify-between items-center gap-4">
            <div class="flex items-center gap-3">
                <div class="bg-blue-100 p-2 rounded-lg text-blue-700">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-5 8a2 2 0 100-4 2 2 0 000 4zm0 0c1.306 0 2.417.835 2.83 2M9 14a3.001 3.001 0 00-2.83 2M15 11h3m-3 4h2"></path></svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-gray-800">Cetak Kartu Ujian</h1>
                    <p class="text-xs text-gray-500">Total: <span class="font-bold"><?php echo count($students_data); ?></span> Siswa</p>
                </div>
            </div>

            <div class="flex items-center gap-2">
                <!-- Toggle Foto (Link diperbaiki) -->
                <div class="flex bg-gray-100 rounded-lg p-0.5 border border-gray-200">
                    <a href="<?php echo buildUrl(['show_photo' => 1], $ids_param); ?>" class="px-3 py-1.5 text-xs font-medium rounded transition <?php echo $show_photo ? 'bg-white shadow text-blue-700 font-bold' : 'text-gray-500 hover:text-gray-700'; ?>">
                        + Foto
                    </a>
                    <a href="<?php echo buildUrl(['show_photo' => 0], $ids_param); ?>" class="px-3 py-1.5 text-xs font-medium rounded transition <?php echo !$show_photo ? 'bg-white shadow text-blue-700 font-bold' : 'text-gray-500 hover:text-gray-700'; ?>">
                        - Foto
                    </a>
                </div>

                <!-- Toggle TTD (Link diperbaiki) -->
                <div class="flex bg-gray-100 rounded-lg p-0.5 border border-gray-200">
                    <a href="<?php echo buildUrl(['show_ttd' => 1], $ids_param); ?>" class="px-3 py-1.5 text-xs font-medium rounded transition <?php echo $show_ttd ? 'bg-white shadow text-blue-700 font-bold' : 'text-gray-500 hover:text-gray-700'; ?>">
                        + TTD
                    </a>
                    <a href="<?php echo buildUrl(['show_ttd' => 0], $ids_param); ?>" class="px-3 py-1.5 text-xs font-medium rounded transition <?php echo !$show_ttd ? 'bg-white shadow text-blue-700 font-bold' : 'text-gray-500 hover:text-gray-700'; ?>">
                        - TTD
                    </a>
                </div>

                <div class="h-6 w-px bg-gray-300 mx-1"></div>

                <button onclick="window.print()" class="px-5 py-2 bg-blue-700 text-white rounded-lg hover:bg-blue-800 transition flex items-center gap-2 text-sm font-semibold shadow-sm ring-2 ring-offset-2 ring-transparent hover:ring-blue-600">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path></svg>
                    Print
                </button>
            </div>
        </div>
    </div>

    <!-- MAIN CONTENT AREA -->
    <div class="print-grid max-w-7xl mx-auto">
        
        <?php if (empty($students_data)): ?>
            <div class="col-span-full text-center py-20 text-gray-400 no-print">
                <p class="text-xl">Tidak ada data siswa yang dipilih atau sesi kadaluarsa.</p>
                <a href="javascript:history.back()" class="text-blue-600 underline text-sm mt-2">Kembali</a>
            </div>
        <?php else: ?>

            <?php foreach ($students_data as $siswa): ?>
                <div class="id-card-wrapper">
                    <!-- Garis Putus-putus disembunyikan saat print agar grid solid utama lebih jelas -->
                    <div class="cut-guide"></div> 
                    
                    <div class="id-card">
                        <div class="security-bg"></div>

                        <!-- Header -->
                        <div class="card-header">
                            <div class="w-9 h-9 bg-white rounded-full p-0.5 flex-shrink-0 flex items-center justify-center shadow-md border border-blue-200">
                                <img src="<?php echo $logo_path; ?>" class="w-full h-full object-contain" onerror="this.src='https://placehold.co/100x100/transparent/eee?text=IMG'">
                            </div>
                            
                            <div class="flex-1 min-w-0">
                                <h2 class="text-[10px] font-bold uppercase tracking-wider leading-tight font-oswald text-yellow-50">
                                    <?php echo $nama_sekolah; ?>
                                </h2>
                                <p class="text-[6.5px] text-blue-200 leading-tight mt-0.5 truncate font-light">
                                    <?php echo $alamat_sekolah; ?>
                                </p>
                            </div>

                            <div class="bg-white/10 border border-white/20 rounded px-1.5 py-0.5">
                                <span class="block text-[6px] font-bold text-white uppercase tracking-widest text-center">
                                    KARTU<br>PESERTA
                                </span>
                            </div>
                        </div>

                        <!-- Body -->
                        <div class="card-body">
                            
                            <?php if ($show_photo): ?>
                                <!-- FOTO -->
                                <div class="w-[21mm] h-[27mm] bg-white p-1 shadow-sm border border-gray-200 flex-shrink-0 rotate-1 transform transition hover:rotate-0">
                                    <div class="w-full h-full bg-gray-100 overflow-hidden relative">
                                        <?php if (!empty($siswa['foto']) && file_exists('uploads/' . $siswa['foto'])): ?>
                                            <img src="uploads/<?php echo htmlspecialchars($siswa['foto']); ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <div class="flex items-center justify-center h-full text-gray-300">
                                                <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24"><path d="M24 20.993V24H0v-2.996A14.977 14.977 0 0112.004 15c4.904 0 9.26 2.354 11.996 5.993zM16.002 8.999a4 4 0 11-8 0 4 4 0 018 0z" /></svg>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- CONTAINER DATA & TTD -->
                            <div class="flex-1 min-w-0 flex flex-col h-full relative">
                                
                                <!-- Tabel Data -->
                                <table class="data-table relative z-10">
                                    <tr>
                                        <td class="label-col">Nama</td>
                                        <td class="sep-col">:</td>
                                        <td class="val-col val-nama truncate"><?php echo htmlspecialchars($siswa['nama']); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="label-col">No. Ujian</td>
                                        <td class="sep-col">:</td>
                                        <td class="val-col font-mono tracking-wide"><?php echo htmlspecialchars($siswa['id']); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="label-col">Kelas</td>
                                        <td class="sep-col">:</td>
                                        <td class="val-col"><?php echo htmlspecialchars($siswa['kelas']); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="label-col">Ruang</td>
                                        <td class="sep-col">:</td>
                                        <td class="val-col"><?php echo htmlspecialchars($siswa['ruangan'] ?? '-'); ?></td>
                                    </tr>
                                </table>

                               

                                <!-- QR CODE (Absolute positioning) -->
                                <div class="absolute bottom-0 right-0 bg-white p-0.5 border border-gray-100 rounded z-20">
                                    <canvas id="qr-<?php echo $siswa['id']; ?>" style="width: 75px; height: 75px;"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Footer -->
                        <div class="card-footer">
                            <div class="flex items-center gap-1">
                                <svg class="w-2 h-2 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                <span class="font-bold tracking-tight text-blue-900">VERIFIED</span>
                            </div>
                            <div class="text-[6px] italic opacity-70">
                                Berlaku selama periode ujian
                            </div>
                        </div>

                    </div>
                </div>

                <!-- QR Generation Script -->
                <script>
                    (function() {
                        var qr = new QRious({
                            element: document.getElementById('qr-<?php echo $siswa['id']; ?>'),
                            value: '<?php echo htmlspecialchars($siswa['id']); ?>',
                            size: 200, 
                            level: 'M',
                            foreground: '#000000',
                            background: '#ffffff'
                        });
                    })();
                </script>

            <?php endforeach; ?>
        <?php endif; ?>
    </div>

</body>
</html>