<!DOCTYPE html>
<html>
<head>
    <title>Pembayaran Bebas</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo media_url('css/bootstrap.min.css') ?>">
    <style>
        /* Custom styles for the modals */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .modal-content {
            background-color: #fff;
            padding: 2rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            max-width: 90%;
            width: 400px;
            text-align: center;
        }
        .modal-content input {
            width: 100%;
            padding: 0.75rem;
            margin-top: 1rem;
            border: 1px solid #ccc;
            border-radius: 0.25rem;
        }
        .modal-content button {
            margin-top: 1.5rem;
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            cursor: pointer;
            font-weight: 600;
        }
    </style>
</head>
<body class="font-sans antialiased bg-gray-100">
    <section class="content p-4">
        <div class="row">   
            <div class="col-md-12">
                <table class="table table-bordered table-striped w-full bg-white shadow-md rounded-lg overflow-hidden">
                    <thead>
                        <tr class="bg-blue-600 text-white">
                            <th class="p-3 text-left rounded-tl-lg">No</th>
                            <th class="p-3 text-left">Tanggal</th>
                            <th class="p-3 text-right">Jumlah Bayar</th>
                            <th class="p-3 text-left">Keterangan</th>
                            <th class="p-3 text-left rounded-tr-lg">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($bill)) {
                            $i = 1;
                            foreach ($bill as $row): 
                        ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="p-3"><?php echo $i; ?></td>
                                    <td class="p-3"><?php echo pretty_date($row['bebas_pay_input_date'],'d F Y',false); ?></td>
                                    <td class="p-3 text-right"><?php echo 'Rp. ' . number_format($row['bebas_pay_bill'], 0, ',', '.') ?></td>
                                    <td class="p-3"><?php echo $row['bebas_pay_desc']; ?></td>
                                    <td class="p-3">
                                        <!-- The delete button now calls a JavaScript function -->
                                        <a class="btn btn-danger btn-xs bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-3 rounded-lg shadow-md transition duration-300 ease-in-out" 
                                           onclick="promptForPasswordAndRedirect('<?php echo site_url('manage/payout/delete_pay_free/'.$row['payment_payment_id'].'/'.$row['student_student_id'].'/'.$row['bebas_bebas_id'].'/'.$row['bebas_pay_id']) ?>', '<?php echo $row['bebas_pay_desc'] ?>'); return false;" 
                                           title="Hapus">
                                            <span class="glyphicon glyphicon-trash"></span> Hapus
                                        </a>
                                    </td>
                                </tr>
                        <?php 
                                $i++;
                            endforeach; 
                        ?>
                        <tr class="bg-green-100 text-green-800 font-bold">
                            <td class="p-3" colspan="2"><b>Total Sudah Bayar</b></td>
                            <td class="p-3 text-right"><b><?php echo 'Rp. ' . number_format($total_pay, 0, ',', '.') ?></b></td>
                            <td class="p-3" colspan="3"><b>Tunggakan : <?php echo 'Rp. ' . number_format($total-$total_pay, 0, ',', '.') ?></b></td>
                        </tr>
                        <?php } ?>              
                    </tbody>
                </table>
            </div>
        </div>
    </section>

    <!-- Custom Password Input Modal -->
    <div id="passwordModal" class="modal-overlay hidden">
        <div class="modal-content">
            <h3 class="text-xl font-bold mb-4">Konfirmasi Hapus Data</h3>
            <p id="deleteConfirmationText" class="text-gray-700 mb-4"></p>
            <p class="text-gray-700">Silakan masukkan password untuk melanjutkan:</p>
            <input type="password" id="passwordInput" placeholder="Masukkan password" class="w-full p-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            <div class="flex justify-center space-x-4 mt-6">
                <button id="confirmPasswordBtn" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded-lg shadow-md transition duration-300 ease-in-out">Konfirmasi</button>
                <button id="cancelPasswordBtn" class="bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 px-4 rounded-lg shadow-md transition duration-300 ease-in-out">Batal</button>
            </div>
        </div>
    </div>

    <!-- Custom Message Modal -->
    <div id="messageModal" class="modal-overlay hidden">
        <div class="modal-content">
            <h3 id="messageModalTitle" class="text-xl font-bold mb-4">Pesan</h3>
            <p id="messageModalText" class="text-gray-700 mb-4"></p>
            <button id="closeMessageModalBtn" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded-lg shadow-md transition duration-300 ease-in-out">Tutup</button>
        </div>
    </div>

    <script>
        // Get modal elements
        const passwordModal = document.getElementById('passwordModal');
        const passwordInput = document.getElementById('passwordInput');
        const confirmPasswordBtn = document.getElementById('confirmPasswordBtn');
        const cancelPasswordBtn = document.getElementById('cancelPasswordBtn');
        const deleteConfirmationText = document.getElementById('deleteConfirmationText');

        const messageModal = document.getElementById('messageModal');
        const messageModalTitle = document.getElementById('messageModalTitle');
        const messageModalText = document.getElementById('messageModalText');
        const closeMessageModalBtn = document.getElementById('closeMessageModalBtn');

        let currentDeleteUrl = ''; // To store the URL for deletion
        const correctPassword = 'titacantik'; // The required password

        /**
         * Displays the password input modal and handles the confirmation logic.
         * @param {string} url - The URL to redirect to upon successful password entry.
         * @param {string} description - The description of the item being deleted.
         */
        function promptForPasswordAndRedirect(url, description) {
            currentDeleteUrl = url;
            deleteConfirmationText.textContent = `Anda Akan Menghapus Pembayaran ${description}?`;
            passwordInput.value = ''; // Clear previous input
            passwordModal.classList.remove('hidden'); // Show the modal
            passwordInput.focus(); // Focus on the input field
        }

        /**
         * Displays a custom message modal.
         * @param {string} title - The title of the message.
         * @param {string} message - The message content.
         */
        function showMessage(title, message) {
            messageModalTitle.textContent = title;
            messageModalText.textContent = message;
            messageModal.classList.remove('hidden'); // Show the modal
        }

        // Event listener for the confirm password button
        confirmPasswordBtn.addEventListener('click', () => {
            const enteredPassword = passwordInput.value;
            if (enteredPassword === correctPassword) {
                passwordModal.classList.add('hidden'); // Hide the modal
                window.location.href = currentDeleteUrl; // Redirect to delete URL
            } else {
                passwordModal.classList.add('hidden'); // Hide password modal
                showMessage('Password Salah', 'Password salah, silahkan menghubungi bu tita yang terhormat.');
            }
        });

        // Event listener for the cancel password button
        cancelPasswordBtn.addEventListener('click', () => {
            passwordModal.classList.add('hidden'); // Hide the modal
        });

        // Event listener for the close message modal button
        closeMessageModalBtn.addEventListener('click', () => {
            messageModal.classList.add('hidden'); // Hide the modal
        });

        // Close modals if clicked outside (optional, but good for UX)
        passwordModal.addEventListener('click', (e) => {
            if (e.target === passwordModal) {
                passwordModal.classList.add('hidden');
            }
        });

        messageModal.addEventListener('click', (e) => {
            if (e.target === messageModal) {
                messageModal.classList.add('hidden');
            }
        });
    </script>
</body>
</html>
