<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Payout_set extends CI_Controller {

  public function __construct() {
    parent::__construct(TRUE);
    if ($this->session->userdata('logged') == NULL) {
      header("Location:" . site_url('manage/auth/login') . "?location=" . urlencode($_SERVER['REQUEST_URI']));
    }
    $this->load->model(array('payment/Payment_model', 'student/Student_model', 'period/Period_model', 'pos/Pos_model', 'bulan/Bulan_model', 'bebas/Bebas_model', 'bebas/Bebas_pay_model', 'setting/Setting_model', 'letter/Letter_model', 'logs/Logs_model', 'ltrx/Log_trx_model'));

  }

// payment view in list
  public function index($offset = NULL, $id =NULL) {
// Apply Filter
// Get $_GET variable
    $f = $this->input->get(NULL, TRUE);

    $data['f'] = $f;

    $siswa['student_id'] = '';
    $params = array();
    $param = array();
    $pay = array();
    $cashback = array();
    $logs = array();

// Tahun Ajaran
    if (isset($f['n']) && !empty($f['n']) && $f['n'] != '') {
      $params['period_id'] = $f['n'];
      $pay['period_id'] = $f['n'];
      $cashback['period_id'] = $f['n'];
      $logs['period_id'] = $f['n'];
    }

// Siswa
    if (isset($f['r']) && !empty($f['r']) && $f['r'] != '') {
      $params['student_nis'] = $f['r'];
      $param['student_nis'] = $f['r'];
      $cashback['student_nis'] = $f['r'];
      $logs['student_nis'] = $f['r'];
      $siswa = $this->Student_model->get(array('student_nis'=>$f['r']));
    }

    // tanggal
    if (isset($f['d']) && !empty($f['d']) && $f['d'] != '') {
      $param['date'] = $f['d'];

    }


    $params['group'] = TRUE;
    $pay['paymentt'] = TRUE;
    $param['status'] = 1;
    $cashback['status'] = 1;
    $pay['student_id']=$siswa['student_id'];
    $cashback['student_id']=$siswa['student_id'];
    $logs['student_id']=$siswa['student_id'];
    $cashback['date'] = date('Y-m-d');
    $cashback['bebas_pay_input_date'] = date('Y-m-d');
    $logs['limit'] = 3;


    $paramsPage = $params;
    $data['period'] = $this->Period_model->get($params);
    $data['siswa'] = $this->Student_model->get(array('student_id'=>$siswa['student_id'], 'group'=>TRUE));
    $data['student'] = $this->Bulan_model->get($pay);
    $data['bulan'] = $this->Bulan_model->get(array('student_id'=>$siswa['student_id']));
    $data['bebas'] = $this->Bebas_model->get($pay);
    $data['free'] = $this->Bebas_pay_model->get($params);
    $data['dom'] = $this->Bebas_pay_model->get($params);
    $data['bill'] = $this->Bulan_model->get_total($params);
    $data['in'] = $this->Bulan_model->get_total($param);
    $data['month'] = $this->Bulan_model->get_total($cashback);
    $data['beb'] = $this->Bebas_pay_model->get($cashback);
    $data['log'] = $this->Log_trx_model->get($logs);

    // cashback
    $data['cash'] = 0;
    foreach ($data['month'] as $row) {
      $data['cash'] += $row['bulan_bill'];
    }

    $data['cashb'] = 0;
    foreach ($data['beb'] as $row) {
      $data['cashb'] += $row['bebas_pay_bill'];
    }

    // endcashback


    // 
    $data['total'] = 0;
    foreach ($data['bill'] as $key) {
      $data['total'] += $key['bulan_bill'];
    }

    $data['pay'] = 0;
    foreach ($data['in'] as $row) {
      $data['pay'] += $row['bulan_bill'];
    }

    $data['pay_bill'] = 0;
    foreach ($data['dom'] as $row) {
      $data['pay_bill'] += $row['bebas_pay_bill'];
    }

    $config['base_url'] = site_url('manage/payment/index');
    $config['suffix'] = '?' . http_build_query($_GET, '', "&");
    $config['total_rows'] = count($this->Bulan_model->get($paramsPage));

    $data['title'] = 'Pembayaran Siswa';
    $data['main'] = 'payout/payout_list';

    $this->load->view('manage/layout', $data);
    
    
	} 

  function printBill() {
    $this->load->helper(array('dompdf'));
    $f = $this->input->get(NULL, TRUE);

    $data['f'] = $f;

    $siswa['student_id'] = '';
    $params = array();
    $pay = array();

// Tahun Ajaran
    if (isset($f['n']) && !empty($f['n']) && $f['n'] != '') {
      $params['period_id'] = $f['n'];
      $pay['period_id'] = $f['n'];
    }

// Siswa
    if (isset($f['r']) && !empty($f['r']) && $f['r'] != '') {
      $params['student_nis'] = $f['r'];
      $siswa = $this->Student_model->get(array('student_nis'=>$f['r']));

    }

    $pay['student_id']=$siswa['student_id'];

    $data['period'] = $this->Period_model->get($params);
    $data['siswa'] = $this->Student_model->get(array('student_id'=>$siswa['student_id'], 'group'=>TRUE));
    $data['bulan'] = $this->Bulan_model->get($pay);
    $data['bebas'] = $this->Bebas_model->get($pay);

    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT)); 

    echo $this->load->view('payout/payout_bill_pdf', $data, true);
    // $data = pdf_create($html, $siswa['student_full_name'], TRUE, 'A4', TRUE);
  }

  function cetakBukti() {
    $this->load->helper(array('dompdf'));
    $f = $this->input->get(NULL, TRUE);
    // $a4 = $this->input->get('a4');
    // // $struk = $this->input->get('struk');
    // var_dump($a4);
    // // var_dump($_GET);
    // die;
    $data['f'] = $f;

    $siswa['student_id'] = '';
    $params = array();
    $param = array();
    $pay = array();
    $cashback = array();

// Tahun Ajaran
    if (isset($f['n']) && !empty($f['n']) && $f['n'] != '') {
      $params['period_id'] = $f['n'];
      $pay['period_id'] = $f['n'];
      $cashback['period_id'] = $f['n'];
    }

// Siswa
    if (isset($f['r']) && !empty($f['r']) && $f['r'] != '') {
      $params['student_nis'] = $f['r'];
      $param['student_nis'] = $f['r'];
      $siswa = $this->Student_model->get(array('student_nis'=>$f['r']));

    }

    // tanggal
    if (isset($f['d']) && !empty($f['d']) && $f['d'] != '') {
      $param['date'] = $f['d'];
      $cashback['date'] = $f['d'];

    }


    $params['group'] = TRUE;
    $pay['paymentt'] = TRUE;
    $param['status'] = 1;
    $param['student_id']=$siswa['student_id'];
    $cashback['status'] = 1;
    $pay['student_id']=$siswa['student_id'];
    $cashback['student_id']=$siswa['student_id'];

    $data['period'] = $this->Period_model->get($params);
    $data['siswa'] = $this->Student_model->get(array('student_id'=>$siswa['student_id'], 'group'=>TRUE));
    $data['student'] = $this->Bulan_model->get($pay);
    $data['bulan'] = $this->Bulan_model->get($param);
    $data['bebas'] = $this->Bebas_model->get($pay);
    $data['free'] = $this->Bebas_pay_model->get($param);
    $data['s_bl'] = $this->Bulan_model->get_total($cashback);
    $data['s_bb'] = $this->Bebas_pay_model->get($cashback);

    //total
    $data['summonth'] = 0;
    foreach ($data['s_bl'] as $row) {
      $data['summonth'] += $row['bulan_bill'];
    }

    $data['sumbeb'] = 0;
    foreach ($data['s_bb'] as $row) {
      $data['sumbeb'] += $row['bebas_pay_bill'];
    }
    // endtotal

    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT)); 
    $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME)); 
    $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS)); 
    $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE)); 

    // if(isset($this->input->get('a4'))) {
      echo $this->load->view('payout/payout_cetak_pdf', $data, true);
    // }else {
    //   echo "Hai";
    // }
    // echo $this->load->view('payout/payout_cetak_pdf', $data, true);
    // $data = pdf_create($html, 'Cetak_Struk_'.$siswa['student_full_name'].'_'.date('Y-m-d'), TRUE, 'A4', TRUE);
  }

  function cetakBuktiStruk() {
    $this->load->helper(array('dompdf'));
    $f = $this->input->get(NULL, TRUE);
   $this->load->model('setting/Setting_model');
     $data['title'] = 'Pengaturan';
     $data['setting_school'] = $this->Setting_model->get(array('id' => 1));
     $data['setting_address'] = $this->Setting_model->get(array('id' => 2));
     $data['setting_phone'] = $this->Setting_model->get(array('id' => 3));
     $data['setting_district'] = $this->Setting_model->get(array('id' => 4));
    $data['setting_city'] = $this->Setting_model->get(array('id' => 5));
      $data['setting_logo'] = $this->Setting_model->get(array('id' => 6));
      $data['setting_level'] = $this->Setting_model->get(array('id' => 7));
      $data['setting_user_sms'] = $this->Setting_model->get(array('id' => 8));
      $data['setting_pass_sms'] = $this->Setting_model->get(array('id' => 9));
      $data['setting_sms'] = $this->Setting_model->get(array('id' => 10));


    // $a4 = $this->input->get('a4');
    // // $struk = $this->input->get('struk');
    // var_dump($a4);
    // // var_dump($_GET);
    // die;
    $data['f'] = $f;

    $siswa['student_id'] = '';
    $params = array();
    $param = array();
    $pay = array();
    $cashback = array();

// Tahun Ajaran
    if (isset($f['n']) && !empty($f['n']) && $f['n'] != '') {
      $params['period_id'] = $f['n'];
      $pay['period_id'] = $f['n'];
      $cashback['period_id'] = $f['n'];
    }

// Siswa
    if (isset($f['r']) && !empty($f['r']) && $f['r'] != '') {
      $params['student_nis'] = $f['r'];
      $param['student_nis'] = $f['r'];
      $siswa = $this->Student_model->get(array('student_nis'=>$f['r']));

    }

    // tanggal
    if (isset($f['d']) && !empty($f['d']) && $f['d'] != '') {
      $param['date'] = $f['d'];
      $cashback['date'] = $f['d'];

    }


    $params['group'] = TRUE;
    $pay['paymentt'] = TRUE;
    $param['status'] = 1;
    $param['student_id']=$siswa['student_id'];
    $cashback['status'] = 1;
    $pay['student_id']=$siswa['student_id'];
    $cashback['student_id']=$siswa['student_id'];

    $data['period'] = $this->Period_model->get($params);
    $data['siswa'] = $this->Student_model->get(array('student_id'=>$siswa['student_id'], 'group'=>TRUE));
    $data['student'] = $this->Bulan_model->get($pay);
    $data['bulan'] = $this->Bulan_model->get($param);
    $data['bebas'] = $this->Bebas_model->get($pay);
    $data['free'] = $this->Bebas_pay_model->get($param);
    $data['s_bl'] = $this->Bulan_model->get_total($cashback);
    $data['s_bb'] = $this->Bebas_pay_model->get($cashback);

    //total
    $data['summonth'] = 0;
    foreach ($data['s_bl'] as $row) {
      $data['summonth'] += $row['bulan_bill'];
    }

    $data['sumbeb'] = 0;
    foreach ($data['s_bb'] as $row) {
      $data['sumbeb'] += $row['bebas_pay_bill'];
    }
    // endtotal
    $ttl = number_format($data['summonth'] + $data['sumbeb'], 0, ',', '.');
    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT)); 
    $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME)); 
    $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS)); 
    $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE)); 
    // $nama;
    foreach ($data['siswa'] as $row) {
      $nama = $row['student_full_name'];
      $nis = $row['student_nis'];
      $kelas = $row['class_name'];
      
    }

    foreach ( $data['period'] as $rw):
       if($f['n'] == $rw['period_id']) {
        $ta=$rw['period_start'].'/'.$rw['period_end'];
       }else {
         $ta = '';
       }  
   endforeach;

   $tgl = pretty_date($f['d'],'d F Y',false);

    

echo $this->load->view('payout/payout_struk', $data, true);
    
  }


 function cetakBuktiStruks() {
    $this->load->helper(array('dompdf'));
    $f = $this->input->get(NULL, TRUE);
   $this->load->model('setting/Setting_model');
     $data['title'] = 'Pengaturan';
     $data['setting_school'] = $this->Setting_model->get(array('id' => 1));
     $data['setting_address'] = $this->Setting_model->get(array('id' => 2));
     $data['setting_phone'] = $this->Setting_model->get(array('id' => 3));
     $data['setting_district'] = $this->Setting_model->get(array('id' => 4));
    $data['setting_city'] = $this->Setting_model->get(array('id' => 5));
      $data['setting_logo'] = $this->Setting_model->get(array('id' => 6));
      $data['setting_level'] = $this->Setting_model->get(array('id' => 7));
      $data['setting_user_sms'] = $this->Setting_model->get(array('id' => 8));
      $data['setting_pass_sms'] = $this->Setting_model->get(array('id' => 9));
      $data['setting_sms'] = $this->Setting_model->get(array('id' => 10));


    // $a4 = $this->input->get('a4');
    // // $struk = $this->input->get('struk');
    // var_dump($a4);
    // // var_dump($_GET);
    // die;
    $data['f'] = $f;

    $siswa['student_id'] = '';
    $params = array();
    $param = array();
    $pay = array();
    $cashback = array();

// Tahun Ajaran
    if (isset($f['n']) && !empty($f['n']) && $f['n'] != '') {
      $params['period_id'] = $f['n'];
      $pay['period_id'] = $f['n'];
      $cashback['period_id'] = $f['n'];
    }

// Siswa
    if (isset($f['r']) && !empty($f['r']) && $f['r'] != '') {
      $params['student_nis'] = $f['r'];
      $param['student_nis'] = $f['r'];
      $siswa = $this->Student_model->get(array('student_nis'=>$f['r']));

    }

    // tanggal
    if (isset($f['d']) && !empty($f['d']) && $f['d'] != '') {
      $param['date'] = $f['d'];
      $cashback['date'] = $f['d'];

    }


    $params['group'] = TRUE;
    $pay['paymentt'] = TRUE;
    $param['status'] = 1;
    $param['student_id']=$siswa['student_id'];
    $cashback['status'] = 1;
    $pay['student_id']=$siswa['student_id'];
    $cashback['student_id']=$siswa['student_id'];

    $data['period'] = $this->Period_model->get($params);
    $data['siswa'] = $this->Student_model->get(array('student_id'=>$siswa['student_id'], 'group'=>TRUE));
    $data['student'] = $this->Bulan_model->get($pay);
    $data['bulan'] = $this->Bulan_model->get($param);
    $data['bebas'] = $this->Bebas_model->get($pay);
    $data['free'] = $this->Bebas_pay_model->get($param);
    $data['s_bl'] = $this->Bulan_model->get_total($cashback);
    $data['s_bb'] = $this->Bebas_pay_model->get($cashback);

    //total
    $data['summonth'] = 0;
    foreach ($data['s_bl'] as $row) {
      $data['summonth'] += $row['bulan_bill'];
    }

    $data['sumbeb'] = 0;
    foreach ($data['s_bb'] as $row) {
      $data['sumbeb'] += $row['bebas_pay_bill'];
    }
    // endtotal
    $ttl = number_format($data['summonth'] + $data['sumbeb'], 0, ',', '.');
    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT)); 
    $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME)); 
    $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS)); 
    $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE)); 
    // $nama;
    foreach ($data['siswa'] as $row) {
      $nama = $row['student_full_name'];
      $nis = $row['student_nis'];
      $kelas = $row['class_name'];
      
    }

    foreach ( $data['period'] as $rw):
       if($f['n'] == $rw['period_id']) {
        $ta=$rw['period_start'].'/'.$rw['period_end'];
       }else {
         $ta = '';
       }  
   endforeach;

   $tgl = pretty_date($f['d'],'d F Y',false);

    // $html = '
       
    //     <h3 class="text-center">' .$data["setting_school"]["setting_value"]. '</h3>
    //     <h5 class="text-center">' .$data["setting_address"]["setting_value"]. '</h5>
    //     --------------------------------------------------------------
    //     <div style="clear:both;"></div><span class="float-left">NISN: ' . $nis. '</span><br><div style="clear:both;"></div><span class="float-left">Nama : ' . $nama . '</span><br><div style="clear:both;"><span class="float-left">Kelas: ' . $kelas . '</span><br><span class="float-left">TA: ' . $ta . '</span>
    //     </span><br>Tgl Bayar: ' . $tgl . '</span><div style="clear:both;"></div>
    //     --------------------------------------------------------------<div style="clear:both;"></div>
    //     <table class="table" cellspacing="0" border="0"><thead><tr><th><em>#</em></th><th>Pembayaran</th><th>Total</th></tr></thead><tbody>';
    //      $i =1;
    //             foreach ($data['bulan'] as $rw) :
    //                 $namePay = $rw['pos_name'].' - T.A '.$rw['period_start'].'/'.$rw['period_end'];
    //                 $mont = ($rw['month_month_id']<=6) ? $rw['period_start'] : $rw['period_end'];
                 
    //   $html .=  '<tr><td style="text-align:center; width:30px;">' . $i . '</td><td style="text-align:left; width:180px;">' . $namePay.' - ('.$rw['month_name'].' '. $mont.')' . '</td><td style="text-align:center; width:20px;">' . number_format($rw['bulan_bill'], 0, ',', '.') . '</td></tr>';
    //   $i++;
    //   endforeach;

    //   $j =$i;

    //   foreach ($data['free'] as $row) :
    //   $namePayFree = $row['pos_name'].' - T.A '.$row['period_start'].'/'.$row['period_end'];
    //   $html .=  '<tr><td style="text-align:center; width:30px;">' . $j . '</td><td style="text-align:left; width:180px;">' . $namePayFree .' - ('.$row['bebas_pay_desc'].')' . '</td><td style="text-align:center; width:20px;">' . number_format($row['bebas_pay_bill'], 0, ',', '.') . '</td></tr>';
    //   $j++;
    //   endforeach;

    //     $html .= '</tbody></table><table class="table" cellspacing="0" border="0" style="margin-bottom:8px;"><tbody><tr><td style="text-align:left;"></td><td style="text-align:right; padding-right:1.5%;"></td><td style="text-align:left; padding-left:1.5%;">TOTAL</td><td style="text-align:right;font-weight:bold;">' .$ttl . '</td></tr>
    //     </tbody></table>

    //     ';



    // echo $html;
      echo $this->load->view('payout/payout_struk', $data, true);

    // }else {
      // echo "Hai";
    // }
    // echo $this->load->view('payout/payout_cetak_pdf', $data, true);
    // $data = pdf_create($html, 'Cetak_Struk_'.$siswa['student_full_name'].'_'.date('Y-m-d'), TRUE, 'A4', TRUE);
  }


 public function pdfreceipt()
    {
        $content = $this->input->post('content');
        $this->load->library('pdf');
        $pdf = new pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->SetTitle('Pdf');
        $pdf->SetHeaderMargin(30);
        $pdf->SetTopMargin(20);
        $pdf->setFooterMargin(20);
        $pdf->SetAutoPageBreak(true);
        $pdf->SetAuthor('Author');
        // $pdf->SetDisplayMode('real', 'default');
        // add a page
        $pdf->AddPage();

        $pdf->writeHTMLCell(0, 0, '', '', $content, 0, 1, 0, true, '', true);
        ob_end_clean();
        $pdf->Output('Recipt-SPP.pdf', 'D');
    }

// View data detail
  public function view_bulan($id = NULL) {

// Apply Filter
// Get $_GET variable
    $q = $this->input->get(NULL, TRUE); 

    $data['q'] = $q;
    $params = array();

// Programs
    if (isset($q['pr']) && !empty($q['pr']) && $q['pr'] != '') {
      $params['class_id'] = $q['pr'];
    }

    $data['class'] = $this->Student_model->get_class($params);
    $data['student'] = $this->Student_model->get($params);
    $data['payment'] = $this->Payment_model->get(array('id' => $id));
    $data['bulan'] = $this->Bulan_model->get(array('id' => $id));
    $data['title'] = 'Tarif Pembayaran';
    $data['main'] = 'payment/payment_view_bulan';
    $this->load->view('manage/layout', $data);
  }

// View data detail
  public function view_bebas($id = NULL) {

    $data['payment'] = $this->Payment_model->get(array('id' => $id));
    $data['bebas'] = $this->Bebas_model->get(array('id' => $id));
    $data['title'] = 'Tarif Pembayaran';
    $data['main'] = 'payment/payment_view_bebas';
    $this->load->view('manage/layout', $data);
  }


  public function payout_bulan($id = NULL, $student_id = NULL) {

    if ($id == NULL AND $student_id == NULL OR $student_id == NULL) {
      redirect('manage/payout');
    }

    $data['class'] = $this->Student_model->get_class();
    $data['payment'] = $this->Payment_model->get(array('id' => $id));
    $data['bulan'] = $this->Bulan_model->get(array('payment_id' => $id, 'student_id' => $student_id));
    $data['in'] = $this->Bulan_model->get_total(array('status'=>1, 'payment_id' => $id, 'student_id' => $student_id));
    $data['student'] = $this->Student_model->get(array('id'=> $student_id));

    $data['total'] = 0;
    foreach ($data['bulan'] as $key) {
      $data['total'] += $key['bulan_bill'];
    }

    $data['pay'] = 0;
    foreach ($data['in'] as $row) {
      $data['pay'] += $row['bulan_bill'];
    }

    $data['ngapp'] = 'ng-app="App"';
    $data['title'] = 'Pembayaran Siswa';
    $data['main'] = 'payout/payout_add_bulan';
    $this->load->view('manage/layout', $data);
  }



  public function payout_bebas($id = NULL, $student_id = NULL, $bebas_id = NULL, $pay_id =NULL) {

    // if ($id == NULL AND $student_id == NULL AND $bebas_id == NULL OR $bebas_id == NULL) {
    //   redirect('manage/payout');
    // }
    if ($_POST == TRUE) {

      $lastletter = $this->Letter_model->get(array('limit' => 1));
      $student = $this->Bebas_model->get(array('id'=>$this->input->post('bebas_id')));
      $user = $this->Setting_model->get(array('id' => 8));
      $password = $this->Setting_model->get(array('id' => 9));
      $activated = $this->Setting_model->get(array('id' => 10));

      if ($lastletter['letter_year'] < date('Y') OR count($lastletter) == 0) {
        $this->Letter_model->add(array('letter_number' => '00001', 'letter_month' => date('m'), 'letter_year' => date('Y')));
        $nomor = sprintf('%05d', '00001');
        $nofull = date('Y'). date('m'). $nomor;
      } else {
        $nomor = sprintf('%05d', $lastletter['letter_number'] + 00001);
        $this->Letter_model->add(array('letter_number' => $nomor, 'letter_month' => date('m'), 'letter_year' => date('Y')));
        $nofull = date('Y'). date('m'). $nomor;
      }
      if ($this->input->post('bebas_id')) {
        $param['bebas_id'] = $this->input->post('bebas_id');
      } 
      $param['bebas_pay_number'] = $nofull;
      $param['bebas_pay_bill'] = $this->input->post('bebas_pay_bill');
      $param['increase_budget'] = $this->input->post('bebas_pay_bill');
      $param['bebas_pay_desc'] = $this->input->post('bebas_pay_desc');
      $param['user_user_id'] = $this->session->userdata('uid');
      $param['bebas_pay_input_date'] = date('Y-m-d H:i:s');
      $param['bebas_pay_last_update'] = date('Y-m-d H:i:s');

      $data['bill'] = $this->Bebas_pay_model->get(array('bebas_id'=>$this->input->post('bebas_id')));
      $data['bebas'] = $this->Bebas_model->get(array('payment_id' => $this->input->post('payment_payment_id'), 'student_nis' => $this->input->post('student_nis')));

      $data['total'] = 0;
      foreach ($data['bebas'] as $key) {
        $data['total'] += $key['bebas_bill'];
      }

      $data['total_pay'] = 0;
      foreach ($data['bill'] as $row) {
        $data['total_pay'] += $row['bebas_pay_bill'];
      }

      $sisa = $data['total'] - $data['total_pay'];


      if ($this->input->post('bebas_pay_bill') > $sisa OR $this->input->post('bebas_pay_bill') == 0) {
        $this->session->set_flashdata('failed',' Pembayaran yang anda masukkan melebihi total tagihan!!!');
        redirect('manage/payout?n='.$student['period_period_id'].'&r='.$student['student_nis']);
      } else {

        $idd = $this->Bebas_pay_model->add($param);

        $this->Bebas_model->add(array('increase_budget' => $this->input->post('bebas_pay_bill'), 'bebas_id' =>  $this->input->post('bebas_id'), 'bebas_last_update'=>date('Y-m-d H:i:s'))); 
        
        $log = array(
          'bulan_bulan_id' => NULL,
          'bebas_pay_bebas_pay_id' => $idd,
          'student_student_id' => $this->input->post('student_student_id'),
          'log_trx_input_date' =>  date('Y-m-d H:i:s'),
          'log_trx_last_update' => date('Y-m-d H:i:s'),
        );
        $this->Log_trx_model->add($log);
      }

      // --- KODE SMS BAWAAN ---
      if ($activated['setting_value'] == 'Y') {
        $userkey = $user['setting_value']; 
        $passkey = $password['setting_value']; 
        $telepon = $student['student_parent_phone'];
        $message = "Pembayaran ".$student['pos_name'].' - T.A '.$student['period_start'].'/'.$student['period_end'].'-'.$this->input->post('bebas_pay_desc').' a/n '.$student['student_full_name'].' Berhasil';
        $url = "https://reguler.zenziva.net/apps/smsapi.php";
        $curlHandle = curl_init();
        curl_setopt($curlHandle, CURLOPT_URL, $url);
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, 'userkey='.$userkey.'&passkey='.$passkey.'&nohp='.$telepon.'&pesan='.urlencode($message));
        curl_setopt($curlHandle, CURLOPT_HEADER, 0);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curlHandle, CURLOPT_TIMEOUT,30);
        curl_setopt($curlHandle, CURLOPT_POST, 1);
        $results = curl_exec($curlHandle);
        curl_close($curlHandle);
      }

      // --- MULAI KODE WA OTOMATIS WABLAS (INTEGRASI BARU METODE GET) ---
      // 1. Ambil data Langsung dari Database ($student)
      $wa_phone = $student['student_parent_phone']; 
      $wa_nama_siswa = $student['student_full_name'];
      
      // Ambil data pembayaran dari input
      $wa_jumlah = $this->input->post('bebas_pay_bill');
      $wa_desc = $this->input->post('bebas_pay_desc');
      
      // Waktu Transaksi
      $wa_tanggal = date('d-m-Y');
      $wa_jam = date('H:i:s');

      // 2. Cek apakah nomor HP tersedia
      if (!empty($wa_phone)) {
          // Format Nomor HP (Ubah 08... menjadi 628...)
          if (substr($wa_phone, 0, 1) == '0') {
              $wa_phone = '62' . substr($wa_phone, 1);
          }
          // Pastikan hanya angka
          $wa_phone = preg_replace('/[^0-9]/', '', $wa_phone);

          // Susun Pesan (Format Baru)
          $message_wa  = "*SMK PASUNDAN 3 BANDUNG*\n\n";
          $message_wa .= "Assalamualikum bapak/ibu orang tua siswa\n";
          $message_wa .= "kami informasikan bahwwa pembayaran sekolah telah di terima\n\n";
          $message_wa .= "Nama Siswa : *" . $wa_nama_siswa . "*\n";
          $message_wa .= "Nominal : *Rp. " . number_format($wa_jumlah, 0, ',', '.') . "*\n";
          $message_wa .= "Metode : " . $wa_desc . "\n";
          $message_wa .= "Tanggal : " . $wa_tanggal . "\n";
          $message_wa .= "Waktu: " . $wa_jam . "\n\n";
          $message_wa .= "*Terimakasih semoga rezeki bapak ibu tergantikan berkali kali lipat*\n\n";
          $message_wa .= "untuk memudahkan informasi mengenai kegiatan sekolah\n";
          $message_wa .= "bapak ibu dapat membuka website official kami di\n";
          $message_wa .= "*https://smkpasundan3bdg.sch.id*\n\n\n";
          $message_wa .= "salam hormat\n";
          $message_wa .= "Tata Usaha SMK Pasundan 3 bandung";

          // Konfigurasi API Wablas & Secret Key
          $token_wa = "3IQkgooGa9QUHEkOuhStLtbeddBxyloKrbrEGYVrZOKZcNbRuV6acbC";
          $secret_key_wa = "NdOuivxB"; 
          $domain_api_wa = "https://jogja.wablas.com"; 

          // Bangun URL Query String
          // Format: /api/send-message?token=TOKEN.SECRET&phone=PH&message=MSG
          $fullApiUrl = $domain_api_wa . "/api/send-message?token=" . urlencode($token_wa . '.' . $secret_key_wa) . "&phone=" . urlencode($wa_phone) . "&message=" . urlencode($message_wa);

          // Inisialisasi cURL dengan URL lengkap
          $curl_wa = curl_init($fullApiUrl); 
          curl_setopt($curl_wa, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($curl_wa, CURLOPT_TIMEOUT, 10);
          curl_setopt($curl_wa, CURLOPT_SSL_VERIFYHOST, 0); 
          curl_setopt($curl_wa, CURLOPT_SSL_VERIFYPEER, 0);

          $result_wa = curl_exec($curl_wa);
          $error_wa = curl_error($curl_wa);
          curl_close($curl_wa);

          // Opsional: Logging
          if ($error_wa) {
             log_message('error', 'Wablas Error: ' . $error_wa);
          }
      }
      // --- SELESAI KODE WA OTOMATIS ---

      $this->session->set_flashdata('success',' Pembayaran Tagihan berhasil');
      redirect('manage/payout?n='.$student['period_period_id'].'&r='.$student['student_nis']);

    } else {
      // Load view if not POST
      $data['class'] = $this->Student_model->get_class();
      $data['payment'] = $this->Payment_model->get(array('id' => $id));
      $data['bebas'] = $this->Bebas_model->get(array('payment_id' => $id, 'student_id' => $student_id));
      $data['student'] = $this->Student_model->get(array('id'=> $student_id));
      $data['bill'] = $this->Bebas_pay_model->get(array('bebas_id'=>$bebas_id, 'student_id'=>$student_id, 'payment_id'=>$id));

      $data['total'] = 0;
      foreach ($data['bebas'] as $key) {
        $data['total'] += $key['bebas_bill'];
      }

      $data['total_pay'] = 0;
      foreach ($data['bill'] as $row) {
        $data['total_pay'] += $row['bebas_pay_bill'];
      }

      $data['title'] = 'Tagihan Siswa';
      $this->load->view('payout/payout_add_bebas', $data);
    }
  }




  function pay($payment_id = NULL, $student_id =NULL, $id = NULL) { 

    $lastletter = $this->Letter_model->get(array('limit' => 1));
    $student = $this->Bulan_model->get(array('student_id'=>$student_id,'id'=>$id));
    $user = $this->Setting_model->get(array('id' => 8));
    $password = $this->Setting_model->get(array('id' => 9));
    $activated = $this->Setting_model->get(array('id' => 10));

    if ($lastletter['letter_year'] < date('Y') OR count($lastletter) == 0) {
      $this->Letter_model->add(array('letter_number' => '00001', 'letter_month' => date('m'), 'letter_year' => date('Y')));
      $nomor = sprintf('%05d', '00001');
      $nofull = date('Y'). date('m'). $nomor;
    } else {
      $nomor = sprintf('%05d', $lastletter['letter_number'] + 00001);
      $this->Letter_model->add(array('letter_number' => $nomor, 'letter_month' => date('m'), 'letter_year' => date('Y')));
      $nofull = date('Y'). date('m'). $nomor;
    }


    $pay = array(
      'bulan_id' => $id,
      'bulan_number_pay' => $nofull,
      'bulan_date_pay' => date('Y-m-d H:i:s'),
      'bulan_last_update' => date('Y-m-d H:i:s'),
      'bulan_status' => 1,
      'user_user_id' => $this->session->userdata('uid')
    );

    $log = array(
      'bulan_bulan_id' => $id,
      'student_student_id' => $student_id,
      'bebas_pay_bebas_pay_id' => NULL,
      'log_trx_input_date' =>  date('Y-m-d H:i:s'),
      'log_trx_last_update' => date('Y-m-d H:i:s'),
    );


    $status = $this->Bulan_model->add($pay);

    $this->Log_trx_model->add($log);

    if ($activated['setting_value'] == 'Y') {

      $userkey = $user['setting_value']; 
      $passkey = $password['setting_value']; 
      $telepon = $student['student_parent_phone'];

      $namePay = $student['pos_name'].' - T.A '.$student['period_start'].'/'.$student['period_end'];
      $mont = ($student['month_month_id']<=6) ? $student['period_start'] : $student['period_end'];

      $message = "Pembayaran ".$namePay.' - ('.$student['month_name'].' '. $mont.') a/n '.$student['student_full_name'].' Berhasil';

      $url = "https://reguler.zenziva.net/apps/smsapi.php";
      $curlHandle = curl_init();
      curl_setopt($curlHandle, CURLOPT_URL, $url);
      curl_setopt($curlHandle, CURLOPT_POSTFIELDS, 'userkey='.$userkey.'&passkey='.$passkey.'&nohp='.$telepon.'&pesan='.urlencode($message));
      curl_setopt($curlHandle, CURLOPT_HEADER, 0);
      curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST, 2);
      curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt($curlHandle, CURLOPT_TIMEOUT,30);
      curl_setopt($curlHandle, CURLOPT_POST, 1);
      $results = curl_exec($curlHandle);
      curl_close($curlHandle);
    }


    if ($this->input->is_ajax_request()) {
      echo $status;
    } else {
      $this->session->set_flashdata('success', 'Pembayaran Berhasil');
      redirect('manage/payout?n='.$student['period_period_id'].'&r='.$student['student_nis']);
    }
  }

  function not_pay($payment_id = NULL, $student_id =NULL, $id = NULL) { 
    $student = $this->Bulan_model->get(array('student_id'=>$student_id,'id'=>$id));
    $pay = array(
      'bulan_id' => $id,
      'bulan_number_pay' => NULL,
      'bulan_status' => 0,
      'bulan_date_pay' => NULL,
      'bulan_last_update' => date('Y-m-d H:i:s'),
      'user_user_id' => NULL
    );

    
    $this->Log_trx_model->delete_log(array(
      'student_id' => $student_id,
      'bulan_id' => $id
    ));



    $this->Bulan_model->add($pay);
    if ($this->input->is_ajax_request()) {
      echo $status;
    } else {
      $this->session->set_flashdata('success', 'Hapus Pembayaran Berhasil');
      redirect('manage/payout?n='.$student['period_period_id'].'&r='.$student['student_nis']);
    }
  }

  function printPay($payment_id = NULL, $student_id =NULL, $id = NULL) {
    $this->load->helper(array('dompdf'));
    $this->load->helper(array('tanggal'));

    if ($id == NULL)
      redirect('manage/payout/payout_bulan/'.$payment_id.'/'.$student_id);

    $data['printpay'] = $this->Bulan_model->get(array('id' =>$id));

    $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME));
    $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS));
    $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE)); 
    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT));
    $data['setting_city'] = $this->Setting_model->get(array('id' => SCHOOL_CITY)); 

    $html = $this->load->view('payout/payout_pdf', $data, true);
    $data = pdf_create($html, $data['printpay']['student_full_name'], TRUE, 'A4', TRUE);
  }

  function printPayFree($payment_id = NULL, $student_id =NULL, $id = NULL) {
    $this->load->helper(array('dompdf'));
    $this->load->helper(array('tanggal'));

    if ($id == NULL)
      redirect('manage/payout/payout_bebas/'.$payment_id.'/'.$student_id);

    $data['printpay'] = $this->Bebas_pay_model->get(array('id' =>$id));

    $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME));
    $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS));
    $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE));
    $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT));
    $data['setting_city'] = $this->Setting_model->get(array('id' => SCHOOL_CITY));  
    $data['bebas'] = $this->Bebas_model->get(array('payment_id' => $payment_id, 'student_id' => $student_id));

    $data['total_bill'] = 0;
    foreach ($data['bebas'] as $key) {
      $data['total_bill'] += $key['bebas_total_pay'];
    }

    $data['bill'] = 0;
    foreach ($data['bebas'] as $key) {
      $data['bill'] += $key['bebas_bill'];
    }

    $html = $this->load->view('payout/payout_free_pdf', $data, true);
    $data = pdf_create($html, $data['printpay']['student_full_name'], TRUE, 'A4', TRUE);
  }

  function multiple() {
    $this->load->helper(array('dompdf'));
    $this->load->helper(array('tanggal'));
    $action = $this->input->post('action');
    $print = array();
    if ($action == "printAll") {
      $bln = $this->input->post('msg');
      for ($i = 0; $i < count($bln); $i++) {
        $print[] = $bln[$i];
      }

      $data['printpay'] = $this->Bulan_model->get(array('multiple_id' => $print, 'group'=>TRUE));
      $data['pay'] = $this->Bulan_model->get(array('multiple_id' => $print));

      $data['total_pay'] = 0;
      foreach ($data['pay'] as $row) {
        $data['total_pay'] += $row['bulan_bill'];
      }

      $data['setting_school'] = $this->Setting_model->get(array('id' => SCHOOL_NAME));
      $data['setting_address'] = $this->Setting_model->get(array('id' => SCHOOL_ADRESS));
      $data['setting_phone'] = $this->Setting_model->get(array('id' => SCHOOL_PHONE));
      $data['setting_district'] = $this->Setting_model->get(array('id' => SCHOOL_DISTRICT));
      $data['setting_city'] = $this->Setting_model->get(array('id' => SCHOOL_CITY)); 

      $html = $this->load->view('payout/payout_bulan_multiple_pdf', $data, true);
      $data = pdf_create($html, 'Tagihan_Pembayaran_'.date('d_m_Y'), TRUE, 'A4', TRUE);

    } 
    redirect('manage/payout');
  }

  function delete_pay_free($payment_id = NULL, $student_id =NULL, $bebas_id = NULL, $id =NULL) {

    $total_pay = $this->Bebas_pay_model->get(array('id'=>$id));

    $this->Bebas_model->add(
      array(
        'decrease_budget'=> $total_pay['bebas_pay_bill'],
        'bebas_id'=>$bebas_id
      )
    );

    $this->Log_trx_model->delete_log(array(
      'student_id' => $student_id,
      'bebas_pay_id' => $id
    ));

    $this->Bebas_pay_model->delete($id);

    if ($this->input->is_ajax_request()) {
      echo $status;
    } else {
      $this->session->set_flashdata('success', 'Delete Berhasil');
      redirect('manage/payout/payout_bebas/' . $payment_id.'/'.$student_id.'/'.$bebas_id);
    }
    
  }

// Delete to database
  public function delete($id = NULL) {
    if ($this->session->userdata('uroleid')!= SUPERUSER){
      redirect('manage');
    }
    if ($_POST) {
      $this->Payment_model->delete($id);
// activity log
      $this->load->model('logs/Logs_model');
      $this->Logs_model->add(
        array(
          'log_date' => date('Y-m-d H:i:s'),
          'user_id' => $this->session->userdata('uid'),
          'log_module' => 'Jenis Pembayaran',
          'log_action' => 'Hapus',
          'log_info' => 'ID:' . $id . ';Title:' . $this->input->post('delName')
        )
      );
      $this->session->set_flashdata('success', 'Hapus Jenis Pembayran berhasil');
      redirect('manage/payment');
    } elseif (!$_POST) {
      $this->session->set_flashdata('delete', 'Delete');
      redirect('manage/payment/edit/' . $id);
    }
  }


}