<?php
session_start();
include '../config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pengurus') {
    header("Location: ../index.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$query = $conn->prepare("SELECT * FROM users WHERE id = ?");
$query->bind_param("i", $user_id);
$query->execute();
$result = $query->get_result();
$user = $result->fetch_assoc();
$nama_lengkap = $user['nama_lengkap'];
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'];
    $no_wa = $_POST['no_wa'];
    $foto_name = $user['foto'];

    // Handle upload foto
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $new_name = uniqid('foto_', true) . '.' . $ext;
        $upload_path = '../uploads/' . $new_name;

        if (move_uploaded_file($_FILES['foto']['tmp_name'], $upload_path)) {
            if (!empty($user['foto']) && file_exists('../uploads/' . $user['foto'])) {
                unlink('../uploads/' . $user['foto']);
            }
            $foto_name = $new_name;
        }
    }

    // Update ke database
    if (!empty($password)) {
        $stmt = $conn->prepare("UPDATE users SET password = ?, no_wa = ?, foto = ? WHERE id = ?");
        $stmt->bind_param("sssi", $password, $no_wa, $foto_name, $user_id);
    } else {
        $stmt = $conn->prepare("UPDATE users SET no_wa = ?, foto = ? WHERE id = ?");
        $stmt->bind_param("ssi", $no_wa, $foto_name, $user_id);
    }

 if ($stmt->execute()) {
    $success = true;
} else {
    $error = "Gagal memperbarui profil.";
}
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ubah Profil - Digikop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
   
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Konten -->
<div class="container py-5 main-content">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card p-4">
                <h4 class="text-center mb-4">Ubah Profil</h4>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?= $error; ?></div>
                <?php endif; ?>

                <form method="POST" enctype="multipart/form-data">
                    <!-- Nama Lengkap -->
                    <div class="mb-3">
                        <label class="form-label">Nama Lengkap</label>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($user['nama_lengkap']); ?>" disabled>
                        <div class="form-text text-danger">Untuk mengubah nama, silakan hubungi pengurus.</div>
                    </div>

                    <!-- Nomor WhatsApp -->
                    <div class="mb-3">
                        <label class="form-label">Nomor WhatsApp</label>
                        <input type="text" name="no_wa" class="form-control" value="<?= htmlspecialchars($user['no_wa'] ?? ''); ?>" required>
                    </div>

                    <!-- Foto Profil -->
                    <div class="mb-3 text-center">
                        <label class="form-label d-block">Foto Profil</label>
                        <div class="preview-wrapper mb-2">
                            <img id="preview" src="../uploads/<?= htmlspecialchars($user['foto']); ?>" alt="Foto Profil" class="profile-pic rounded-circle" width="120" height="120">
                        </div>
                        <input type="file" name="foto" class="form-control" accept="image/*" onchange="previewFoto(this)">
                    </div>

                    <!-- Password Baru -->
                    <div class="mb-3">
                        <label class="form-label">Password Baru</label>
                        <input type="text" name="password" class="form-control" placeholder="Kosongkan jika tidak diubah">
                    </div>

                    <!-- Tombol Aksi -->
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-dark">Simpan Perubahan</button>
                        <a href="index.php" class="btn btn-secondary">Kembali ke Beranda</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="dataanggota.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>Simpanan</span>
    </a>
    <a href="pinjaman.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>Pinjaman</span>
    </a>
    <a href="pengajuan.php" title="Pengajuan">
        <i class="fas fa-plus-circle"></i>
        <span>Pengajuan</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>
<!-- Script Preview Foto -->
<script>
function previewFoto(input) {
    const preview = document.getElementById('preview');
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php if (isset($success) && $success): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: 'Profil berhasil diperbarui!',
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: true
        }).then(() => {
            window.location.href = 'index.php';
        });
    });
</script>
<?php endif; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
