<?php
session_start();
include '../config.php';

// Cek apakah user login dan rolenya pengurus
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pengurus') {
    header("Location: ../login.php");
    exit;
}

// Ambil nama pengurus dari session
$nama_pengurus = $_SESSION['nama_lengkap'] ?? 'Nama Pengurus';

// Ambil ID dari URL
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Ambil data pengajuan + nama anggota
$query = "SELECT p.*, u.nama_lengkap 
          FROM pengajuan p 
          JOIN users u ON p.user_id = u.id 
          WHERE p.id = $id 
          LIMIT 1";
$result = $conn->query($query);
$data = $result->fetch_assoc();

if (!$data) {
    echo "Data tidak ditemukan.";
    exit;
}

// Ambil settingan perusahaan
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();
$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Surat Perjanjian Pinjaman</title>
    <style>
        @page {
            size: A4;
            margin: 2cm;
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            width: 210mm;
            height: 297mm;
            box-sizing: border-box;
            line-height: 1.6;
        }
.logo {
    text-align: center;
    margin-bottom: 20px;
}
        .header {
            text-align: center;
            padding: 5px 0;
            border-bottom: 2px solid #000;
        }

        .header img {
            height: 80px;
        }

        .header h1 {
            margin: 5px 0 0;
            font-size: 18px;
        }

        .header p {
            margin: 2px 0;
            font-size: 12px;
        }

        .footer {
            text-align: center;
            font-size: 11px;
            position: fixed;
            bottom: 0;
            width: 100%;
            border-top: 1px solid #000;
            padding-top: 5px;
        }

        .container {
            width: 90%;
            margin: 50px auto 100px auto;
        }

        h2 {
            text-align: center;
            margin-top: 20px;
        }

        ol {
            margin-left: 20px;
        }

        table {
            width: 100%;
            margin-top: 40px;
        }

        td {
            vertical-align: top;
        }

        .btn-print {
            display: block;
            margin: 30px auto;
            padding: 10px 20px;
            font-size: 16px;
        }

        @media print {
            .btn-print {
                display: none;
            }

            .footer {
                position: fixed;
                bottom: 0;
            }
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="header">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan) ?>" alt="Logo Perusahaan">
    <h1><?= htmlspecialchars($nama_perusahaan) ?></h1>
    <p>Alamat Perusahaan | Telepon: 0812-3456-7890 | Email: info@perusahaan.com</p>
</div>

<!-- Isi Surat -->
<div class="container">
    <h2>Surat Perjanjian Kerja Sama Pinjaman</h2>

    <p>Yang bertanda tangan di bawah ini:</p>
    <table style="margin-top: 20px; margin-bottom: 20px;">
    <tr>
        <td style="width: 180px;">Nama Anggota</td>
        <td style="width: 10px;">:</td>
        <td><?= htmlspecialchars($data['nama_lengkap']) ?></td>
    </tr>
    <tr>
        <td>Jumlah Pinjaman</td>
        <td>:</td>
        <td>Rp.<?= number_format($data['jumlah_pinjaman'], 0, ',', '.') ?></td>
    </tr>
    <tr>
        <td>Tenor</td>
        <td>:</td>
        <td><?= (int)$data['tenor'] ?> bulan</td>
    </tr>
    <tr>
        <td>Biaya Perbulan</td>
        <td>:</td>
        <td>Rp.<?= number_format($data['biaya_perbulan'], 0, ',', '.') ?></td>
    </tr>
</table>

    <p>Dengan ini sepakat mengadakan perjanjian kerja sama pinjaman dengan ketentuan sebagai berikut:</p>
    <ol>
        <li>Peminjam setuju mengembalikan pinjaman sesuai tenor yang disepakati.</li>
        <li>Angsuran bulanan wajib dibayarkan tepat waktu.</li>
        <li>Keterlambatan pembayaran dikenakan sanksi sesuai ketentuan koperasi.</li>
        <li>Perjanjian berlaku sejak ditandatangani hingga pinjaman lunas.</li>
    </ol>

    <p>Demikian perjanjian ini dibuat untuk dipatuhi oleh kedua belah pihak.</p>

  <?php
    // Format tanggal Indonesia
    setlocale(LC_TIME, 'id_ID.UTF-8');
    $tanggalHariIni = strftime('%d %B %Y');
?>

<p style="text-align: right; margin-top: 40px;">
    Bandung, <?= $tanggalHariIni ?>
</p>

<table style="margin-top: 20px;">
    <tr>
        <td align="center">
            <strong>Pihak Koperasi</strong><br><br><br><br>
            (<?= htmlspecialchars($nama_pengurus) ?>)
        </td>
        <td align="center">
            <strong>Peminjam</strong><br><br><br><br>
            (<?= htmlspecialchars($data['nama_lengkap']) ?>)
        </td>
    </tr>
</table>

    <button class="btn-print" onclick="window.print()">🖨️ Cetak</button>
</div>

<!-- Footer -->
<div class="footer">
    <?= htmlspecialchars($nama_perusahaan) ?> &copy; <?= date('Y') ?> - Semua Hak Dilindungi
</div>

</body>
</html>
