<?php
session_start();
include '../config.php';

// Cek hak akses
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'pengurus') {
    header("Location: ../index.php");
    exit;
}

// Ambil informasi pengguna dan perusahaan
$nama_lengkap = $_SESSION['nama_lengkap'] ?? 'Pengurus';
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';

// Ambil data pinjaman
$query = $conn->query("
    SELECT u.nama_lengkap, p.id, p.jumlah_pinjaman, p.tanggal_pinjaman, p.jangka_waktu, p.sisa, 
           pg.tenor, pg.biaya_perbulan
    FROM pinjaman p
    JOIN pengajuan pg ON p.user_id = pg.user_id
    JOIN users u ON p.user_id = u.id
    ORDER BY p.tanggal_pinjaman DESC
");

// Tambah Pinjaman
if (isset($_POST['tambah_pinjaman'])) {
    $user_id   = $_POST['user_id'];
    $jumlah    = $_POST['jumlah_pinjaman'];
    $tanggal   = $_POST['tanggal_pinjaman'];
    $jangka    = $_POST['jangka_waktu'];
    $keterangan = $_POST['keterangan'];
    $sisa      = $jumlah;

    $stmt = $conn->prepare("INSERT INTO pinjaman (user_id, jumlah_pinjaman, tanggal_pinjaman, jangka_waktu, keterangan, sisa)
                            VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("iisssi", $user_id, $jumlah, $tanggal, $jangka, $keterangan, $sisa);
    $stmt->execute();
    $stmt->close();

    header("Location: pinjaman.php");
    exit;
}

// Edit Pinjaman
if (isset($_POST['edit_pinjaman'])) {
    $id        = $_POST['id'];
    $user_id   = $_POST['user_id'];
    $jumlah    = $_POST['jumlah_pinjaman'];
    $tanggal   = $_POST['tanggal_pinjaman'];
    $jangka    = $_POST['jangka_waktu'];
    $keterangan = $_POST['keterangan'];
    $sisa      = $jumlah;

    $stmt = $conn->prepare("UPDATE pinjaman 
                            SET user_id = ?, jumlah_pinjaman = ?, tanggal_pinjaman = ?, 
                                jangka_waktu = ?, keterangan = ?, sisa = ?
                            WHERE id = ?");
    $stmt->bind_param("iisssii", $user_id, $jumlah, $tanggal, $jangka, $keterangan, $sisa, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: pinjaman.php");
    exit;
}

// Bayar Tagihan
if (isset($_POST['bayar'])) {
    $pinjaman_id = $_POST['pinjaman_id'];
    $jumlah_bayar = $_POST['jumlah_bayar'];
    $tanggal_bayar = $_POST['tanggal_bayar'];

    $stmt1 = $conn->prepare("INSERT INTO pembayaran (pinjaman_id, jumlah_bayar, tanggal_bayar) 
                             VALUES (?, ?, ?)");
    $stmt1->bind_param("iis", $pinjaman_id, $jumlah_bayar, $tanggal_bayar);
    $stmt1->execute();
    $stmt1->close();

    $stmt2 = $conn->prepare("UPDATE pinjaman 
                             SET sisa = sisa - ? 
                             WHERE id = ?");
    $stmt2->bind_param("ii", $jumlah_bayar, $pinjaman_id);
    $stmt2->execute();
    $stmt2->close();

    header("Location: pinjaman.php");
    exit;
}

// Hapus Pinjaman
if (isset($_POST['hapus_pinjaman'])) {
    $id = $_POST['id'];

    $stmt1 = $conn->prepare("DELETE FROM pembayaran WHERE pinjaman_id = ?");
    $stmt1->bind_param("i", $id);
    $stmt1->execute();
    $stmt1->close();

    $stmt2 = $conn->prepare("DELETE FROM pinjaman WHERE id = ?");
    $stmt2->bind_param("i", $id);
    $stmt2->execute();
    $stmt2->close();

    header("Location: pinjaman.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
<link rel="stylesheet" href="../style.css">
</head>
<body>
<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

  <!-- Filter dan Pencarian -->
  <div class="container">
    <div class="card">
    </div>

<div class="container mt-4">
  <div class="card p-3">
    <div class="row g-3 align-items-center justify-content-between">
      
      <!-- Tombol Tambah Pinjaman -->
      <div class="col-md-3 d-grid">
        <button class="btn btn-dark rounded-3 shadow-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
          <i class="fas fa-plus me-1"></i> Tambah Pinjaman
        </button>
      </div>

      <!-- Kolom Pencarian -->
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white border-end-0">
            <i class="fas fa-search text-muted"></i>
          </span>
          <input type="text" id="searchInput" class="form-control border-start-0" placeholder="Cari nama..." aria-label="Cari nama">
        </div>
      </div>

      <!-- Kolom Filter Status -->
      <div class="col-md-4">
        <select id="statusFilter" class="form-select">
          <option value="">Semua</option>
          <option value="Lunas">Lunas</option>
          <option value="Belum Lunas">Belum Lunas</option>
        </select>
      </div>
    </div>

    <!-- Keterangan Ikon -->
    <div class="mt-4 d-flex flex-wrap align-items-center" style="font-size: 0.85rem; color: #555;">
      <div class="d-flex align-items-center me-4 mb-2">
        <i class="fas fa-info-circle text-info me-1"></i> <span>Detail</span>
      </div>
      <div class="d-flex align-items-center me-4 mb-2">
        <i class="fas fa-edit text-warning me-1"></i> <span>Edit</span>
      </div>
      <div class="d-flex align-items-center me-4 mb-2">
        <i class="fas fa-hand-holding-usd text-success me-1"></i> <span>Bayar</span>
      </div>
      <div class="d-flex align-items-center me-4 mb-2">
        <i class="fas fa-trash-alt text-danger me-1"></i> <span>Hapus</span>
      </div>
    </div>
  </div>
</div>



  <div id="tableWrapper" class="table-responsive">
  <table id="tabelData" class="table table-bordered table-custom">
    <thead>
      <tr>
        <th>Nama</th>
        <th>Sisa Tagihan</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $q = mysqli_query($conn, "SELECT p.*, u.nama_lengkap FROM pinjaman p JOIN users u ON p.user_id = u.id");
      while ($data = mysqli_fetch_assoc($q)) {
        $id = $data['id'];
        $dibayar = mysqli_fetch_assoc(mysqli_query($conn, "SELECT SUM(jumlah_bayar) as total FROM pembayaran WHERE pinjaman_id = '$id'"))['total'];
        $dibayar = $dibayar ?: 0;
        $sisa = $data['jumlah_pinjaman'] - $dibayar;
        $status = $sisa <= 0 ? "Lunas" : "Belum Lunas";

        echo "<tr class='data-row' data-nama='{$data['nama_lengkap']}'>
          <td>{$data['nama_lengkap']}</td>
          <td class='sisa-tagihan'>" . number_format($sisa, 0, ',', '.') . "</td>
          <td>
            <button class='btn btn-sm btn-info' data-bs-toggle='modal' data-bs-target='#modalDetail'
              onclick='showDetailModal(" . json_encode([
                'nama' => $data['nama_lengkap'],
                'jumlah_pinjaman' => $data['jumlah_pinjaman'],
                'tanggal_pinjaman' => $data['tanggal_pinjaman'],
                'jangka_waktu' => $data['jangka_waktu'],
                'sisa' => $sisa,
                'status' => $status
              ]) . ")'>
              <i class='fas fa-info-circle'></i>
            </button>

            <button class='btn btn-sm btn-warning' onclick='showEdit(" . json_encode($data) . ")' data-bs-toggle='modal' data-bs-target='#modalEdit'><i class='fas fa-edit'></i></button>

            <button class='btn btn-sm btn-success' onclick='showBayar($id, {$data['angsuran']})' data-bs-toggle='modal' data-bs-target='#modalBayar'><i class='fas fa-hand-holding-usd'></i></button>

            <button class='btn btn-sm btn-danger' data-bs-toggle='modal' data-bs-target='#modalHapus$id'>
              <i class='fas fa-trash-alt'></i>
            </button>
          </td>
        </tr>";

        // Modal Hapus
        echo "
        <div class='modal fade' id='modalHapus$id' tabindex='-1' aria-labelledby='modalHapusLabel$id' aria-hidden='true'>
          <div class='modal-dialog'>
            <div class='modal-content'>
              <div class='modal-header'>
                <img src='../uploads/" . htmlspecialchars($logo_perusahaan) . "' alt='Logo' class='modal-logo me-2' style='width: 40px; height: 40px;'>
                <h5 class='modal-title' id='modalHapusLabel$id'>" . htmlspecialchars($nama_perusahaan) . "</h5>
                <button type='button' class='btn-close' data-bs-dismiss='modal' aria-label='Close'></button>
              </div>
              <div class='modal-body'>
                <p>Apakah Anda yakin ingin menghapus data pinjaman <strong>{$data['nama_lengkap']}</strong>?</p>
              </div>
              <div class='modal-footer'>
                <form method='post'>
                  <input type='hidden' name='id' value='$id'>
                  <button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Batal</button>
                  <button type='submit' name='hapus_pinjaman' class='btn btn-danger'>Hapus</button>
                </form>
              </div>
            </div>
          </div>
        </div>
        ";
      }
      ?>
    </tbody>
  </table>
</div>

 
</div><!-- Bottom Navigation -->

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="dataanggota.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>Simpanan</span>
    </a>
    <a href="pinjaman.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>Pinjaman</span>
    </a>
    <a href="pengajuan.php" title="Pengajuan">
        <i class="fas fa-plus-circle"></i>
        <span>Pengajuan</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>
<?php include 'modal.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
  const searchInput = document.getElementById('searchInput');
  const statusFilter = document.getElementById('statusFilter');

  function filterTable() {
    const rows = document.querySelectorAll('.data-row');
    const search = searchInput.value.trim().toLowerCase();
    const status = statusFilter.value;

    rows.forEach(row => {
      const nama = row.getAttribute('data-nama').toLowerCase();
      const sisaCell = row.querySelector('.sisa-tagihan');

      let sisaText = sisaCell ? sisaCell.textContent : '';
      sisaText = sisaText.replace(/[^\d-]/g, ''); // Hilangkan Rp, titik, dll
      const sisa = parseFloat(sisaText) || 0;

      const currentStatus = sisa <= 0 ? 'Lunas' : 'Belum Lunas';

      const matchNama = nama.includes(search);
      const matchStatus = status === '' || status === currentStatus;

      row.style.display = (matchNama && matchStatus) ? '' : 'none';
    });
  }

  // Event listeners
  searchInput.addEventListener('input', filterTable);
  statusFilter.addEventListener('change', filterTable);

  // Jalankan saat halaman dimuat
  document.addEventListener('DOMContentLoaded', filterTable);
</script>


<script>
  document.addEventListener("DOMContentLoaded", function () {
    const inputs = document.querySelectorAll(".jumlah-format");

    inputs.forEach(input => {
      input.addEventListener("input", function () {
        const id = this.dataset.id;
        const rawValue = this.value.replace(/\./g, "").replace(/[^\d]/g, "");
        if (rawValue) {
          const formatted = rawValue.replace(/\B(?=(\d{3})+(?!\d))/g, ".");
          this.value = formatted;
          document.getElementById("jumlah_simpanan" + id).value = rawValue;
        } else {
          document.getElementById("jumlah_simpanan" + id).value = "";
        }
      });
    });
  });
</script>



</body>
</html>
