<?php
session_start();
include '../config.php';

// Cek apakah user login dan rolenya pengurus
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pengurus') {
    header("Location: ../login.php");
    exit;
}

$notif = null;
$nama_lengkap = $_SESSION['nama_lengkap'] ?? 'Pengurus';

// Ambil nama dan logo perusahaan
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';

// Jika pengurus menyetujui/menolak pengajuan
if (isset($_GET['aksi']) && isset($_GET['id'])) {
    $aksi = $_GET['aksi'];
    $id = (int) $_GET['id'];

    if (in_array($aksi, ['diterima', 'ditolak'])) {
        // Ambil data pengajuan dan user
        $stmt = $conn->prepare("SELECT p.user_id, p.jumlah_pinjaman, p.tenor, u.nama_lengkap, u.no_wa 
                                FROM pengajuan p
                                JOIN users u ON p.user_id = u.id
                                WHERE p.id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = $result->fetch_assoc();
        $stmt->close();

        if ($data) {
            $user_id = $data['user_id'];
            $jumlah_pinjaman = $data['jumlah_pinjaman'];
            $jangka_waktu = $data['tenor'];
            $nama_anggota = $data['nama_lengkap'];
            $no_wa = $data['no_wa'];

            // Update status pengajuan
            $stmt = $conn->prepare("UPDATE pengajuan SET keterangan = ? WHERE id = ?");
            $stmt->bind_param("si", $aksi, $id);
            $stmt->execute();
            $stmt->close();

            // Jika diterima, simpan ke tabel pinjaman
            if ($aksi === 'diterima') {
                $tanggal_pinjaman = date('Y-m-d');
                $keterangan = 'belum lunas';
                $sisa = $jumlah_pinjaman;

                $stmt = $conn->prepare("INSERT INTO pinjaman (user_id, jumlah_pinjaman, tanggal_pinjaman, jangka_waktu, keterangan, sisa) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("idssis", $user_id, $jumlah_pinjaman, $tanggal_pinjaman, $jangka_waktu, $keterangan, $sisa);
                $stmt->execute();
                $stmt->close();

                $pesan_wa = "*Pengajuan Pinjaman Diterima*\n"
                          . "Halo $nama_anggota,\n"
                          . "Pengajuan pinjaman kamu sebesar Rp " . number_format($jumlah_pinjaman, 0, ',', '.') . " telah *DITERIMA*.\n"
                          . "Tenor: $jangka_waktu bulan.\n"
                          . "Silakan hubungi pengurus untuk proses selanjut nya .";
            } else {
                $pesan_wa = "*Pengajuan Pinjaman Ditolak*\n"
                          . "Halo $nama_anggota,\n"
                          . "Mohon maaf, pengajuan pinjaman kamu sebesar Rp " . number_format($jumlah_pinjaman, 0, ',', '.') . " saat ini  *DITOLAK*.\n"
                          . "Tapi jangan kwatir kamu masih bisa mengajukan pinjaman kembali di lain waktu .";
            }

            // Kirim WhatsApp ke anggota
            $token = 'gZkv3WhY8RzXRTfcckpVF7Hhe79FOyBA2xSrZjObb2RFzdBlw27k9Pj'; // ganti dengan token Anda
            $secret_key = 'bOZSWx7J'; // ganti dengan secret key Anda
            $url = "https://jogja.wablas.com/api/send-message?token=$token.$secret_key&phone=$no_wa&message=" . urlencode($pesan_wa);

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($curl);
            curl_close($curl);
        }

        header("Location: pengajuan.php");
        exit;
    }
}

// Jika pengurus menghapus pengajuan
if (isset($_GET['hapus']) && is_numeric($_GET['hapus'])) {
    $id = (int) $_GET['hapus'];
    $stmt = $conn->prepare("DELETE FROM pengajuan WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    $notif = "Pengajuan berhasil dihapus.";
    header("Location: pengajuan.php");
    exit;
}

// Ambil semua pengajuan
$query = "SELECT p.*, u.nama_lengkap FROM pengajuan p 
          JOIN users u ON p.user_id = u.id 
          ORDER BY p.created_at DESC";
$result = $conn->query($query);
?>


<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>


<!-- Modal Konfirmasi Hapus -->
<div class="modal fade" id="modalHapus" tabindex="-1" aria-labelledby="modalHapusLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../logosmapasundan1.png" alt="Logo" style="width: 40px; height: 40px;" class="me-2">
        <h5 class="modal-title" id="modalHapusLabel">Konfirmasi Hapus</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        Apakah Anda yakin ingin menghapus pengajuan ini?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a id="btnConfirmDelete" href="#" class="btn btn-danger">Hapus</a>
      </div>
    </div>
  </div>
</div>

<!-- Filter dan Pencarian -->
  <div class="container">
    <div class="card">
    </div>
  </div>
<body class="bg-light">
<div class="container mt-5">
    <h3 class="mb-4">Daftar Pengajuan pinjaman</h3>
    
    
    <!-- Keterangan Ikon -->
<div class="mt-3 d-flex flex-wrap align-items-center" style="font-size: 0.85rem; color: #555;">
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-check-circle" style="color: green;"></i> <span class="ms-1">Diterima</span>
    </div>
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-times-circle" style="color: orange;"></i> <span class="ms-1">Ditolak</span>
    </div>
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-trash" style="color: red;"></i> <span class="ms-1">Hapus pinjaman</span>
    </div>
</div>

<div class="mb-3 d-flex justify-content-between flex-wrap gap-2">
  <div class="input-group">
        <!-- Ikon Pencarian -->
        <span class="input-group-text bg-light text-muted border-end-0">
            <i class="fas fa-search"></i>
        </span>
        <input type="text" id="cariAnggota" class="form-control border-start-0" placeholder="Cari anggota berdasarkan nama...">
    </div>
<select id="filterStatus" class="form-select w-auto">
    <option value="">Semua Status</option>
    <option value="ditolak">Ditolak</option>
    <option value="diterima">Diterima</option>
    <option value="dalam proses">Dalam Proses</option>
</select>
</div>
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                    <th>Nama Anggota</th>
                    <th>Jumlah Pinjaman</th>
                    <th>Tenor</th>
                    <th>Biaya Perbulan</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                            <td>Rp<?= number_format($row['jumlah_pinjaman'], 0, ',', '.') ?></td>
                            <td><?= $row['tenor'] ?> bulan</td>
                            <td>Rp<?= number_format($row['biaya_perbulan'], 0, ',', '.') ?></td>
                            <td>
                                <span class="label-status status-<?= str_replace(' ', '-', strtolower($row['keterangan'])) ?>">
                                    <?= ucfirst($row['keterangan']) ?>
                                </span>
                            </td>
    <td>
    <div class="d-flex flex-column gap-1">
        <?php if ($row['keterangan'] === 'dalam proses'): ?>
            <a class="btn btn-sm btn-success" href="?aksi=diterima&id=<?= $row['id'] ?>">
                <i class="fas fa-check-circle me-1"></i>
            </a>
            <a class="btn btn-sm btn-danger" href="?aksi=ditolak&id=<?= $row['id'] ?>">
                <i class="fas fa-times-circle me-1"></i>
            </a>
        <?php endif; ?>

        <?php if ($row['keterangan'] === 'diterima'): ?>
            <a class="btn btn-sm btn-primary" href="print.php?id=<?= $row['id'] ?>" target="_blank">
                <i class="fas fa-print me-1"></i>
            </a>
        <?php endif; ?>

        <a class="btn btn-sm btn-outline-danger" href="javascript:void(0);" onclick="showDeleteModal(<?= $row['id'] ?>)">
            <i class="fas fa-trash-alt me-1"></i>
        </a>
    </div>
</td>
                           
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="6" class="text-center">Belum ada pengajuan</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="dataanggota.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>Simpanan</span>
    </a>
    <a href="pinjaman.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>Pinjaman</span>
    </a>
    <a href="pengajuan.php" title="Pengajuan">
        <i class="fas fa-plus-circle"></i>
        <span>Pengajuan</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('cariAnggota');
    const statusFilter = document.getElementById('filterStatus');
    const table = document.querySelector('table');
    const rows = document.querySelectorAll('table tbody tr');
    const pesanKosong = document.getElementById('pesanKosong');

    function filterTable() {
        const keyword = searchInput.value.toLowerCase().trim();
        const selectedStatus = statusFilter.value.toLowerCase().trim();

        let adaYangCocok = false;

        rows.forEach(row => {
            const nama = row.cells[0]?.textContent.toLowerCase();
            const status = row.cells[4]?.textContent.toLowerCase().trim();

            const matchNama = keyword === '' || nama.includes(keyword);
            const matchStatus = selectedStatus === '' || status === selectedStatus;

            if (matchNama && matchStatus) {
                row.style.display = '';
                adaYangCocok = true;
            } else {
                row.style.display = 'none';
            }
        });

        const rowKosong = document.getElementById('rowKosong');
        if (!adaYangCocok) {
            table.style.display = 'table';
            if (!rowKosong) {
                const tbody = document.querySelector('table tbody');
                const newRow = document.createElement('tr');
                newRow.id = 'rowKosong';
                const td = document.createElement('td');
                td.colSpan = rows[0].cells.length;
                td.className = 'text-center text-muted';
                td.textContent = 'Tidak ditemukan.';
                newRow.appendChild(td);
                tbody.appendChild(newRow);
            }
        } else {
            if (rowKosong) rowKosong.remove();
            table.style.display = 'table';
        }

        // Sembunyikan atau tampilkan pesan kosong
        if (keyword === '' && selectedStatus === '') {
            table.style.display = 'none';
            pesanKosong.style.display = 'block';
        } else {
            pesanKosong.style.display = 'none';
        }
    }

    // Event listener
    searchInput.addEventListener('keyup', filterTable);
    statusFilter.addEventListener('change', filterTable);

    // Awal: langsung sembunyikan tabel dan tampilkan pesan
    table.style.display = 'none';
    if (pesanKosong) {
        pesanKosong.style.display = 'block';
    }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function showDeleteModal(id) {
  document.getElementById('btnConfirmDelete').href = 'hapus.php?id=' + id;
  var myModal = new bootstrap.Modal(document.getElementById('modalHapus'));
  myModal.show();
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
