<!-- Modal Detail Pinjaman -->
<div class="modal fade" id="modalDetail" tabindex="-1" aria-labelledby="modalDetailLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="modalDetailLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <p class="fw-bold text-center">Detail Pinjaman</p>
        <table class="table table-sm">
          <tr><th>Nama</th><td id="d_nama"></td></tr>
          <tr><th>Jumlah Pinjaman</th><td id="d_jumlah"></td></tr>
          <tr><th>Tanggal Pinjaman</th><td id="d_tanggal"></td></tr>
          <tr><th>Jangka Waktu</th><td id="d_jangka"></td></tr>
          <tr><th>Sisa Tagihan</th><td id="d_sisa"></td></tr>
          <tr><th>Status</th><td id="d_status"></td></tr>
        </table>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
      </div>
    </div>
  </div>
</div>


<!-- Modal Tambah Pinjaman -->
<div class="modal fade" id="modalTambah" tabindex="-1" aria-labelledby="modalTambahLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="modalTambahLabel"><?= htmlspecialchars($nama_perusahaan); ?> - Tambah Pinjaman</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>

      <div class="modal-body">
        <div class="mb-2">
          <label for="user_id" class="form-label">Pilih Anggota</label>
          <select name="user_id" id="user_id" class="form-select" required>
            <option value="">-- Pilih Anggota --</option>
            <?php
            $anggota = mysqli_query($conn, "SELECT * FROM users WHERE role='anggota'");
            while ($u = mysqli_fetch_assoc($anggota)) {
              echo "<option value='{$u['id']}'>{$u['nama_lengkap']}</option>";
            }
            ?>
          </select>
        </div>

        <div class="mb-2">
          <label for="jumlah_pinjaman" class="form-label">Jumlah Pinjaman</label>
          <input type="number" name="jumlah_pinjaman" id="jumlah_pinjaman" class="form-control" placeholder="Masukkan jumlah pinjaman" required>
        </div>

        <div class="mb-2">
          <label for="tanggal_pinjaman" class="form-label">Tanggal Pinjaman</label>
          <input type="date" name="tanggal_pinjaman" id="tanggal_pinjaman" class="form-control" required>
        </div>

        <div class="mb-2">
          <label for="jangka_waktu" class="form-label">Jangka Waktu (bulan)</label>
          <input type="number" name="jangka_waktu" id="jangka_waktu" class="form-control" placeholder="Contoh: 12" required>
        </div>

        <div>
          <label for="keterangan" class="form-label">Keterangan</label>
          <textarea name="keterangan" id="keterangan" class="form-control" placeholder="Opsional..."></textarea>
        </div>
      </div>

      <div class="modal-footer">
        <button type="submit" name="tambah_pinjaman" class="btn btn-primary">Simpan</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>


<!-- Modal Edit Pinjaman -->
<div class="modal fade" id="modalEdit" tabindex="-1" aria-labelledby="modalEditLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" id="formEdit" class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="modalEditLabel"><?= htmlspecialchars($nama_perusahaan); ?> - Edit Pinjaman</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">

        <input type="hidden" name="id" id="edit_id">

        <div class="mb-3">
          <label for="edit_nama" class="form-label">Nama Anggota</label>
          <input type="text" class="form-control" id="edit_nama" disabled>
        </div>

        <div class="mb-3">
          <label for="edit_jumlah" class="form-label">Jumlah Pinjaman</label>
          <input type="number" class="form-control" name="jumlah_pinjaman" id="edit_jumlah" required>
        </div>

        <div class="mb-3">
          <label for="edit_tanggal" class="form-label">Tanggal Pinjaman</label>
          <input type="date" class="form-control" name="tanggal_pinjaman" id="edit_tanggal" required>
        </div>

        <div class="mb-3">
          <label for="edit_jangka" class="form-label">Jangka Waktu (bulan)</label>
          <input type="number" class="form-control" name="jangka_waktu" id="edit_jangka" required>
        </div>

      </div>
      <div class="modal-footer">
        <button type="submit" name="update_pinjaman" class="btn btn-primary">Simpan Perubahan</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>


<!-- Modal Bayar -->
<div class="modal fade" id="modalBayar" tabindex="-1" aria-labelledby="modalBayarLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="modalBayarLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <form method="post">
          <input type="hidden" name="pinjaman_id" id="bayar_id">
          
          <div class="mb-2">
            <label for="jumlah_bayar_format" class="form-label">Jumlah Bayar</label>
            <div class="input-group">
              <span class="input-group-text">Rp</span>
              <input type="text" id="jumlah_bayar_format" class="form-control" required>
            </div>
            <input type="hidden" name="jumlah_bayar" id="jumlah_bayar">
          </div>

          <div class="mb-2">
            <label for="tanggal_bayar" class="form-label">Tanggal Bayar</label>
            <input type="date" name="tanggal_bayar" id="tanggal_bayar" class="form-control" required>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="submit" name="bayar" class="btn btn-success">Bayar</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </div>
  </div>
</div>

<script>
  function showDetailModal(data) {
    document.getElementById("d_nama").innerText = data.nama;
    document.getElementById("d_jumlah").innerText = "Rp " + formatRupiah(data.jumlah_pinjaman);
    document.getElementById("d_tanggal").innerText = data.tanggal_pinjaman;
    document.getElementById("d_jangka").innerText = data.jangka_waktu + " bulan";
    document.getElementById("d_sisa").innerText = "Rp " + formatRupiah(data.sisa);
    document.getElementById("d_status").innerHTML = data.status === 'Lunas' 
      ? "<span class='text-success fw-bold'>Lunas</span>" 
      : "<span class='text-danger fw-bold'>Belum Lunas</span>";
  }

  function formatRupiah(angka) {
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
  }
</script>
<script>
  function showEdit(data) {
    document.getElementById('edit_id').value = data.id;
    document.getElementById('edit_nama').value = data.nama_lengkap;
    document.getElementById('edit_jumlah').value = data.jumlah_pinjaman;
    document.getElementById('edit_tanggal').value = data.tanggal_pinjaman;
    document.getElementById('edit_jangka').value = data.jangka_waktu;
  }
</script>