<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include '../config.php';

// Cek login dan role
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pengurus') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nama_lengkap = $_SESSION['nama_lengkap'] ?? 'Pengurus';
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';
$setting = $querySetting->fetch_assoc();

// Gunakan prepared statement untuk keamanan
$query = "
    SELECT 
        u.id,
        u.nama_lengkap,
        u.foto,
        u.no_wa,
        COALESCE(s.simpanan_wajib, 0) AS simpanan_wajib,
        COALESCE(s.simpanan_sukarela, 0) AS simpanan_sukarela,
        COALESCE(SUM(p.jumlah_pinjaman), 0) AS jumlah_pinjaman,
        COALESCE(SUM(p.sisa), 0) AS sisa_pinjaman
    FROM users u
    LEFT JOIN simpanan s ON u.id = s.user_id
    LEFT JOIN pinjaman p ON u.id = p.user_id
    WHERE u.id = ?
    GROUP BY u.id, u.nama_lengkap, u.foto, u.no_wa, s.simpanan_wajib, s.simpanan_sukarela
";// Ambil total anggota koperasi
$stmtAnggota = $conn->prepare("SELECT COUNT(*) AS total_anggota FROM users WHERE role = 'anggota'");
$stmtAnggota->execute();
$resultAnggota = $stmtAnggota->get_result()->fetch_assoc();
$total_anggota = $resultAnggota['total_anggota'];

// Ambil total simpanan wajib & sukarela
$stmtSimpanan = $conn->prepare("SELECT 
    COALESCE(SUM(simpanan_wajib), 0) AS total_wajib,
    COALESCE(SUM(simpanan_sukarela), 0) AS total_sukarela,
    COALESCE(SUM(simpanan_wajib + simpanan_sukarela), 0) AS total_saldo
FROM simpanan");
$stmtSimpanan->execute();
$resultSimpanan = $stmtSimpanan->get_result()->fetch_assoc();

$total_wajib = $resultSimpanan['total_wajib'];
$total_sukarela = $resultSimpanan['total_sukarela'];
$total_saldo = $resultSimpanan['total_saldo'];
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id); // i = integer
$stmt->execute();
$result = $stmt->get_result();

$data = $result->fetch_assoc();
?>


<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
   <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Konten Utama -->
<div class="container">
 <div class="container">
    <div class="welcome-section">
        <img src="../uploads/<?= htmlspecialchars($data['foto']); ?>" alt="Foto Profil">
       <h2>Selamat Datang, <?= htmlspecialchars($data['nama_lengkap']); ?>!</h2>
       <div class="card mt-4 shadow-sm">
    <div class="card-body">
        <h5 class="card-title">Informasi Koperasi</h5>
        <ul class="list-group list-group-flush">
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Total Anggota Koperasi
                <span class="badge bg-primary rounded-pill"><?= $total_anggota; ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Total Saldo Simpanan Anggota
                <span class="badge bg-success rounded-pill">Rp <?= number_format($total_saldo, 0, ',', '.'); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Total Simpanan Wajib
                <span class="badge bg-warning text-dark rounded-pill">Rp <?= number_format($total_wajib, 0, ',', '.'); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Total Simpanan Sukarela
                <span class="badge bg-info text-dark rounded-pill">Rp <?= number_format($total_sukarela, 0, ',', '.'); ?></span>
            </li>
        </ul>
    </div>
</div>
    </div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="dataanggota.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>Simpanan</span>
    </a>
    <a href="pinjaman.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>Pinjaman</span>
    </a>
    <a href="pengajuan.php" title="Pengajuan">
        <i class="fas fa-plus-circle"></i>
        <span>Pengajuan</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>

<script>
    if (window.performance && window.performance.getEntriesByType("navigation")[0]?.type === "back_forward") {
        window.location.reload(true);
    }
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
