<?php
session_start();
include '../config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] != 'pengurus') {
    header("Location: ../login.php");
    exit;
}

// Tambah saldo (wajib atau sukarela)
if (isset($_POST['tambah_saldo'])) {
    $user_id = $_POST['user_id'];
    $jenis = $_POST['jenis_simpanan'];
    $jumlah = $_POST['jumlah_simpanan'];

    // Cek apakah data simpanan sudah ada untuk user ini
    $cek = $conn->query("SELECT * FROM simpanan WHERE user_id = $user_id");

    if ($cek->num_rows > 0) {
        // Update sesuai jenis simpanan
        if ($jenis == 'wajib') {
            $conn->query("UPDATE simpanan SET simpanan_wajib = simpanan_wajib + $jumlah WHERE user_id = $user_id");
        } elseif ($jenis == 'sukarela') {
            $conn->query("UPDATE simpanan SET simpanan_sukarela = simpanan_sukarela + $jumlah WHERE user_id = $user_id");
        }
    } else {
        // Insert baru jika belum ada data
        if ($jenis == 'wajib') {
            $conn->query("INSERT INTO simpanan (user_id, simpanan_wajib, simpanan_sukarela) VALUES ($user_id, $jumlah, 0)");
        } elseif ($jenis == 'sukarela') {
            $conn->query("INSERT INTO simpanan (user_id, simpanan_wajib, simpanan_sukarela) VALUES ($user_id, 0, $jumlah)");
        }
    }

    // Redirect agar tidak terjadi pengulangan saat refresh
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Proses update simpanan dari modal Edit
if (isset($_POST['update'])) {
    $user_id = $_POST['user_id'];
    $simpanan_wajib = $_POST['simpanan_wajib'];
    $simpanan_sukarela = $_POST['simpanan_sukarela'];

    $conn->query("UPDATE simpanan SET simpanan_wajib = $simpanan_wajib, simpanan_sukarela = $simpanan_sukarela WHERE user_id = $user_id");

    // Redirect agar tidak terjadi pengulangan saat refresh
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Ambil data pengguna dan simpanan
$query = "SELECT 
            users.id, 
            users.nama_lengkap, 
            users.status_anggota,
            COALESCE(simpanan.simpanan_wajib, 0) AS simpanan_wajib, 
            COALESCE(simpanan.simpanan_sukarela, 0) AS simpanan_sukarela,
            COALESCE(SUM(pinjaman.jumlah_pinjaman), 0) AS jumlah_pinjaman,
            COALESCE(SUM(pinjaman.sisa), 0) AS sisa_pinjaman
          FROM users
          LEFT JOIN simpanan ON users.id = simpanan.user_id
          LEFT JOIN pinjaman ON users.id = pinjaman.user_id
          WHERE users.role = 'anggota'
          GROUP BY users.id";

$result = $conn->query($query);

// Informasi pengguna yang login
$nama_lengkap = $_SESSION['nama_lengkap'] ?? 'Pengurus';

// Ambil data pengaturan perusahaan
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';

?>




<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

  <!-- Filter dan Pencarian -->
  <div class="container">
    <div class="card">
    </div>
  </div>
<body class="bg-light">
<div class="container mt-5">
    <h3 class="mb-4">Daftar Anggota Koperasi</h3>

<a href="cetak_laporan.php" target="_blank" class="btn btn-success mb-3">
  <i class="fas fa-print me-1"></i> Cetak Semua Laporan
</a>
<div class="mt-3 d-flex flex-wrap align-items-center" style="font-size: 0.85rem; color: #555;">
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-eye text-info me-1"></i> <span>Detail Simpanan</span>
    </div>
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-plus-circle text-primary me-1"></i> <span>Tambah Saldo</span>
    </div>
    <div class="d-flex align-items-center me-4">
        <i class="fas fa-edit text-warning me-1"></i> <span>Edit Data</span>
    </div>
</div>

<div class="mb-3">
    <div class="input-group">
        <!-- Ikon Pencarian -->
        <span class="input-group-text bg-light text-muted border-end-0">
            <i class="fas fa-search"></i>
        </span>
        <input type="text" id="cariAnggota" class="form-control border-start-0" placeholder="Cari anggota berdasarkan nama...">
    </div>
</div>
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Nama Anggota</th>
                    <th>Aksi</th>
                </tr>
            </thead>
          <tbody>
<?php if ($result->num_rows > 0): 
    $no = 1;
    while ($row = $result->fetch_assoc()): ?>
    <tr>
        <td><?= $no++ ?></td>
        <td><?= htmlspecialchars($row['nama_lengkap']) ?></td>
        <td>
            <!-- Tombol Detail -->
            <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#detailModal<?= $row['id'] ?>" title="Detail Simpanan">
                <i class="fas fa-eye"></i>
            </button>

            <!-- Tombol Tambah Saldo -->
            <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#tambahSaldoModal<?= $row['id'] ?>" title="Tambah Saldo">
                <i class="fas fa-plus-circle"></i>
            </button>

            <!-- Tombol Edit -->
            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>" title="Edit">
                <i class="fas fa-edit"></i>
            </button>
        </td>
    </tr>
                  </div>
<div class="modal fade" id="detailModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="detailModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="detailModalLabel<?= $row['id'] ?>">
          <?= htmlspecialchars($nama_perusahaan); ?> 
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>

      <div class="modal-body">
        <p><strong>Nama:</strong> <?= htmlspecialchars($row['nama_lengkap']) ?></p>
        <p><strong>Simpanan Wajib:</strong> Rp <?= number_format($row['simpanan_wajib'], 0, ',', '.') ?></p>
        <p><strong>Simpanan Sukarela:</strong> Rp <?= number_format($row['simpanan_sukarela'], 0, ',', '.') ?></p>
        <hr>
        <p><strong>Total Pinjaman:</strong> Rp <?= number_format($row['jumlah_pinjaman'], 0, ',', '.') ?></p>
        <p><strong>Sisa Pinjaman:</strong> Rp <?= number_format($row['sisa_pinjaman'], 0, ',', '.') ?></p>
        <p><strong>Status Anggota:</strong>
          <?php
          $status = htmlspecialchars($row['status_anggota']);
          if ($status == 'Aktif') {
              echo '<span class="badge bg-success">Aktif</span>';
          } elseif ($status == 'Pasif') {
              echo '<span class="badge bg-warning">Pasif</span>';
          } elseif ($status == 'Keluar') {
              echo '<span class="badge bg-danger">Keluar</span>';
          } else {
              echo '<span class="badge bg-secondary">Tidak Diketahui</span>';
          }
          ?>
        </p>
      </div>
<div class="modal-footer justify-content-between">
  <button type="button" class="btn btn-dark" onclick="printModalContent('detailModal<?= $row['id'] ?>')">
    <i class="bi bi-printer"></i> Print
  </button>
  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
</div>

    </div>
  </div>
</div>


                  <!-- Modal Tambah Saldo -->
<div class="modal fade" id="tambahSaldoModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="tambahSaldoLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post">
      <input type="hidden" name="user_id" value="<?= $row['id'] ?>">
      <div class="modal-content bg-white text-dark">
        <div class="modal-header">
          <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
          <h5 class="modal-title" id="tambahSaldoLabel<?= $row['id'] ?>"> <?= htmlspecialchars($nama_perusahaan); ?> - Tambah Saldo</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="jenis_simpanan<?= $row['id'] ?>" class="form-label">Jenis Simpanan</label>
            <select name="jenis_simpanan" id="jenis_simpanan<?= $row['id'] ?>" class="form-select" required>
              <option value="">-- Pilih Jenis --</option>
              <option value="wajib">Simpanan Wajib</option>
              <option value="sukarela">Simpanan Sukarela</option>
            </select>
          </div>
         <div class="mb-3">
  <label for="jumlah_simpanan<?= $row['id'] ?>" class="form-label">Jumlah</label>
  <div class="input-group">
    <span class="input-group-text">Rp</span>
    <input type="text" id="jumlah_simpanan_format<?= $row['id'] ?>" class="form-control jumlah-format" data-id="<?= $row['id'] ?>" required>
  </div>
  <input type="hidden" name="jumlah_simpanan" id="jumlah_simpanan<?= $row['id'] ?>">
  <div id="error_saldo<?= $row['id'] ?>" class="text-danger mt-1" style="display: none;">Minimal Rp 1.000</div>
</div>

        </div>
        <div class="modal-footer">
          <button type="submit" name="tambah_saldo" class="btn btn-primary">Tambah</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        </div>
      </div>
    </form>
  </div>
</div>


                    <!-- Modal Edit -->
<div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="editModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post">
      <input type="hidden" name="user_id" value="<?= $row['id'] ?>">
      <div class="modal-content bg-white text-dark">
        <div class="modal-header">
          <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
          <h5 class="modal-title" id="editModalLabel<?= $row['id'] ?>"> <?= htmlspecialchars($nama_perusahaan); ?> - Edit Simpanan</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="simpanan_wajib<?= $row['id'] ?>" class="form-label">Simpanan Wajib</label>
            <input type="number" name="simpanan_wajib" id="simpanan_wajib<?= $row['id'] ?>" class="form-control" value="<?= $row['simpanan_wajib'] ?>" required>
          </div>
          <div class="mb-3">
            <label for="simpanan_sukarela<?= $row['id'] ?>" class="form-label">Simpanan Sukarela</label>
            <input type="number" name="simpanan_sukarela" id="simpanan_sukarela<?= $row['id'] ?>" class="form-control" value="<?= $row['simpanan_sukarela'] ?>" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="update" class="btn btn-warning">Simpan Perubahan</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal Detail --><?php

?>
<div class="modal fade" id="modalDetail" tabindex="-1" aria-labelledby="modalDetailLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Pinjaman</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <p><strong>Nama:</strong> <span id="detail_nama"></span></p>
        <p><strong>Jumlah Pinjaman:</strong> <span id="detail_jumlah"></span></p>
        <p><strong>Tanggal Pinjaman:</strong> <span id="detail_tanggal"></span></p>
        <p><strong>Jangka Waktu:</strong> <span id="detail_jangka"></span> bulan</p>
        <p><strong>Angsuran / Bulan:</strong> <span id="detail_angsuran"></span></p>
        <p><strong>Sisa Tagihan:</strong> <span id="detail_sisa"></span></p>
        <p><strong>Status:</strong> <span id="detail_status"></span></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
      </div>
    </div>
  </div>
</div>
                <?php endwhile; else: ?>
                <tr>
                    <td colspan="5" class="text-center">Belum ada data anggota.</td>
                </tr>
            <?php endif; ?>
<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="dataanggota.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>Simpanan</span>
    </a>
    <a href="pinjaman.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>Pinjaman</span>
    </a>
    <a href="pengajuan.php" title="Pengajuan">
        <i class="fas fa-plus-circle"></i>
        <span>Pengajuan</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>


            </tbody>
        </table>
    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("cariAnggota");
    const table = document.querySelector("table");
    const tbody = document.querySelector("tbody");

    // Sembunyikan tabel saat awal
    table.style.display = "none";

    input.addEventListener("keyup", function () {
        const keyword = input.value.toLowerCase();
        const rows = tbody.querySelectorAll("tr");
        let hasResult = false;

        if (keyword.length >= 2) {
            rows.forEach(row => {
                const nama = row.cells[1].textContent.toLowerCase();
                if (nama.includes(keyword)) {
                    row.style.display = "";
                    hasResult = true;
                } else {
                    row.style.display = "none";
                }
            });

            // Tampilkan tabel hanya jika ada hasil
            table.style.display = hasResult ? "" : "none";
        } else {
            // Sembunyikan tabel kalau input kurang dari 2 huruf
            table.style.display = "none";
        }
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
  const inputs = document.querySelectorAll(".jumlah-format");

  inputs.forEach(input => {
    // Blok input selain angka
    input.addEventListener("keypress", function (e) {
      if (!/[0-9]/.test(e.key)) {
        e.preventDefault();
      }
    });

    // Format dan validasi
    input.addEventListener("input", function () {
      const id = this.dataset.id;
      const rawValue = this.value.replace(/\./g, "").replace(/[^\d]/g, "");
      const hiddenInput = document.getElementById("jumlah_simpanan" + id);
      const errorMsg = document.getElementById("error_saldo" + id);

      if (rawValue) {
        const formatted = rawValue.replace(/\B(?=(\d{3})+(?!\d))/g, ".");
        this.value = formatted;
        hiddenInput.value = rawValue;

        // Validasi minimal 1000
        if (parseInt(rawValue) < 1000) {
          errorMsg.style.display = "block";
        } else {
          errorMsg.style.display = "none";
        }
      } else {
        hiddenInput.value = "";
        errorMsg.style.display = "none";
      }
    });
  });
});
</script>
<script>
  function printModalContent(modalId) {
    const modal = document.getElementById(modalId);
    const header = modal.querySelector('.modal-header').cloneNode(true);
    const body = modal.querySelector('.modal-body').cloneNode(true);

    // Bungkus dalam div cetak dengan border putus-putus
    const printArea = document.createElement('div');
  printArea.innerHTML = `
  <div style="border: 2px dashed #000; padding: 20px; margin: 20px; position: relative;">
    <div style="text-align: center;">
      <img src='../uploads/<?= $logo_perusahaan ?>' alt='Logo' style='width: 70px; height: 70px; display: block; margin: 0 auto 10px;'>
      <h3 style="margin: 0;">Laporan Bulanan Anggota</h3>
      <small><?= htmlspecialchars($nama_perusahaan); ?></small>
    </div>
    <hr style="margin: 20px 0;">
    ${body.innerHTML}
  </div>
`;

    // Buka jendela cetak
    const printWindow = window.open('', '', 'width=800,height=600');
    printWindow.document.write(`
      <html>
        <head>
          <title>Laporan Bulanan</title>
          <style>
            body {
              font-family: Arial, sans-serif;
              padding: 20px;
              color: #000;
            }
            h2 {
              margin-top: 0;
            }
            .badge {
              padding: 5px 10px;
              border-radius: 5px;
              color: #fff;
              font-size: 0.9rem;
            }
            .bg-success { background-color: #198754; }
            .bg-warning { background-color: #ffc107; color: #000; }
            .bg-danger { background-color: #dc3545; }
            .bg-secondary { background-color: #6c757d; }
            hr {
              margin: 20px 0;
            }
            img {
              max-height: 50px;
              margin-bottom: 10px;
            }
          </style>
        </head>
        <body>
          ${printArea.innerHTML}
        </body>
      </html>
    `);
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();
  }
</script><script>
  // Format angka sebagai mata uang
  function formatRupiah(angka) {
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
  }

  function unformatRupiah(rp) {
    return rp.replace(/\./g, '');
  }

  document.addEventListener('DOMContentLoaded', function () {
    const inputFormat = document.getElementById('edit_jumlah_format');
    const inputHidden = document.getElementById('edit_jumlah');
    const errorDiv = document.getElementById('error_jumlah');

    inputFormat.addEventListener('input', function () {
      let rawValue = this.value.replace(/\D/g, '');
      let formatted = formatRupiah(rawValue);
      this.value = formatted;
      inputHidden.value = unformatRupiah(formatted);

      // Validasi minimum Rp 1.000
      if (parseInt(inputHidden.value) < 1000) {
        errorDiv.style.display = 'block';
      } else {
        errorDiv.style.display = 'none';
      }
    });
  });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
