<?php
include '../config.php';

// Ambil data perusahaan
$setting = $conn->query("SELECT * FROM setting LIMIT 1")->fetch_assoc();
$nama_perusahaan = $setting['nama_perusahaan'] ?? 'KOPERASI';
$logo = $setting['logo_perusahaan'] ?? 'default_logo.jpg';

// Ambil data anggota
$query = "SELECT 
            users.nama_lengkap, users.status_anggota,
            COALESCE(simpanan.simpanan_wajib, 0) AS simpanan_wajib,
            COALESCE(simpanan.simpanan_sukarela, 0) AS simpanan_sukarela,
            COALESCE(SUM(pinjaman.jumlah_pinjaman), 0) AS jumlah_pinjaman,
            COALESCE(SUM(pinjaman.sisa), 0) AS sisa_pinjaman
          FROM users
          LEFT JOIN simpanan ON users.id = simpanan.user_id
          LEFT JOIN pinjaman ON users.id = pinjaman.user_id
          WHERE users.role = 'anggota'
          GROUP BY users.id";
$result = $conn->query($query);

// Simpan ke array
$anggota = [];
while ($row = $result->fetch_assoc()) {
    $anggota[] = $row;
}
$total = count($anggota);
$perPage = 4;
$pageCount = ceil($total / $perPage);
?>

<!DOCTYPE html>
<html>
<head>
  <title>Laporan Anggota Koperasi</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @media print {
      .no-print { display: none; }
      body {
        margin: 0;
        padding: 0;
        font-size: 12px;
      }
      .page-break {
        page-break-after: always;
      }
    }

    .anggota-box {
      border: 1px solid #ccc;
      padding: 10px 15px;
      margin-bottom: 20px;
      border-radius: 8px;
      height: auto;  /* Menghapus tinggi tetap */
      box-sizing: border-box;
    }

    .anggota-container {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      justify-content: space-between;
    }

    .anggota-card {
      width: calc(50% - 10px);
      box-sizing: border-box;
    }

    .anggota-header {
      text-align: center;
      margin-bottom: 10px;
    }

    .anggota-header img {
      height: 40px;
      margin-bottom: 5px;
    }

    .anggota-header h5, .anggota-header h6 {
      margin: 0;
      font-size: 14px;
    }

    .anggota-box p {
      margin: 5px 0;  /* Mengurangi jarak antar paragraf */
      padding: 0;
    }
    
    .badge {
      font-size: 0.8rem; /* Menyesuaikan ukuran badge */
    }
  </style>
</head>
<body class="p-4">

<?php for ($page = 0; $page < $pageCount; $page++) :
    $start = $page * $perPage;
    $end = min(($start + $perPage), $total);
?>
  <div class="page-break">
    <div class="anggota-container">
      <?php for ($i = $start; $i < $end; $i++) :
        $row = $anggota[$i];
      ?>
        <div class="anggota-card">
          <div class="anggota-box">
            <div class="anggota-header">
              <img src="../uploads/<?= $logo ?>" alt="Logo">
              <h5><?= strtoupper($nama_perusahaan) ?></h5>
              <h6>Laporan Anggota Koperasi</h6>
              <hr>
            </div><div class="text-center no-print mt-4">
    <button onclick="window.print()" class="btn btn-primary">Print</button>
  </div>
            <p><strong>Nama:</strong> <?= htmlspecialchars($row['nama_lengkap']) ?></p>
            <p><strong>Simpanan Wajib:</strong> Rp <?= number_format($row['simpanan_wajib'], 0, ',', '.') ?></p>
            <p><strong>Simpanan Sukarela:</strong> Rp <?= number_format($row['simpanan_sukarela'], 0, ',', '.') ?></p>
            <hr>
            <p><strong>Total Pinjaman:</strong> Rp <?= number_format($row['jumlah_pinjaman'], 0, ',', '.') ?></p>
            <p><strong>Sisa Pinjaman:</strong> Rp <?= number_format($row['sisa_pinjaman'], 0, ',', '.') ?></p>
            <p><strong>Status Anggota:</strong>
              <?php
              $status = htmlspecialchars($row['status_anggota']);
              if ($status == 'Aktif') {
                  echo '<span class="badge bg-success">Aktif</span>';
              } elseif ($status == 'Pasif') {
                  echo '<span class="badge bg-warning">Pasif</span>';
              } elseif ($status == 'Keluar') {
                  echo '<span class="badge bg-danger">Keluar</span>';
              } else {
                  echo '<span class="badge bg-secondary">Tidak Diketahui</span>';
              }
              ?>
            </p>
          </div>
        </div>
      <?php endfor; ?>
    </div>
  </div>
<?php endfor; ?>

  

</body>
</html>
