<?php
session_start();
include 'config.php';

$error = "";

// Cek jika form disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // Gunakan prepared statement untuk keamanan
    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ? AND password = ?");
    $stmt->bind_param("ss", $username, $password); // "ss" = string, string
    $stmt->execute();
    $result = $stmt->get_result();

    // Cek apakah data ditemukan
    if ($result->num_rows > 0) {
        $data = $result->fetch_assoc();

        // Simpan ke session
        $_SESSION['username'] = $data['username'];
        $_SESSION['role'] = $data['role'];
        $_SESSION['nama_lengkap'] = $data['nama_lengkap'];
        $_SESSION['user_id'] = $data['id']; // <- Diperlukan untuk halaman anggota
   $_SESSION['foto']         = $user['foto']; // <--- ini penting
        // Redirect berdasarkan role
        switch ($data['role']) {
            case 'admin':
                header("Location: ./admin");
                break;
            case 'pengurus':
                header("Location: ./pengurus");
                break;
            case 'anggota':
                header("Location: ./anggota");
                break;
            default:
                $error = "Role tidak dikenali.";
        }
    } else {
        $error = "Username atau Password salah!";
    }

    $stmt->close();
}$querySetting = $conn->query("SELECT * FROM setting LIMIT 1");

if ($querySetting && $querySetting->num_rows > 0) {
    $setting = $querySetting->fetch_assoc();
    $nama_perusahaan = $setting['nama_perusahaan'];
    $logo_perusahaan = $setting['logo_perusahaan'];
    $background = $setting['background'];
} else {
    $nama_perusahaan = "Nama Perusahaan";
    $logo_perusahaan = "default_logo.jpg";
    $background = "default_bg.jpg";
}
?>



<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login Koperasi</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
 <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <style>
        body {
            background: url('uploads/<?php echo $background; ?>');no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-box {
            max-width: 400px;
            width: 100%;
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 15px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
            padding: 30px;
            color: #fff;
            text-align: center;
        }

        label, input::placeholder {
            color: #000000;
        }

        input {
            background-color: rgba(255, 255, 255, 0.1) !important;
            border: none;
            color: #fff;
        }

        input:focus {
            background-color: rgba(255, 255, 255, 0.2) !important;
            color: #fff;
        }

        .alert {
            background-color: rgba(255, 0, 0, 0.7);
            border: none;
        }

        .logo-top {
            width: 80px;
            margin-bottom: 20px;
        }

        .logo-bottom {
            width: 50px;
            margin-top: 25px;
            opacity: 0.85;
        }

        .copyright {
            margin-top: 10px;
            font-size: 0.85rem;
            color: #eee;
        }
          .mb-4{
            color: #000000;
        }
    </style>
</head>
<body>

<div class="login-box">
    <div class="glass-card">
        <!-- Logo Atas -->
        <img src="uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo SMAPA" class="logo-top">

        <h4 class="mb-4"> <?= htmlspecialchars($nama_perusahaan); ?></h4>

        <?php if ($error): ?>
            <div class="alert alert-danger text-white"><?= $error ?></div>
        <?php endif; ?>

       <form method="POST" autocomplete="off">
    <div class="mb-3 text-start">
        <label for="username" class="form-label">Username</label>
        <input type="text" name="username" id="username" class="form-control" required autofocus>
    </div>
    <div class="mb-3 text-start">
        <label for="password" class="form-label">Password</label>
        <input type="password" name="password" id="password" class="form-control" required>
        <div class="form-check mt-2">
            <input type="checkbox" class="form-check-input" id="showPassword" onclick="togglePassword()">
            <label class="form-check-label" for="showPassword">Tampilkan Password</label>
        </div>
    </div>
    <button type="submit" class="btn btn-light w-100">Login</button>
</form>

        <!-- Logo Bawah -->
        <img src="logodigipas.png" alt="Logo DigiPas" class="logo-bottom">

        <!-- Copyright -->
        <div class="copyright">
            &copy; 2025 Koperasi SMAPA | Powered by DigiPas
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
