<?php
session_start();
include '../config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'anggota') {
    header("Location: ../index.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nama_lengkap = $_SESSION['nama_lengkap'];

// Ambil data pengaturan perusahaan (termasuk wa_perusahaan)
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan, wa_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';

// Fungsi untuk membersihkan angka dari format "Rp" dan titik
function bersihkanAngka($string) {
    return intval(preg_replace('/[^\d]/', '', $string));
}

// Proses pengajuan jika form disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $jumlah = isset($_POST['jumlah']) ? bersihkanAngka($_POST['jumlah']) : 0;
    $tenor = isset($_POST['tenor']) ? intval($_POST['tenor']) : 0;
    $biaya = isset($_POST['biaya']) ? bersihkanAngka($_POST['biaya']) : 0;

    $cek = $conn->prepare("SELECT * FROM pengajuan WHERE user_id = ? AND keterangan = 'dalam proses'");
    $cek->bind_param("i", $user_id);
    $cek->execute();
    $res = $cek->get_result();

   if ($res->num_rows == 0 && $jumlah > 0 && $tenor > 0 && $biaya > 0) {
    $stmt = $conn->prepare("INSERT INTO pengajuan (user_id, jumlah_pinjaman, tenor, biaya_perbulan, keterangan) VALUES (?, ?, ?, ?, 'dalam proses')");
    $stmt->bind_param("iiii", $user_id, $jumlah, $tenor, $biaya);
    $stmt->execute();
    $stmt->close();
    $pesan = "Pengajuan berhasil dikirim. Menunggu persetujuan.";

    // Token dan Secret Key dari akun Wablas (ganti sesuai akun Anda)
    $token = 'gZkv3WhY8RzXRTfcckpVF7Hhe79FOyBA2xSrZjObb2RFzdBlw27k9Pj';
    $secret_key = 'bOZSWx7J';
    $no_admin = '6287878762628'; // Nomor WA admin

    // --------------------- WA ke Admin ---------------------
    $pesan_wa_admin = "*Notifikasi Pengajuan Pinjaman*\n"
                    . "Nama: $nama_lengkap\n"
                    . "Jumlah: Rp " . number_format($jumlah, 0, ',', '.') . "\n"
                    . "Tenor: $tenor bulan\n"
                    . "Biaya per bulan: Rp " . number_format($biaya, 0, ',', '.') . "\n"
                    . "Status: Dalam proses";

    $url_admin = "https://jogja.wablas.com/api/send-message?token=$token.$secret_key&phone=$no_admin&message=" . urlencode($pesan_wa_admin);

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url_admin);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response_admin = curl_exec($curl);
    curl_close($curl);

    // --------------------- WA ke Anggota ---------------------
    // Ambil no_wa anggota dari tabel users
    $stmtWa = $conn->prepare("SELECT no_wa FROM users WHERE id = ?");
    $stmtWa->bind_param("i", $user_id);
    $stmtWa->execute();
    $stmtWa->bind_result($no_wa);
    $stmtWa->fetch();
    $stmtWa->close();

    if (!empty($no_wa)) {
        $pesan_wa_anggota = "*Terima kasih $nama_lengkap atas pengajuan Anda!*\n"
                          . "Data pengajuan Anda sedang dalam proses.\n\n"
                          . "Jumlah: Rp " . number_format($jumlah, 0, ',', '.') . "\n"
                          . "Tenor: $tenor bulan\n"
                          . "Biaya per bulan: Rp " . number_format($biaya, 0, ',', '.') . "\n"
                          . "Status: Dalam proses\n\n"
                          . "Mohon tunggu konfirmasi lebih lanjut dari admin.";

        $url_user = "https://jogja.wablas.com/api/send-message?token=$token.$secret_key&phone=$no_wa&message=" . urlencode($pesan_wa_anggota);

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url_user);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response_user = curl_exec($curl);
        curl_close($curl);
    }

} else {
    $pesan = "Pengajuan sebelumnya masih dalam proses atau data tidak valid.";
}

    $cek->close();

    // Redirect agar tidak double submit saat refresh
    header("Location: " . $_SERVER['PHP_SELF'] . "?pesan=" . urlencode($pesan));
    exit;
}

// Ambil pengajuan user
$query = "SELECT * FROM pengajuan WHERE user_id = ? ORDER BY created_at DESC";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$pesan = '';
if (isset($_GET['pesan'])) {
    $pesan = urldecode($_GET['pesan']);
}
?>




<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
     <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Modal Form Pengajuan -->
<div class="modal fade" id="modalPengajuan" tabindex="-1" aria-labelledby="modalPengajuanLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header">
          <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
          <h5 class="modal-title" id="modalPengajuanLabel"><?= htmlspecialchars($nama_perusahaan); ?> - Form Pengajuan Pinjaman</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
        </div>
        <div class="modal-body">
          <label>Jumlah Pinjaman (Rp)</label>
          <input type="text" class="form-control" id="jumlah_display" placeholder="Rp 0">
          <input type="hidden" name="jumlah" id="jumlah" required>

          <label class="mt-2">Tenor (bulan)</label>
          <select class="form-select" name="tenor" id="tenor" required>
              <option value="">-- Pilih --</option>
              <option value="3">3 bulan</option>
              <option value="6">6 bulan</option>
              <option value="12">12 bulan</option>
          </select>

          <label class="mt-2">Biaya Perbulan (Rp)</label>
          <input type="text" class="form-control" id="biaya_display" readonly required>
          <input type="hidden" name="biaya" id="biaya" required>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary">Ajukan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="container">
    <h2>Pengajuan Pinjaman</h2>
<?php if (!empty($pesan)): ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($pesan) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

    <!-- Tombol untuk membuka modal -->
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalPengajuan">
        Ajukan Pinjaman Baru
    </button>

    <div class="status mt-4">
    <h3>Status Pengajuan</h3>
    <?php if ($result->num_rows > 0): ?>
       <div class="table-responsive">
    <table class="table table-bordered table-striped">
         
                <thead class="table-dark">
                    <tr>
                        <th>Jumlah Pinjaman</th>
                        <th>Tenor</th>
                        <th>Biaya per Bulan</th>
                        <th>Status</th>
                        <th>Tanggal Pengajuan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><strong>Rp<?= number_format($row['jumlah_pinjaman'], 0, ',', '.') ?></strong></td>
                            <td><?= $row['tenor'] ?> bulan</td>
                            <td>Rp<?= number_format($row['biaya_perbulan'], 0, ',', '.') ?>/bulan</td>
                            <td>
                                <span class="label-status status-<?= str_replace(' ', '-', strtolower($row['keterangan'])) ?>">
                                    <?= ucfirst($row['keterangan']) ?>
                                </span>
                            </td>
                            <td><?= date('d M Y, H:i', strtotime($row['created_at'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p>Belum ada pengajuan.</p>
    <?php endif; ?>
</div>

    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <a href="index.php" title="Home">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="pengajuan.php" title="Pengajuan">
            <i class="fas fa-plus-circle"></i>
            <span>Pengajuan</span>
        </a>
        <a href="profile.php" title="Profil">
            <i class="fas fa-user-edit"></i>
            <span>Profil</span>
        </a>
    </div>
</div>

<!-- Modal Form Pengajuan -->
<div class="modal fade" id="modalPengajuan" tabindex="-1" aria-labelledby="modalPengajuanLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header">
          <h5 class="modal-title" id="modalPengajuanLabel">Form Pengajuan Pinjaman</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
        </div>
        <div class="modal-body">
         <label>Jumlah Pinjaman (Rp)</label>
<input type="text" class="form-control" id="jumlah_display" placeholder="Rp 0">
<input type="hidden" name="jumlah" id="jumlah" required>


          <label class="mt-2">Tenor (bulan)</label>
          <select class="form-select" name="tenor" id="tenor" required>
              <option value="">-- Pilih --</option>
              <option value="3">3 bulan</option>
              <option value="6">6 bulan</option>
              <option value="12">12 bulan</option>
          </select>

   <label class="mt-2">Biaya Perbulan (Rp)</label>
<input type="text" class="form-control" id="biaya_display" readonly required>
<input type="hidden" name="biaya" id="biaya" required>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary">Ajukan</button>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const jumlahDisplay = document.getElementById("jumlah_display");
    const jumlahHidden = document.getElementById("jumlah");
    const tenorInput = document.getElementById("tenor");
    const biayaDisplay = document.getElementById("biaya_display");
    const biayaHidden = document.getElementById("biaya");

    function formatRupiah(angka) {
        return 'Rp ' + angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    }

    function parseRupiah(rupiah) {
        return parseInt(rupiah.replace(/[^\d]/g, '')) || 0;
    }

    function hitungBiaya() {
        const jumlah = parseRupiah(jumlahDisplay.value);
        const tenor = parseInt(tenorInput.value);

        if (!isNaN(jumlah) && !isNaN(tenor) && tenor > 0) {
            const cicilanPokok = jumlah / tenor;
            const bunga = jumlah * 0.015;
            const total = Math.round(cicilanPokok + bunga);
            biayaDisplay.value = formatRupiah(total);
            biayaHidden.value = total;
        } else {
            biayaDisplay.value = "";
            biayaHidden.value = "";
        }
    }

    jumlahDisplay.addEventListener("input", function () {
        const raw = parseRupiah(jumlahDisplay.value);
        jumlahDisplay.value = formatRupiah(raw);
        jumlahHidden.value = raw;
        hitungBiaya();
    });

    tenorInput.addEventListener("change", hitungBiaya);
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
