<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../config.php';

// Cek login dan role
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'anggota') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nama_lengkap = $_SESSION['nama_lengkap'];

// Ambil data user dan keuangan
$query = "
    SELECT 
        u.id,
        u.nama_lengkap,
        u.foto,
        u.no_wa,
        u.status_anggota,
        u.bergabung_sejak,
        COALESCE(s.simpanan_wajib, 0) AS simpanan_wajib,
        COALESCE(s.simpanan_sukarela, 0) AS simpanan_sukarela,
        COALESCE(SUM(p.jumlah_pinjaman), 0) AS jumlah_pinjaman,
        COALESCE(SUM(p.sisa), 0) AS sisa_pinjaman
    FROM users u
    LEFT JOIN simpanan s ON u.id = s.user_id
    LEFT JOIN pinjaman p ON u.id = p.user_id
    WHERE u.id = ?
    GROUP BY u.id, u.nama_lengkap, u.foto, u.no_wa, u.status_anggota, u.bergabung_sejak, s.simpanan_wajib, s.simpanan_sukarela
";

$stmt = $conn->prepare($query);
if (!$stmt) {
    die("Query error: " . $conn->error);
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
if (!$data) {
    echo "<script>alert('Data tidak ditemukan.'); window.location.href='../logout.php';</script>";
    exit;
}

// Hitung lama bergabung
$bergabung_sejak = $data['bergabung_sejak'] ?? null;
$jumlah_hari = $bergabung_sejak ? (new DateTime())->diff(new DateTime($bergabung_sejak))->days : 0;

// Ambil pengaturan perusahaan
$querySetting = $conn->query("SELECT nama_perusahaan, logo_perusahaan, wa_perusahaan FROM setting LIMIT 1");
$setting = $querySetting->fetch_assoc();

$nama_perusahaan = $setting['nama_perusahaan'] ?? 'Nama Perusahaan';
$logo_perusahaan = $setting['logo_perusahaan'] ?? 'default_logo.jpg';
$wa_perusahaan = preg_replace('/\D/', '', $setting['wa_perusahaan'] ?? ''); // pastikan hanya angka
// Foto profil fallback
$foto = $data['foto'] ?: 'default_user.jpg';
setlocale(LC_TIME, 'id_ID.utf8');
$hari_ini = strftime("%A");
$tanggal_ini = strftime("%e %B %Y");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Anggota - <?= htmlspecialchars($nama_perusahaan); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
            <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
            <?= htmlspecialchars($nama_perusahaan); ?>
        </span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Konten -->
<div class="container mt-5 pt-5">
    <div class="welcome-section text-center mt-4">
        <div class="neon-glow heartbeat">
            <img src="../uploads/<?= htmlspecialchars($foto); ?>" alt="Foto Profil" class="status-wa">
        </div>

        <!-- Ucapan Sambutan -->
        <h2 id="typing-text" style="font-weight:bold; font-size:2.2em;"></h2>
        <p id="fade-out-message" style="font-weight:bold;">Terima kasih telah menjadi bagian dari koperasi kami 🙌</p>

        <!-- Hari Ke -->
        <h2 id="hari-ke" style="display:none; font-weight:bold; font-size:2em;"></h2>

        <!-- Judul Laporan -->
        <h3 id="report-title" class="fade-in-text" style="display:none; font-weight: bold; font-size: 18px; text-align:center;"></h3>

        <!-- Laporan -->
        <div id="report-section" style="display:none;">
            <div class="info-box mt-3">
                <div class="info-item wajib">
                    <span class="label">Simpanan Wajib</span>
                    <span class="value">Rp<?= number_format($data['simpanan_wajib'], 0, ',', '.'); ?></span>
                </div>
                <div class="info-item sukarela">
                    <span class="label">Simpanan Sukarela</span>
                    <span class="value">Rp<?= number_format($data['simpanan_sukarela'], 0, ',', '.'); ?></span>
                </div>
                <div class="info-item pinjaman">
                    <span class="label">Jumlah Pinjaman</span>
                    <span class="value">Rp<?= number_format($data['jumlah_pinjaman'], 0, ',', '.'); ?></span>
                </div>
                <div class="info-item sisa-pinjaman">
                    <span class="label">Sisa Pinjaman</span>
                    <span class="value">Rp<?= number_format($data['sisa_pinjaman'], 0, ',', '.'); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home"><i class="fas fa-home"></i><span>Home</span></a>
    <a href="pengajuan.php" title="Pengajuan"><i class="fas fa-plus-circle"></i><span>Pengajuan</span></a>
    <a href="profile.php" title="Profil"><i class="fas fa-user-edit"></i><span>Profil</span></a>
</div>

<!-- Floating WhatsApp -->
<a href="https://wa.me/<?= $wa_perusahaan; ?>" class="whatsapp-float" target="_blank" title="Kirim pesan ke WhatsApp">
    <img src="https://img.icons8.com/color/48/000000/whatsapp--v1.png" alt="WhatsApp">
</a>

<!-- Confetti -->
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.5.1/dist/confetti.browser.min.js"></script>

<!-- Script Animasi -->
<script>
const namaLengkap = "<?= htmlspecialchars(strtoupper($data['nama_lengkap'])); ?>";
const hariKe = <?= $jumlah_hari; ?>;
const namaPerusahaan = "<?= htmlspecialchars($nama_perusahaan); ?>";

const typingText = document.getElementById("typing-text");
const fadeMessage = document.getElementById("fade-out-message");
const hariKeElem = document.getElementById("hari-ke");
const reportTitle = document.getElementById("report-title");
const reportSection = document.getElementById("report-section");

const tanggalID = new Date().toLocaleDateString('id-ID', {
    weekday: 'long',
    day: 'numeric',
    month: 'long',
    year: 'numeric'
});

const text = `SELAMAT DATANG, ${namaLengkap}!`;
let index = 0;

function typeWelcome() {
    if (index < text.length) {
        typingText.innerHTML += text.charAt(index);
        index++;
        setTimeout(typeWelcome, 50);
    } else {
        setTimeout(() => {
            fadeMessage.style.transition = "opacity 1s ease-out";
            typingText.style.transition = "opacity 1s ease-out";
            fadeMessage.style.opacity = 0;
            typingText.style.opacity = 0;
            setTimeout(() => {
                fadeMessage.style.display = "none";
                typingText.style.display = "none";
                showHariKe();
            }, 1000);
        }, 1500);
    }
}

function showHariKe() {
    hariKeElem.innerHTML = `INI ADALAH HARI KE <br><b>${hariKe}</b><br> KITA MEMBANGUN ${namaPerusahaan}`;
    hariKeElem.style.display = "block";
    hariKeElem.style.opacity = 1;
    confettiEffect();
    setTimeout(() => {
        hariKeElem.style.transition = "opacity 1s ease-out";
        hariKeElem.style.opacity = 0;
        setTimeout(() => {
            hariKeElem.style.display = "none";
            showReport();
        }, 1000);
    }, 2500);
}

function showReport() {
    reportTitle.innerHTML = `<div style="font-size: 16px; font-weight: 600;">
        <span style="text-transform: uppercase;">${namaLengkap}</span><br>
        Berikut laporan koperasi per tanggal<br>
        <b>${tanggalID}</b>
    </div>`;
    reportTitle.classList.add("fade-in-text", "show");
    reportTitle.style.display = "block";

    setTimeout(() => {
        reportSection.style.display = "block";
    }, 500);
}


function confettiEffect() {
    const duration = 2000;
    const end = Date.now() + duration;
    (function frame() {
        confetti({ particleCount: 5, angle: 60, spread: 55, origin: { x: 0 } });
        confetti({ particleCount: 5, angle: 120, spread: 55, origin: { x: 1 } });
        if (Date.now() < end) requestAnimationFrame(frame);
    })();
}

window.onload = typeWelcome;
</script>

