<?php
session_start();
include '../config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../index.php");
    exit;
}
// Ambil data setting
$querySetting = $conn->query("SELECT * FROM setting LIMIT 1");
if ($querySetting && $querySetting->num_rows > 0) {
    $setting = $querySetting->fetch_assoc();
    $nama_perusahaan = $setting['nama_perusahaan'];
    $logo_perusahaan = $setting['logo_perusahaan'];
    $background = $setting['background'];
} else {
    $nama_perusahaan = "Nama Perusahaan";
    $logo_perusahaan = "default_logo.jpg";
    $background = "default_bg.jpg";
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $wa_api_key = $_POST['wa_api_key'];
    $link_server = $_POST['link_server'];
    $pesan_pengurus = $_POST['pesan_pengurus'];
    $pesan_anggota = $_POST['pesan_anggota'];
    $pesan_update = $_POST['pesan_update'];
    $secret_key = $_POST['secret_key']; // Ambil nilai secret_key dari form

    // Update ke database
    $stmt = $conn->prepare("UPDATE setting SET wa_api_key = ?, link_server = ?, pesan_pengurus = ?, pesan_anggota = ?, pesan_update = ?, secret_key = ? WHERE id = 1");
    $stmt->bind_param("ssssss", $wa_api_key, $link_server, $pesan_pengurus, $pesan_anggota, $pesan_update, $secret_key);

    if ($stmt->execute()) {
        $success = "Pengaturan berhasil diperbarui!";
    } else {
        $error = "Gagal memperbarui pengaturan.";
    }
}

// Ambil data pengaturan saat ini
$setting = $conn->query("SELECT * FROM setting LIMIT 1")->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
     <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>
<body>

<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
            <img src="../uploads/<?= htmlspecialchars($setting['logo_perusahaan']); ?>" alt="Logo" class="logo-icon me-2">
            <?= htmlspecialchars($setting['nama_perusahaan']); ?>
        </span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($_SESSION['nama_lengkap']); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <img src="../uploads/<?= htmlspecialchars($setting['logo_perusahaan']); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
                <h5 class="modal-title" id="logoutModalLabel"><?= htmlspecialchars($setting['nama_perusahaan']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a href="../logout.php" class="btn btn-danger">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Konten -->
<div class="container py-5 main-content">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card p-4">
                <h4 class="text-center mb-4">Update Pengaturan</h4>

                <?php if (isset($success)): ?>
                    <div class="alert alert-success"><?= $success; ?></div>
                <?php endif; ?>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?= $error; ?></div>
                <?php endif; ?>

                <form method="POST">
                    <!-- WA API Key -->
                    <div class="mb-3">
                        <label class="form-label">WA API Key</label>
                        <input type="text" name="wa_api_key" class="form-control" value="<?= htmlspecialchars($setting['wa_api_key']); ?>" required>
                    </div>

                    <!-- Link Server -->
                    <div class="mb-3">
                        <label class="form-label">Link Server</label>
                        <input type="text" name="link_server" class="form-control" value="<?= htmlspecialchars($setting['link_server']); ?>" required>
                    </div>

                    <!-- Pesan Pengurus -->
                    <div class="mb-3">
                        <label class="form-label">Pesan Pengurus</label>
                        <textarea name="pesan_pengurus" class="form-control" rows="3" required><?= htmlspecialchars($setting['pesan_pengurus']); ?></textarea>
                    </div>

                    <!-- Pesan Anggota -->
                    <div class="mb-3">
                        <label class="form-label">Pesan Anggota</label>
                        <textarea name="pesan_anggota" class="form-control" rows="3" required><?= htmlspecialchars($setting['pesan_anggota']); ?></textarea>
                    </div>

                    <!-- Pesan Update -->
                    <div class="mb-3">
                        <label class="form-label">Pesan Update</label>
                        <textarea name="pesan_update" class="form-control" rows="3" required><?= htmlspecialchars($setting['pesan_update']); ?></textarea>
                    </div>

                    <!-- Secret Key -->
                    <div class="mb-3">
                        <label class="form-label">Secret Key</label>
                        <input type="text" name="secret_key" class="form-control" value="<?= htmlspecialchars($setting['secret_key']); ?>" required>
                    </div>

                    <!-- Tombol Aksi -->
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-dark">Simpan Pengaturan</button>
                        <a href="index.php" class="btn btn-secondary">Kembali ke Beranda</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="setting.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>setting</span>
    </a>
    <a href="wa.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>setting wa</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>