<?php
include '../config.php'; // Sesuaikan dengan lokasi file config.php

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv'])) {
    $file = $_FILES['csv']['tmp_name'];

    if (($handle = fopen($file, 'r')) !== false) {
        $row = 0;

        while (($data = fgetcsv($handle, 1000, ",")) !== false) {
            if ($row == 0) {
                $row++;
                continue; // Lewati header
            }

            // Ambil data per kolom
            $id                  = $data[0];
            $username            = $data[1];
            $password_plain      = $data[2];
            $foto                = $data[3];
            $no_wa               = $data[4];
            $role                = $data[5];
            $nama_lengkap        = $data[6];
            $status_anggota      = $data[7];
            $bergabung_sejak     = $data[8];
            $simpanan_wajib      = $data[9];
            $simpanan_hari_raya  = $data[10];
            $jasa_pinjaman       = $data[11];

            // Enkripsi password
            $password = password_hash($password_plain, PASSWORD_DEFAULT);

            // Cek apakah username sudah ada
            $cek = $conn->prepare("SELECT id FROM users WHERE username = ?");
            $cek->bind_param("s", $username);
            $cek->execute();
            $cek->store_result();

            if ($cek->num_rows == 0) {
                // Simpan ke database
                $stmt = $conn->prepare("INSERT INTO users (username, password, foto, no_wa, role, nama_lengkap, status_anggota, bergabung_sejak, simpanan_wajib, simpanan_hari_raya, jasa_pinjaman)
                                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("sssssssssss", $username, $password, $foto, $no_wa, $role, $nama_lengkap, $status_anggota, $bergabung_sejak, $simpanan_wajib, $simpanan_hari_raya, $jasa_pinjaman);
                $stmt->execute();
                $stmt->close();
            }

            $cek->close();
            $row++;
        }

        fclose($handle);
        echo "<script>alert('Data berhasil diunggah!'); window.location.href='index.php';</script>";
    } else {
        echo "<script>alert('Gagal membuka file.'); window.history.back();</script>";
    }
} else {
    echo "<script>alert('File tidak valid.'); window.history.back();</script>";
}
?>
