<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include '../config.php';

// Cek login
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../index.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nama_lengkap = $_SESSION['nama_lengkap'];
// Ambil data setting
$querySetting = $conn->query("SELECT * FROM setting LIMIT 1");
if ($querySetting && $querySetting->num_rows > 0) {
    $setting = $querySetting->fetch_assoc();
    $nama_perusahaan = $setting['nama_perusahaan'];
    $logo_perusahaan = $setting['logo_perusahaan'];
    $background = $setting['background'];
    $wa_perusahaan = $setting['wa_perusahaan'];
    $simpanan_pokok = isset($setting['simpanan_pokok']) ? $setting['simpanan_pokok'] : 0;
$simpanan_wajib = isset($setting['simpanan_wajib']) ? $setting['simpanan_wajib'] : 0;
} else {
    $nama_perusahaan = "Nama Perusahaan";
    $logo_perusahaan = "default_logo.jpg";
    $background = "default_bg.jpg";
    $wa_perusahaan = "";
}

// Jika form disubmit
if (isset($_POST['submit'])) {
    $nama = htmlspecialchars($_POST['nama_perusahaan']);
    $wa = htmlspecialchars($_POST['wa_perusahaan']);
    $background_lama = $setting['background'];
    $logo_lama = $setting['logo_perusahaan'];
$simpanan_pokok = intval($_POST['simpanan_pokok']);
$simpanan_wajib = intval($_POST['simpanan_wajib']);
    // Upload background baru jika ada
    if (!empty($_FILES['background']['name'])) {
        if ($background_lama && file_exists("../uploads/$background_lama")) {
            unlink("../uploads/$background_lama");
        }
        $bg_name = 'bg_' . time() . '_' . basename($_FILES['background']['name']);
        move_uploaded_file($_FILES['background']['tmp_name'], '../uploads/' . $bg_name);
    } else {
        $bg_name = $background_lama;
    }

    // Upload logo baru jika ada
    if (!empty($_FILES['logo_perusahaan']['name'])) {
        if ($logo_lama && file_exists("../uploads/$logo_lama")) {
            unlink("../uploads/$logo_lama");
        }
        $logo_name = 'logo_' . time() . '_' . basename($_FILES['logo_perusahaan']['name']);
        move_uploaded_file($_FILES['logo_perusahaan']['tmp_name'], '../uploads/' . $logo_name);
    } else {
        $logo_name = $logo_lama;
    }

    if (!empty($setting['id'])) {
        // Jika sudah ada setting, lakukan UPDATE
        $query = mysqli_query($conn, "UPDATE setting SET 
    nama_perusahaan='$nama',
    background='$bg_name',
    logo_perusahaan='$logo_name',
    wa_perusahaan='$wa',
    simpanan_pokok=$simpanan_pokok,
    simpanan_wajib=$simpanan_wajib
    WHERE id=" . $setting['id']);
    } else {
        // Jika belum ada setting, lakukan INSERT
       $query = mysqli_query($conn, "INSERT INTO setting 
    (nama_perusahaan, background, logo_perusahaan, wa_perusahaan, simpanan_pokok, simpanan_wajib) 
    VALUES 
    ('$nama', '$bg_name', '$logo_name', '$wa', $simpanan_pokok, $simpanan_wajib)");
    }

    if ($query) {
        echo "<script>alert('Setting berhasil disimpan!'); window.location='setting.php';</script>";
    } else {
        echo "<script>alert('Gagal menyimpan setting!');</script>";
    }
}
?>


<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
     <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>
<body>

<!-- Navbar -->
<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2">
    <?= htmlspecialchars($nama_perusahaan); ?>
</span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel">  <?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<body>
<!-- Konten -->
<div class="container py-5 main-content" style="margin-top:80px;">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card p-4 shadow">
                <h4 class="text-center mb-4">Setting Perusahaan</h4>

                <form method="POST" enctype="multipart/form-data">
                    <div class="row mb-3 align-items-center">
                        <label class="col-sm-3 col-form-label">Nama Perusahaan</label>
                        <div class="col-sm-9">
                            <input type="text" name="nama_perusahaan" class="form-control" value="<?= htmlspecialchars($setting['nama_perusahaan']); ?>" required>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <label class="col-sm-3 col-form-label">Background Aplikasi</label>
                        <div class="col-sm-5">
                            <input type="file" name="background" class="form-control" accept="image/*" onchange="previewImage(event, 'bgPreview')">
                        </div>
                        <div class="col-sm-4 text-center">
                            <img id="bgPreview" src="<?= $setting['background'] ? '../uploads/' . htmlspecialchars($setting['background']) : '../default_background.jpg'; ?>" alt="Background" class="img-fluid rounded border" style="max-height: 100px;">
                        </div>
                    </div>

                    <div class="row mb-4">
                        <label class="col-sm-3 col-form-label">Logo Perusahaan</label>
                        <div class="col-sm-5">
                            <input type="file" name="logo_perusahaan" class="form-control" accept="image/*" onchange="previewImage(event, 'logoPreview')">
                        </div>
                        <div class="col-sm-4 text-center">
                            <img id="logoPreview" src="<?= $setting['logo_perusahaan'] ? '../uploads/' . htmlspecialchars($setting['logo_perusahaan']) : '../default_logo.jpg'; ?>" alt="Logo" class="img-fluid rounded border" style="max-height: 100px;">
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <label class="col-sm-3 col-form-label">Nomor WhatsApp</label>
                        <div class="col-sm-9">
                            <input type="text" name="wa_perusahaan" class="form-control" value="<?= htmlspecialchars($setting['wa_perusahaan']); ?>" placeholder="Contoh: 6281234567890" required>
                        </div>
                    </div>
<div class="row mb-3 align-items-center">
    <label class="col-sm-3 col-form-label">Simpanan Pokok</label>
    <div class="col-sm-9">
        <input type="number" name="simpanan_pokok" class="form-control" value="<?= htmlspecialchars($simpanan_pokok); ?>" required>
    </div>
</div>

<div class="row mb-3 align-items-center">
    <label class="col-sm-3 col-form-label">Simpanan Wajib</label>
    <div class="col-sm-9">
        <input type="number" name="simpanan_wajib" class="form-control" value="<?= htmlspecialchars($simpanan_wajib); ?>" required>
    </div>
</div>
                    <div class="row mt-4">
                        <div class="col-sm-12 d-flex justify-content-center gap-2">
                            <button type="submit" name="submit" class="btn btn-dark px-4">Simpan Perubahan</button>
                            <a href="index.php" class="btn btn-secondary px-4">Kembali</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="setting.php" title="Data Anggota">
        <i class="fas fa-users"></i>
        <span>setting</span>
    </a>
    <a href="wa.php" title="Pinjaman">
        <i class="fas fa-hand-holding-usd"></i>
        <span>setting wa</span>
    </a>
    <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>
<script>
function previewImage(event, id) {
    const reader = new FileReader();
    reader.onload = function () {
        document.getElementById(id).src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
}
</script>
<!-- Script Preview -->
<script>
function previewImage(event, id) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById(id).src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>