<?php
session_start();
include '../config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../index.php");
    exit;
}

// Ambil data anggota dari tabel users
$query = "SELECT id, nama_lengkap, no_wa FROM users WHERE role = 'anggota'";
$result = $conn->query($query);

// Ambil API key, link server, dan secret key dari tabel setting
$setting = $conn->query("SELECT wa_api_key, link_server, secret_key FROM setting LIMIT 1")->fetch_assoc();

// Ambil nilai API key, link server, dan secret key
$api_key = $setting['wa_api_key'];
$link_server = $setting['link_server'];
$secret_key = $setting['secret_key'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pesan_pengumuman = $_POST['pesan_pengumuman'];

    // Kirim ke semua anggota atau beberapa anggota
    if (isset($_POST['kirim_ke_semua']) && $_POST['kirim_ke_semua'] == 'yes') {
        // Kirim ke semua anggota
        $queryAnggota = "SELECT no_wa FROM users WHERE role = 'anggota'";
        $resultAnggota = $conn->query($queryAnggota);
        $success = '';  // Pesan sukses
        $error = '';  // Pesan error

        while ($row = $resultAnggota->fetch_assoc()) {
            $no_wa_anggota = $row['no_wa'];

            // Kirim request ke server WhatsApp API menggunakan cURL
            $message = urlencode($pesan_pengumuman);
            $url = $link_server;
            $data = [
                'api_key' => $api_key,
                'no_wa' => $no_wa_anggota,
                'pesan' => $message,
                'secret_key' => $secret_key // Menambahkan secret_key ke data
            ];

            // Initialize cURL session
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

            $response = curl_exec($ch);
            if ($response === false) {
                // Error terjadi
                $error = 'Curl error: ' . curl_error($ch);
            } else {
                // Respons dari server
                $success = "Pengumuman berhasil dikirim ke semua anggota!";
            }
            curl_close($ch);
        }
    } else {
        // Kirim ke anggota yang dipilih
        if (isset($_POST['no_wa_anggota']) && is_array($_POST['no_wa_anggota'])) {
            $no_wa_anggota_list = $_POST['no_wa_anggota'];
            $success = '';  // Pesan sukses
            $error = '';  // Pesan error

            foreach ($no_wa_anggota_list as $no_wa_anggota) {
                // Kirim request ke server WhatsApp API menggunakan cURL
                $message = urlencode($pesan_pengumuman);
                $url = $link_server;
                $data = [
                    'api_key' => $api_key,
                    'no_wa' => $no_wa_anggota,
                    'pesan' => $message,
                    'secret_key' => $secret_key // Menambahkan secret_key ke data
                ];

                // Initialize cURL session
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

                $response = curl_exec($ch);
                if ($response === false) {
                    // Error terjadi
                    $error = 'Curl error: ' . curl_error($ch);
                } else {
                    // Respons dari server
                    $success = "Pengumuman berhasil dikirim ke anggota yang dipilih!";
                }
                curl_close($ch);
            }
        }
    }
}
?>



<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kirim Pengumuman - Digikop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../style.css">
    <style>
        .select2-container--bootstrap5 .select2-selection {
            height: 38px;
            line-height: 36px;
        }
    </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm">
    <div>
        <span class="navbar-brand">
            <img src="../uploads/<?= htmlspecialchars($setting['logo_perusahaan']); ?>" alt="Logo" class="logo-icon me-2">
            <?= htmlspecialchars($setting['nama_perusahaan']); ?>
        </span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($_SESSION['nama_lengkap']); ?></strong></span>
        </div>
        <a href="../logout.php" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>

<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <img src="../uploads/<?= htmlspecialchars($setting['logo_perusahaan']); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
                <h5 class="modal-title" id="logoutModalLabel"><?= htmlspecialchars($setting['nama_perusahaan']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a href="../logout.php" class="btn btn-danger">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Konten -->
<div class="container py-5 main-content">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card p-4">
                <h4 class="text-center mb-4">Kirim Pengumuman</h4>

                <?php if (isset($success)): ?>
                    <div class="alert alert-success"><?= $success; ?></div>
                <?php endif; ?>

                <form method="POST">
                    <!-- Pilihan Pengiriman -->
                    <div class="mb-3">
                        <label class="form-label">Pilih Pengiriman</label><br>
                        <input type="radio" name="kirim_ke_semua" value="yes" id="kirim_ke_semua" required> Kirim ke Semua Anggota<br>
                        <input type="radio" name="kirim_ke_semua" value="no" id="kirim_ke_beberapa"> Pilih Beberapa Anggota
                    </div>

                    <!-- Pencarian Anggota -->
                    <div class="mb-3" id="select-anggotas" style="display: none;">
                        <label class="form-label">Pilih Anggota</label>
                        <input type="text" id="search" class="form-control mb-3" placeholder="Cari anggota..." onkeyup="searchAnggota()">
                        <div id="anggota-list">
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <div class="form-check">
                                    <input type="checkbox" name="no_wa_anggota[]" value="<?= htmlspecialchars($row['no_wa']); ?>" class="form-check-input">
                                    <label class="form-check-label">
                                        <?= htmlspecialchars($row['nama_lengkap']); ?> (<?= htmlspecialchars($row['no_wa']); ?>)
                                    </label>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>

                    <!-- Pesan Pengumuman -->
                    <div class="mb-3">
                        <label class="form-label">Pesan Pengumuman</label>
                        <textarea name="pesan_pengumuman" class="form-control" rows="5" placeholder="Tulis pengumuman yang akan dikirim..." required></textarea>
                    </div>

                    <!-- Tombol Aksi -->
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-dark">Kirim Pengumuman</button>
                        <a href="index.php" class="btn btn-secondary">Kembali ke Beranda</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
 <!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a href="wa.php" title="wa">
        <i class="fas fa-users"></i>
        <span>wa server</span> </a>
    <a href="pengumuman.php" title="pengumuman">
        <i class="fas fa-user-edit"></i>
        <span>pengumuman</span>
    </a>
     <a href="profile.php" title="Profil">
        <i class="fas fa-user-edit"></i>
        <span>Profil</span>
    </a>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Menampilkan / Menyembunyikan pilihan anggota jika memilih "Pilih Beberapa Anggota"
    document.getElementById('kirim_ke_beberapa').addEventListener('change', function () {
        document.getElementById('select-anggotas').style.display = 'block';
    });
    document.getElementById('kirim_ke_semua').addEventListener('change', function () {
        document.getElementById('select-anggotas').style.display = 'none';
    });

    // Fungsi untuk pencarian anggota
    function searchAnggota() {
        let input = document.getElementById('search');
        let filter = input.value.toLowerCase();
        let anggotaList = document.getElementById('anggota-list');
        let anggotaItems = anggotaList.getElementsByClassName('form-check');

        for (let i = 0; i < anggotaItems.length; i++) {
            let label = anggotaItems[i].getElementsByTagName("label")[0];
            if (label.innerText.toLowerCase().includes(filter)) {
                anggotaItems[i].style.display = "";
            } else {
                anggotaItems[i].style.display = "none";
            }
        }
    }
</script>

</body>
</html>
