<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        Apakah Anda yakin ingin keluar dari aplikasi?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>



<!-- Modal Tambah User -->
<div class="modal fade" id="tambahUserModal" tabindex="-1" aria-labelledby="tambahUserLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form method="POST" enctype="multipart/form-data" class="modal-content shadow rounded-4">
      <div class="modal-header border-0">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="me-2 rounded-circle" style="width: 40px; height: 40px;">
        <h5 class="modal-title fw-semibold"><?= htmlspecialchars($nama_perusahaan); ?> - Tambah User Baru</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body py-4 px-4">

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Nama Lengkap</label>
            <input type="text" name="nama_lengkap" class="form-control" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Password</label>
            <input type="text" name="password" class="form-control" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">No WA</label>
            <input type="text" name="no_wa" class="form-control">
          </div>

          <div class="col-md-6">
            <label class="form-label">Foto Profil</label>
            <input type="file" name="foto" class="form-control" accept="image/*">
          </div>

          <div class="col-md-6">
            <label class="form-label">Tanggal Bergabung</label>
            <input type="text" id="tanggal" name="bergabung_sejak" class="form-control"
                   value="<?= $data['bergabung_sejak']; ?>" placeholder="Pilih tanggal..." required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Simpanan Wajib</label>
            <input type="number" name="simpanan_wajib" class="form-control" value="0" min="0">
          </div>

          <div class="col-md-6">
            <label class="form-label">Simpanan Hari Raya</label>
            <input type="number" name="simpanan_hari_raya" class="form-control" value="0" min="0">
          </div>

          <div class="col-md-6">
            <label class="form-label">Role</label>
            <select name="role" class="form-select" required>
              <option value="">-- Pilih Hak Akses --</option>
              <option value="admin">Admin</option>
              <option value="pengurus">Pengurus</option>
              <option value="anggota">Anggota</option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">Status Anggota</label>
            <select name="status_anggota" class="form-select" required>
              <option value="">-- Pilih Status --</option>
              <option value="Aktif">Aktif</option>
              <option value="Pasif">Pasif</option>
              <option value="Keluar">Keluar</option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">Jasa Pinjaman</label>
            <div class="input-group">
              <input type="number" name="jasa_pinjaman" class="form-control" min="0" step="0.01" placeholder="Contoh: 1.5">
              <span class="input-group-text">%</span>
            </div>
          </div>
        </div>

      </div>
      <div class="modal-footer border-0 px-4 pb-4">
        <button type="submit" name="tambah" class="btn btn-dark px-4">Tambah</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>
<!-- Modal Detail User -->
<?php foreach ($users as $row): ?>
<div class="modal fade" id="detailModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="detailModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded-4">
      <div class="modal-header bg-primary text-white rounded-top-4">
        <h5 class="modal-title" id="detailModalLabel<?= $row['id'] ?>">Detail Anggota: <?= htmlspecialchars($row['nama_lengkap']) ?></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body bg-light">
        <div class="row g-4">
          <div class="col-md-4 text-center">
            <img src="../uploads/<?= htmlspecialchars($row['foto']) ?>" alt="Foto" class="img-fluid rounded-3 shadow" style="max-height: 200px; object-fit: cover;">
          </div>
          <div class="col-md-8">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><strong>Username:</strong> <?= htmlspecialchars($row['username']) ?></li>
              <li class="list-group-item"><strong>No. WA:</strong> <?= htmlspecialchars($row['no_wa']) ?></li>
              <li class="list-group-item"><strong>Role:</strong> <?= htmlspecialchars($row['role']) ?></li>
              <li class="list-group-item"><strong>Status Anggota:</strong> <?= htmlspecialchars($row['status_anggota']) ?></li>
              <li class="list-group-item"><strong>Simpanan Wajib:</strong> Rp<?= number_format($row['simpanan_wajib']) ?></li>
              <li class="list-group-item"><strong>Simpanan Hari Raya:</strong> Rp<?= number_format($row['simpanan_hari_raya']) ?></li>
              <li class="list-group-item"><strong>Jasa Pinjaman:</strong> <?= htmlspecialchars($row['jasa_pinjaman']) ?>%</li>
              <li class="list-group-item"><strong>Bergabung Sejak:</strong> <?= htmlspecialchars($row['bergabung_sejak']) ?></li>
            </ul>
          </div>
        </div>
      </div>
      <div class="modal-footer bg-white rounded-bottom-4">
          <button class="btn btn-success" data-bs-target="#cetakModal<?= $row['id'] ?>" data-bs-toggle="modal" data-bs-dismiss="modal">Cetak Kartu Anggota</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
        
      </div>
    </div>
  </div>
</div>
<?php endforeach; ?>
<?php foreach ($users as $row): ?>
<div class="modal fade" id="cetakModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="cetakModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Preview Kartu Anggota</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body d-flex justify-content-center" style="background-color: #f8f9fa;">
        <div id="ktpCard<?= $row['id'] ?>" style="
          width: 85.6mm;
          height: 53.98mm;
          background: white;
          border: 1px solid #ccc;
          padding: 4mm;
          font-family: 'Arial', sans-serif;
          font-size: 8px;
          display: flex;
          flex-direction: column;
          justify-content: space-between;
          box-sizing: border-box;
          box-shadow: 0 0 5px rgba(0,0,0,0.1);
        ">

          <!-- Header -->
          <div style="display: flex; align-items: center; margin-bottom: 2mm;">
            <img src="../uploads/<?= htmlspecialchars($logo_perusahaan) ?>" alt="Logo" style="width: 12mm; height: 12mm; margin-right: 3mm;">
            <div>
              <div style="font-size: 10px; font-weight: bold; color: #007bff;"><?= strtoupper($nama_perusahaan) ?></div>
              <div style="font-size: 8px;">Kartu Anggota Koperasi</div>
            </div>
          </div>

          <!-- Foto dan Data -->
          <div style="display: flex; gap: 3mm;">
            <div style="width: 20mm;">
              <img src="../uploads/<?= $row['foto'] ?>" alt="Foto" style="width: 100%; height: auto; max-height: 28mm; object-fit: cover; border: 1px solid #aaa;">
            </div>
            <div style="flex-grow: 1;">
              <table style="width: 100%; border-collapse: collapse;">
                <tr>
                  <td style="width: 22mm;">Nama</td>
                  <td style="width: 2mm;">:</td>
                  <td><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                </tr>
                <tr>
                  <td>Username</td>
                  <td>:</td>
                  <td><?= htmlspecialchars($row['username']) ?></td>
                </tr>
                <tr>
                  <td>Status</td>
                  <td>:</td>
                  <td><?= htmlspecialchars($row['status_anggota']) ?></td>
                </tr>
                <tr>
                  <td>Bergabung</td>
                  <td>:</td>
                  <td><?= htmlspecialchars($row['bergabung_sejak']) ?></td>
                </tr>
              </table>
            </div>
          </div>

          <!-- Footer: QR Code, TTD, Catatan -->
          <div style="display: flex; justify-content: space-between; align-items: end; margin-top: 2mm;">
            <div>
              <img src="https://api.qrserver.com/v1/create-qr-code/?size=50x50&data=<?= urlencode($row['username']) ?>" alt="QR" style="width: 13mm; height: 13mm;">
            </div>
            <div style="text-align: center;">
              <div style="font-size: 7px;">Tanda Tangan</div>
              <img src="../uploads/ttd/<?= $row['id'] ?>.png" alt="TTD" style="height: 12px;">
              <div style="font-size: 6.5px;"><?= $row['nama_lengkap'] ?></div>
            </div>
            <div style="font-size: 6.5px; text-align: right;">
              Dicetak dari<br>Sistem Koperasi
            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer bg-white">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
        <button class="btn btn-primary" onclick="printKartu('ktpCard<?= $row['id'] ?>')">Print</button>
        <button class="btn btn-danger" onclick="downloadPDF('ktpCard<?= $row['id'] ?>', 'kartu-anggota-<?= $row['username'] ?>')">Download PDF</button>
      </div>
    </div>
  </div>
</div>
<?php endforeach; ?>
<?php foreach ($users as $row): ?>
<div class="modal fade" id="cetakModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="cetakModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Preview Kartu Anggota</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body d-flex justify-content-center" style="background-color: #f8f9fa;">
       <!-- Kartu Anggota -->
<div id="ktpCard<?= $row['id'] ?>" style="
  width: 85.6mm;
  height: 53.98mm;
  background: linear-gradient(to bottom right, #ffffff, #f1f1f1);
  border: 1px solid #ddd;
  padding: 4mm;
  font-family: 'Arial', sans-serif;
  font-size: 8px;
  display: flex;
  flex-direction: column;
  justify-content: start;
  box-sizing: border-box;
  box-shadow: 0 0 4px rgba(0,0,0,0.1);
  border-radius: 2mm;
">

  <!-- Logo dan Nama Koperasi -->
  <div style="text-align: center; margin-bottom: 2mm;">
    <img src="../uploads/<?= htmlspecialchars($logo_perusahaan) ?>" alt="Logo" style="width: 10mm; height: 10mm; border-radius: 50%;"><br>
    <div style="font-size: 10px; font-weight: bold; color: #2c3e50;"><?= strtoupper($nama_perusahaan) ?></div>
    <div style="font-size: 7px; color: #555;">Kartu Anggota Koperasi</div>
  </div>

  <!-- Isi Utama: Foto, Barcode, dan Data -->
  <div style="display: flex; gap: 4mm;">
    <!-- Foto dan QR -->
    <div style="width: 18mm; text-align: center;">
      <img src="../uploads/<?= $row['foto'] ?>" alt="Foto" style="width: 100%; height: auto; max-height: 23mm; object-fit: cover; border: 1px solid #aaa; border-radius: 1mm;">
      <img src="https://api.qrserver.com/v1/create-qr-code/?size=50x50&data=<?= urlencode($row['username']) ?>" alt="QR" style="width: 13mm; height: 13mm; margin-top: 1mm;">
    </div>

    <!-- Informasi -->
    <div style="flex-grow: 1;">
      <table style="width: 100%; border-collapse: collapse;">
        <tr>
          <td style="width: 22mm; font-weight: bold;">Nama</td>
          <td style="width: 2mm;">:</td>
          <td><?= htmlspecialchars($row['nama_lengkap']) ?></td>
        </tr>
        <tr>
          <td style="font-weight: bold;">Username</td>
          <td>:</td>
          <td><?= htmlspecialchars($row['username']) ?></td>
        </tr>
        <tr>
          <td style="font-weight: bold;">Status</td>
          <td>:</td>
          <td><?= htmlspecialchars($row['status_anggota']) ?></td>
        </tr>
        <tr>
          <td style="font-weight: bold;">Bergabung</td>
          <td>:</td>
          <td><?= htmlspecialchars($row['bergabung_sejak']) ?></td>
        </tr>
      </table>
    </div>
  </div>

  <!-- Footer -->
  <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-top: 2mm;">
    <div style="font-size: 6px; text-align: right; color: #777;">
      Dicetak dari<br>Sistem Koperasi
    </div>
    <div style="text-align: center;">
      <div style="font-size: 6.5px; color: #555;">Tanda Tangan</div>
      <img src="../uploads/ttd/<?= $row['id'] ?>.png" alt="TTD" style="height: 12px;">
      <div style="font-size: 6px;"><?= $row['nama_lengkap'] ?></div>
    </div>
  </div>

</div>
 
      </div>
      <div class="modal-footer bg-white">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
        <button class="btn btn-primary" onclick="printKartu('ktpCard<?= $row['id'] ?>')">Print</button>
        <button class="btn btn-danger" onclick="downloadPDF('ktpCard<?= $row['id'] ?>', 'kartu-anggota-<?= $row['username'] ?>')">Download PDF</button>
      </div>
    </div>
  </div>
</div>
<?php endforeach; ?>

<!-- MODAL EDIT USER -->
<?php $users->data_seek(0); while ($row = $users->fetch_assoc()): ?>
<div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="editModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <form method="POST" enctype="multipart/form-data" class="modal-content border-0 shadow-sm rounded-3">

      <!-- Header Modal dengan Logo dan Nama Perusahaan -->
      <div class="modal-header bg-light border-bottom-0">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title fw-semibold" id="editModalLabel<?= $row['id'] ?>">
          <?= htmlspecialchars($nama_perusahaan); ?> - Edit User: <?= htmlspecialchars($row['username']) ?>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>

      <div class="modal-body py-3">
        <input type="hidden" name="id" value="<?= $row['id'] ?>">
        <input type="hidden" name="foto_lama" value="<?= $row['foto'] ?>">
        <input type="hidden" name="bergabung_sejak" value="<?= htmlspecialchars($row['bergabung_sejak']) ?>">

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Nama Lengkap</label>
            <input type="text" name="nama_lengkap" value="<?= htmlspecialchars($row['nama_lengkap']) ?>" class="form-control form-control-sm" required>
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Username</label>
            <input type="text" name="username" value="<?= htmlspecialchars($row['username']) ?>" class="form-control form-control-sm" required>
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Password</label>
            <input type="text" name="password" value="<?= htmlspecialchars($row['password']) ?>" class="form-control form-control-sm" required>
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">No WA</label>
            <input type="text" name="no_wa" value="<?= htmlspecialchars($row['no_wa']) ?>" class="form-control form-control-sm">
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Simpanan Wajib</label>
            <input type="number" name="simpanan_wajib" class="form-control form-control-sm" value="<?= htmlspecialchars($row['simpanan_wajib']) ?>" min="0">
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Simpanan Hari Raya</label>
            <input type="number" name="simpanan_hari_raya" class="form-control form-control-sm" value="<?= htmlspecialchars($row['simpanan_hari_raya']) ?>" min="0">
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Role</label>
            <select name="role" class="form-select form-select-sm" required>
              <option value="admin" <?= $row['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
              <option value="pengurus" <?= $row['role'] == 'pengurus' ? 'selected' : '' ?>>Pengurus</option>
              <option value="anggota" <?= $row['role'] == 'anggota' ? 'selected' : '' ?>>Anggota</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label small fw-semibold">Status Anggota</label>
            <select name="status_anggota" class="form-select form-select-sm" required>
              <option value="Aktif" <?= $row['status_anggota'] == 'Aktif' ? 'selected' : '' ?>>Aktif</option>
              <option value="Pasif" <?= $row['status_anggota'] == 'Pasif' ? 'selected' : '' ?>>Pasif</option>
              <option value="Keluar" <?= $row['status_anggota'] == 'Keluar' ? 'selected' : '' ?>>Keluar</option>
            </select>
          </div>
          <div class="col-md-6">
  <label class="form-label small fw-semibold">Jasa Pinjaman (%)</label>
  <input type="number" step="0.01" name="jasa_pinjaman" class="form-control form-control-sm"
         value="<?= isset($row['jasa_pinjaman']) ? htmlspecialchars($row['jasa_pinjaman']) : '0' ?>" min="0">
</div>
          <div class="col-12">
            <label class="form-label small fw-semibold">Ganti Foto</label>
            <input type="file" name="foto" class="form-control form-control-sm" accept="image/*">
          </div>
          <div class="col-12">
            <label class="form-label small fw-semibold">Tanggal Bergabung</label>
            <div class="p-2 rounded-2 bg-warning-subtle text-dark border small">
              <?php
                $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
                $bulan = [
                  1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                  'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
                ];
                $timestamp = strtotime($row['bergabung_sejak']);
                echo "<strong>" . $hari[date('w', $timestamp)] . ", " . date('d', $timestamp) . " " .
                     $bulan[(int)date('m', $timestamp)] . " " . date('Y', $timestamp) . "</strong>";
              ?>
              <br><span class="fst-italic text-muted">*Tanggal tidak dapat diubah</span>
            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer bg-light border-top-0">
        <button type="submit" name="update" class="btn btn-primary btn-sm px-3">Simpan</button>
        <button type="button" class="btn btn-outline-secondary btn-sm px-3" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>
<?php endwhile; ?>

<!-- Modal Konfirmasi Tambah Sukarela -->
<div class="modal fade" id="konfirmasiTambahSukarelaModal" tabindex="-1" aria-labelledby="konfirmasiTambahSukarelaLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="konfirmasiTambahSukarelaLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin menambahkan semua simpanan sukarela berdasarkan simpanan sukarela masing-masing anggota?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="tambah_otomatis_sukarela.php" class="btn btn-success">Ya, Tambahkan</a>
      </div>
    </div>
  </div>
</div>
<!-- Modal Konfirmasi Tambah Wajib -->
<div class="modal fade" id="konfirmasiTambahWajibModal" tabindex="-1" aria-labelledby="konfirmasiTambahWajibLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="konfirmasiTambahWajibLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin menambahkan saldo simpanan wajib semua anggota ?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="tambah_otomatis_wajib.php" class="btn btn-warning">Ya, Tambahkan</a>
      </div>
    </div>
  </div>
</div>
<?php if (isset($_SESSION['modal_success'])): ?>
<!-- Modal -->
<div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-success">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title" id="successModalLabel">Sukses</h5>
        <button type="button" class="btn-close text-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <?= $_SESSION['modal_success']; ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success" data-bs-dismiss="modal">Tutup</button>
      </div>
    </div>
  </div>
</div>
<!-- Modal foto -->
<?php unset($_SESSION['modal_success']); ?>
<?php endif; ?>
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="previewModalLabel"> Foto <?= htmlspecialchars($row['nama_lengkap']) ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body text-center">
        <img id="previewImage" src="" alt="Foto User" class="img-fluid rounded shadow">
      </div>
    </div>
  </div>
</div>
<!-- Modal Upload CSV -->
<div class="modal fade" id="uploadCsvModal" tabindex="-1" aria-labelledby="uploadCsvModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      
      <div class="modal-header">
        <h5 class="modal-title" id="uploadCsvModalLabel">Upload Data User via CSV</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <form action="upload_csv.php" method="post" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="mb-3">
            <label for="csvFile" class="form-label">Pilih File CSV</label>
            <input type="file" name="csv" id="csvFile" class="form-control" accept=".csv" required>
          </div>

          <div class="mb-3">
            <a href="template_user.csv" class="btn btn-outline-secondary btn-sm" download>
              <i class="bi bi-file-earmark-arrow-down"></i> Download Template CSV
            </a>
          </div>

          <div class="alert alert-info">
            <strong>Note:</strong> Pastikan urutan kolom pada CSV adalah: 
            <code>id,username,password,foto,no_wa,role,nama_lengkap,status_anggota,bergabung_sejak,simpanan_wajib,simpanan_hari_raya,jasa_pinjaman</code><br>
            Untuk menyimpan file Excel ke CSV: <br>
            <strong>File > Save As > Pilih Format: CSV (Comma delimited)</strong>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" name="upload" class="btn btn-primary">Upload</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        </div>
      </form>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const previewModal = document.getElementById('previewModal');
  const previewImage = document.getElementById('previewImage');
  const previewTitle = document.getElementById('previewModalLabel');

  previewModal.addEventListener('show.bs.modal', function (event) {
    const trigger = event.relatedTarget;
    const fotoSrc = trigger.getAttribute('data-foto');
    const namaLengkap = trigger.getAttribute('data-nama');

    previewImage.src = fotoSrc;
    previewTitle.textContent = 'Foto ' + namaLengkap;
  });
});
</script><script>
  flatpickr("#tanggal", {
    dateFormat: "Y-m-d", // format tanggal sesuai database
    defaultDate: "<?= $data['bergabung_sejak']; ?>",
    maxDate: "today", // tidak bisa memilih tanggal di masa depan
    locale: "id" // opsional: ubah ke Bahasa Indonesia
  });
</script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/id.js"></script><!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<!-- (Opsional) Bahasa Indonesia -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/id.js"></script>

<script>
  flatpickr("#tanggal", {
    dateFormat: "Y-m-d",
    defaultDate: "<?= $data['bergabung_sejak']; ?>",
    maxDate: "today",
    locale: "id" // agar hari dan bulan pakai Bahasa Indonesia
  });
</script>
