<?php
session_start();
include '../config.php';

// Cek role
if ($_SESSION['role'] != 'admin') {
    header("Location: ../index.php");
    exit;
}

$nama_lengkap = $_SESSION['nama_lengkap'];

// Ambil data setting
$querySetting = $conn->query("SELECT * FROM setting LIMIT 1");
if ($querySetting && $querySetting->num_rows > 0) {
    $setting = $querySetting->fetch_assoc();
    $nama_perusahaan = $setting['nama_perusahaan'];
    $logo_perusahaan = $setting['logo_perusahaan'];
    $background = $setting['background'];
} else {
    $nama_perusahaan = "Nama Perusahaan";
    $logo_perusahaan = "default_logo.jpg";
    $background = "default_bg.jpg";
}

// Tambah user
if (isset($_POST['tambah'])) {
    $username           = $_POST['username'];
    $password           = $_POST['password'];
    $nama_lengkap       = $_POST['nama_lengkap'];
    $role               = $_POST['role'];
    $no_wa              = $_POST['no_wa'];
    $status_anggota     = $_POST['status_anggota'];
    $simpanan_wajib     = $_POST['simpanan_wajib'];
    $simpanan_hari_raya = $_POST['simpanan_hari_raya'];
    $bergabung_sejak    = $_POST['bergabung_sejak'];
    $jasa_pinjaman      = $_POST['jasa_pinjaman'];

    $foto = '';
    if (!empty($_FILES['foto']['name'])) {
        $ext  = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = 'foto_' . time() . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], '../uploads/' . $foto);
    }

    $stmt = $conn->prepare("INSERT INTO users (
        username, password, nama_lengkap, role, no_wa, foto, status_anggota,
        simpanan_wajib, simpanan_hari_raya, bergabung_sejak, jasa_pinjaman
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssssss", $username, $password, $nama_lengkap, $role, $no_wa, $foto, $status_anggota, $simpanan_wajib, $simpanan_hari_raya, $bergabung_sejak, $jasa_pinjaman);
    $stmt->execute();
    $stmt->close();

    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Update user
if (isset($_POST['update'])) {
    $id                 = $_POST['id'];
    $password           = $_POST['password'];
    $nama_lengkap       = $_POST['nama_lengkap'];
    $role               = $_POST['role'];
    $no_wa              = $_POST['no_wa'];
    $status_anggota     = $_POST['status_anggota'];
    $simpanan_wajib     = $_POST['simpanan_wajib'];
    $simpanan_hari_raya = $_POST['simpanan_hari_raya'];
    $bergabung_sejak    = $_POST['bergabung_sejak'];
    $jasa_pinjaman      = $_POST['jasa_pinjaman'];

    $getUser   = $conn->query("SELECT username FROM users WHERE id = $id");
    $dataUser  = $getUser->fetch_assoc();
    $username  = $dataUser['username'];

    $foto = $_POST['foto_lama'];
    if (!empty($_FILES['foto']['name'])) {
        $ext  = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = 'foto_' . time() . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], '../uploads/' . $foto);
    }

    $stmt = $conn->prepare("UPDATE users 
        SET password=?, nama_lengkap=?, role=?, no_wa=?, foto=?, status_anggota=?, 
            simpanan_wajib=?, simpanan_hari_raya=?, bergabung_sejak=?, jasa_pinjaman=?
        WHERE id=?");
    $stmt->bind_param("ssssssssssi", $password, $nama_lengkap, $role, $no_wa, $foto, $status_anggota, $simpanan_wajib, $simpanan_hari_raya, $bergabung_sejak, $jasa_pinjaman, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
// Proses hapus user
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];

    // Pastikan ID valid
    if ($id > 0) {
        // Ambil nama file foto jika perlu dihapus juga
        $stmt = $conn->prepare("SELECT foto FROM users WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->bind_result($foto);
        $stmt->fetch();
        $stmt->close();

        // Hapus file foto dari folder uploads jika ada
        if (!empty($foto) && file_exists("../uploads/$foto")) {
            unlink("../uploads/$foto");
        }

        // Hapus data dari database
        $stmt = $conn->prepare("DELETE FROM users WHERE id=?");
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $stmt->close();
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            echo "Gagal menghapus user: " . $stmt->error;
        }
    }
}
// Ambil semua data user
$users = $conn->query("SELECT * FROM users");
?>



<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pengurus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="../style.css">
</head>
<body>

<!-- Navbar -->
<nav class="navbar fixed-top d-flex justify-content-between align-items-center shadow-sm bg-light px-4 py-2">
    <div>
        <span class="navbar-brand mb-0 h1">
            <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="logo-icon me-2" style="height: 40px;">
            <?= htmlspecialchars($nama_perusahaan); ?>
        </span>
    </div>
    <div class="d-flex align-items-center gap-3">
        <div class="user-info">
            <i class="fas fa-user-circle me-1"></i>
            <span>Halo, <strong><?= htmlspecialchars($nama_lengkap); ?></strong></span>
        </div>
        <a href="../logout.php" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#logoutModal">Logout</a>
    </div>
</nav>
<!-- Modal Konfirmasi Hapus -->
<?php foreach ($users as $row): ?>
<div class="modal fade" id="hapusModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="hapusModalLabel<?= $row['id'] ?>" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="hapusModalLabel<?= $row['id'] ?>"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        Apakah Anda yakin ingin menghapus user <strong><?= htmlspecialchars($row['nama_lengkap']); ?></strong>?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="?hapus=<?= $row['id'] ?>" class="btn btn-danger">Hapus</a>
      </div>
    </div>
  </div>
</div>
<?php endforeach; ?>
<!-- Modal Konfirmasi Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <img src="../uploads/<?= htmlspecialchars($logo_perusahaan); ?>" alt="Logo" class="modal-logo me-2" style="width: 40px; height: 40px;">
        <h5 class="modal-title" id="logoutModalLabel"><?= htmlspecialchars($nama_perusahaan); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Apakah Anda yakin ingin keluar dari aplikasi?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="../logout.php" class="btn btn-danger">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Konten -->
<div class="container mt-5 pt-5">
    <div class="mb-4">
        <h2>Manajemen User</h2>
        <div class="d-flex flex-wrap gap-2 mb-3">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tambahUserModal">Tambah User</button>
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#konfirmasiTambahSukarelaModal">Tambah Semua Sukarela</button>
            <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#konfirmasiTambahWajibModal">Tambah Semua Wajib</button>
            <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#uploadCsvModal">
  <i class="bi bi-upload"></i> Upload CSV
</button>
        </div>

        <!-- Filter & Search -->
        <div class="row mb-3">
            <div class="col-md-4 mb-2">
                <input type="text" id="searchInput" onkeyup="filterAndSortUsers()" class="form-control" placeholder="Cari username, nama, role, WA...">
            </div>
            <div class="col-md-4 mb-2">
                <select class="form-select" id="filterRole" onchange="filterAndSortUsers()">
                    <option value="">Semua Role</option>
                    <option value="admin">Admin</option>
                    <option value="pengurus">Pengurus</option>
                    <option value="anggota">Anggota</option>
                </select>
           
        </div>
    </div>


   <div class="table-responsive">
    <table class="table table-bordered table-striped table-hover align-middle" id="userTable">
        <thead class="table-light">
            <tr>
                <th>Foto</th>
                <th>Username</th>
                <th>Nama Lengkap</th>
                <th>No WA</th>
                <th>Role</th>
                <th>Status</th>
                <th>Tanggal Bergabung</th>
                <th style="width: 180px;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $users->data_seek(0); while ($row = $users->fetch_assoc()): ?>
            <tr 
                data-role="<?= htmlspecialchars($row['role']) ?>" 
                data-bergabung="<?= date('Y-m-d', strtotime($row['bergabung_sejak'])) ?>">
                <td>
  <img src="../uploads/<?= htmlspecialchars($row['foto']) ?>" 
     class="foto-user" 
     style="width: 50px; height: 50px; object-fit: cover; cursor: pointer;" 
     data-bs-toggle="modal" 
     data-bs-target="#previewModal" 
     data-foto="../uploads/<?= htmlspecialchars($row['foto']) ?>"
     data-nama="<?= htmlspecialchars($row['nama_lengkap']) ?>">
</td>
                <td class="username"><?= htmlspecialchars($row['username']) ?></td>
                <td class="nama_lengkap"><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                <td class="no_wa"><?= htmlspecialchars($row['no_wa']) ?></td>
                <td class="role"><?= htmlspecialchars($row['role']) ?></td>
                <td>
                    <?php
                    $status = htmlspecialchars($row['status_anggota']);
                    if ($status == 'Aktif') echo '<span class="badge bg-success">Aktif</span>';
                    elseif ($status == 'Pasif') echo '<span class="badge bg-warning">Pasif</span>';
                    elseif ($status == 'Keluar') echo '<span class="badge bg-danger">Keluar</span>';
                    else echo '<span class="badge bg-secondary">Tidak Diketahui</span>';
                    ?>
                </td>
                <td>
                    <div class="p-2 rounded-2 bg-warning-subtle text-dark border small">
                        <?php
                        $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
                        $bulan = [
                          1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                          'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
                        ];
                        $timestamp = strtotime($row['bergabung_sejak']);
                        echo "<strong>" . $hari[date('w', $timestamp)] . ", " . date('d', $timestamp) . " " . 
                             $bulan[(int)date('m', $timestamp)] . " " . date('Y', $timestamp) . "</strong>";
                        ?>
                    </div>
                </td>
                <td>
                    <div class="d-flex gap-2">
                        <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>">Edit</button>
                        <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#hapusModal<?= $row['id'] ?>">Hapus</button>
                        <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#detailModal<?= $row['id'] ?>">
  Detail
</button>
                    </div>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>



<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" title="Home"><i class="fas fa-home"></i><span>Home</span></a>
    <a href="setting.php" title="Data Anggota"><i class="fas fa-users"></i><span>Setting</span></a>
    <a href="wa.php" title="WA"><i class="fas fa-hand-holding-usd"></i><span>WA</span></a>
    <a href="profile.php" title="Profil"><i class="fas fa-user-edit"></i><span>Profil</span></a>
</div>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>

function filterAndSortUsers() {
    const input = document.getElementById("searchInput").value.toLowerCase();
    const selectedRole = document.getElementById("filterRole").value.toLowerCase();
    const rows = document.querySelectorAll("#userTable tbody tr");

    rows.forEach(row => {
        const username = row.querySelector(".username").textContent.toLowerCase();
        const nama = row.querySelector(".nama_lengkap").textContent.toLowerCase();
        const role = row.querySelector(".role").textContent.toLowerCase();
        const wa = row.querySelector(".no_wa").textContent.toLowerCase();
        const matchSearch = username.includes(input) || nama.includes(input) || role.includes(input) || wa.includes(input);
        const matchRole = selectedRole === "" || row.dataset.role === selectedRole;
        row.style.display = (matchSearch && matchRole) ? "" : "none";
    });
}


</script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
</body>
</html>
