<?php
session_start();
include 'config.php';

if ($_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

if (isset($_POST['tambah'])) {
    $username     = $_POST['username'];
    $password     = $_POST['password'];
    $nama_lengkap = $_POST['nama_lengkap'];
    $role         = $_POST['role'];
    $no_wa        = $_POST['no_wa'];

    $foto = '';
    if ($_FILES['foto']['name']) {
        $ext  = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = 'foto_' . time() . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], 'uploads/' . $foto);
    }

    $conn->query("INSERT INTO users (username, password, nama_lengkap, role, no_wa, foto) VALUES ('$username', '$password', '$nama_lengkap', '$role', '$no_wa', '$foto')");
}

if (isset($_POST['update'])) {
    $id           = $_POST['id'];
    $username     = $_POST['username'];
    $password     = $_POST['password'];
    $nama_lengkap = $_POST['nama_lengkap'];
    $role         = $_POST['role'];
    $no_wa        = $_POST['no_wa'];

    $foto = $_POST['foto_lama'];
    if ($_FILES['foto']['name']) {
        $ext  = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = 'foto_' . time() . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], 'uploads/' . $foto);
    }

    $cek = $conn->query("SELECT * FROM users WHERE username = '$username' AND id != $id");
    if ($cek->num_rows > 0) {
        echo "<script>alert('Username sudah digunakan oleh user lain!');</script>";
    } else {
        $conn->query("UPDATE users SET username='$username', password='$password', nama_lengkap='$nama_lengkap', role='$role', no_wa='$no_wa', foto='$foto' WHERE id=$id");
    }
}

if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $conn->query("DELETE FROM users WHERE id=$id");
}

$users = $conn->query("SELECT * FROM users");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manajemen User</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: url('bg.jpg') no-repeat center center fixed;
            background-size: cover;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        .overlay {
            background-color: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(12px);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .container {
            max-width: 1000px;
            margin-top: 60px;
        }
        .table thead {
            background-color: #212529;
            color: white;
        }
        .btn {
            border-radius: 10px;
        }
        .foto-user {
            width: 40px;
            height: 40px;
            object-fit: cover;
            border-radius: 50%;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="overlay">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Manajemen User</h2>
            <div>
                <p>Halo, <strong><?= htmlspecialchars($_SESSION['nama_lengkap']); ?></strong></p>
                <a href="logout.php" class="btn btn-outline-secondary btn-sm">Logout</a>
            </div>
        </div>

        <div class="mb-3">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tambahUserModal">Tambah User</button>
        </div>

        <input type="text" id="searchInput" onkeyup="searchUsers()" class="form-control mb-3" placeholder="Cari username, nama lengkap, no WA atau role...">

        <div class="table-responsive" id="userTableWrapper" style="display: none;">
            <table class="table table-bordered align-middle" id="userTable">
                <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Username</th>
                        <th>Nama Lengkap</th>
                        <th>No WA</th>
                        <th>Role</th>
                        <th style="width: 200px;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $users->data_seek(0); while ($row = $users->fetch_assoc()): ?>
                    <tr>
                        <td><img src="uploads/<?= htmlspecialchars($row['foto']) ?>" class="foto-user"></td>
                        <td class="username"><?= htmlspecialchars($row['username']) ?></td>
                        <td class="nama_lengkap"><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                        <td class="no_wa"><?= htmlspecialchars($row['no_wa']) ?></td>
                        <td class="role"><?= htmlspecialchars($row['role']) ?></td>
                        <td>
                            <div class="d-flex gap-2">
                                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>">Edit</button>
                                <a href="?hapus=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus user ini?')">Hapus</a>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah -->
<div class="modal fade" id="tambahUserModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Tambah User Baru</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label>Nama Lengkap</label>
          <input type="text" name="nama_lengkap" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Username</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Password</label>
          <input type="text" name="password" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>No WA</label>
          <input type="text" name="no_wa" class="form-control">
        </div>
        <div class="mb-3">
          <label>Foto Profil</label>
          <input type="file" name="foto" class="form-control" accept="image/*">
        </div>
        <div class="mb-3">
          <label>Role</label>
          <select name="role" class="form-select" required>
            <option value="">-- pilih hak akses --</option>
            <option value="admin">Admin</option>
            <option value="pengurus">Pengurus</option>
            <option value="anggota">Anggota</option>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="tambah" class="btn btn-primary">Tambah</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Edit -->
<?php
$users->data_seek(0);
while ($row = $users->fetch_assoc()):
?>
<div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit User: <?= htmlspecialchars($row['username']) ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" value="<?= $row['id'] ?>">
        <input type="hidden" name="foto_lama" value="<?= $row['foto'] ?>">
        <div class="mb-3">
          <label>Nama Lengkap</label>
          <input type="text" name="nama_lengkap" value="<?= htmlspecialchars($row['nama_lengkap']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Username</label>
          <input type="text" name="username" value="<?= htmlspecialchars($row['username']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Password</label>
          <input type="text" name="password" value="<?= htmlspecialchars($row['password']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>No WA</label>
          <input type="text" name="no_wa" value="<?= htmlspecialchars($row['no_wa']) ?>" class="form-control">
        </div>
        <div class="mb-3">
          <label>Ganti Foto</label>
          <input type="file" name="foto" class="form-control" accept="image/*">
        </div>
        <div class="mb-3">
          <label>Role</label>
          <select name="role" class="form-select" required>
            <option value="admin" <?= $row['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
            <option value="pengurus" <?= $row['role'] == 'pengurus' ? 'selected' : '' ?>>Pengurus</option>
            <option value="anggota" <?= $row['role'] == 'anggota' ? 'selected' : '' ?>>Anggota</option>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="update" class="btn btn-success">Simpan</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
      </div>
    </form>
  </div>
</div>
<?php endwhile; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function searchUsers() {
    const input = document.getElementById("searchInput").value.toLowerCase();
    const wrapper = document.getElementById("userTableWrapper");
    const rows = document.querySelectorAll("#userTable tbody tr");

    if (input.trim() === "") {
        wrapper.style.display = "none";
        return;
    } else {
        wrapper.style.display = "";
    }

    rows.forEach(row => {
        const username = row.querySelector(".username").textContent.toLowerCase();
        const nama = row.querySelector(".nama_lengkap").textContent.toLowerCase();
        const role = row.querySelector(".role").textContent.toLowerCase();
        const wa = row.querySelector(".no_wa").textContent.toLowerCase();
        const isMatch = username.includes(input) || nama.includes(input) || role.includes(input) || wa.includes(input);
        row.style.display = isMatch ? "" : "none";
    });
}
</script>

</body>
</html>

