<?php
session_start();
include 'config.php';

if (!isset($_SESSION['ujian']) || $_SESSION['ujian'] !== true) {
    header("Location: index.php");
    exit();
}

$query = mysqli_query($conn, "SELECT * FROM setting WHERE id = 1");
$setting = mysqli_fetch_assoc($query);

$setting_lat = isset($setting['latitude']) ? floatval($setting['latitude']) : 0;
$setting_lon = isset($setting['longitude']) ? floatval($setting['longitude']) : 0;
$aktif_lokasi = isset($setting['aktif_lokasi']) ? intval($setting['aktif_lokasi']) : 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?= htmlspecialchars($setting['nama_sekolah'] ?? 'Nama Sekolah') ?></title>
    <style>
        * {
            box-sizing: border-box;
        }

        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            font-family: 'Segoe UI', sans-serif;
            background: #000;
            color: #fff;
            overflow: hidden;
        }

        .overlay,
        .rules-overlay,
        .geo-overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.85);
            color: white;
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 2000;
            animation: fadeIn 0.3s ease-out;
            text-align: center;
            padding: 20px;
        }

        .overlay-content,
        .rules-content,
        .geo-content {
            background: #1c1c1c;
            padding: 30px;
            border-radius: 12px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.05);
            border: 1px solid #333;
        }

        .overlay-content h1,
        .rules-content h1,
        .geo-content h1 {
            font-size: 26px;
            color: #f44336;
            margin-bottom: 15px;
        }

        .overlay-content p,
        .rules-content p,
        .geo-content p {
            font-size: 17px;
            color: #ddd;
            margin-bottom: 20px;
        }

        button {
            background: #2196f3;
            border: none;
            padding: 10px 25px;
            font-size: 16px;
            border-radius: 6px;
            color: #fff;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover {
            background: #1976d2;
        }

        #hidden-container {
            width: 100vw;
            height: 100vh;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        iframe {
            border: none;
        }
          .rules-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(10, 10, 10, 0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    animation: fadeIn 0.4s ease-in-out;
  }

  .rules-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(10, 10, 10, 0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    animation: fadeIn 0.4s ease-in-out;
  }

  .rules-content {
    background: #1f1f1f;
    color: #fff;
    padding: 2rem;
    border-radius: 20px;
    max-width: 90%;
    text-align: center;
    box-shadow: 0 0 20px rgba(255, 255, 255, 0.1);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    animation: slideIn 0.5s ease-out;
  }

  .rules-content h1 {
    font-size: 2rem;
    margin-bottom: 1.2rem;
    color: #ffcc00;
  }

  .rule-list {
    list-style: none;
    padding: 0;
    margin: 0 0 1.5rem 0;
    text-align: left;
  }

  .rule-list li {
    font-size: 1.1rem;
    margin-bottom: 1rem;
    line-height: 1.5;
  }

  .motivasi {
    font-size: 1rem;
    color: #00ffcc;
    font-weight: bold;
    margin-bottom: 1.5rem;
  }

  .rules-content button {
    background: #ffcc00;
    color: #000;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: bold;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
  }

  .rules-content button:hover {
    background: #ffd633;
    transform: scale(1.05);
  }

  @keyframes fadeIn {
    from { opacity: 0 }
    to { opacity: 1 }
  }

  @keyframes slideIn {
    from { transform: translateY(-50px); opacity: 0; }
    to { transform: translateY(0); opacity: 1; }
  }
    </style>
</head>
<body>
    <div id="hidden-container"></div>

    <!-- Overlay Kecurangan -->
    <div class="overlay" id="overlay">
        <div class="overlay-content">
            <h1>Peringatan!</h1>
            <p>Kecurangan terdeteksi. Anda akan dikeluarkan dari ujian.</p>
            <button onclick="hideOverlay()">Tutup</button>
        </div>
    </div>

  <!-- Overlay Aturan -->
<div class="rules-overlay" id="rules-overlay">
  <div class="rules-content">
    <h1>⚠️ PERHATIAN!</h1>
    <ul class="rule-list">
      <li>1️⃣ <strong>PASTIKAN NAMA DAN KELAS SESUAI</strong></li>
      <li>2️⃣ <strong>PASTIKAN TIDAK MELAKUKAN KECURANGAN KETIKA UJIAN BERLANGSUNG</strong></li>
      <li>3️⃣ <strong>JIKA KEMBALI KE HALAMAN AWAL, SILAHKAN MINTA TOKEN TERBARU KE PENGAWAS</strong></li>
    </ul>
    <p class="motivasi">💪 SEMANGAT! SEMOGA MENDAPATKAN HASIL TERBAIK DENGAN KEMAMPUAN SENDIRI ✨</p>
    <button onclick="hideRulesOverlay()">Siap, Saya Mengerti! 👍</button>
  </div>
</div>

    <!-- Overlay Lokasi -->
    <div class="geo-overlay" id="geo-overlay">
        <div class="geo-content">
            <h1>Lokasi Tidak Sesuai</h1>
            <p>Lokasi Anda berada di luar zona yang diizinkan untuk mengikuti ujian.</p>
            <button onclick="hideGeoOverlay()">Tutup</button>
        </div>
    </div>

    <script>
        const settingLat = <?= json_encode($setting_lat); ?>;
        const settingLon = <?= json_encode($setting_lon); ?>;
        const aktifLokasi = <?= json_encode($aktif_lokasi); ?>;
        const allowedDistance = 100;

        function deg2rad(deg) {
            return deg * (Math.PI / 180);
        }

        function getDistanceFromLatLonInMeters(lat1, lon1, lat2, lon2) {
            const R = 6371000;
            const dLat = deg2rad(lat2 - lat1);
            const dLon = deg2rad(lon2 - lon1);
            const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                      Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) *
                      Math.sin(dLon / 2) * Math.sin(dLon / 2);
            const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            return R * c;
        }

        function showOverlayAndRedirect() {
            document.getElementById("overlay").style.display = "flex";
            setTimeout(() => {
                window.location.href = "logout.php";
            }, 3000);
        }

        function hideOverlay() {
            document.getElementById("overlay").style.display = "none";
        }

        function hideRulesOverlay() {
            document.getElementById("rules-overlay").style.display = "none";
        }

        function hideGeoOverlay() {
            document.getElementById("geo-overlay").style.display = "none";
        }

        function showGeoOverlayAndRedirect() {
            document.getElementById("geo-overlay").style.display = "flex";
            setTimeout(() => {
                window.location.href = "logout.php";
            }, 5000);
        }

        function checkGeoLocation() {
            if (!aktifLokasi) return;

            if (!navigator.geolocation) {
                alert("Geolokasi tidak didukung oleh browser Anda.");
                showGeoOverlayAndRedirect();
                return;
            }

            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const userLat = position.coords.latitude;
                    const userLon = position.coords.longitude;
                    const distance = getDistanceFromLatLonInMeters(userLat, userLon, settingLat, settingLon);
                    if (distance > allowedDistance) {
                        showGeoOverlayAndRedirect();
                    }
                },
                () => {
                    alert("Tidak dapat mendeteksi lokasi. Pastikan izin lokasi aktif.");
                    showGeoOverlayAndRedirect();
                },
                {
                    enableHighAccuracy: true,
                    timeout: 10000,
                    maximumAge: 0
                }
            );
        }

        function preventScreenshot() {
            window.addEventListener("keyup", (e) => {
                if (e.key === "PrintScreen") {
                    showOverlayAndRedirect();
                }
            });

            document.addEventListener("visibilitychange", () => {
                if (document.hidden) {
                    showOverlayAndRedirect();
                }
            });
        }

        function preventSplitScreen() {
            const initialWidth = window.innerWidth;
            const initialHeight = window.innerHeight;

            window.addEventListener("resize", () => {
                if (window.innerWidth < initialWidth * 0.9 || window.innerHeight < initialHeight * 0.9) {
                    showOverlayAndRedirect();
                }
            });
        }

        function preventHotkeys() {
            const forbiddenKeys = ["Alt", "Tab", "Meta", "Control", "PrintScreen"];
            window.addEventListener("keydown", (e) => {
                if (forbiddenKeys.includes(e.key)) {
                    e.preventDefault();
                    e.stopPropagation();
                    showOverlayAndRedirect();
                    return false;
                }
            });
        }

        function insertIframeSecurely() {
            const host = document.getElementById("hidden-container");
            const shadow = host.attachShadow({ mode: 'closed' });

            const iframe = document.createElement("iframe");
            iframe.src = "../cbt/";
            iframe.allowFullscreen = true;
            iframe.style.width = "100vw";
            iframe.style.height = "100vh";
            iframe.style.border = "none";

            shadow.appendChild(iframe);
        }

        function activateCheatingProtection() {
            setTimeout(() => {
                preventScreenshot();
                preventSplitScreen();
                preventHotkeys();
            }, 20000);

            document.getElementById("rules-overlay").style.display = "flex";
            checkGeoLocation();
            insertIframeSecurely();
        }

        window.onload = () => {
            activateCheatingProtection();
        };
    </script>
</body>
</html>
