<?php
session_start();
include 'config.php';

if (!isset($_SESSION['ujian']) || $_SESSION['ujian'] !== true) {
    header("Location: index.php");
    exit();
}

$query = mysqli_query($conn, "SELECT * FROM setting WHERE id = 1");
$setting = mysqli_fetch_assoc($query);

$setting_lat = isset($setting['latitude']) ? floatval($setting['latitude']) : 0;
$setting_lon = isset($setting['longitude']) ? floatval($setting['longitude']) : 0;
$aktif_lokasi = isset($setting['aktif_lokasi']) ? intval($setting['aktif_lokasi']) : 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?= htmlspecialchars($setting['nama_sekolah'] ?? 'Nama Sekolah') ?></title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            background: black;
        }

        .overlay,
        .rules-overlay,
        .geo-overlay {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: rgba(0, 0, 0, 0.9);
            color: white;
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 2000;
            animation: fadeIn 0.5s ease-out;
            text-align: center;
            padding: 20px;
            box-sizing: border-box;
        }

        .overlay-content,
        .rules-content,
        .geo-content {
            max-width: 600px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
            padding: 20px;
        }

        .overlay-content h1,
        .rules-content h1,
        .geo-content h1 {
            font-size: 28px;
            margin-bottom: 15px;
            color: #ff4d4d;
        }

        .overlay-content p,
        .rules-content p,
        .geo-content p {
            font-size: 18px;
            margin-bottom: 15px;
        }

        .overlay-content button,
        .rules-content button,
        .geo-content button {
            padding: 10px 20px;
            background: #007bff;
            border: none;
            color: white;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
        }

        .overlay-content button:hover,
        .rules-content button:hover,
        .geo-content button:hover {
            background: #0056b3;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
    </style>
</head>
<body>
    <div id="hidden-container"></div>

    <div class="overlay" id="overlay">
        <div class="overlay-content">
            <h1>Peringatan!</h1>
            <p>Kecurangan terdeteksi</p>
            <button onclick="hideOverlay()">Tutup</button>
        </div>
    </div>

    <div class="rules-overlay" id="rules-overlay">
        <div class="rules-content">
            <h1>Peringatan</h1>
            <p>Jangan membuka aplikasi lain selama ujian berlangsung.</p>
            <button onclick="hideRulesOverlay()">Saya Mengerti</button>
        </div>
    </div>

    <div class="geo-overlay" id="geo-overlay">
        <div class="geo-content">
            <h1>Lokasi Tidak Sesuai</h1>
            <p>Lokasi Anda tidak sesuai dengan lokasi ujian yang diizinkan.<br />
            Pastikan Anda mengikuti ujian dari lokasi yang benar.</p>
            <button onclick="hideGeoOverlay()">Tutup</button>
        </div>
    </div>

    <script>
        const settingLat = <?= json_encode($setting_lat); ?>;
        const settingLon = <?= json_encode($setting_lon); ?>;
        const aktifLokasi = <?= json_encode($aktif_lokasi); ?>;
        const allowedDistance = 100;

        function getDistanceFromLatLonInMeters(lat1, lon1, lat2, lon2) {
            const R = 6371000;
            const dLat = deg2rad(lat2 - lat1);
            const dLon = deg2rad(lon2 - lon1);
            const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                      Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) *
                      Math.sin(dLon / 2) * Math.sin(dLon / 2);
            const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            return R * c;
        }

        function deg2rad(deg) {
            return deg * (Math.PI / 180);
        }

        function showOverlayAndRedirect() {
            document.getElementById("overlay").style.display = "flex";
            setTimeout(() => {
                window.location.href = "logout.php";
            }, 3000);
        }

        function hideOverlay() {
            document.getElementById("overlay").style.display = "none";
        }

        function hideRulesOverlay() {
            document.getElementById("rules-overlay").style.display = "none";
        }

        function hideGeoOverlay() {
            document.getElementById("geo-overlay").style.display = "none";
        }

        function showGeoOverlayAndRedirect() {
            document.getElementById("geo-overlay").style.display = "flex";
            setTimeout(() => {
                window.location.href = "logout.php";
            }, 5000);
        }

        function checkGeoLocation() {
            if (!aktifLokasi) return; // Lewati jika tidak aktif

            if (!navigator.geolocation) {
                alert("Geolokasi tidak didukung oleh browser Anda.");
                showGeoOverlayAndRedirect();
                return;
            }

            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const userLat = position.coords.latitude;
                    const userLon = position.coords.longitude;
                    const distance = getDistanceFromLatLonInMeters(userLat, userLon, settingLat, settingLon);

                    if (distance > allowedDistance) {
                        showGeoOverlayAndRedirect();
                    }
                },
                () => {
                    alert("Tidak dapat mendapatkan lokasi Anda. Pastikan izin lokasi diaktifkan.");
                    showGeoOverlayAndRedirect();
                },
                {
                    enableHighAccuracy: true,
                    timeout: 10000,
                    maximumAge: 0
                }
            );
        }

        function preventScreenshot() {
            window.addEventListener("keyup", (e) => {
                if (e.key === "PrintScreen") {
                    showOverlayAndRedirect();
                }
            });
            document.addEventListener("visibilitychange", () => {
                if (document.hidden) {
                    showOverlayAndRedirect();
                }
            });
        }

        function preventSplitScreen() {
            const initialWidth = window.innerWidth;
            const initialHeight = window.innerHeight;

            window.addEventListener("resize", () => {
                if (window.innerWidth < initialWidth * 0.9 || window.innerHeight < initialHeight * 0.9) {
                    showOverlayAndRedirect();
                }
            });
        }

        function preventHotkeys() {
            const forbiddenKeys = ["Alt", "Tab", "Meta", "Control", "PrintScreen"];
            window.addEventListener("keydown", (e) => {
                if (forbiddenKeys.includes(e.key)) {
                    e.preventDefault();
                    e.stopPropagation();
                    showOverlayAndRedirect();
                    return false;
                }
            });
        }

        function insertIframeSecurely() {
            const host = document.getElementById("hidden-container");
            const shadow = host.attachShadow({ mode: 'closed' });

            const iframe = document.createElement("iframe");
            iframe.src = "/cbt/";
            iframe.allowFullscreen = true;
            iframe.style.width = "100vw";
            iframe.style.height = "100vh";
            iframe.style.border = "none";

            shadow.appendChild(iframe);
        }

        function activateCheatingProtection() {
            setTimeout(() => {
                preventScreenshot();
                preventSplitScreen();
                preventHotkeys();
            }, 20000);

            document.getElementById("rules-overlay").style.display = "flex";
            checkGeoLocation();
            insertIframeSecurely();
        }

        window.onload = () => {
            activateCheatingProtection();
        };
    </script>
</body>
</html>
